/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.recipe.trie;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.simibubi.create.Create;
import com.simibubi.create.content.processing.basin.BasinRecipe;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.recipe.trie.AbstractIngredient;
import com.simibubi.create.foundation.recipe.trie.AbstractRecipe;
import com.simibubi.create.foundation.recipe.trie.AbstractVariant;
import com.simibubi.create.foundation.recipe.trie.IntArrayTrie;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecipeTrie<R extends Recipe<?>> {
    private static final int MAX_CACHE_SIZE = Integer.getInteger("create.recipe_trie.max_cache_size", 512);
    private final IntArrayTrie<R> trie;
    private final Object2IntMap<AbstractVariant> variantToId;
    private final Int2ObjectMap<IntSet> variantToIngredients;
    private final int universalIngredientId;
    private final Cache<Set<AbstractVariant>, IntSet> ingredientCache = CacheBuilder.newBuilder().maximumSize((long)MAX_CACHE_SIZE).build();

    private RecipeTrie(IntArrayTrie<R> trie, Object2IntMap<AbstractVariant> variantToId, Int2ObjectMap<IntSet> variantToIngredients, int universalIngredientId) {
        this.trie = trie;
        this.variantToId = variantToId;
        this.variantToIngredients = variantToIngredients;
        this.universalIngredientId = universalIngredientId;
    }

    @NotNull
    public static Set<AbstractVariant> getVariants(@Nullable IItemHandler itemStorage, @Nullable IFluidHandler fluidStorage) {
        HashSet<AbstractVariant> variants = new HashSet<AbstractVariant>();
        if (itemStorage != null) {
            for (int slot = 0; slot < itemStorage.getSlots(); ++slot) {
                ItemStack item = itemStorage.getStackInSlot(slot);
                if (item.m_41619_()) continue;
                variants.add(new AbstractVariant.AbstractItem(item.m_41720_()));
            }
        }
        if (fluidStorage != null) {
            for (int tank = 0; tank < fluidStorage.getTanks(); ++tank) {
                FluidStack fluid = fluidStorage.getFluidInTank(tank);
                if (fluid.isEmpty()) continue;
                variants.add(new AbstractVariant.AbstractFluid(fluid.getFluid()));
            }
        }
        return variants;
    }

    private IntSet getAvailableIngredients(@NotNull Set<AbstractVariant> pool) {
        pool.retainAll((Collection<?>)this.variantToId.keySet());
        try {
            return (IntSet)this.ingredientCache.get(Set.copyOf(pool), () -> {
                IntOpenHashSet ingredients = new IntOpenHashSet();
                ingredients.add(this.universalIngredientId);
                for (AbstractVariant variant : pool) {
                    IntSet ingredientIds;
                    int id = this.variantToId.getInt((Object)variant);
                    if (id < 0 || (ingredientIds = (IntSet)this.variantToIngredients.get(id)) == null) continue;
                    ingredients.addAll((IntCollection)ingredientIds);
                }
                return ingredients;
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public List<R> lookup(@NotNull Set<AbstractVariant> pool) {
        return this.trie.lookup(this.getAvailableIngredients(pool));
    }

    public static <R extends Recipe<?>> Builder<R> builder() {
        return new Builder();
    }

    public static class Builder<R extends Recipe<?>> {
        private final IntArrayTrie<R> trie = new IntArrayTrie();
        private final Map<Object, AbstractVariant> variantCache = new HashMap<Object, AbstractVariant>();
        private final Object2IntOpenHashMap<AbstractVariant> variantToId = new Object2IntOpenHashMap();
        private int nextVariantId = 0;
        private final Object2IntMap<AbstractIngredient> ingredientToId = new Object2IntOpenHashMap();
        private int nextIngredientId = 0;
        private final int universalIngredientId;
        private final Int2ObjectOpenHashMap<IntSet> variantToIngredients = new Int2ObjectOpenHashMap();

        private Builder() {
            this.variantToId.defaultReturnValue(-1);
            this.ingredientToId.defaultReturnValue(-1);
            this.universalIngredientId = this.getOrAssignId(AbstractIngredient.Universal.INSTANCE);
        }

        private int getOrAssignId(AbstractIngredient ingredient) {
            return this.ingredientToId.computeIfAbsent((Object)ingredient, $ -> {
                int id = this.nextIngredientId++;
                for (AbstractVariant variant : ingredient.variants) {
                    ((IntSet)this.variantToIngredients.computeIfAbsent(this.getOrAssignId(variant), $1 -> new IntOpenHashSet())).add(id);
                }
                return id;
            });
        }

        private int getOrAssignId(AbstractVariant variant) {
            return this.variantToId.computeIfAbsent((Object)variant, $ -> this.nextVariantId++);
        }

        private AbstractVariant getOrAssignVariant(Item item) {
            AbstractVariant variant = this.variantCache.computeIfAbsent(item, $ -> new AbstractVariant.AbstractItem(item));
            this.getOrAssignId(variant);
            return variant;
        }

        private AbstractVariant getOrAssignVariant(Fluid fluid) {
            AbstractVariant variant = this.variantCache.computeIfAbsent(fluid, $ -> new AbstractVariant.AbstractFluid(fluid));
            this.getOrAssignId(variant);
            return variant;
        }

        private void insert(AbstractRecipe<? extends R> recipe) {
            int[] key = new int[recipe.ingredients.size()];
            int i = 0;
            for (AbstractIngredient ingredient : recipe.ingredients) {
                key[i++] = this.getOrAssignId(ingredient);
            }
            Arrays.sort(key);
            this.trie.insert(key, recipe.recipe);
        }

        public <R1 extends R> void insert(R1 recipe) {
            this.insert((R1)this.createRecipe(recipe));
        }

        private <R1 extends R> AbstractRecipe<R1> createRecipe(R1 recipe) {
            HashSet<AbstractIngredient> ingredients = new HashSet<AbstractIngredient>();
            for (Ingredient ingredient : recipe.m_7527_()) {
                if (ingredient.m_43947_()) {
                    ingredients.add(AbstractIngredient.Universal.INSTANCE);
                    continue;
                }
                if (!ingredient.isSimple()) {
                    ingredients.add(AbstractIngredient.Universal.INSTANCE);
                    continue;
                }
                HashSet<AbstractVariant> variants = new HashSet<AbstractVariant>();
                for (ItemStack stack : ingredient.m_43908_()) {
                    variants.add(this.getOrAssignVariant(stack.m_41720_()));
                }
                ingredients.add(new AbstractIngredient(variants));
            }
            if (recipe instanceof BasinRecipe) {
                BasinRecipe basinRecipe = (BasinRecipe)recipe;
                for (FluidIngredient ingredient : basinRecipe.getFluidIngredients()) {
                    if (ingredient.getRequiredAmount() == 0) {
                        ingredients.add(AbstractIngredient.Universal.INSTANCE);
                        continue;
                    }
                    HashSet<AbstractVariant> variants = new HashSet<AbstractVariant>();
                    for (FluidStack stack : ingredient.getMatchingFluidStacks()) {
                        variants.add(this.getOrAssignVariant(stack.getFluid()));
                    }
                    ingredients.add(new AbstractIngredient(variants));
                }
            }
            return new AbstractRecipe<R1>(recipe, ingredients);
        }

        public RecipeTrie<R> build() {
            this.variantToId.trim();
            this.variantToIngredients.trim();
            Create.LOGGER.info("RecipeTrie of depth {} with {} nodes built with {} variants, {} ingredients, and {} recipes", new Object[]{this.trie.getMaxDepth(), this.trie.getNodeCount(), this.variantToId.size(), this.ingredientToId.size(), this.trie.getValueCount()});
            return new RecipeTrie<R>(this.trie, (Object2IntMap<AbstractVariant>)this.variantToId, (Int2ObjectMap<IntSet>)this.variantToIngredients, this.universalIngredientId);
        }
    }
}

