/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.config;

import com.copycatsplus.copycats.config.FeatureToggle;
import com.copycatsplus.copycats.config.SyncConfigBase;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.jetbrains.annotations.ApiStatus;

public class CFeatures
extends SyncConfigBase {
    final Map<ResourceLocation, ForgeConfigSpec.ConfigValue<Boolean>> toggles = new HashMap<ResourceLocation, ForgeConfigSpec.ConfigValue<Boolean>>();
    Map<ResourceLocation, Boolean> synchronizedToggles;

    public String getName() {
        return "features";
    }

    public void registerAll(ForgeConfigSpec.Builder builder) {
        FeatureToggle.TOGGLEABLE_FEATURES.forEach(r -> this.toggles.put((ResourceLocation)r, (ForgeConfigSpec.ConfigValue<Boolean>)builder.define(r.m_135815_(), true)));
    }

    @ApiStatus.Internal
    public boolean hasToggle(ResourceLocation key) {
        return this.synchronizedToggles != null && this.synchronizedToggles.containsKey(key) || this.toggles.containsKey(key);
    }

    @ApiStatus.Internal
    public boolean isEnabled(ResourceLocation key) {
        Boolean synced;
        if (this.synchronizedToggles != null && (synced = this.synchronizedToggles.get(key)) != null) {
            return synced;
        }
        ForgeConfigSpec.ConfigValue<Boolean> value = this.toggles.get(key);
        if (value != null) {
            return (Boolean)value.get();
        }
        return true;
    }

    @Override
    public void onLoad() {
        super.onLoad();
        FeatureToggle.refreshItemVisibility();
    }

    @Override
    public void onReload() {
        super.onReload();
        FeatureToggle.refreshItemVisibility();
    }

    @Override
    protected void readSyncConfig(CompoundTag nbt) {
        this.synchronizedToggles = new HashMap<ResourceLocation, Boolean>();
        for (String key : nbt.m_128431_()) {
            ResourceLocation location = new ResourceLocation(key);
            this.synchronizedToggles.put(location, nbt.m_128471_(key));
        }
        FeatureToggle.refreshItemVisibility();
    }

    @Override
    protected ModConfig.Type type() {
        return ModConfig.Type.COMMON;
    }

    @Override
    protected void writeSyncConfig(CompoundTag nbt) {
        this.toggles.forEach((key, value) -> nbt.m_128379_(key.toString(), ((Boolean)value.get()).booleanValue()));
    }
}

