/*
 * Decompiled with CFR 0.152.
 */
package kalrog.cc_printers_plus.data;

import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kalrog.cc_printers_plus.data.Shape;
import net.minecraft.core.Direction;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ShapesCollection
extends HashSet<Shape> {
    private Integer cachedHashCode = null;

    @Override
    public int hashCode() {
        if (this.cachedHashCode == null) {
            this.cachedHashCode = super.hashCode();
        }
        return this.cachedHashCode;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof ShapesCollection)) {
            return false;
        }
        ShapesCollection otherShapes = (ShapesCollection)other;
        return otherShapes.hashCode() == this.hashCode() && super.equals(other);
    }

    public double getTotalVolume() {
        return this.stream().mapToDouble(shape -> {
            AABB bounds = shape.getBounds();
            return (bounds.f_82291_ - bounds.f_82288_) * (bounds.f_82292_ - bounds.f_82289_) * (bounds.f_82293_ - bounds.f_82290_);
        }).sum();
    }

    public double getTotalSurfaceArea() {
        return this.stream().mapToDouble(shape -> {
            AABB bounds = shape.getBounds();
            double dx = bounds.f_82291_ - bounds.f_82288_;
            double dy = bounds.f_82292_ - bounds.f_82289_;
            double dz = bounds.f_82293_ - bounds.f_82290_;
            return 2.0 * (dx * dy + dy * dz + dz * dx);
        }).sum();
    }

    public ListTag toNbt() {
        List sortedShapes = this.stream().sorted((a, b) -> Integer.compare(a.hashCode(), b.hashCode())).collect(Collectors.toList());
        ListTag list = new ListTag();
        for (Shape shape : sortedShapes) {
            list.add((Object)shape.toNbt());
        }
        return list;
    }

    public static ShapesCollection fromNbt(ListTag list) {
        ShapesCollection shapes = new ShapesCollection();
        for (int i = 0; i < list.size(); ++i) {
            shapes.add(Shape.fromNbt(list.m_128728_(i)));
        }
        return shapes;
    }

    public VoxelShape toVoxelShape(Direction direction) {
        if (this.isEmpty()) {
            return Shapes.m_83144_();
        }
        return this.stream().map(shape -> {
            AABB bounds = shape.getBounds();
            AABB rotatedBounds = ShapesCollection.rotateBounds(bounds, direction);
            return Shapes.m_83048_((double)(rotatedBounds.f_82288_ / 16.0), (double)(rotatedBounds.f_82289_ / 16.0), (double)(rotatedBounds.f_82290_ / 16.0), (double)(rotatedBounds.f_82291_ / 16.0), (double)(rotatedBounds.f_82292_ / 16.0), (double)(rotatedBounds.f_82293_ / 16.0));
        }).reduce(Shapes.m_83040_(), (a, b) -> Shapes.m_83148_((VoxelShape)a, (VoxelShape)b, (BooleanOp)BooleanOp.f_82695_)).m_83296_();
    }

    private static AABB rotateBounds(AABB bounds, Direction direction) {
        double newZ2;
        double newX2;
        double newZ1;
        double newX1;
        if (direction == Direction.NORTH) {
            return bounds;
        }
        double minX = bounds.f_82288_;
        double minY = bounds.f_82289_;
        double minZ = bounds.f_82290_;
        double maxX = bounds.f_82291_;
        double maxY = bounds.f_82292_;
        double maxZ = bounds.f_82293_;
        double x1 = minX - 8.0;
        double z1 = minZ - 8.0;
        double x2 = maxX - 8.0;
        double z2 = maxZ - 8.0;
        switch (direction) {
            case SOUTH: {
                newX1 = -x2;
                newZ1 = -z2;
                newX2 = -x1;
                newZ2 = -z1;
                break;
            }
            case WEST: {
                newX1 = z1;
                newZ1 = -x2;
                newX2 = z2;
                newZ2 = -x1;
                break;
            }
            case EAST: {
                newX1 = -z2;
                newZ1 = x1;
                newX2 = -z1;
                newZ2 = x2;
                break;
            }
            default: {
                return bounds;
            }
        }
        return new AABB(Math.min(newX1, newX2) + 8.0, minY, Math.min(newZ1, newZ2) + 8.0, Math.max(newX1, newX2) + 8.0, maxY, Math.max(newZ1, newZ2) + 8.0);
    }

    @Deprecated
    public VoxelShape toVoxelShape() {
        return this.toVoxelShape(Direction.NORTH);
    }
}

