/*
 * Decompiled with CFR 0.152.
 */
package kalrog.cc_printers_plus.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import kalrog.cc_printers_plus.block.PrinterBlock;
import kalrog.cc_printers_plus.block.entity.PrinterBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class PrinterRenderer
implements BlockEntityRenderer<PrinterBlockEntity> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("cc_printers_plus", "textures/gui/container/printer.png");
    private final ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();

    public PrinterRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(PrinterBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        this.renderPrint(blockEntity, partialTick, poseStack, bufferSource, packedLight, packedOverlay);
        this.renderInkOverlay(blockEntity, poseStack, bufferSource, packedLight, packedOverlay);
    }

    private void renderPrint(PrinterBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        ItemStack previewStack = blockEntity.getPreviewStack();
        if (previewStack.m_41619_()) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.7, 0.5);
        float animationAngle = (float)(System.currentTimeMillis() % 20000L) / 20000.0f * 360.0f;
        poseStack.m_252781_(Axis.f_252436_.m_252977_(animationAngle));
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        BakedModel model = this.itemRenderer.m_174264_(previewStack, blockEntity.m_58904_(), null, 0);
        this.itemRenderer.m_115143_(previewStack, ItemDisplayContext.FIXED, false, poseStack, bufferSource, packedLight, packedOverlay, model);
        poseStack.m_85849_();
    }

    private void renderInkOverlay(PrinterBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Direction facing = (Direction)blockEntity.m_58900_().m_61143_((Property)PrinterBlock.FACING);
        int chamelium = blockEntity.getChamelium();
        int ink = blockEntity.getInk();
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.5, 0.5);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-facing.m_122424_().m_122435_()));
        poseStack.m_85837_(-0.5, -0.5, -0.5);
        poseStack.m_85837_(0.0, 0.0, -0.001);
        float chameliumWidth = (float)chamelium / 256000.0f;
        this.drawQuad(poseStack, bufferSource, 0.1875f, 0.1875f, 0, 232, chameliumWidth, packedLight, packedOverlay);
        float inkWidth = (float)ink / 100000.0f;
        this.drawQuad(poseStack, bufferSource, 0.5625f, 0.1875f, 0, 240, inkWidth, packedLight, packedOverlay);
        poseStack.m_85849_();
    }

    private void drawQuad(PoseStack poseStack, MultiBufferSource bufferSource, float x0, float y0, int u, int v, float width, int packedLight, int packedOverlay) {
        VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)TEXTURE));
        float x1 = x0 + width * 0.25f;
        float y1 = y0 + 0.125f;
        float u0 = (float)u / 256.0f;
        float u1 = ((float)u + width * 16.0f) / 256.0f;
        float v0 = (float)v / 256.0f;
        float v1 = ((float)v + 8.0f) / 256.0f;
        PoseStack.Pose pose = poseStack.m_85850_();
        Matrix4f matrix = pose.m_252922_();
        Matrix3f normalMatrix = pose.m_252943_();
        this.vertex(matrix, normalMatrix, consumer, x0, y0, u0, v1, packedLight, packedOverlay);
        this.vertex(matrix, normalMatrix, consumer, x1, y0, u1, v1, packedLight, packedOverlay);
        this.vertex(matrix, normalMatrix, consumer, x1, y1, u1, v0, packedLight, packedOverlay);
        this.vertex(matrix, normalMatrix, consumer, x0, y1, u0, v0, packedLight, packedOverlay);
    }

    private void vertex(Matrix4f matrix, Matrix3f normalMatrix, VertexConsumer consumer, float x, float y, float u, float v, int packedLight, int packedOverlay) {
        consumer.m_252986_(matrix, 1.0f - x, y, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u, v).m_86008_(packedOverlay).m_85969_(packedLight).m_252939_(normalMatrix, 1.0f, 0.0f, 0.0f).m_5752_();
    }
}

