/*
 * Decompiled with CFR 0.152.
 */
package kalrog.cc_printers_plus.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import kalrog.cc_printers_plus.block.PrintBlock;
import kalrog.cc_printers_plus.block.entity.PrintBlockEntity;
import kalrog.cc_printers_plus.data.PrintData;
import kalrog.cc_printers_plus.data.Shape;
import kalrog.cc_printers_plus.data.ShapesCollection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.joml.Matrix4f;

public class PrintBlockRenderer
implements BlockEntityRenderer<PrintBlockEntity> {
    public PrintBlockRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(PrintBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        PrintData printData = blockEntity.getPrintData();
        if (printData == null || printData.isEmpty()) {
            return;
        }
        poseStack.m_85836_();
        if (printData.hasOrientation()) {
            Direction facing = (Direction)blockEntity.m_58900_().m_61143_((Property)PrintBlock.FACING);
            this.applyRotation(poseStack, facing);
        }
        ShapesCollection shapes = (Boolean)blockEntity.m_58900_().m_61143_((Property)PrintBlock.ON) != false ? printData.getShapesOn() : printData.getShapesOff();
        for (Shape shape : shapes) {
            this.renderShape(shape, poseStack, bufferSource, packedLight, packedOverlay);
        }
        poseStack.m_85849_();
    }

    private void applyRotation(PoseStack poseStack, Direction facing) {
        poseStack.m_85837_(0.5, 0.0, 0.5);
        switch (facing) {
            case SOUTH: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                break;
            }
            case WEST: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                break;
            }
            case EAST: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
                break;
            }
        }
        poseStack.m_85837_(-0.5, 0.0, -0.5);
    }

    private void renderShape(Shape shape, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        AABB bounds = shape.getBounds();
        ResourceLocation texture = shape.getTexture();
        Integer tint = shape.getTint();
        if (texture == null) {
            return;
        }
        TextureAtlasSprite sprite = this.getSprite(texture);
        VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_110463_());
        int color = tint != null ? tint | 0xFF000000 : -1;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float minX = (float)(bounds.f_82288_ / 16.0);
        float minY = (float)(bounds.f_82289_ / 16.0);
        float minZ = (float)(bounds.f_82290_ / 16.0);
        float maxX = (float)(bounds.f_82291_ / 16.0);
        float maxY = (float)(bounds.f_82292_ / 16.0);
        float maxZ = (float)(bounds.f_82293_ / 16.0);
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        this.renderFace(consumer, matrix, Direction.DOWN, minX, minY, minZ, maxX, maxY, maxZ, sprite, r, g, b, a, packedLight, packedOverlay);
        this.renderFace(consumer, matrix, Direction.UP, minX, minY, minZ, maxX, maxY, maxZ, sprite, r, g, b, a, packedLight, packedOverlay);
        this.renderFace(consumer, matrix, Direction.NORTH, minX, minY, minZ, maxX, maxY, maxZ, sprite, r, g, b, a, packedLight, packedOverlay);
        this.renderFace(consumer, matrix, Direction.SOUTH, minX, minY, minZ, maxX, maxY, maxZ, sprite, r, g, b, a, packedLight, packedOverlay);
        this.renderFace(consumer, matrix, Direction.WEST, minX, minY, minZ, maxX, maxY, maxZ, sprite, r, g, b, a, packedLight, packedOverlay);
        this.renderFace(consumer, matrix, Direction.EAST, minX, minY, minZ, maxX, maxY, maxZ, sprite, r, g, b, a, packedLight, packedOverlay);
    }

    private void renderFace(VertexConsumer consumer, Matrix4f matrix, Direction face, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, TextureAtlasSprite sprite, float r, float g, float b, float a, int packedLight, int packedOverlay) {
        switch (face) {
            case DOWN: {
                consumer.m_252986_(matrix, minX, minY, minZ).m_85950_(r, g, b, a).m_7421_(sprite.m_118367_((double)(minX * 16.0f)), sprite.m_118393_((double)(minZ * 16.0f))).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                consumer.m_252986_(matrix, maxX, minY, minZ).m_85950_(r, g, b, a).m_7421_(sprite.m_118367_((double)(maxX * 16.0f)), sprite.m_118393_((double)(minZ * 16.0f))).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                consumer.m_252986_(matrix, maxX, minY, maxZ).m_85950_(r, g, b, a).m_7421_(sprite.m_118367_((double)(maxX * 16.0f)), sprite.m_118393_((double)(maxZ * 16.0f))).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                consumer.m_252986_(matrix, minX, minY, maxZ).m_85950_(r, g, b, a).m_7421_(sprite.m_118367_((double)(minX * 16.0f)), sprite.m_118393_((double)(maxZ * 16.0f))).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                break;
            }
            case UP: {
                consumer.m_252986_(matrix, minX, maxY, minZ).m_85950_(r, g, b, a).m_7421_(sprite.m_118367_((double)(minX * 16.0f)), sprite.m_118393_((double)(minZ * 16.0f))).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                consumer.m_252986_(matrix, minX, maxY, maxZ).m_85950_(r, g, b, a).m_7421_(sprite.m_118367_((double)(minX * 16.0f)), sprite.m_118393_((double)(maxZ * 16.0f))).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                consumer.m_252986_(matrix, maxX, maxY, maxZ).m_85950_(r, g, b, a).m_7421_(sprite.m_118367_((double)(maxX * 16.0f)), sprite.m_118393_((double)(maxZ * 16.0f))).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                consumer.m_252986_(matrix, maxX, maxY, minZ).m_85950_(r, g, b, a).m_7421_(sprite.m_118367_((double)(maxX * 16.0f)), sprite.m_118393_((double)(minZ * 16.0f))).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                break;
            }
            case NORTH: {
                consumer.m_252986_(matrix, minX, minY, minZ).m_85950_(r, g, b, a).m_7421_(sprite.m_118367_((double)(minX * 16.0f)), sprite.m_118393_((double)(16.0f - minY * 16.0f))).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                consumer.m_252986_(matrix, minX, maxY, minZ).m_85950_(r, g, b, a).m_7421_(sprite.m_118367_((double)(minX * 16.0f)), sprite.m_118393_((double)(16.0f - maxY * 16.0f))).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                consumer.m_252986_(matrix, maxX, maxY, minZ).m_85950_(r, g, b, a).m_7421_(sprite.m_118367_((double)(maxX * 16.0f)), sprite.m_118393_((double)(16.0f - maxY * 16.0f))).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                consumer.m_252986_(matrix, maxX, minY, minZ).m_85950_(r, g, b, a).m_7421_(sprite.m_118367_((double)(maxX * 16.0f)), sprite.m_118393_((double)(16.0f - minY * 16.0f))).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                break;
            }
            case SOUTH: {
                consumer.m_252986_(matrix, minX, minY, maxZ).m_85950_(r, g, b, a).m_7421_(sprite.m_118367_((double)(16.0f - minX * 16.0f)), sprite.m_118393_((double)(16.0f - minY * 16.0f))).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                consumer.m_252986_(matrix, maxX, minY, maxZ).m_85950_(r, g, b, a).m_7421_(sprite.m_118367_((double)(16.0f - maxX * 16.0f)), sprite.m_118393_((double)(16.0f - minY * 16.0f))).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                consumer.m_252986_(matrix, maxX, maxY, maxZ).m_85950_(r, g, b, a).m_7421_(sprite.m_118367_((double)(16.0f - maxX * 16.0f)), sprite.m_118393_((double)(16.0f - maxY * 16.0f))).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                consumer.m_252986_(matrix, minX, maxY, maxZ).m_85950_(r, g, b, a).m_7421_(sprite.m_118367_((double)(16.0f - minX * 16.0f)), sprite.m_118393_((double)(16.0f - maxY * 16.0f))).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                break;
            }
            case WEST: {
                consumer.m_252986_(matrix, minX, minY, minZ).m_85950_(r, g, b, a).m_7421_(sprite.m_118367_((double)(minZ * 16.0f)), sprite.m_118393_((double)(16.0f - minY * 16.0f))).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                consumer.m_252986_(matrix, minX, minY, maxZ).m_85950_(r, g, b, a).m_7421_(sprite.m_118367_((double)(maxZ * 16.0f)), sprite.m_118393_((double)(16.0f - minY * 16.0f))).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                consumer.m_252986_(matrix, minX, maxY, maxZ).m_85950_(r, g, b, a).m_7421_(sprite.m_118367_((double)(maxZ * 16.0f)), sprite.m_118393_((double)(16.0f - maxY * 16.0f))).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                consumer.m_252986_(matrix, minX, maxY, minZ).m_85950_(r, g, b, a).m_7421_(sprite.m_118367_((double)(minZ * 16.0f)), sprite.m_118393_((double)(16.0f - maxY * 16.0f))).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                break;
            }
            case EAST: {
                consumer.m_252986_(matrix, maxX, minY, minZ).m_85950_(r, g, b, a).m_7421_(sprite.m_118367_((double)(16.0f - minZ * 16.0f)), sprite.m_118393_((double)(16.0f - minY * 16.0f))).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                consumer.m_252986_(matrix, maxX, maxY, minZ).m_85950_(r, g, b, a).m_7421_(sprite.m_118367_((double)(16.0f - minZ * 16.0f)), sprite.m_118393_((double)(16.0f - maxY * 16.0f))).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                consumer.m_252986_(matrix, maxX, maxY, maxZ).m_85950_(r, g, b, a).m_7421_(sprite.m_118367_((double)(16.0f - maxZ * 16.0f)), sprite.m_118393_((double)(16.0f - maxY * 16.0f))).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                consumer.m_252986_(matrix, maxX, minY, maxZ).m_85950_(r, g, b, a).m_7421_(sprite.m_118367_((double)(16.0f - maxZ * 16.0f)), sprite.m_118393_((double)(16.0f - minY * 16.0f))).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
            }
        }
    }

    private TextureAtlasSprite getSprite(ResourceLocation texture) {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(texture);
    }
}

