/*
 * Decompiled with CFR 0.152.
 */
package net.historynoob.blockrandomizer;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="blockrandomizer")
@Mod.EventBusSubscriber(modid="blockrandomizer", value={Dist.CLIENT})
public class BlockRandomizer {
    public static final String MODID = "blockrandomizer";
    public static KeyMapping toggleRandomizerKey;
    private static boolean randomizerEnabled;
    private Random random = new Random();

    public BlockRandomizer(FMLJavaModLoadingContext context) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::registerKeyMappings);
    }

    private void registerKeyMappings(RegisterKeyMappingsEvent event) {
        toggleRandomizerKey = new KeyMapping("key.blockrandomizer.toggle", InputConstants.Type.KEYSYM, 82, "key.categories.misc");
        event.register(toggleRandomizerKey);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && toggleRandomizerKey != null && toggleRandomizerKey.m_90859_()) {
            randomizerEnabled = !randomizerEnabled;
            Minecraft.m_91087_().f_91074_.m_213846_((Component)Component.m_237113_((String)("Block Randomizer: " + (randomizerEnabled ? "Enabled" : "Disabled"))));
        }
    }

    @SubscribeEvent
    public void onBlockPlace(PlayerInteractEvent.RightClickBlock event) {
        if (!randomizerEnabled || event.getEntity() != Minecraft.m_91087_().f_91074_) {
            return;
        }
        List<Integer> placableSlots = this.getPlacableSlots();
        if (!placableSlots.isEmpty()) {
            int randomSlot;
            Minecraft.m_91087_().f_91074_.m_150109_().f_35977_ = randomSlot = placableSlots.get(this.random.nextInt(placableSlots.size())).intValue();
        }
    }

    private List<Integer> getPlacableSlots() {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return slots;
        }
        for (int i = 0; i < 9; ++i) {
            ItemStack itemStack = mc.f_91074_.m_150109_().m_8020_(i);
            if (itemStack.m_41619_() || !(itemStack.m_41720_() instanceof BlockItem)) continue;
            slots.add(i);
        }
        return slots;
    }

    static {
        randomizerEnabled = false;
    }
}

