/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.client.gui.elements.buttons;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.dawnoftime.dawnoftime.DoTBCommon;
import org.dawnoftime.dawnoftime.client.gui.creative.CreativeInventoryCategories;
import org.dawnoftime.dawnoftime.mixin.api.CreativeScreen;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CategoryButton
extends Button {
    private final CreativeScreen parent;
    private boolean selected = false;
    private static final ResourceLocation[] BUTTON_ICONS = CategoryButton.fillButtonIcons();
    private static final Tooltip[] BUTTON_TOOLTIPS = CategoryButton.fillButtonTooltips();
    private final int index;

    public CategoryButton(int x, int y, int index, Button.OnPress pressable, CreativeScreen parent) {
        super(x, y, 32, 28, (Component)Component.m_237119_(), pressable, f_252438_);
        this.index = index;
        this.parent = parent;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public int getCategoryID() {
        return this.parent.dOTBuilder$getPage() * 4 + this.index;
    }

    @Nullable
    public Tooltip getTooltipForCategory() {
        int id = this.getCategoryID();
        if (id < BUTTON_TOOLTIPS.length && id >= 0) {
            return BUTTON_TOOLTIPS[id];
        }
        return null;
    }

    protected void m_87963_(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.f_93623_) {
            PoseStack ps = pGuiGraphics.m_280168_();
            ps.m_85836_();
            RenderSystem.clearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
            RenderSystem.enableBlend();
            pGuiGraphics.m_280218_(DoTBCommon.CREATIVE_ICONS, this.m_252754_() - 1, this.m_252907_(), 0, this.selected ? 0 : 28, 31, 28);
            RenderSystem.disableBlend();
            ps.m_85849_();
            ps.m_85836_();
            RenderSystem.clearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
            RenderSystem.enableBlend();
            pGuiGraphics.m_280398_(BUTTON_ICONS[this.getCategoryID()], this.m_252754_() + (this.selected ? 6 : 9), this.m_252907_() + 6, 0, 0.0f, 0.0f, 16, 16, 16, 16);
            RenderSystem.disableBlend();
            ps.m_85849_();
        }
    }

    private static ResourceLocation[] fillButtonIcons() {
        int number = CreativeInventoryCategories.values().length;
        ResourceLocation[] table = new ResourceLocation[number];
        for (int i = 0; i < number; ++i) {
            table[i] = new ResourceLocation("dawnoftimebuilder", "textures/item/logo_" + CreativeInventoryCategories.values()[i].getName() + ".png");
        }
        return table;
    }

    private static Tooltip[] fillButtonTooltips() {
        int number = CreativeInventoryCategories.values().length;
        Tooltip[] tooltips = new Tooltip[number];
        for (int i = 0; i < number; ++i) {
            tooltips[i] = Tooltip.m_257550_((Component)Component.m_237115_((String)("gui.dawnoftimebuilder." + CreativeInventoryCategories.values()[i].getName())));
        }
        return tooltips;
    }

    @Nullable
    public Tooltip m_278622_() {
        return this.f_93623_ ? super.m_278622_() : null;
    }

    protected ClientTooltipPositioner m_262860_() {
        return DefaultTooltipPositioner.f_262752_;
    }
}

