/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.templates;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.dawnoftime.dawnoftime.block.templates.WaterloggedBlock;
import org.dawnoftime.dawnoftime.util.BlockStatePropertiesAA;
import org.dawnoftime.dawnoftime.util.Utils;
import org.dawnoftime.dawnoftime.util.VoxelShapes;
import org.jetbrains.annotations.NotNull;

public class PortcullisBlock
extends WaterloggedBlock {
    private static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    private static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    private static final EnumProperty<Direction.Axis> HORIZONTAL_AXIS = BlockStateProperties.f_61364_;
    private static final EnumProperty<BlockStatePropertiesAA.VerticalConnection> VERTICAL_CONNECTION = BlockStatePropertiesAA.VERTICAL_CONNECTION;

    public PortcullisBlock(BlockBehaviour.Properties properties) {
        super(properties, VoxelShapes.PORTCULLIS_SHAPES);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_(HORIZONTAL_AXIS, (Comparable)Direction.Axis.X)).m_61124_(VERTICAL_CONNECTION, (Comparable)((Object)BlockStatePropertiesAA.VerticalConnection.NONE)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{OPEN, POWERED, HORIZONTAL_AXIS, VERTICAL_CONNECTION});
    }

    @Override
    public int getShapeIndex(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)OPEN)).booleanValue() && state.m_61143_(VERTICAL_CONNECTION) != BlockStatePropertiesAA.VerticalConnection.NONE && state.m_61143_(VERTICAL_CONNECTION) != BlockStatePropertiesAA.VerticalConnection.UNDER) {
            return 0;
        }
        return state.m_61143_(HORIZONTAL_AXIS) == Direction.Axis.X ? 1 : 2;
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        state = (BlockState)state.m_61124_(HORIZONTAL_AXIS, (Comparable)(context.m_8125_().m_122434_() == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X));
        return this.getShape(state, (LevelAccessor)context.m_43725_(), context.m_8083_());
    }

    @Override
    @NotNull
    public BlockState m_7417_(BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        stateIn = super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        return this.getShape(stateIn, worldIn, currentPos);
    }

    private BlockState getShape(BlockState state, LevelAccessor worldIn, BlockPos pos) {
        Direction.Axis axis = (Direction.Axis)state.m_61143_(HORIZONTAL_AXIS);
        if (this.hasSameAxis(worldIn.m_8055_(pos.m_7494_()), axis)) {
            return (BlockState)state.m_61124_(VERTICAL_CONNECTION, (Comparable)((Object)(this.hasSameAxis(worldIn.m_8055_(pos.m_7495_()), axis) ? BlockStatePropertiesAA.VerticalConnection.BOTH : BlockStatePropertiesAA.VerticalConnection.ABOVE)));
        }
        return (BlockState)state.m_61124_(VERTICAL_CONNECTION, (Comparable)((Object)(this.hasSameAxis(worldIn.m_8055_(pos.m_7495_()), axis) ? BlockStatePropertiesAA.VerticalConnection.UNDER : BlockStatePropertiesAA.VerticalConnection.NONE)));
    }

    private boolean hasSameAxis(BlockState state, Direction.Axis axis) {
        if (state.m_60734_() instanceof PortcullisBlock) {
            return state.m_61143_(HORIZONTAL_AXIS) == axis;
        }
        return false;
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        Direction.Axis axis;
        if (state.m_61143_(VERTICAL_CONNECTION) == BlockStatePropertiesAA.VerticalConnection.UNDER) {
            Direction.Axis axis2 = (Direction.Axis)state.m_61143_(HORIZONTAL_AXIS);
            boolean isNowPowered = worldIn.m_276867_(pos);
            if (((Boolean)state.m_61143_((Property)OPEN)).booleanValue()) {
                if (this.isInSamePlane(pos, fromPos, axis2) && isNowPowered) {
                    this.setOpenState(worldIn, pos, axis2, true);
                }
            } else if (isNowPowered) {
                this.setOpenState(worldIn, pos, axis2, true);
                state = (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(true));
            }
            if (!isNowPowered && ((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
                state = (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false));
                worldIn.m_7731_(pos, state, 2);
                if (!this.hasAnotherPowerSource(worldIn, pos, axis2)) {
                    this.setOpenState(worldIn, pos, axis2, false);
                }
            }
            if (isNowPowered != (Boolean)state.m_61143_((Property)POWERED)) {
                state = (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(isNowPowered));
                worldIn.m_7731_(pos, state, 2);
            }
        } else if (state.m_61143_(VERTICAL_CONNECTION) == BlockStatePropertiesAA.VerticalConnection.NONE) {
            if (((Boolean)state.m_61143_((Property)OPEN)).booleanValue()) {
                worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false)), 2);
            }
        } else if (((Boolean)state.m_61143_((Property)OPEN)).booleanValue() && this.isInSamePlane(pos, fromPos, axis = (Direction.Axis)state.m_61143_(HORIZONTAL_AXIS))) {
            pos = this.getTopPortcullisPos(worldIn, pos, axis);
            worldIn.m_8055_(pos).m_60690_(worldIn, pos, blockIn, fromPos, isMoving);
        }
    }

    private boolean isInSamePlane(BlockPos pos, BlockPos fromPos, Direction.Axis axis) {
        return axis == Direction.Axis.X ? fromPos.m_123343_() == pos.m_123343_() : fromPos.m_123341_() == pos.m_123341_();
    }

    private BlockPos getTopPortcullisPos(Level worldIn, BlockPos pos, Direction.Axis axis) {
        boolean isStillPortcullis = true;
        while (isStillPortcullis) {
            BlockState state = worldIn.m_8055_(pos);
            if (state.m_60734_() instanceof PortcullisBlock) {
                if (!this.hasSameAxis(state, axis)) {
                    isStillPortcullis = false;
                }
            } else {
                isStillPortcullis = false;
            }
            pos = pos.m_7494_();
        }
        return pos.m_7495_();
    }

    private boolean hasAnotherPowerSource(Level worldIn, BlockPos pos, Direction.Axis axis) {
        boolean isAxisX = axis == Direction.Axis.X;
        Direction direction = isAxisX ? Direction.WEST : Direction.NORTH;
        int widthLeft = this.getPortcullisWidth(worldIn, pos, axis, isAxisX ? Direction.EAST : Direction.SOUTH);
        int widthRight = this.getPortcullisWidth(worldIn, pos, axis, isAxisX ? Direction.WEST : Direction.NORTH);
        pos = pos.m_5484_(direction, -widthLeft);
        for (int i = 0; i <= widthLeft + widthRight; ++i) {
            BlockState state = worldIn.m_8055_(pos.m_5484_(direction, i));
            if (!((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private void setOpenState(Level worldIn, BlockPos pos, Direction.Axis axis, boolean openState) {
        BlockState state;
        boolean isAxisX = axis == Direction.Axis.X;
        Direction direction = isAxisX ? Direction.WEST : Direction.NORTH;
        int height = this.getPortcullisHeight(worldIn, pos, axis);
        int widthLeft = this.getPortcullisWidth(worldIn, pos, axis, isAxisX ? Direction.EAST : Direction.SOUTH);
        int widthRight = this.getPortcullisWidth(worldIn, pos, axis, isAxisX ? Direction.WEST : Direction.NORTH);
        if (height > 16 || widthLeft + widthRight + 1 > 16) {
            return;
        }
        if (openState) {
            int vertical;
            int horizontal;
            for (horizontal = 1; horizontal <= widthLeft; ++horizontal) {
                for (vertical = 0; vertical < height; ++vertical) {
                    state = worldIn.m_8055_(pos.m_5484_(isAxisX ? Direction.EAST : Direction.SOUTH, horizontal).m_6625_(vertical));
                    if (state.m_60734_() instanceof PortcullisBlock) {
                        if (state.m_61143_(HORIZONTAL_AXIS) == axis) continue;
                        openState = false;
                        break;
                    }
                    openState = false;
                    break;
                }
                if (!openState) break;
            }
            if (openState) {
                for (horizontal = 1; horizontal <= widthRight; ++horizontal) {
                    for (vertical = 0; vertical < height; ++vertical) {
                        state = worldIn.m_8055_(pos.m_5484_(direction, horizontal).m_6625_(vertical));
                        if (state.m_60734_() instanceof PortcullisBlock) {
                            if (state.m_61143_(HORIZONTAL_AXIS) == axis) continue;
                            openState = false;
                            break;
                        }
                        openState = false;
                        break;
                    }
                    if (!openState) break;
                }
            }
            if (openState) {
                openState = this.isCorrectBorder(worldIn, pos.m_5484_(direction, -widthLeft).m_7494_(), axis, isAxisX ? Direction.WEST : Direction.NORTH, widthLeft + widthRight);
                openState = openState && this.isCorrectBorder(worldIn, pos.m_5484_(direction, -widthLeft).m_6625_(height), axis, isAxisX ? Direction.WEST : Direction.NORTH, widthLeft + widthRight);
                openState = openState && this.isCorrectBorder(worldIn, pos.m_5484_(direction, -widthLeft - 1), axis, Direction.DOWN, height - 1);
                openState = openState && this.isCorrectBorder(worldIn, pos.m_5484_(direction, widthRight + 1), axis, Direction.DOWN, height - 1);
            }
        }
        pos = pos.m_5484_(direction, -widthLeft);
        for (int horizontal = 0; horizontal < widthLeft + widthRight + 1; ++horizontal) {
            for (int vertical = 0; vertical < height; ++vertical) {
                BlockPos newPos = pos.m_5484_(direction, horizontal).m_6625_(vertical);
                state = worldIn.m_8055_(newPos);
                if (!(state.m_60734_() instanceof PortcullisBlock) || state.m_61143_(HORIZONTAL_AXIS) != axis) continue;
                worldIn.m_7731_(newPos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(openState)), 10);
                if (horizontal != widthLeft) continue;
                if (vertical == 0 && openState) {
                    worldIn.m_5898_(null, this.getOpenSound(), newPos, 0);
                }
                if (vertical != height - 1 || openState) continue;
                worldIn.m_5898_(null, this.getCloseSound(), newPos, 0);
            }
        }
    }

    private int getPortcullisHeight(Level worldIn, BlockPos pos, Direction.Axis axis) {
        int height = 0;
        boolean isSamePortcullis = true;
        while (isSamePortcullis) {
            BlockState state = worldIn.m_8055_(pos = pos.m_7495_());
            if (state.m_60734_() instanceof PortcullisBlock) {
                if (state.m_61143_(HORIZONTAL_AXIS) != axis) {
                    isSamePortcullis = false;
                }
            } else {
                isSamePortcullis = false;
            }
            ++height;
        }
        return height;
    }

    private int getPortcullisWidth(Level worldIn, BlockPos pos, Direction.Axis axis, Direction direction) {
        int width = 0;
        boolean isSamePortcullis = true;
        while (isSamePortcullis) {
            BlockState state = worldIn.m_8055_(pos = pos.m_121945_(direction));
            if (state.m_60734_() instanceof PortcullisBlock) {
                if (state.m_61143_(HORIZONTAL_AXIS) != axis) {
                    isSamePortcullis = false;
                }
            } else {
                isSamePortcullis = false;
            }
            ++width;
        }
        return width - 1;
    }

    private boolean isCorrectBorder(Level worldIn, BlockPos pos, Direction.Axis axis, Direction direction, int length) {
        for (int i = 0; i <= length; ++i) {
            BlockState state = worldIn.m_8055_(pos.m_5484_(direction, i));
            if (!(state.m_60734_() instanceof PortcullisBlock) || state.m_61143_(HORIZONTAL_AXIS) != axis) continue;
            return false;
        }
        return true;
    }

    private int getCloseSound() {
        return 1011;
    }

    private int getOpenSound() {
        return 1005;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        if (rot == Rotation.CLOCKWISE_90 || rot == Rotation.COUNTERCLOCKWISE_90) {
            return (BlockState)state.m_61124_(HORIZONTAL_AXIS, (Comparable)(state.m_61143_(HORIZONTAL_AXIS) == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X));
        }
        return super.m_6843_(state, rot);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_5871_(stack, worldIn, tooltip, flagIn);
        Utils.addTooltip(tooltip, this, new String[0]);
    }
}

