/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.armoroftheages.client.models.holy_armor;

import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.LivingEntity;
import org.dawnoftime.armoroftheages.client.models.ArmorModel;

public class ChestHolyArmorModel<T extends LivingEntity>
extends ArmorModel<T> {
    private final ModelPart chestEffectFrontA;
    private final ModelPart chestEffectFrontB;
    private final ModelPart chestEffectBig;
    private final ModelPart chestEffectMiddle;
    private final ModelPart chestEffectMiddleRotated;
    private final ModelPart chestEffectSmall;
    private final ModelPart chestEffectSmallRotated;
    private final ModelPart armLeftEffect;
    private final ModelPart armLeftEffectRotated;
    private final ModelPart armLeftWing;
    private final ModelPart armRightEffect;
    private final ModelPart armRightEffectRotated;
    private final ModelPart armRightWing;

    public ChestHolyArmorModel(ModelPart root, boolean isSlim) {
        super(root, isSlim);
        ModelPart chestCore = this.f_102810_.m_171324_("chestCore");
        this.chestEffectFrontA = chestCore.m_171324_("chestEffectFrontA");
        this.chestEffectFrontB = chestCore.m_171324_("chestEffectFrontB");
        this.chestEffectBig = this.f_102810_.m_171324_("chestEffectBig");
        this.chestEffectMiddle = this.f_102810_.m_171324_("chestEffectMiddle");
        this.chestEffectMiddleRotated = this.f_102810_.m_171324_("chestEffectMiddleRotated");
        this.chestEffectSmall = this.f_102810_.m_171324_("chestEffectSmall");
        this.chestEffectSmallRotated = this.f_102810_.m_171324_("chestEffectSmallRotated");
        this.armLeftEffect = this.f_102812_.m_171324_("armLeftEffect");
        this.armLeftEffectRotated = this.f_102812_.m_171324_("armLeftEffectRotated");
        this.armLeftWing = this.f_102812_.m_171324_("armLeftElbow").m_171324_("armLeftWing");
        this.armRightEffect = this.f_102811_.m_171324_("armRightEffect");
        this.armRightEffectRotated = this.f_102811_.m_171324_("armRightEffectRotated");
        this.armRightWing = this.f_102811_.m_171324_("armRightElbow").m_171324_("armRightWing");
    }

    @Override
    public <E extends LivingEntity> ArmorModel<E> create(ModelPart root, boolean isSlim) {
        return new ChestHolyArmorModel<T>(root, isSlim);
    }

    public static LayerDefinition createLayerDefinition() {
        MeshDefinition meshdefinition = ChestHolyArmorModel.templateLayerDefinition(1.0f);
        PartDefinition root = meshdefinition.m_171576_();
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 28).m_171488_(-4.5f, -0.5f, -2.5f, 9.0f, 13.0f, 5.0f, new CubeDeformation(-0.2f)), PartPose.f_171404_);
        PartDefinition chestEffectBig = body.m_171599_("chestEffectBig", CubeListBuilder.m_171558_().m_171514_(66, 0).m_171481_(-15.5f, -15.5f, 0.0f, 31.0f, 31.0f, 0.0f), PartPose.m_171419_((float)0.0f, (float)-2.5f, (float)7.0f));
        chestEffectBig.m_171599_("chestEffectBigRotated", CubeListBuilder.m_171558_().m_171514_(90, 31).m_171481_(-9.5f, -9.5f, 0.0f, 19.0f, 19.0f, 0.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        body.m_171599_("chestEffectMiddle", CubeListBuilder.m_171558_().m_171514_(0, 63).m_171481_(-8.5f, -8.5f, 0.01f, 17.0f, 17.0f, 0.0f), PartPose.m_171419_((float)0.0f, (float)-2.5f, (float)8.0f));
        body.m_171599_("chestEffectMiddleRotated", CubeListBuilder.m_171558_().m_171514_(0, 80).m_171481_(-6.5f, -6.5f, 0.0f, 13.0f, 13.0f, 0.0f), PartPose.m_171419_((float)0.0f, (float)-2.5f, (float)8.0f));
        body.m_171599_("chestEffectSmall", CubeListBuilder.m_171558_().m_171514_(83, 50).m_171481_(-4.5f, -4.5f, 0.0f, 9.0f, 9.0f, 0.0f), PartPose.m_171419_((float)0.0f, (float)-2.5f, (float)9.0f));
        body.m_171599_("chestEffectSmallRotated", CubeListBuilder.m_171558_().m_171514_(101, 50).m_171481_(-4.5f, -4.5f, 0.01f, 9.0f, 9.0f, 0.0f), PartPose.m_171419_((float)0.0f, (float)-2.5f, (float)9.0f));
        body.m_171599_("chestBack", CubeListBuilder.m_171558_().m_171514_(0, 46).m_171481_(-3.5f, -6.5f, -1.7f, 7.0f, 12.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)6.2f, (float)2.5f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        body.m_171599_("chestPecRight", CubeListBuilder.m_171558_().m_171514_(37, 45).m_171480_().m_171481_(-4.0f, -5.0f, -2.9f, 4.0f, 5.0f, 4.0f), PartPose.m_171423_((float)0.5f, (float)4.0f, (float)-0.5f, (float)-0.2007f, (float)0.0f, (float)-0.2618f));
        body.m_171599_("chestPecLeft", CubeListBuilder.m_171558_().m_171514_(37, 45).m_171481_(0.0f, -5.0f, -2.9f, 4.0f, 5.0f, 4.0f), PartPose.m_171423_((float)-0.5f, (float)4.0f, (float)-0.5f, (float)-0.2007f, (float)0.0f, (float)0.2618f));
        PartDefinition chestCore = body.m_171599_("chestCore", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171481_(-1.0f, -3.5f, 0.0f, 2.0f, 3.0f, 1.0f), PartPose.m_171423_((float)0.0f, (float)4.5f, (float)-3.6f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        chestCore.m_171599_("chestEffectFrontA", CubeListBuilder.m_171558_().m_171514_(34, 70).m_171481_(-2.5f, -2.5f, 0.01f, 5.0f, 5.0f, 0.0f), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)0.3f));
        chestCore.m_171599_("chestEffectFrontB", CubeListBuilder.m_171558_().m_171514_(34, 75).m_171481_(-2.5f, -2.5f, 0.0f, 5.0f, 5.0f, 0.0f), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)0.3f));
        body.m_171599_("abs", CubeListBuilder.m_171558_().m_171514_(18, 48).m_171481_(-3.5f, -1.0f, 0.3f, 7.0f, 8.0f, 1.0f), PartPose.m_171423_((float)0.0f, (float)4.7f, (float)-3.3f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition armRight = root.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(46, 28).m_171480_().m_171488_(-3.5f, -2.0f, -2.5f, 5.0f, 12.0f, 5.0f, new CubeDeformation(-0.19f)), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        armRight.m_171599_("armRightShoulderA", CubeListBuilder.m_171558_().m_171514_(25, 21).m_171480_().m_171481_(-4.0f, -3.5f, -3.5f, 6.0f, 5.0f, 7.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        armRight.m_171599_("armRightShoulderB", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171480_().m_171481_(-6.2f, -2.0f, -4.0f, 8.0f, 1.0f, 8.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.6109f));
        PartDefinition armRightElbow = armRight.m_171599_("armRightElbow", CubeListBuilder.m_171558_().m_171514_(44, 20).m_171480_().m_171481_(-3.5f, 3.3f, -3.0f, 5.0f, 2.0f, 6.0f), PartPose.f_171404_);
        armRightElbow.m_171599_("armRightElbowDetail", CubeListBuilder.m_171558_().m_171514_(0, 6).m_171480_().m_171481_(-4.0f, 3.8f, -1.1f, 1.0f, 1.0f, 1.0f), PartPose.f_171404_);
        armRightElbow.m_171599_("armRightWing", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171480_().m_171481_(-0.099f, -1.0f, 0.0f, 0.0f, 2.0f, 4.0f), PartPose.m_171423_((float)-3.401f, (float)4.3f, (float)-1.6f, (float)0.1745f, (float)-0.3054f, (float)0.0f));
        armRight.m_171599_("armRightGlove", CubeListBuilder.m_171558_().m_171514_(47, 48).m_171480_().m_171488_(-2.5f, -1.5f, 0.0f, 5.0f, 3.0f, 6.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)-1.0f, (float)9.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)-0.0873f));
        armRight.m_171599_("armRightEffect", CubeListBuilder.m_171558_().m_171514_(34, 56).m_171480_().m_171488_(0.0f, -3.5f, -3.5f, 0.0f, 7.0f, 7.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)-3.0f, (float)5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.0f));
        armRight.m_171599_("armRightEffectRotated", CubeListBuilder.m_171558_().m_171514_(34, 56).m_171480_().m_171488_(0.0f, -3.5f, -3.5f, 0.0f, 7.0f, 7.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)-3.0f, (float)5.0f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)-1.0f));
        PartDefinition armLeft = root.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(46, 28).m_171488_(-1.5f, -2.0f, -2.5f, 5.0f, 12.0f, 5.0f, new CubeDeformation(-0.19f)), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        armLeft.m_171599_("armLeftShoulderA", CubeListBuilder.m_171558_().m_171514_(25, 21).m_171481_(-2.0f, -3.5f, -3.5f, 6.0f, 5.0f, 7.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        armLeft.m_171599_("armLeftShoulderB", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171481_(-1.8f, -2.0f, -4.0f, 8.0f, 1.0f, 8.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.6109f));
        PartDefinition armLeftElbow = armLeft.m_171599_("armLeftElbow", CubeListBuilder.m_171558_().m_171514_(44, 20).m_171481_(-1.5f, 3.3f, -3.0f, 5.0f, 2.0f, 6.0f), PartPose.f_171404_);
        armLeftElbow.m_171599_("armLeftElbowDetail", CubeListBuilder.m_171558_().m_171514_(0, 6).m_171481_(3.0f, 3.8f, -1.1f, 1.0f, 1.0f, 1.0f), PartPose.f_171404_);
        armLeftElbow.m_171599_("armLeftWing", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.099f, -1.0f, 0.0f, 0.0f, 2.0f, 4.0f), PartPose.m_171423_((float)3.401f, (float)4.3f, (float)-1.6f, (float)0.1745f, (float)0.3054f, (float)0.0f));
        armLeft.m_171599_("armLeftGlove", CubeListBuilder.m_171558_().m_171514_(47, 48).m_171488_(-2.5f, -1.5f, 0.0f, 5.0f, 3.0f, 6.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)1.0f, (float)9.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.0873f));
        armLeft.m_171599_("armLeftEffect", CubeListBuilder.m_171558_().m_171514_(34, 56).m_171488_(0.0f, -3.5f, -3.5f, 0.0f, 7.0f, 7.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)3.0f, (float)5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f));
        armLeft.m_171599_("armLeftEffectRotated", CubeListBuilder.m_171558_().m_171514_(34, 56).m_171488_(0.0f, -3.5f, -3.5f, 0.0f, 7.0f, 7.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)3.0f, (float)5.0f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)1.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public static LayerDefinition createSlimLayerDefinition() {
        MeshDefinition meshdefinition = ChestHolyArmorModel.templateLayerDefinition(1.0f);
        PartDefinition root = meshdefinition.m_171576_();
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 28).m_171488_(-4.5f, -0.5f, -2.5f, 9.0f, 13.0f, 5.0f, new CubeDeformation(-0.2f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition chestEffectBig = body.m_171599_("chestEffectBig", CubeListBuilder.m_171558_().m_171514_(66, 0).m_171481_(-15.5f, -15.5f, 0.0f, 31.0f, 31.0f, 0.0f), PartPose.m_171419_((float)0.0f, (float)-2.5f, (float)7.0f));
        chestEffectBig.m_171599_("chestEffectBigRotated", CubeListBuilder.m_171558_().m_171514_(90, 31).m_171481_(-9.5f, -9.5f, 0.0f, 19.0f, 19.0f, 0.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        body.m_171599_("chestEffectMiddle", CubeListBuilder.m_171558_().m_171514_(0, 63).m_171481_(-8.5f, -8.5f, 0.01f, 17.0f, 17.0f, 0.0f), PartPose.m_171419_((float)0.0f, (float)-2.5f, (float)8.0f));
        body.m_171599_("chestEffectMiddleRotated", CubeListBuilder.m_171558_().m_171514_(0, 80).m_171481_(-6.5f, -6.5f, 0.0f, 13.0f, 13.0f, 0.0f), PartPose.m_171419_((float)0.0f, (float)-2.5f, (float)8.0f));
        body.m_171599_("chestEffectSmall", CubeListBuilder.m_171558_().m_171514_(83, 50).m_171481_(-4.5f, -4.5f, 0.0f, 9.0f, 9.0f, 0.0f), PartPose.m_171419_((float)0.0f, (float)-2.5f, (float)9.0f));
        body.m_171599_("chestEffectSmallRotated", CubeListBuilder.m_171558_().m_171514_(101, 50).m_171481_(-4.5f, -4.5f, 0.01f, 9.0f, 9.0f, 0.0f), PartPose.m_171419_((float)0.0f, (float)-2.5f, (float)9.0f));
        body.m_171599_("chestBack", CubeListBuilder.m_171558_().m_171514_(0, 46).m_171481_(-3.5f, -6.5f, -1.7f, 7.0f, 12.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)6.2f, (float)2.5f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        body.m_171599_("chestPecRight", CubeListBuilder.m_171558_().m_171514_(37, 45).m_171480_().m_171481_(-4.0f, -4.0f, -3.5f, 4.0f, 5.0f, 4.0f), PartPose.m_171423_((float)0.5f, (float)4.0f, (float)-0.5f, (float)-0.3752f, (float)0.0f, (float)-0.1745f));
        body.m_171599_("chestPecLeft", CubeListBuilder.m_171558_().m_171514_(37, 45).m_171481_(0.0f, -4.0f, -3.5f, 4.0f, 5.0f, 4.0f), PartPose.m_171423_((float)-0.5f, (float)4.0f, (float)-0.5f, (float)-0.3752f, (float)0.0f, (float)0.1745f));
        PartDefinition chestCore = body.m_171599_("chestCore", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171481_(-1.0f, -3.5f, -0.7f, 2.0f, 3.0f, 1.0f), PartPose.m_171423_((float)0.0f, (float)4.5f, (float)-3.6f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        chestCore.m_171599_("chestEffectFrontA", CubeListBuilder.m_171558_().m_171514_(34, 70).m_171481_(-2.5f, -2.5f, 0.01f, 5.0f, 5.0f, 0.0f), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)0.3f));
        chestCore.m_171599_("chestEffectFrontB", CubeListBuilder.m_171558_().m_171514_(34, 75).m_171481_(-2.5f, -2.5f, 0.0f, 5.0f, 5.0f, 0.0f), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)0.3f));
        body.m_171599_("abs", CubeListBuilder.m_171558_().m_171514_(18, 48).m_171481_(-3.5f, -1.0f, 0.8f, 7.0f, 8.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)4.7f, (float)-3.3f));
        PartDefinition armRight = root.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(46, 28).m_171480_().m_171488_(-2.5f, -2.0f, -2.5f, 4.0f, 12.0f, 5.0f, new CubeDeformation(-0.19f)), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        armRight.m_171599_("armRightShoulderA", CubeListBuilder.m_171558_().m_171514_(25, 21).m_171480_().m_171481_(-3.0f, -3.5f, -3.5f, 5.0f, 5.0f, 7.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        armRight.m_171599_("armRightShoulderB", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171480_().m_171481_(-5.2f, -2.0f, -4.0f, 7.0f, 1.0f, 8.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.6109f));
        PartDefinition armRightElbow = armRight.m_171599_("armRightElbow", CubeListBuilder.m_171558_().m_171514_(44, 20).m_171480_().m_171481_(-2.5f, 3.3f, -3.0f, 4.0f, 2.0f, 6.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        armRightElbow.m_171599_("armRightElbowDetail", CubeListBuilder.m_171558_().m_171514_(0, 6).m_171480_().m_171481_(-3.0f, 3.8f, -1.1f, 1.0f, 1.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        armRightElbow.m_171599_("armRightWing", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171480_().m_171481_(0.901f, -1.0f, 0.0f, 0.0f, 2.0f, 4.0f), PartPose.m_171423_((float)-3.401f, (float)4.3f, (float)-1.6f, (float)0.1745f, (float)-0.3054f, (float)0.0f));
        armRight.m_171599_("armRightGlove", CubeListBuilder.m_171558_().m_171514_(47, 48).m_171480_().m_171488_(-1.5f, -1.5f, 0.0f, 4.0f, 3.0f, 6.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)-1.0f, (float)9.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)-0.0873f));
        armRight.m_171599_("armRightEffect", CubeListBuilder.m_171558_().m_171514_(34, 56).m_171480_().m_171488_(0.0f, -3.5f, -3.5f, 0.0f, 7.0f, 7.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)-3.0f, (float)5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.0f));
        armRight.m_171599_("armRightEffectRotated", CubeListBuilder.m_171558_().m_171514_(34, 56).m_171480_().m_171488_(0.0f, -3.5f, -3.5f, 0.0f, 7.0f, 7.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)-3.0f, (float)5.0f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)-1.0f));
        PartDefinition armLeft = root.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(46, 28).m_171488_(-1.5f, -2.0f, -2.5f, 4.0f, 12.0f, 5.0f, new CubeDeformation(-0.19f)), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        armLeft.m_171599_("armLeftShoulderA", CubeListBuilder.m_171558_().m_171514_(25, 21).m_171481_(-2.0f, -3.5f, -3.5f, 5.0f, 5.0f, 7.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        armLeft.m_171599_("armLeftShoulderB", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171481_(-1.8f, -2.0f, -4.0f, 7.0f, 1.0f, 8.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.6109f));
        PartDefinition armLeftElbow = armLeft.m_171599_("armLeftElbow", CubeListBuilder.m_171558_().m_171514_(44, 20).m_171481_(-1.5f, 3.3f, -3.0f, 4.0f, 2.0f, 6.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        armLeftElbow.m_171599_("armLeftElbowDetail", CubeListBuilder.m_171558_().m_171514_(0, 6).m_171481_(2.0f, 3.8f, -1.1f, 1.0f, 1.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        armLeftElbow.m_171599_("armLeftWing", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-0.901f, -1.0f, 0.0f, 0.0f, 2.0f, 4.0f), PartPose.m_171423_((float)3.401f, (float)4.3f, (float)-1.6f, (float)0.1745f, (float)0.3054f, (float)0.0f));
        armLeft.m_171599_("armLeftGlove", CubeListBuilder.m_171558_().m_171514_(47, 48).m_171488_(-2.5f, -1.5f, 0.0f, 4.0f, 3.0f, 6.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)1.0f, (float)9.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.0873f));
        armLeft.m_171599_("armLeftEffect", CubeListBuilder.m_171558_().m_171514_(34, 56).m_171488_(0.0f, -3.5f, -3.5f, 0.0f, 7.0f, 7.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)3.0f, (float)5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f));
        armLeft.m_171599_("armLeftEffectRotated", CubeListBuilder.m_171558_().m_171514_(34, 56).m_171488_(0.0f, -3.5f, -3.5f, 0.0f, 7.0f, 7.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)3.0f, (float)5.0f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)1.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    @Override
    protected void setupArmorPartAnim(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float dA = ageInTicks / 40.0f;
        float rotation = dA % ((float)Math.PI * 2);
        float rotationD = (dA + 0.7853982f) % ((float)Math.PI * 2);
        this.chestEffectFrontA.f_104205_ = rotation;
        this.chestEffectFrontB.f_104205_ = rotationD;
        this.chestEffectMiddle.f_104205_ = rotation;
        this.chestEffectMiddleRotated.f_104205_ = rotationD;
        this.armLeftEffect.f_104203_ = -rotation;
        this.armLeftEffectRotated.f_104203_ = -rotationD;
        this.armRightEffect.f_104203_ = -rotation;
        this.armRightEffectRotated.f_104203_ = -rotationD;
        dA = 0.1f * ChestHolyArmorModel.sinPI(dA);
        this.armLeftWing.f_104203_ = 0.1745f + dA;
        this.armRightWing.f_104203_ = 0.1745f + dA;
        this.chestEffectBig.f_104201_ = dA = 0.06f * ChestHolyArmorModel.sinPI(ageInTicks / 80.0f);
        this.chestEffectMiddle.f_104201_ = dA;
        this.chestEffectMiddleRotated.f_104201_ = dA;
        this.chestEffectSmall.f_104201_ = dA;
        this.chestEffectSmallRotated.f_104201_ = dA;
        dA = ageInTicks / 20.0f;
        rotation = dA % ((float)Math.PI * 2);
        rotationD = (dA + 0.7853982f) % ((float)Math.PI * 2);
        this.chestEffectSmall.f_104205_ = -rotation;
        this.chestEffectSmallRotated.f_104205_ = -rotationD;
    }
}

