/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.armoroftheages.client;

import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import org.dawnoftime.armoroftheages.client.ArmorModelProvider;
import org.dawnoftime.armoroftheages.client.ArmorModelSupplier;
import org.jetbrains.annotations.NotNull;

public class AnimatedArmorModelProvider
extends ArmorModelProvider {
    private final ResourceLocation[] resourceLocations;
    private final int ticksPerFrame;

    public static ArmorModelProvider create(String armorName, EquipmentSlot slot, ArmorModelSupplier modelSupplier, Supplier<LayerDefinition> layerDefinitionSupplier, int numberOfFrames, int ticksPerFrame) {
        return new AnimatedArmorModelProvider(armorName, slot, modelSupplier, layerDefinitionSupplier, numberOfFrames, ticksPerFrame);
    }

    public static ArmorModelProvider create(String armorName, EquipmentSlot slot, ArmorModelSupplier modelSupplier, Supplier<LayerDefinition> layerDefinitionSupplier, Supplier<LayerDefinition> slimLayerDefinitionSupplier, int numberOfFrames, int ticksPerFrame) {
        return new AnimatedMixedArmorModelProvider(armorName, slot, modelSupplier, layerDefinitionSupplier, slimLayerDefinitionSupplier, numberOfFrames, ticksPerFrame);
    }

    private AnimatedArmorModelProvider(String armorName, EquipmentSlot slot, ArmorModelSupplier modelSupplier, Supplier<LayerDefinition> layerDefinitionSupplier, int numberOfFrames, int ticksPerFrame) {
        super(armorName, slot, modelSupplier, layerDefinitionSupplier);
        this.resourceLocations = (ResourceLocation[])IntStream.range(0, numberOfFrames).mapToObj(n -> new ResourceLocation("armoroftheages", "textures/models/armor/" + armorName + "_" + (n + 1) + ".png")).toArray(ResourceLocation[]::new);
        this.ticksPerFrame = ticksPerFrame;
    }

    @Override
    @NotNull
    public ResourceLocation getTexture(Entity entity) {
        return this.resourceLocations[entity.f_19797_ / this.ticksPerFrame % this.resourceLocations.length];
    }

    public static class AnimatedMixedArmorModelProvider
    extends ArmorModelProvider.MixedArmorModelProvider {
        private final ResourceLocation[] resourceLocations;
        private final ResourceLocation[] slimResourceLocations;
        private final int ticksPerFrame;

        private AnimatedMixedArmorModelProvider(String armorName, EquipmentSlot slot, ArmorModelSupplier modelSupplier, Supplier<LayerDefinition> layerDefinitionSupplier, Supplier<LayerDefinition> slimLayerDefinitionSupplier, int numberOfFrames, int ticksPerFrame) {
            super(armorName, slot, modelSupplier, layerDefinitionSupplier, slimLayerDefinitionSupplier);
            this.resourceLocations = (ResourceLocation[])IntStream.range(0, numberOfFrames).mapToObj(n -> new ResourceLocation("armoroftheages", "textures/models/armor/" + armorName + "_" + (n + 1) + ".png")).toArray(ResourceLocation[]::new);
            this.slimResourceLocations = (ResourceLocation[])IntStream.range(0, numberOfFrames).mapToObj(n -> new ResourceLocation("armoroftheages", "textures/models/armor/" + armorName + "_slim_" + (n + 1) + ".png")).toArray(ResourceLocation[]::new);
            this.ticksPerFrame = ticksPerFrame;
        }

        @Override
        @NotNull
        public ResourceLocation getTexture(Entity entity) {
            if (AnimatedMixedArmorModelProvider.isSlim(entity)) {
                return this.slimResourceLocations[entity.f_19797_ / this.ticksPerFrame % this.slimResourceLocations.length];
            }
            return this.resourceLocations[entity.f_19797_ / this.ticksPerFrame % this.resourceLocations.length];
        }
    }
}

