/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.render.RenderUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BrewingStandBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BrewingStandBlockEntity;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;

public class InventoryOverlay {
    public static final ResourceLocation TEXTURE_BREWING_STAND = new ResourceLocation("textures/gui/container/brewing_stand.png");
    public static final ResourceLocation TEXTURE_DISPENSER = new ResourceLocation("textures/gui/container/dispenser.png");
    public static final ResourceLocation TEXTURE_DOUBLE_CHEST = new ResourceLocation("textures/gui/container/generic_54.png");
    public static final ResourceLocation TEXTURE_FURNACE = new ResourceLocation("textures/gui/container/furnace.png");
    public static final ResourceLocation TEXTURE_HOPPER = new ResourceLocation("textures/gui/container/hopper.png");
    public static final ResourceLocation TEXTURE_PLAYER_INV = new ResourceLocation("textures/gui/container/hopper.png");
    public static final ResourceLocation TEXTURE_SINGLE_CHEST = new ResourceLocation("textures/gui/container/shulker_box.png");
    private static final EquipmentSlot[] VALID_EQUIPMENT_SLOTS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    public static final InventoryProperties INV_PROPS_TEMP = new InventoryProperties();
    private static final ResourceLocation[] EMPTY_SLOT_TEXTURES = new ResourceLocation[]{new ResourceLocation("item/empty_armor_slot_boots"), new ResourceLocation("item/empty_armor_slot_leggings"), new ResourceLocation("item/empty_armor_slot_chestplate"), new ResourceLocation("item/empty_armor_slot_helmet")};

    public static void renderInventoryBackground(InventoryRenderType type, int x, int y, int slotsPerRow, int totalSlots, Minecraft mc) {
        RenderUtils.setupBlend();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.applyModelViewMatrix();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        if (type == InventoryRenderType.FURNACE) {
            RenderUtils.bindTexture(TEXTURE_FURNACE);
            RenderUtils.drawTexturedRectBatched(x, y, 0, 0, 4, 64, buffer);
            RenderUtils.drawTexturedRectBatched(x + 4, y, 84, 0, 92, 4, buffer);
            RenderUtils.drawTexturedRectBatched(x, y + 64, 0, 162, 92, 4, buffer);
            RenderUtils.drawTexturedRectBatched(x + 92, y + 4, 172, 102, 4, 64, buffer);
            RenderUtils.drawTexturedRectBatched(x + 4, y + 4, 52, 13, 88, 60, buffer);
        } else if (type == InventoryRenderType.BREWING_STAND) {
            RenderUtils.bindTexture(TEXTURE_BREWING_STAND);
            RenderUtils.drawTexturedRectBatched(x, y, 0, 0, 4, 68, buffer);
            RenderUtils.drawTexturedRectBatched(x + 4, y, 63, 0, 113, 4, buffer);
            RenderUtils.drawTexturedRectBatched(x, y + 68, 0, 162, 113, 4, buffer);
            RenderUtils.drawTexturedRectBatched(x + 113, y + 4, 172, 98, 4, 68, buffer);
            RenderUtils.drawTexturedRectBatched(x + 4, y + 4, 13, 13, 109, 64, buffer);
        } else if (type == InventoryRenderType.DISPENSER) {
            RenderUtils.bindTexture(TEXTURE_DISPENSER);
            RenderUtils.drawTexturedRectBatched(x, y, 0, 0, 7, 61, buffer);
            RenderUtils.drawTexturedRectBatched(x + 7, y, 115, 0, 61, 7, buffer);
            RenderUtils.drawTexturedRectBatched(x, y + 61, 0, 159, 61, 7, buffer);
            RenderUtils.drawTexturedRectBatched(x + 61, y + 7, 169, 105, 7, 61, buffer);
            RenderUtils.drawTexturedRectBatched(x + 7, y + 7, 61, 16, 54, 54, buffer);
        } else if (type == InventoryRenderType.HOPPER) {
            RenderUtils.bindTexture(TEXTURE_HOPPER);
            RenderUtils.drawTexturedRectBatched(x, y, 0, 0, 7, 25, buffer);
            RenderUtils.drawTexturedRectBatched(x + 7, y, 79, 0, 97, 7, buffer);
            RenderUtils.drawTexturedRectBatched(x, y + 25, 0, 126, 97, 7, buffer);
            RenderUtils.drawTexturedRectBatched(x + 97, y + 7, 169, 108, 7, 25, buffer);
            RenderUtils.drawTexturedRectBatched(x + 7, y + 7, 43, 19, 90, 18, buffer);
        } else if (type == InventoryRenderType.VILLAGER) {
            RenderUtils.bindTexture(TEXTURE_DOUBLE_CHEST);
            RenderUtils.drawTexturedRectBatched(x, y, 0, 0, 7, 79, buffer);
            RenderUtils.drawTexturedRectBatched(x + 7, y, 133, 0, 43, 7, buffer);
            RenderUtils.drawTexturedRectBatched(x, y + 79, 0, 215, 43, 7, buffer);
            RenderUtils.drawTexturedRectBatched(x + 43, y + 7, 169, 143, 7, 79, buffer);
            RenderUtils.drawTexturedRectBatched(x + 7, y + 7, 7, 17, 36, 72, buffer);
        } else if (type == InventoryRenderType.FIXED_27) {
            InventoryOverlay.renderInventoryBackground27(x, y, buffer, mc);
        } else if (type == InventoryRenderType.FIXED_54) {
            InventoryOverlay.renderInventoryBackground54(x, y, buffer, mc);
        } else {
            RenderUtils.bindTexture(TEXTURE_DOUBLE_CHEST);
            int rows = (int)Math.ceil((double)totalSlots / (double)slotsPerRow);
            int bgw = Math.min(totalSlots, slotsPerRow) * 18 + 7;
            int bgh = rows * 18 + 7;
            RenderUtils.drawTexturedRectBatched(x, y, 0, 0, 7, bgh, buffer);
            RenderUtils.drawTexturedRectBatched(x + 7, y, 176 - bgw, 0, bgw, 7, buffer);
            RenderUtils.drawTexturedRectBatched(x, y + bgh, 0, 215, bgw, 7, buffer);
            RenderUtils.drawTexturedRectBatched(x + bgw, y + 7, 169, 222 - bgh, 7, bgh, buffer);
            for (int row = 0; row < rows; ++row) {
                int rowLen = Mth.m_14045_((int)(totalSlots - row * slotsPerRow), (int)1, (int)slotsPerRow);
                RenderUtils.drawTexturedRectBatched(x + 7, y + row * 18 + 7, 7, 17, rowLen * 18, 18, buffer);
                if (rows <= 1 || rowLen >= slotsPerRow) continue;
                RenderUtils.drawTexturedRectBatched(x + rowLen * 18 + 7, y + row * 18 + 7, 7, 3, (slotsPerRow - rowLen) * 18, 9, buffer);
                RenderUtils.drawTexturedRectBatched(x + rowLen * 18 + 7, y + row * 18 + 16, 7, 3, (slotsPerRow - rowLen) * 18, 9, buffer);
            }
        }
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        tessellator.m_85914_();
    }

    public static void renderInventoryBackground27(int x, int y, BufferBuilder buffer, Minecraft mc) {
        RenderUtils.bindTexture(TEXTURE_SINGLE_CHEST);
        RenderUtils.drawTexturedRectBatched(x, y, 0, 0, 7, 61, buffer);
        RenderUtils.drawTexturedRectBatched(x + 7, y, 7, 0, 169, 7, buffer);
        RenderUtils.drawTexturedRectBatched(x, y + 61, 0, 159, 169, 7, buffer);
        RenderUtils.drawTexturedRectBatched(x + 169, y + 7, 169, 105, 7, 61, buffer);
        RenderUtils.drawTexturedRectBatched(x + 7, y + 7, 7, 17, 162, 54, buffer);
    }

    public static void renderInventoryBackground54(int x, int y, BufferBuilder buffer, Minecraft mc) {
        RenderUtils.bindTexture(TEXTURE_DOUBLE_CHEST);
        RenderUtils.drawTexturedRectBatched(x, y, 0, 0, 7, 115, buffer);
        RenderUtils.drawTexturedRectBatched(x + 7, y, 7, 0, 169, 7, buffer);
        RenderUtils.drawTexturedRectBatched(x, y + 115, 0, 215, 169, 7, buffer);
        RenderUtils.drawTexturedRectBatched(x + 169, y + 7, 169, 107, 7, 115, buffer);
        RenderUtils.drawTexturedRectBatched(x + 7, y + 7, 7, 17, 162, 108, buffer);
    }

    public static void renderEquipmentOverlayBackground(int x, int y, LivingEntity entity, GuiGraphics drawContext) {
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.applyModelViewMatrix();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        RenderUtils.bindTexture(TEXTURE_DISPENSER);
        RenderUtils.drawTexturedRectBatched(x, y, 0, 0, 50, 83, buffer);
        RenderUtils.drawTexturedRectBatched(x + 50, y, 173, 0, 3, 83, buffer);
        RenderUtils.drawTexturedRectBatched(x, y + 83, 0, 163, 50, 3, buffer);
        RenderUtils.drawTexturedRectBatched(x + 50, y + 83, 173, 163, 3, 3, buffer);
        int i = 0;
        int xOff = 7;
        int yOff = 7;
        while (i < 4) {
            RenderUtils.drawTexturedRectBatched(x + xOff, y + yOff, 61, 16, 18, 18, buffer);
            ++i;
            yOff += 18;
        }
        RenderUtils.drawTexturedRectBatched(x + 28, y + 36 + 7, 61, 16, 18, 18, buffer);
        RenderUtils.drawTexturedRectBatched(x + 28, y + 54 + 7, 61, 16, 18, 18, buffer);
        tessellator.m_85914_();
        RenderUtils.bindTexture(InventoryMenu.f_39692_);
        if (entity.m_6844_(EquipmentSlot.OFFHAND).m_41619_()) {
            ResourceLocation texture = new ResourceLocation("minecraft:item/empty_armor_slot_shield");
            RenderUtils.renderSprite(x + 28 + 1, y + 54 + 7 + 1, 16, 16, InventoryMenu.f_39692_, texture, drawContext);
        }
        i = 0;
        xOff = 7;
        yOff = 7;
        while (i < 4) {
            EquipmentSlot eqSlot = VALID_EQUIPMENT_SLOTS[i];
            if (entity.m_6844_(eqSlot).m_41619_()) {
                ResourceLocation texture = EMPTY_SLOT_TEXTURES[eqSlot.m_20749_()];
                RenderUtils.renderSprite(x + xOff + 1, y + yOff + 1, 16, 16, InventoryMenu.f_39692_, texture, drawContext);
            }
            ++i;
            yOff += 18;
        }
    }

    public static InventoryRenderType getInventoryType(Container inv) {
        if (inv instanceof ShulkerBoxBlockEntity) {
            return InventoryRenderType.FIXED_27;
        }
        if (inv instanceof CompoundContainer) {
            return InventoryRenderType.FIXED_54;
        }
        if (inv instanceof AbstractFurnaceBlockEntity) {
            return InventoryRenderType.FURNACE;
        }
        if (inv instanceof BrewingStandBlockEntity) {
            return InventoryRenderType.BREWING_STAND;
        }
        if (inv instanceof DispenserBlockEntity) {
            return InventoryRenderType.DISPENSER;
        }
        if (inv instanceof HopperBlockEntity) {
            return InventoryRenderType.HOPPER;
        }
        if (inv.getClass() == SimpleContainer.class) {
            return InventoryRenderType.HORSE;
        }
        return InventoryRenderType.GENERIC;
    }

    public static InventoryRenderType getInventoryType(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof BlockItem) {
            Block block = ((BlockItem)item).m_40614_();
            if (block instanceof ShulkerBoxBlock || block instanceof ChestBlock) {
                return InventoryRenderType.FIXED_27;
            }
            if (block instanceof AbstractFurnaceBlock) {
                return InventoryRenderType.FURNACE;
            }
            if (block instanceof DispenserBlock) {
                return InventoryRenderType.DISPENSER;
            }
            if (block instanceof HopperBlock) {
                return InventoryRenderType.HOPPER;
            }
            if (block instanceof BrewingStandBlock) {
                return InventoryRenderType.BREWING_STAND;
            }
        }
        return InventoryRenderType.GENERIC;
    }

    public static InventoryProperties getInventoryPropsTemp(InventoryRenderType type, int totalSlots) {
        InventoryOverlay.INV_PROPS_TEMP.totalSlots = totalSlots;
        if (type == InventoryRenderType.FURNACE) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 1;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 0;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 0;
            InventoryOverlay.INV_PROPS_TEMP.width = 96;
            InventoryOverlay.INV_PROPS_TEMP.height = 68;
        } else if (type == InventoryRenderType.BREWING_STAND) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 9;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 0;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 0;
            InventoryOverlay.INV_PROPS_TEMP.width = 127;
            InventoryOverlay.INV_PROPS_TEMP.height = 72;
        } else if (type == InventoryRenderType.DISPENSER) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 3;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            InventoryOverlay.INV_PROPS_TEMP.width = 68;
            InventoryOverlay.INV_PROPS_TEMP.height = 68;
        } else if (type == InventoryRenderType.HORSE) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = Math.max(1, totalSlots / 3);
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            InventoryOverlay.INV_PROPS_TEMP.width = totalSlots * 18 / 3 + 14;
            InventoryOverlay.INV_PROPS_TEMP.height = 68;
        } else if (type == InventoryRenderType.HOPPER) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 5;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            InventoryOverlay.INV_PROPS_TEMP.width = 105;
            InventoryOverlay.INV_PROPS_TEMP.height = 32;
        } else if (type == InventoryRenderType.VILLAGER) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 2;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            InventoryOverlay.INV_PROPS_TEMP.width = 50;
            InventoryOverlay.INV_PROPS_TEMP.height = 86;
        } else {
            if (type == InventoryRenderType.FIXED_27) {
                totalSlots = 27;
            } else if (type == InventoryRenderType.FIXED_54) {
                totalSlots = 54;
            }
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 9;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            int rows = (int)Math.ceil((double)totalSlots / (double)InventoryOverlay.INV_PROPS_TEMP.slotsPerRow);
            InventoryOverlay.INV_PROPS_TEMP.width = Math.min(InventoryOverlay.INV_PROPS_TEMP.slotsPerRow, totalSlots) * 18 + 14;
            InventoryOverlay.INV_PROPS_TEMP.height = rows * 18 + 14;
        }
        return INV_PROPS_TEMP;
    }

    public static void renderInventoryStacks(InventoryRenderType type, Container inv, int startX, int startY, int slotsPerRow, int startSlot, int maxSlots, Minecraft mc, GuiGraphics drawContext) {
        if (type == InventoryRenderType.FURNACE) {
            InventoryOverlay.renderStackAt(inv.m_8020_(0), startX + 8, startY + 8, 1.0f, mc, drawContext);
            InventoryOverlay.renderStackAt(inv.m_8020_(1), startX + 8, startY + 44, 1.0f, mc, drawContext);
            InventoryOverlay.renderStackAt(inv.m_8020_(2), startX + 68, startY + 26, 1.0f, mc, drawContext);
        } else if (type == InventoryRenderType.BREWING_STAND) {
            InventoryOverlay.renderStackAt(inv.m_8020_(0), startX + 47, startY + 42, 1.0f, mc, drawContext);
            InventoryOverlay.renderStackAt(inv.m_8020_(1), startX + 70, startY + 49, 1.0f, mc, drawContext);
            InventoryOverlay.renderStackAt(inv.m_8020_(2), startX + 93, startY + 42, 1.0f, mc, drawContext);
            InventoryOverlay.renderStackAt(inv.m_8020_(3), startX + 70, startY + 8, 1.0f, mc, drawContext);
            InventoryOverlay.renderStackAt(inv.m_8020_(4), startX + 8, startY + 8, 1.0f, mc, drawContext);
        } else {
            int slots = inv.m_6643_();
            int x = startX;
            int y = startY;
            if (maxSlots < 0) {
                maxSlots = slots;
            }
            int slot = startSlot;
            int i = 0;
            while (slot < slots && i < maxSlots) {
                for (int column = 0; column < slotsPerRow && slot < slots && i < maxSlots; ++column, ++slot, ++i) {
                    ItemStack stack = inv.m_8020_(slot);
                    if (!stack.m_41619_()) {
                        InventoryOverlay.renderStackAt(stack, x, y, 1.0f, mc, drawContext);
                    }
                    x += 18;
                }
                x = startX;
                y += 18;
            }
        }
    }

    public static void renderEquipmentStacks(LivingEntity entity, int x, int y, Minecraft mc, GuiGraphics drawContext) {
        int i = 0;
        int xOff = 7;
        int yOff = 7;
        while (i < 4) {
            EquipmentSlot eqSlot = VALID_EQUIPMENT_SLOTS[i];
            ItemStack stack = entity.m_6844_(eqSlot);
            if (!stack.m_41619_()) {
                InventoryOverlay.renderStackAt(stack, x + xOff + 1, y + yOff + 1, 1.0f, mc, drawContext);
            }
            ++i;
            yOff += 18;
        }
        ItemStack stack = entity.m_6844_(EquipmentSlot.MAINHAND);
        if (!stack.m_41619_()) {
            InventoryOverlay.renderStackAt(stack, x + 28, y + 36 + 7 + 1, 1.0f, mc, drawContext);
        }
        if (!(stack = entity.m_6844_(EquipmentSlot.OFFHAND)).m_41619_()) {
            InventoryOverlay.renderStackAt(stack, x + 28, y + 54 + 7 + 1, 1.0f, mc, drawContext);
        }
    }

    public static void renderItemStacks(NonNullList<ItemStack> items, int startX, int startY, int slotsPerRow, int startSlot, int maxSlots, Minecraft mc, GuiGraphics drawContext) {
        int slots = items.size();
        int x = startX;
        int y = startY;
        if (maxSlots < 0) {
            maxSlots = slots;
        }
        int slot = startSlot;
        int i = 0;
        while (slot < slots && i < maxSlots) {
            for (int column = 0; column < slotsPerRow && slot < slots && i < maxSlots; ++column, ++slot, ++i) {
                ItemStack stack = (ItemStack)items.get(slot);
                if (!stack.m_41619_()) {
                    InventoryOverlay.renderStackAt(stack, x, y, 1.0f, mc, drawContext);
                }
                x += 18;
            }
            x = startX;
            y += 18;
        }
    }

    public static void renderStackAt(ItemStack stack, float x, float y, float scale, Minecraft mc, GuiGraphics drawContext) {
        PoseStack matrixStack = drawContext.m_280168_();
        matrixStack.m_85836_();
        matrixStack.m_252880_(x, y, 0.0f);
        matrixStack.m_85841_(scale, scale, 1.0f);
        RenderUtils.enableDiffuseLightingGui3D();
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        drawContext.m_280480_(stack, 0, 0);
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        drawContext.m_280370_(mc.f_91062_, stack, 0, 0);
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.m_85849_();
    }

    public static void renderStackToolTip(int x, int y, ItemStack stack, Minecraft mc, GuiGraphics drawContext) {
        List list = stack.m_41651_((Player)mc.f_91074_, (TooltipFlag)(mc.f_91066_.f_92125_ ? TooltipFlag.Default.f_256730_ : TooltipFlag.Default.f_256752_));
        ArrayList<String> lines = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            if (i == 0) {
                lines.add(String.valueOf(stack.m_41791_().f_43022_) + ((Component)list.get(i)).getString());
                continue;
            }
            lines.add(GuiBase.TXT_DARK_GRAY + ((Component)list.get(i)).getString());
        }
        RenderUtils.drawHoverText(x, y, lines, drawContext);
    }

    public static enum InventoryRenderType {
        BREWING_STAND,
        DISPENSER,
        FURNACE,
        HOPPER,
        HORSE,
        FIXED_27,
        FIXED_54,
        VILLAGER,
        GENERIC;

    }

    public static class InventoryProperties {
        public int totalSlots = 1;
        public int width = 176;
        public int height = 83;
        public int slotsPerRow = 9;
        public int slotOffsetX = 8;
        public int slotOffsetY = 8;
    }
}

