/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.util.shape;

import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.PositionUtils;
import fi.dy.masa.minihud.renderer.shapes.SideQuad;
import fi.dy.masa.minihud.util.ShapeRenderType;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;

public class SphereUtils {
    public static void collectSpherePositions(Consumer<BlockPos.MutableBlockPos> positionConsumer, RingPositionTest test, BlockPos centerPos, int radius) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        mutablePos.m_122190_((Vec3i)centerPos);
        SphereUtils.addPositionsOnHorizontalBlockRing(positionConsumer, mutablePos, test);
        mutablePos.m_122190_((Vec3i)centerPos);
        SphereUtils.addPositionsOnVerticalBlockRing(positionConsumer, mutablePos, Direction.NORTH, test);
        int r = radius + 2;
        for (int i = 1; i < r; ++i) {
            mutablePos.m_122178_(centerPos.m_123341_(), centerPos.m_123342_() - i, centerPos.m_123343_());
            SphereUtils.addPositionsOnHorizontalBlockRing(positionConsumer, mutablePos, test);
            mutablePos.m_122178_(centerPos.m_123341_(), centerPos.m_123342_() + i, centerPos.m_123343_());
            SphereUtils.addPositionsOnHorizontalBlockRing(positionConsumer, mutablePos, test);
            mutablePos.m_122178_(centerPos.m_123341_(), centerPos.m_123342_(), centerPos.m_123343_() - i);
            SphereUtils.addPositionsOnVerticalBlockRing(positionConsumer, mutablePos, Direction.NORTH, test);
            mutablePos.m_122178_(centerPos.m_123341_(), centerPos.m_123342_(), centerPos.m_123343_() + i);
            SphereUtils.addPositionsOnVerticalBlockRing(positionConsumer, mutablePos, Direction.NORTH, test);
        }
    }

    public static boolean movePositionToRing(BlockPos.MutableBlockPos posMutable, Direction moveDirection, RingPositionTest test) {
        int incX = moveDirection.m_122429_();
        int incY = moveDirection.m_122430_();
        int incZ = moveDirection.m_122431_();
        int x = posMutable.m_123341_();
        int y = posMutable.m_123342_();
        int z = posMutable.m_123343_();
        int nextX = x;
        int nextY = y;
        int nextZ = z;
        while (test.isInsideOrCloserThan(nextX, nextY, nextZ, moveDirection)) {
            x = nextX;
            y = nextY;
            z = nextZ;
            nextX += incX;
            nextY += incY;
            nextZ += incZ;
        }
        if (x != nextX || y != nextY | z != nextZ) {
            posMutable.m_122178_(x, y, z);
            return true;
        }
        return false;
    }

    public static void addPositionsOnHorizontalBlockRing(Consumer<BlockPos.MutableBlockPos> positionConsumer, BlockPos.MutableBlockPos mutablePos, RingPositionTest test) {
        Function<Direction, Direction> nextDirectionFunction = SphereUtils::getNextHorizontalDirection;
        Direction startDirection = Direction.EAST;
        SphereUtils.addPositionsOnBlockRing(positionConsumer, mutablePos, startDirection, test, nextDirectionFunction);
    }

    public static void addPositionsOnVerticalBlockRing(Consumer<BlockPos.MutableBlockPos> positionConsumer, BlockPos.MutableBlockPos mutablePos, Direction mainAxis, RingPositionTest test) {
        Function<Direction, Direction> nextDirectionFunction = dir -> SphereUtils.getNextVerticalRingDirection(dir, mainAxis);
        Direction startDirection = Direction.UP;
        SphereUtils.addPositionsOnBlockRing(positionConsumer, mutablePos, startDirection, test, nextDirectionFunction);
    }

    public static void addPositionsOnBlockRing(Consumer<BlockPos.MutableBlockPos> positionConsumer, BlockPos.MutableBlockPos mutablePos, Direction startDirection, RingPositionTest test, Function<Direction, Direction> nextDirectionFunction) {
        if (SphereUtils.movePositionToRing(mutablePos, startDirection, test)) {
            LongOpenHashSet seenPositions = new LongOpenHashSet();
            BlockPos firstPos = mutablePos.m_7949_();
            Direction direction = startDirection;
            positionConsumer.accept(mutablePos);
            while (true) {
                direction = SphereUtils.getNextPositionOnBlockRing(mutablePos, direction, test, nextDirectionFunction);
                long posLong = mutablePos.m_121878_();
                if (direction == null || mutablePos.equals((Object)firstPos) || seenPositions.contains(posLong)) break;
                positionConsumer.accept(mutablePos);
                seenPositions.add(posLong);
            }
        }
    }

    @Nullable
    public static Direction getNextPositionOnBlockRing(BlockPos.MutableBlockPos posMutable, Direction escapeDirection, RingPositionTest test, Function<Direction, Direction> nextDirectionFunction) {
        Direction dirOut = escapeDirection;
        for (int i = 0; i < 4; ++i) {
            int z;
            int y;
            int x = posMutable.m_123341_() + escapeDirection.m_122429_();
            if (test.isInsideOrCloserThan(x, y = posMutable.m_123342_() + escapeDirection.m_122430_(), z = posMutable.m_123343_() + escapeDirection.m_122431_(), escapeDirection)) {
                posMutable.m_122178_(x, y, z);
                return dirOut;
            }
            Direction ccw90 = nextDirectionFunction.apply(escapeDirection);
            if (test.isInsideOrCloserThan(x += ccw90.m_122429_(), y += ccw90.m_122430_(), z += ccw90.m_122431_(), escapeDirection)) {
                posMutable.m_122178_(x, y, z);
                return dirOut;
            }
            dirOut = escapeDirection;
            escapeDirection = nextDirectionFunction.apply(escapeDirection);
        }
        return null;
    }

    public static boolean isPositionInsideOrClosestToRadiusOnBlockRing(int blockX, int blockY, int blockZ, Vec3 center, double squareRadius, Direction escapeDirection) {
        double zAdj;
        double yAdj;
        double x = (double)blockX + 0.5;
        double y = (double)blockY + 0.5;
        double z = (double)blockZ + 0.5;
        double dist = center.m_82531_(x, y, z);
        double diff = squareRadius - dist;
        if (diff > 0.0) {
            return true;
        }
        double xAdj = (double)blockX + (double)escapeDirection.m_122429_() + 0.5;
        double distAdj = center.m_82531_(xAdj, yAdj = (double)blockY + (double)escapeDirection.m_122430_() + 0.5, zAdj = (double)blockZ + (double)escapeDirection.m_122431_() + 0.5);
        double diffAdj = squareRadius - distAdj;
        return diffAdj > 0.0 && Math.abs(diff) < Math.abs(diffAdj);
    }

    public static Direction getNextHorizontalDirection(Direction dirIn) {
        return dirIn.m_122428_();
    }

    public static Direction getNextVerticalRingDirection(Direction currentDirection, Direction mainAxis) {
        return switch (mainAxis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN, Direction.UP -> {
                switch (currentDirection) {
                    case NORTH: {
                        yield Direction.DOWN;
                    }
                    case SOUTH: {
                        yield Direction.UP;
                    }
                    case DOWN: {
                        yield Direction.SOUTH;
                    }
                }
                yield Direction.NORTH;
            }
            case Direction.NORTH, Direction.SOUTH -> {
                switch (currentDirection) {
                    case WEST: {
                        yield Direction.UP;
                    }
                    case EAST: {
                        yield Direction.DOWN;
                    }
                    case DOWN: {
                        yield Direction.WEST;
                    }
                }
                yield Direction.EAST;
            }
            case Direction.WEST, Direction.EAST -> {
                switch (currentDirection) {
                    case NORTH: {
                        yield Direction.UP;
                    }
                    case SOUTH: {
                        yield Direction.DOWN;
                    }
                    case DOWN: {
                        yield Direction.NORTH;
                    }
                }
                yield Direction.SOUTH;
            }
        };
    }

    public static Direction[] getDirectionsNotOnAxis(Direction.Axis axis) {
        Direction[] sides = new Direction[4];
        int index = 0;
        for (Direction side : PositionUtils.ALL_DIRECTIONS) {
            if (side.m_122434_() == axis) continue;
            sides[index++] = side;
        }
        return sides;
    }

    public static List<SideQuad> buildSphereShellToQuads(LongOpenHashSet positions, Direction.Axis mainAxis, RingPositionTest test, ShapeRenderType renderType, LayerRange layerRange) {
        Long2ObjectOpenHashMap<SideQuad> strips = SphereUtils.buildSphereShellToStrips(positions, mainAxis, test, renderType, layerRange);
        return SphereUtils.buildStripsToQuads(strips, mainAxis);
    }

    public static Long2ObjectOpenHashMap<SideQuad> buildSphereShellToStrips(LongOpenHashSet positions, Direction.Axis mainAxis, RingPositionTest test, ShapeRenderType renderType, LayerRange layerRange) {
        Long2ObjectOpenHashMap strips = new Long2ObjectOpenHashMap();
        Long2ByteOpenHashMap handledPositions = new Long2ByteOpenHashMap();
        Direction[] sides = PositionUtils.ALL_DIRECTIONS;
        LongIterator longIterator = positions.iterator();
        while (longIterator.hasNext()) {
            long pos = (Long)longIterator.next();
            if (!layerRange.isPositionWithinRange(pos)) continue;
            for (Direction side : sides) {
                if (SphereUtils.isHandledAndMarkHandled(pos, side, handledPositions) || !SphereUtils.shouldRenderSide(pos, side, test, renderType, positions)) continue;
                Direction minDir = side.m_122434_() != mainAxis ? SphereUtils.getNegativeDirectionFor(SphereUtils.getThirdAxis(mainAxis, side.m_122434_())) : (mainAxis.m_122478_() ? Direction.WEST : Direction.DOWN);
                Direction maxDir = minDir.m_122424_();
                int lengthMin = SphereUtils.getStripLengthOnSide(pos, side, minDir, test, renderType, positions, handledPositions);
                int lengthMax = SphereUtils.getStripLengthOnSide(pos, side, maxDir, test, renderType, positions, handledPositions);
                long startPosLong = SphereUtils.offsetPos(pos, minDir, lengthMin);
                int length = lengthMin + lengthMax + 1;
                long index = SphereUtils.getCompressedPosSide(startPosLong, side);
                strips.put(index, (Object)new SideQuad(startPosLong, length, 1, side));
            }
        }
        return strips;
    }

    public static List<SideQuad> buildStripsToQuads(Long2ObjectOpenHashMap<SideQuad> strips, Direction.Axis mainAxis) {
        ArrayList<SideQuad> quads = new ArrayList<SideQuad>();
        Long2ByteOpenHashMap handledPositions = new Long2ByteOpenHashMap();
        for (SideQuad strip : strips.values()) {
            Direction side;
            long pos = strip.startPos();
            if (SphereUtils.isHandledAndMarkHandled(pos, side = strip.side(), handledPositions)) continue;
            Direction minDir = side.m_122434_() != mainAxis ? SphereUtils.getNegativeDirectionFor(mainAxis) : (mainAxis.m_122478_() ? Direction.NORTH : Direction.DOWN);
            Direction maxDir = minDir.m_122424_();
            int stripCountMin = SphereUtils.getStripCountOnSide(strip, minDir, strips, handledPositions);
            int stripCountMax = SphereUtils.getStripCountOnSide(strip, maxDir, strips, handledPositions);
            long startPos = SphereUtils.offsetPos(pos, minDir, stripCountMin);
            int height = stripCountMin + stripCountMax + 1;
            quads.add(new SideQuad(startPos, strip.width(), height, side));
        }
        return quads;
    }

    protected static int getStripCountOnSide(SideQuad startStrip, Direction offsetSide, Long2ObjectOpenHashMap<SideQuad> strips, Long2ByteOpenHashMap handledPositions) {
        long index;
        SideQuad adjStrip;
        long startPos = startStrip.startPos();
        Direction side = startStrip.side();
        int width = startStrip.width();
        long adjPos = BlockPos.m_121915_((long)startPos, (Direction)offsetSide);
        int count = 0;
        while ((adjStrip = (SideQuad)strips.get(index = SphereUtils.getCompressedPosSide(adjPos, side))) != null && adjStrip.width() == width && !SphereUtils.isHandledAndMarkHandled(adjPos, side, handledPositions)) {
            ++count;
            adjPos = BlockPos.m_121915_((long)adjPos, (Direction)offsetSide);
        }
        return count;
    }

    protected static int getStripLengthOnSide(long pos, Direction side, Direction moveDirection, RingPositionTest test, ShapeRenderType renderType, LongOpenHashSet positions, Long2ByteOpenHashMap handledPositions) {
        int length = 0;
        long adjPos = BlockPos.m_121915_((long)pos, (Direction)moveDirection);
        while (positions.contains(adjPos) && SphereUtils.shouldRenderSide(adjPos, side, test, renderType, positions) && !SphereUtils.isHandledAndMarkHandled(adjPos, side, handledPositions)) {
            ++length;
            adjPos = BlockPos.m_121915_((long)adjPos, (Direction)moveDirection);
        }
        return length;
    }

    public static boolean isHandledAndMarkHandled(long pos, Direction side, Long2ByteOpenHashMap handledPositions) {
        byte sideMask = (byte)(1 << side.m_122411_());
        byte val = handledPositions.get(pos);
        if ((val & sideMask) != 0) {
            return true;
        }
        val = (byte)(val | sideMask);
        handledPositions.put(pos, val);
        return false;
    }

    protected static boolean shouldRenderSide(long pos, Direction side, RingPositionTest test, ShapeRenderType renderType, LongOpenHashSet positions) {
        long adjPos = BlockPos.m_121915_((long)pos, (Direction)side);
        if (positions.contains(adjPos)) {
            return false;
        }
        if (renderType == ShapeRenderType.FULL_BLOCK) {
            return true;
        }
        int adjX = BlockPos.m_121983_((long)adjPos);
        int adjY = BlockPos.m_122008_((long)adjPos);
        int adjZ = BlockPos.m_122015_((long)adjPos);
        boolean onOrIn = test.isInsideOrCloserThan(adjX, adjY, adjZ, side);
        return renderType == ShapeRenderType.OUTER_EDGE && !onOrIn || renderType == ShapeRenderType.INNER_EDGE && onOrIn;
    }

    public static Direction getNegativeDirectionFor(Direction.Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> Direction.WEST;
            case Direction.Axis.Y -> Direction.DOWN;
            case Direction.Axis.Z -> Direction.NORTH;
        };
    }

    public static Direction getPositiveDirectionFor(Direction.Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> Direction.EAST;
            case Direction.Axis.Y -> Direction.UP;
            case Direction.Axis.Z -> Direction.SOUTH;
        };
    }

    public static Direction.Axis getThirdAxis(Direction.Axis axis1, Direction.Axis axis2) {
        return switch (axis1) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> {
                if (axis2 == Direction.Axis.Y) {
                    yield Direction.Axis.Z;
                }
                yield Direction.Axis.Y;
            }
            case Direction.Axis.Y -> {
                if (axis2 == Direction.Axis.X) {
                    yield Direction.Axis.Z;
                }
                yield Direction.Axis.X;
            }
            case Direction.Axis.Z -> axis2 == Direction.Axis.X ? Direction.Axis.Y : Direction.Axis.X;
        };
    }

    public static long offsetPos(long pos, Direction direction, int amount) {
        return BlockPos.m_121910_((long)pos, (int)(direction.m_122429_() * amount), (int)(direction.m_122430_() * amount), (int)(direction.m_122431_() * amount));
    }

    public static long getCompressedPosSide(long pos, Direction side) {
        int x = BlockPos.m_121983_((long)pos);
        int y = BlockPos.m_122008_((long)pos);
        int z = BlockPos.m_122015_((long)pos);
        long val = 1L << side.m_122411_() << 58;
        val |= ((long)y & 0x3FFFL) << 44;
        val |= ((long)z & 0x3FFFFFL) << 22;
        return val |= (long)x & 0x3FFFFFL;
    }

    public static interface RingPositionTest {
        public boolean isInsideOrCloserThan(int var1, int var2, int var3, Direction var4);
    }
}

