/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer.shapes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import fi.dy.masa.malilib.util.BlockSnap;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.PositionUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.renderer.RenderObjectBase;
import fi.dy.masa.minihud.renderer.RenderUtils;
import fi.dy.masa.minihud.renderer.shapes.ShapeBlocky;
import fi.dy.masa.minihud.renderer.shapes.ShapeType;
import fi.dy.masa.minihud.renderer.shapes.SideQuad;
import fi.dy.masa.minihud.util.RayTracer;
import fi.dy.masa.minihud.util.shape.SphereUtils;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.Collection;
import java.util.List;
import java.util.function.LongConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ShapeLineBlock
extends ShapeBlocky {
    protected Vec3 startPos = Vec3.f_82478_;
    protected Vec3 endPos = Vec3.f_82478_;
    protected Vec3 effectiveStartPos = Vec3.f_82478_;
    protected Vec3 effectiveEndPos = Vec3.f_82478_;

    public ShapeLineBlock() {
        super(ShapeType.BLOCK_LINE, Configs.Colors.SHAPE_LINE_BLOCKY.getColor());
        this.setBlockSnap(BlockSnap.CENTER);
    }

    public Vec3 getStartPos() {
        return this.effectiveStartPos;
    }

    public Vec3 getEndPos() {
        return this.effectiveEndPos;
    }

    public void setStartPos(Vec3 startPos) {
        this.startPos = startPos;
        this.updateEffectivePositions();
    }

    public void setEndPos(Vec3 endPos) {
        this.endPos = endPos;
        this.updateEffectivePositions();
    }

    @Override
    public void setBlockSnap(BlockSnap snap) {
        super.setBlockSnap(snap);
        this.updateEffectivePositions();
    }

    @Override
    public void update(Vec3 cameraPos, Entity entity, Minecraft mc) {
        this.renderLineShape(cameraPos);
        this.needsUpdate = false;
    }

    @Override
    public List<String> getWidgetHoverLines() {
        List<String> lines = super.getWidgetHoverLines();
        Vec3 s = this.startPos;
        Vec3 e = this.endPos;
        lines.add(StringUtils.translate((String)"minihud.gui.label.shape.line.start", (Object[])new Object[]{ShapeLineBlock.d2(s.f_82479_), ShapeLineBlock.d2(s.f_82480_), ShapeLineBlock.d2(s.f_82481_)}));
        lines.add(StringUtils.translate((String)"minihud.gui.label.shape.line.end", (Object[])new Object[]{ShapeLineBlock.d2(e.f_82479_), ShapeLineBlock.d2(e.f_82480_), ShapeLineBlock.d2(e.f_82481_)}));
        return lines;
    }

    @Override
    public JsonObject toJson() {
        JsonObject obj = super.toJson();
        obj.add("start", (JsonElement)JsonUtils.vec3dToJson((Vec3)this.startPos));
        obj.add("end", (JsonElement)JsonUtils.vec3dToJson((Vec3)this.endPos));
        return obj;
    }

    @Override
    public void fromJson(JsonObject obj) {
        super.fromJson(obj);
        Vec3 startPos = JsonUtils.vec3dFromJson((JsonObject)obj, (String)"start");
        Vec3 endPos = JsonUtils.vec3dFromJson((JsonObject)obj, (String)"end");
        if (startPos != null) {
            this.startPos = startPos;
        }
        if (endPos != null) {
            this.endPos = endPos;
        }
        this.updateEffectivePositions();
    }

    protected void updateRenderPerimeter() {
        double range = 512.0;
        double minX = Math.min(this.effectiveStartPos.m_7096_(), this.effectiveEndPos.m_7096_()) - range;
        double minY = Math.min(this.effectiveStartPos.m_7098_(), this.effectiveEndPos.m_7098_()) - range;
        double minZ = Math.min(this.effectiveStartPos.m_7094_(), this.effectiveEndPos.m_7094_()) - range;
        double maxX = Math.max(this.effectiveStartPos.m_7096_(), this.effectiveEndPos.m_7096_()) + range;
        double maxY = Math.max(this.effectiveStartPos.m_7098_(), this.effectiveEndPos.m_7098_()) + range;
        double maxZ = Math.max(this.effectiveStartPos.m_7094_(), this.effectiveEndPos.m_7094_()) + range;
        this.renderPerimeter = new AABB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    protected void updateEffectivePositions() {
        this.effectiveStartPos = this.getBlockSnappedPosition(this.startPos);
        this.effectiveEndPos = this.getBlockSnappedPosition(this.endPos);
        this.updateRenderPerimeter();
        this.setNeedsUpdate();
    }

    protected void renderLineShape(Vec3 cameraPos) {
        double distance = this.effectiveEndPos.m_82554_(this.effectiveStartPos);
        double maxDist = 10000.0;
        if (distance > 10000.0) {
            return;
        }
        LongOpenHashSet positions = new LongOpenHashSet();
        RayTracer tracer = new RayTracer(this.effectiveStartPos, this.effectiveEndPos);
        double expand = 0.0;
        tracer.iterateAllPositions(this.getLinePositionCollector(positions));
        RenderObjectBase renderQuads = (RenderObjectBase)this.renderObjects.get(0);
        BUFFER_1.m_166779_(renderQuads.getGlMode(), DefaultVertexFormat.f_85815_);
        if (this.getCombineQuads()) {
            Long2ObjectOpenHashMap<SideQuad> strips = this.buildPositionsToStrips(positions, this.layerRange);
            RenderUtils.renderQuads((Collection<SideQuad>)strips.values(), this.color, expand, cameraPos, BUFFER_1);
        } else {
            RenderUtils.renderBlockPositions(positions, this.layerRange, this.color, expand, cameraPos, BUFFER_1);
        }
        renderQuads.uploadData(BUFFER_1);
    }

    protected LongConsumer getLinePositionCollector(LongOpenHashSet positionsOut) {
        IntBoundingBox box = this.layerRange.getExpandedBox((Level)this.mc.f_91073_, 0);
        LongConsumer positionCollector = pos -> {
            if (box.containsPos(pos)) {
                positionsOut.add(pos);
            }
        };
        return positionCollector;
    }

    public Long2ObjectOpenHashMap<SideQuad> buildPositionsToStrips(LongOpenHashSet positions, LayerRange layerRange) {
        Long2ObjectOpenHashMap strips = new Long2ObjectOpenHashMap();
        Long2ByteOpenHashMap handledPositions = new Long2ByteOpenHashMap();
        Direction[] sides = PositionUtils.ALL_DIRECTIONS;
        double lengthX = Math.abs(this.effectiveEndPos.m_7096_() - this.effectiveStartPos.m_7096_());
        double lengthY = Math.abs(this.effectiveEndPos.m_7098_() - this.effectiveStartPos.m_7098_());
        double lengthZ = Math.abs(this.effectiveEndPos.m_7094_() - this.effectiveStartPos.m_7094_());
        Direction mainAxisHor = lengthX >= lengthZ ? Direction.WEST : Direction.NORTH;
        Direction mainAxisAll = lengthY >= lengthX && lengthY >= lengthZ ? Direction.DOWN : mainAxisHor;
        LongIterator longIterator = positions.iterator();
        while (longIterator.hasNext()) {
            long pos = (Long)longIterator.next();
            if (!layerRange.isPositionWithinRange(pos)) continue;
            for (Direction side : sides) {
                if (SphereUtils.isHandledAndMarkHandled(pos, side, handledPositions) || positions.contains(BlockPos.m_121915_((long)pos, (Direction)side))) continue;
                Direction minDir = side.m_122434_().m_122478_() ? mainAxisHor : mainAxisAll;
                Direction maxDir = minDir.m_122424_();
                int lengthMin = ShapeLineBlock.getStripLengthOnSide(pos, side, minDir, positions, handledPositions);
                int lengthMax = ShapeLineBlock.getStripLengthOnSide(pos, side, maxDir, positions, handledPositions);
                long startPosLong = SphereUtils.offsetPos(pos, minDir, lengthMin);
                long index = SphereUtils.getCompressedPosSide(startPosLong, side);
                int width = lengthMin + lengthMax + 1;
                int height = 1;
                if (side.m_122434_().m_122478_() && mainAxisHor.m_122434_() == Direction.Axis.Z || side.m_122434_().m_122479_() && mainAxisAll.m_122434_().m_122478_()) {
                    height = width;
                    width = 1;
                }
                strips.put(index, (Object)new SideQuad(startPosLong, width, height, side));
            }
        }
        return strips;
    }

    protected static int getStripLengthOnSide(long pos, Direction side, Direction moveDirection, LongOpenHashSet positions, Long2ByteOpenHashMap handledPositions) {
        int length = 0;
        long adjPos = BlockPos.m_121915_((long)pos, (Direction)moveDirection);
        while (positions.contains(adjPos) && !positions.contains(BlockPos.m_121915_((long)adjPos, (Direction)side)) && !SphereUtils.isHandledAndMarkHandled(adjPos, side, handledPositions)) {
            ++length;
            adjPos = BlockPos.m_121915_((long)adjPos, (Direction)moveDirection);
        }
        return length;
    }
}

