/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer.shapes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.malilib.util.BlockSnap;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.minihud.renderer.shapes.ShapeBlocky;
import fi.dy.masa.minihud.renderer.shapes.ShapeType;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public abstract class ShapeCircleBase
extends ShapeBlocky {
    protected Direction mainAxis = Direction.UP;
    private final double maxRadius = 1024.0;
    private double radius;
    private double radiusSq;
    private Vec3 center = Vec3.f_82478_;
    private Vec3 effectiveCenter = Vec3.f_82478_;

    public ShapeCircleBase(ShapeType type, Color4f color, double radius) {
        super(type, color);
        this.setRadius(radius);
        Entity entity = EntityUtils.getCameraEntity();
        if (entity != null) {
            Vec3 center = entity.m_20182_();
            center = new Vec3(Math.floor(center.f_82479_) + 0.5, Math.floor(center.f_82480_), Math.floor(center.f_82481_) + 0.5);
            this.setCenter(center);
        } else {
            this.setCenter(Vec3.f_82478_);
        }
    }

    public Vec3 getCenter() {
        return this.center;
    }

    public Vec3 getEffectiveCenter() {
        return this.effectiveCenter;
    }

    public void setCenter(Vec3 center) {
        this.center = center;
        this.updateEffectiveCenter();
    }

    public double getRadius() {
        return this.radius;
    }

    public double getSquaredRadius() {
        return this.radiusSq;
    }

    public void setRadius(double radius) {
        if (radius >= 0.0 && radius <= this.maxRadius) {
            this.radius = radius;
            this.radiusSq = radius * radius;
            this.setRenderPerimeter(this.effectiveCenter, this.radius + 512.0);
            this.setNeedsUpdate();
        }
    }

    public Direction getMainAxis() {
        return this.mainAxis;
    }

    public void setMainAxis(Direction mainAxis) {
        this.mainAxis = mainAxis;
        this.setNeedsUpdate();
    }

    protected BlockPos getCenterBlock() {
        return BlockPos.m_274446_((Position)this.effectiveCenter);
    }

    @Override
    public void setBlockSnap(BlockSnap snap) {
        super.setBlockSnap(snap);
        this.updateEffectiveCenter();
    }

    protected void updateEffectiveCenter() {
        this.effectiveCenter = this.getBlockSnappedPosition(this.center);
        this.setRenderPerimeter(this.effectiveCenter, this.radius + 512.0);
        this.setNeedsUpdate();
    }

    @Override
    public JsonObject toJson() {
        JsonObject obj = super.toJson();
        obj.add("center", (JsonElement)JsonUtils.vec3dToJson((Vec3)this.center));
        obj.add("main_axis", (JsonElement)new JsonPrimitive(this.mainAxis.name()));
        obj.add("radius", (JsonElement)new JsonPrimitive((Number)this.getRadius()));
        return obj;
    }

    @Override
    public void fromJson(JsonObject obj) {
        Vec3 center;
        Direction facing;
        super.fromJson(obj);
        if (JsonUtils.hasString((JsonObject)obj, (String)"main_axis") && (facing = Direction.valueOf((String)obj.get("main_axis").getAsString())) != null) {
            this.setMainAxis(facing);
        }
        if (JsonUtils.hasDouble((JsonObject)obj, (String)"radius")) {
            this.setRadius(JsonUtils.getDouble((JsonObject)obj, (String)"radius"));
        }
        if ((center = JsonUtils.vec3dFromJson((JsonObject)obj, (String)"center")) != null) {
            this.setCenter(center);
        }
    }

    @Override
    public List<String> getWidgetHoverLines() {
        List<String> lines = super.getWidgetHoverLines();
        BlockSnap snap = this.getBlockSnap();
        Vec3 c = this.center;
        lines.add(StringUtils.translate((String)"minihud.gui.hover.shape.radius_value", (Object[])new Object[]{this.getRadius()}));
        lines.add(StringUtils.translate((String)"minihud.gui.hover.shape.center_value", (Object[])new Object[]{ShapeCircleBase.d2(c.f_82479_), ShapeCircleBase.d2(c.f_82480_), ShapeCircleBase.d2(c.f_82481_)}));
        if (snap != BlockSnap.NONE) {
            c = this.effectiveCenter;
            lines.add(StringUtils.translate((String)"minihud.gui.hover.shape.effective_center_value", (Object[])new Object[]{ShapeCircleBase.d2(c.f_82479_), ShapeCircleBase.d2(c.f_82480_), ShapeCircleBase.d2(c.f_82481_)}));
        }
        return lines;
    }
}

