/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer.shapes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.PositionUtils;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.renderer.RenderObjectBase;
import fi.dy.masa.minihud.renderer.RenderUtils;
import fi.dy.masa.minihud.renderer.shapes.ShapeCircleBase;
import fi.dy.masa.minihud.renderer.shapes.ShapeType;
import fi.dy.masa.minihud.renderer.shapes.SideQuad;
import fi.dy.masa.minihud.util.ShapeRenderType;
import fi.dy.masa.minihud.util.shape.SphereUtils;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.StringUtils;

public class ShapeCircle
extends ShapeCircleBase {
    protected int height = 1;

    public ShapeCircle() {
        super(ShapeType.CIRCLE, Configs.Colors.SHAPE_CIRCLE.getColor(), 16.0);
    }

    @Override
    public void update(Vec3 cameraPos, Entity entity, Minecraft mc) {
        this.renderCircleShape(cameraPos);
        this.needsUpdate = false;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = Mth.m_14045_((int)height, (int)1, (int)8192);
        this.setNeedsUpdate();
    }

    protected void renderCircleShape(Vec3 cameraPos) {
        LongOpenHashSet positions = new LongOpenHashSet();
        Consumer<BlockPos.MutableBlockPos> positionConsumer = this.getPositionCollector(positions);
        SphereUtils.RingPositionTest test = this::isPositionOnOrInsideRing;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        Vec3 effectiveCenter = this.getEffectiveCenter();
        Direction.Axis axis = this.mainAxis.m_122434_();
        double expand = 0.0;
        RenderObjectBase renderQuads = (RenderObjectBase)this.renderObjects.get(0);
        BUFFER_1.m_166779_(renderQuads.getGlMode(), DefaultVertexFormat.f_85815_);
        if (this.getCombineQuads()) {
            mutablePos.m_122169_(effectiveCenter.f_82479_, effectiveCenter.f_82480_, effectiveCenter.f_82481_);
            if (axis == Direction.Axis.Y) {
                SphereUtils.addPositionsOnHorizontalBlockRing(positionConsumer, mutablePos, test);
            } else {
                SphereUtils.addPositionsOnVerticalBlockRing(positionConsumer, mutablePos, this.mainAxis, test);
            }
            Long2ObjectOpenHashMap<SideQuad> strips = SphereUtils.buildSphereShellToStrips(positions, axis, test, this.renderType, this.layerRange);
            List<SideQuad> quads = ShapeCircle.buildStripsToQuadsForCircle(strips, this.mainAxis, this.height);
            RenderUtils.renderQuads(quads, this.color, expand, cameraPos, BUFFER_1);
        } else {
            BlockPos posCenter = BlockPos.m_274446_((Position)effectiveCenter);
            int offX = this.mainAxis.m_122429_();
            int offY = this.mainAxis.m_122430_();
            int offZ = this.mainAxis.m_122431_();
            for (int i = 0; i < this.height; ++i) {
                mutablePos.m_122178_(posCenter.m_123341_() + offX * i, posCenter.m_123342_() + offY * i, posCenter.m_123343_() + offZ * i);
                if (axis == Direction.Axis.Y) {
                    SphereUtils.addPositionsOnHorizontalBlockRing(positionConsumer, mutablePos, test);
                    continue;
                }
                SphereUtils.addPositionsOnVerticalBlockRing(positionConsumer, mutablePos, this.mainAxis, test);
            }
            Direction[] sides = this.getSides();
            RenderUtils.renderCircleBlockPositions(positions, sides, test, this.renderType, this.layerRange, this.color, expand, cameraPos, BUFFER_1);
        }
        renderQuads.uploadData(BUFFER_1);
    }

    protected Direction[] getSides() {
        if (this.renderType != ShapeRenderType.FULL_BLOCK) {
            return SphereUtils.getDirectionsNotOnAxis(this.mainAxis.m_122434_());
        }
        return PositionUtils.ALL_DIRECTIONS;
    }

    protected boolean isPositionOnOrInsideRing(int blockX, int blockY, int blockZ, Direction outSide) {
        double zAdj;
        double yAdj;
        double z;
        double y;
        double x;
        double distSq;
        Direction.Axis axis = this.mainAxis.m_122434_();
        Vec3 effectiveCenter = this.getEffectiveCenter();
        double radiusSq = this.getSquaredRadius();
        double diff = radiusSq - (distSq = effectiveCenter.m_82531_(x = axis == Direction.Axis.X ? effectiveCenter.f_82479_ : (double)blockX + 0.5, y = axis == Direction.Axis.Y ? effectiveCenter.f_82480_ : (double)blockY + 0.5, z = axis == Direction.Axis.Z ? effectiveCenter.f_82481_ : (double)blockZ + 0.5));
        if (diff > 0.0) {
            return true;
        }
        double xAdj = x + (double)outSide.m_122429_();
        double distAdjSq = effectiveCenter.m_82531_(xAdj, yAdj = y + (double)outSide.m_122430_(), zAdj = z + (double)outSide.m_122431_());
        double diffAdj = radiusSq - distAdjSq;
        return diffAdj > 0.0 && Math.abs(diff) < Math.abs(diffAdj);
    }

    public static List<SideQuad> buildStripsToQuadsForCircle(Long2ObjectOpenHashMap<SideQuad> strips, Direction mainAxisDirection, int circleHeight) {
        ArrayList<SideQuad> quads = new ArrayList<SideQuad>();
        Long2ByteOpenHashMap handledPositions = new Long2ByteOpenHashMap();
        Direction.Axis mainAxis = mainAxisDirection.m_122434_();
        for (SideQuad strip : strips.values()) {
            Direction side;
            long pos = strip.startPos();
            if (SphereUtils.isHandledAndMarkHandled(pos, side = strip.side(), handledPositions)) continue;
            long startPos = side == mainAxisDirection ? SphereUtils.offsetPos(pos, mainAxisDirection, circleHeight - 1) : pos;
            int height = side.m_122434_() != mainAxis ? circleHeight : strip.height();
            quads.add(new SideQuad(startPos, strip.width(), height, side));
        }
        return quads;
    }

    @Override
    public List<String> getWidgetHoverLines() {
        List<String> lines = super.getWidgetHoverLines();
        lines.add(2, fi.dy.masa.malilib.util.StringUtils.translate((String)"minihud.gui.hover.shape.circle.main_axis_value", (Object[])new Object[]{StringUtils.capitalize((String)this.getMainAxis().toString().toLowerCase())}));
        lines.add(3, fi.dy.masa.malilib.util.StringUtils.translate((String)"minihud.gui.hover.shape.height_value", (Object[])new Object[]{this.getHeight()}));
        return lines;
    }

    @Override
    public JsonObject toJson() {
        JsonObject obj = super.toJson();
        obj.add("height", (JsonElement)new JsonPrimitive((Number)this.height));
        return obj;
    }

    @Override
    public void fromJson(JsonObject obj) {
        super.fromJson(obj);
        this.setHeight(JsonUtils.getInteger((JsonObject)obj, (String)"height"));
    }
}

