/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.PositionUtils;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.renderer.IOverlayRenderer;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.renderer.OverlayRendererBeaconRange;
import fi.dy.masa.minihud.renderer.OverlayRendererBiomeBorders;
import fi.dy.masa.minihud.renderer.OverlayRendererBlockGrid;
import fi.dy.masa.minihud.renderer.OverlayRendererConduitRange;
import fi.dy.masa.minihud.renderer.OverlayRendererLightLevel;
import fi.dy.masa.minihud.renderer.OverlayRendererRandomTickableChunks;
import fi.dy.masa.minihud.renderer.OverlayRendererRegion;
import fi.dy.masa.minihud.renderer.OverlayRendererSlimeChunks;
import fi.dy.masa.minihud.renderer.OverlayRendererSpawnChunks;
import fi.dy.masa.minihud.renderer.OverlayRendererSpawnableColumnHeights;
import fi.dy.masa.minihud.renderer.OverlayRendererStructures;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class RenderContainer {
    public static final RenderContainer INSTANCE = new RenderContainer();
    private final List<OverlayRendererBase> renderers = new ArrayList<OverlayRendererBase>();
    protected boolean resourcesAllocated;
    protected int countActive;

    private RenderContainer() {
        this.addRenderer(OverlayRendererBeaconRange.INSTANCE);
        this.addRenderer(OverlayRendererBiomeBorders.INSTANCE);
        this.addRenderer(new OverlayRendererBlockGrid());
        this.addRenderer(OverlayRendererConduitRange.INSTANCE);
        this.addRenderer(OverlayRendererLightLevel.INSTANCE);
        this.addRenderer(new OverlayRendererRandomTickableChunks(RendererToggle.OVERLAY_RANDOM_TICKS_FIXED));
        this.addRenderer(new OverlayRendererRandomTickableChunks(RendererToggle.OVERLAY_RANDOM_TICKS_PLAYER));
        this.addRenderer(new OverlayRendererRegion());
        this.addRenderer(new OverlayRendererSlimeChunks());
        this.addRenderer(new OverlayRendererSpawnableColumnHeights());
        this.addRenderer(new OverlayRendererSpawnChunks(RendererToggle.OVERLAY_SPAWN_CHUNK_OVERLAY_REAL));
        this.addRenderer(new OverlayRendererSpawnChunks(RendererToggle.OVERLAY_SPAWN_CHUNK_OVERLAY_PLAYER));
        this.addRenderer(OverlayRendererStructures.INSTANCE);
    }

    public void addRenderer(OverlayRendererBase renderer) {
        if (this.resourcesAllocated) {
            renderer.allocateGlResources();
        }
        this.renderers.add(renderer);
    }

    public void removeRenderer(OverlayRendererBase renderer) {
        this.renderers.remove(renderer);
        if (this.resourcesAllocated) {
            renderer.deleteGlResources();
        }
    }

    public void render(Entity entity, PoseStack matrixStack, Matrix4f projMatrix, Minecraft mc) {
        Vec3 cameraPos = mc.f_91063_.m_109153_().m_90583_();
        this.update(cameraPos, entity, mc);
        this.draw(cameraPos, matrixStack, projMatrix, mc);
    }

    protected void update(Vec3 cameraPos, Entity entity, Minecraft mc) {
        mc.m_91307_().m_6521_(() -> "RenderContainer#update()");
        this.allocateResourcesIfNeeded();
        this.countActive = 0;
        for (OverlayRendererBase renderer : this.renderers) {
            mc.m_91307_().m_6521_(() -> renderer.getClass().getName());
            if (renderer.shouldRender(mc)) {
                if (renderer.needsUpdate(entity, mc)) {
                    renderer.lastUpdatePos = PositionUtils.getEntityBlockPos((Entity)entity);
                    renderer.setUpdatePosition(cameraPos);
                    renderer.update(cameraPos, entity, mc);
                }
                ++this.countActive;
            }
            mc.m_91307_().m_7238_();
        }
        mc.m_91307_().m_7238_();
    }

    protected void draw(Vec3 cameraPos, PoseStack matrixStack, Matrix4f projMatrix, Minecraft mc) {
        if (this.resourcesAllocated && this.countActive > 0) {
            mc.m_91307_().m_6521_(() -> "RenderContainer#draw()");
            RenderSystem.disableCull();
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.polygonOffset((float)-3.0f, (float)-3.0f);
            RenderSystem.enablePolygonOffset();
            RenderUtils.setupBlend();
            RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            for (IOverlayRenderer iOverlayRenderer : this.renderers) {
                mc.m_91307_().m_6521_(() -> renderer.getClass().getName());
                if (iOverlayRenderer.shouldRender(mc)) {
                    Vec3 updatePos = iOverlayRenderer.getUpdatePosition();
                    matrixStack.m_85836_();
                    matrixStack.m_85837_(updatePos.f_82479_ - cameraPos.f_82479_, updatePos.f_82480_ - cameraPos.f_82480_, updatePos.f_82481_ - cameraPos.f_82481_);
                    iOverlayRenderer.draw(matrixStack, projMatrix);
                    matrixStack.m_85849_();
                }
                mc.m_91307_().m_7238_();
            }
            RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
            RenderSystem.disablePolygonOffset();
            RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
            RenderSystem.enableDepthTest();
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)true);
            mc.m_91307_().m_7238_();
        }
    }

    protected void allocateResourcesIfNeeded() {
        if (!this.resourcesAllocated) {
            this.deleteGlResources();
            this.allocateGlResources();
        }
    }

    protected void allocateGlResources() {
        if (!this.resourcesAllocated) {
            for (OverlayRendererBase renderer : this.renderers) {
                renderer.allocateGlResources();
            }
            this.resourcesAllocated = true;
        }
    }

    protected void deleteGlResources() {
        if (this.resourcesAllocated) {
            for (OverlayRendererBase renderer : this.renderers) {
                renderer.deleteGlResources();
            }
            this.resourcesAllocated = false;
        }
    }

    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        for (OverlayRendererBase renderer : this.renderers) {
            String id = renderer.getSaveId();
            if (id.isEmpty()) continue;
            obj.add(id, (JsonElement)renderer.toJson());
        }
        return obj;
    }

    public void fromJson(JsonObject obj) {
        for (OverlayRendererBase renderer : this.renderers) {
            String id = renderer.getSaveId();
            if (id.isEmpty() || !JsonUtils.hasObject((JsonObject)obj, (String)id)) continue;
            renderer.fromJson(obj.get(id).getAsJsonObject());
        }
    }
}

