/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.renderer.RenderObjectBase;
import fi.dy.masa.minihud.util.DataStorage;
import fi.dy.masa.minihud.util.MiscUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class OverlayRendererSlimeChunks
extends OverlayRendererBase {
    public static double overlayTopY;
    protected static boolean needsUpdate;
    protected boolean wasSeedKnown;
    protected long seed;
    protected double topY;

    public static void setNeedsUpdate() {
        needsUpdate = true;
    }

    public static void onEnabled() {
        Entity entity = EntityUtils.getCameraEntity();
        if (entity != null) {
            overlayTopY = entity.m_20186_();
            OverlayRendererSlimeChunks.setNeedsUpdate();
        }
    }

    @Override
    public boolean shouldRender(Minecraft mc) {
        return RendererToggle.OVERLAY_SLIME_CHUNKS_OVERLAY.getBooleanValue() && mc.f_91073_ != null && DataStorage.getInstance().isWorldSeedKnown((Level)mc.f_91073_) && MiscUtils.isOverworld((Level)mc.f_91073_);
    }

    @Override
    public boolean needsUpdate(Entity entity, Minecraft mc) {
        if (needsUpdate) {
            return true;
        }
        Level world = entity.m_20193_();
        boolean isSeedKnown = DataStorage.getInstance().isWorldSeedKnown(world);
        long seed = DataStorage.getInstance().getWorldSeed(world);
        if (this.topY != overlayTopY || this.wasSeedKnown != isSeedKnown || this.seed != seed) {
            return true;
        }
        int ex = (int)Math.floor(entity.m_20185_());
        int ez = (int)Math.floor(entity.m_20189_());
        int lx = this.lastUpdatePos.m_123341_();
        int lz = this.lastUpdatePos.m_123343_();
        return Math.abs(lx - ex) > 16 || Math.abs(lz - ez) > 16;
    }

    @Override
    public void update(Vec3 cameraPos, Entity entity, Minecraft mc) {
        DataStorage data = DataStorage.getInstance();
        Level world = entity.m_20193_();
        this.topY = overlayTopY;
        this.wasSeedKnown = data.isWorldSeedKnown(world);
        this.seed = data.getWorldSeed(world);
        if (this.wasSeedKnown) {
            int centerX = Mth.m_14107_((double)entity.m_20185_()) >> 4;
            int centerZ = Mth.m_14107_((double)entity.m_20189_()) >> 4;
            Color4f colorSides = Configs.Colors.SLIME_CHUNKS_OVERLAY_COLOR.getColor();
            Color4f colorLines = Color4f.fromColor((Color4f)colorSides, (float)1.0f);
            BlockPos.MutableBlockPos pos1 = new BlockPos.MutableBlockPos();
            BlockPos.MutableBlockPos pos2 = new BlockPos.MutableBlockPos();
            int r = Mth.m_14045_((int)Configs.Generic.SLIME_CHUNK_OVERLAY_RADIUS.getIntegerValue(), (int)-1, (int)40);
            if (r == -1) {
                r = (Integer)mc.f_91066_.m_231984_().m_231551_();
            }
            RenderObjectBase renderQuads = (RenderObjectBase)this.renderObjects.get(0);
            RenderObjectBase renderLines = (RenderObjectBase)this.renderObjects.get(1);
            BUFFER_1.m_166779_(renderQuads.getGlMode(), DefaultVertexFormat.f_85815_);
            BUFFER_2.m_166779_(renderLines.getGlMode(), DefaultVertexFormat.f_85815_);
            int minY = world != null ? world.m_141937_() : -64;
            int topY = (int)Math.floor(this.topY);
            for (int xOff = -r; xOff <= r; ++xOff) {
                for (int zOff = -r; zOff <= r; ++zOff) {
                    int cx = centerX + xOff;
                    int cz = centerZ + zOff;
                    if (!MiscUtils.canSlimeSpawnInChunk(cx, cz, this.seed)) continue;
                    pos1.m_122178_(cx << 4, minY, cz << 4);
                    pos2.m_122178_((cx << 4) + 15, topY, (cz << 4) + 15);
                    RenderUtils.drawBoxWithEdgesBatched((BlockPos)pos1, (BlockPos)pos2, (Vec3)cameraPos, (Color4f)colorLines, (Color4f)colorSides, (BufferBuilder)BUFFER_1, (BufferBuilder)BUFFER_2);
                }
            }
            renderQuads.uploadData(BUFFER_1);
            renderLines.uploadData(BUFFER_2);
        }
        needsUpdate = false;
    }

    @Override
    public String getSaveId() {
        return "slime_chunks";
    }

    @Override
    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        obj.add("y_top", (JsonElement)new JsonPrimitive((Number)overlayTopY));
        return obj;
    }

    @Override
    public void fromJson(JsonObject obj) {
        overlayTopY = JsonUtils.getFloat((JsonObject)obj, (String)"y_top");
    }

    static {
        needsUpdate = true;
    }
}

