/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.PositionUtils;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.renderer.RenderObjectBase;
import fi.dy.masa.minihud.util.BlockGridMode;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class OverlayRendererBlockGrid
extends OverlayRendererBase {
    @Override
    public boolean shouldRender(Minecraft mc) {
        return RendererToggle.OVERLAY_BLOCK_GRID.getBooleanValue();
    }

    @Override
    public boolean needsUpdate(Entity entity, Minecraft mc) {
        if (this.lastUpdatePos == null) {
            return true;
        }
        return Math.abs(entity.m_20185_() - (double)this.lastUpdatePos.m_123341_()) > 8.0 || Math.abs(entity.m_20186_() - (double)this.lastUpdatePos.m_123342_()) > 8.0 || Math.abs(entity.m_20189_() - (double)this.lastUpdatePos.m_123343_()) > 8.0;
    }

    @Override
    public void update(Vec3 cameraPos, Entity entity, Minecraft mc) {
        Color4f color = Configs.Colors.BLOCK_GRID_OVERLAY_COLOR.getColor();
        int radius = Configs.Generic.BLOCK_GRID_OVERLAY_RADIUS.getIntegerValue();
        RenderObjectBase renderLines = (RenderObjectBase)this.renderObjects.get(0);
        BUFFER_1.m_166779_(renderLines.getGlMode(), DefaultVertexFormat.f_85815_);
        BlockGridMode mode = (BlockGridMode)Configs.Generic.BLOCK_GRID_OVERLAY_MODE.getOptionListValue();
        switch (mode) {
            case ALL: {
                this.renderLinesAll(cameraPos, this.lastUpdatePos, radius, color, BUFFER_1);
                break;
            }
            case NON_AIR: {
                this.renderLinesNonAir(cameraPos, entity.m_20193_(), this.lastUpdatePos, radius, color, BUFFER_1);
                break;
            }
            case ADJACENT: {
                this.renderLinesAdjacentToNonAir(cameraPos, entity.m_20193_(), this.lastUpdatePos, radius, color, BUFFER_1);
            }
        }
        renderLines.uploadData(BUFFER_1);
    }

    @Override
    public void allocateGlResources() {
        this.allocateBuffer(VertexFormat.Mode.DEBUG_LINES);
    }

    protected void renderLinesAll(Vec3 cameraPos, BlockPos center, int radius, Color4f color, BufferBuilder buffer) {
        double y;
        double x;
        double startX = (double)(center.m_123341_() - radius) - cameraPos.f_82479_;
        double startY = (double)(center.m_123342_() - radius) - cameraPos.f_82480_;
        double startZ = (double)(center.m_123343_() - radius) - cameraPos.f_82481_;
        double endX = (double)(center.m_123341_() + radius) - cameraPos.f_82479_;
        double endY = (double)(center.m_123342_() + radius) - cameraPos.f_82480_;
        double endZ = (double)(center.m_123343_() + radius) - cameraPos.f_82481_;
        for (x = startX; x <= endX; x += 1.0) {
            for (y = startY; y <= endY; y += 1.0) {
                buffer.m_5483_(x, y, startZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(x, y, endZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
            }
        }
        for (x = startX; x <= endX; x += 1.0) {
            for (double z = startZ; z <= endZ; z += 1.0) {
                buffer.m_5483_(x, startY, z).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(x, endY, z).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
            }
        }
        for (double z = startZ; z <= endZ; z += 1.0) {
            for (y = startY; y <= endY; y += 1.0) {
                buffer.m_5483_(startX, y, z).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(endX, y, z).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
            }
        }
    }

    protected void renderLinesNonAir(Vec3 cameraPos, Level world, BlockPos center, int radius, Color4f color, BufferBuilder buffer) {
        int startX = center.m_123341_() - radius;
        int startY = center.m_123342_() - radius;
        int startZ = center.m_123343_() - radius;
        int endX = center.m_123341_() + radius;
        int endY = center.m_123342_() + radius;
        int endZ = center.m_123343_() + radius;
        int lastCX = startX >> 4;
        int lastCZ = startZ >> 4;
        LevelChunk chunk = world.m_6325_(lastCX, lastCZ);
        BlockPos.MutableBlockPos posMutable = new BlockPos.MutableBlockPos();
        for (int x = startX; x <= endX; ++x) {
            for (int z = startZ; z <= endZ; ++z) {
                int cx = x >> 4;
                int cz = z >> 4;
                if (cx != lastCX || cz != lastCZ) {
                    chunk = world.m_6325_(cx, cz);
                    lastCX = cx;
                    lastCZ = cz;
                }
                for (int y = startY; y <= endY && y <= chunk.m_5885_(Heightmap.Types.WORLD_SURFACE, x, z); ++y) {
                    posMutable.m_122178_(x, y, z);
                    if (chunk.m_8055_((BlockPos)posMutable).m_60795_()) continue;
                    RenderUtils.drawBlockBoundingBoxOutlinesBatchedLines((BlockPos)posMutable, (Vec3)cameraPos, (Color4f)color, (double)0.001, (BufferBuilder)buffer);
                }
            }
        }
    }

    protected void renderLinesAdjacentToNonAir(Vec3 cameraPos, Level world, BlockPos center, int radius, Color4f color, BufferBuilder buffer) {
        int startX = center.m_123341_() - radius;
        int startY = center.m_123342_() - radius;
        int startZ = center.m_123343_() - radius;
        int endX = center.m_123341_() + radius;
        int endY = center.m_123342_() + radius;
        int endZ = center.m_123343_() + radius;
        int lastCX = startX >> 4;
        int lastCZ = startZ >> 4;
        LevelChunk chunk = world.m_6325_(lastCX, lastCZ);
        BlockPos.MutableBlockPos posMutable = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos posMutable2 = new BlockPos.MutableBlockPos();
        for (int x = startX; x <= endX; ++x) {
            for (int z = startZ; z <= endZ; ++z) {
                int cx = x >> 4;
                int cz = z >> 4;
                if (cx != lastCX || cz != lastCZ) {
                    chunk = world.m_6325_(cx, cz);
                    lastCX = cx;
                    lastCZ = cz;
                }
                block2: for (int y = startY; y <= endY; ++y) {
                    posMutable.m_122178_(x, y, z);
                    if (!chunk.m_8055_((BlockPos)posMutable).m_60795_()) continue;
                    for (Direction side : PositionUtils.VERTICAL_DIRECTIONS) {
                        posMutable2.m_122178_(posMutable.m_123341_() + side.m_122429_(), posMutable.m_123342_() + side.m_122430_(), posMutable.m_123343_() + side.m_122431_());
                        if (chunk.m_8055_((BlockPos)posMutable2).m_60795_()) continue;
                        RenderUtils.drawBlockBoundingBoxOutlinesBatchedLines((BlockPos)posMutable, (Vec3)cameraPos, (Color4f)color, (double)0.001, (BufferBuilder)buffer);
                        break;
                    }
                    for (Direction side : PositionUtils.HORIZONTAL_DIRECTIONS) {
                        posMutable2.m_122178_(posMutable.m_123341_() + side.m_122429_(), posMutable.m_123342_() + side.m_122430_(), posMutable.m_123343_() + side.m_122431_());
                        if (world.m_46859_((BlockPos)posMutable2)) continue;
                        RenderUtils.drawBlockBoundingBoxOutlinesBatchedLines((BlockPos)posMutable, (Vec3)cameraPos, (Color4f)color, (double)0.001, (BufferBuilder)buffer);
                        continue block2;
                    }
                }
            }
        }
    }
}

