/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import com.mojang.blaze3d.vertex.BufferBuilder;
import fi.dy.masa.malilib.config.IConfigBoolean;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.mixin.IMixinBeaconBlockEntity;
import fi.dy.masa.minihud.renderer.BaseBlockRangeOverlay;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.Vec3;

public class OverlayRendererBeaconRange
extends BaseBlockRangeOverlay<BeaconBlockEntity> {
    public static final OverlayRendererBeaconRange INSTANCE = new OverlayRendererBeaconRange();

    public OverlayRendererBeaconRange() {
        super((IConfigBoolean)RendererToggle.OVERLAY_BEACON_RANGE, BlockEntityType.f_58930_, BeaconBlockEntity.class);
    }

    @Override
    protected void renderBlockRange(Level world, BlockPos pos, BeaconBlockEntity be, Vec3 cameraPos) {
        int level = ((IMixinBeaconBlockEntity)be).minihud_getLevel();
        if (level >= 1 && level <= 4) {
            this.renderBeaconBox(world, pos, level, cameraPos, OverlayRendererBeaconRange.getColorForLevel(level));
        }
    }

    protected void renderBeaconBox(Level world, BlockPos pos, int level, Vec3 cameraPos, Color4f color) {
        double x = (double)pos.m_123341_() - cameraPos.f_82479_;
        double y = (double)pos.m_123342_() - cameraPos.f_82480_;
        double z = (double)pos.m_123343_() - cameraPos.f_82481_;
        int range = level * 10 + 10;
        double minX = x - (double)range;
        double minY = y - (double)range;
        double minZ = z - (double)range;
        double maxX = x + (double)range + 1.0;
        double maxY = this.getTopYOverTerrain(world, pos, range);
        double maxZ = z + (double)range + 1.0;
        RenderUtils.drawBoxAllSidesBatchedQuads((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ, (Color4f)color, (BufferBuilder)BUFFER_1);
        RenderUtils.drawBoxAllEdgesBatchedLines((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ, (Color4f)Color4f.fromColor((Color4f)color, (float)1.0f), (BufferBuilder)BUFFER_2);
    }

    public static Color4f getColorForLevel(int level) {
        switch (level) {
            case 1: {
                return Configs.Colors.BEACON_RANGE_LVL1_OVERLAY_COLOR.getColor();
            }
            case 2: {
                return Configs.Colors.BEACON_RANGE_LVL2_OVERLAY_COLOR.getColor();
            }
            case 3: {
                return Configs.Colors.BEACON_RANGE_LVL3_OVERLAY_COLOR.getColor();
            }
        }
        return Configs.Colors.BEACON_RANGE_LVL4_OVERLAY_COLOR.getColor();
    }
}

