/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.hotkeys;

import fi.dy.masa.malilib.config.IConfigBoolean;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.hotkeys.IHotkeyCallback;
import fi.dy.masa.malilib.hotkeys.IKeybind;
import fi.dy.masa.malilib.hotkeys.KeyAction;
import fi.dy.masa.malilib.hotkeys.KeyCallbackAdjustable;
import fi.dy.masa.malilib.interfaces.IValueChangeCallback;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.gui.GuiConfigs;
import fi.dy.masa.minihud.gui.GuiShapeEditor;
import fi.dy.masa.minihud.gui.GuiShapeManager;
import fi.dy.masa.minihud.hotkeys.KeyCallbackToggleRenderer;
import fi.dy.masa.minihud.renderer.OverlayRendererBeaconRange;
import fi.dy.masa.minihud.renderer.OverlayRendererBiomeBorders;
import fi.dy.masa.minihud.renderer.OverlayRendererConduitRange;
import fi.dy.masa.minihud.renderer.OverlayRendererLightLevel;
import fi.dy.masa.minihud.renderer.OverlayRendererSlimeChunks;
import fi.dy.masa.minihud.renderer.OverlayRendererStructures;
import fi.dy.masa.minihud.renderer.shapes.ShapeBase;
import fi.dy.masa.minihud.renderer.shapes.ShapeManager;
import fi.dy.masa.minihud.util.DataStorage;
import fi.dy.masa.minihud.util.DebugInfoUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.entity.Entity;

public class KeyCallbacks {
    public static void init() {
        Callbacks callback = new Callbacks();
        Configs.Generic.SET_DISTANCE_REFERENCE_POINT.getKeybind().setCallback((IHotkeyCallback)callback);
        Configs.Generic.OPEN_CONFIG_GUI.getKeybind().setCallback((IHotkeyCallback)callback);
        Configs.Generic.SHAPE_EDITOR.getKeybind().setCallback((IHotkeyCallback)callback);
        Configs.Colors.BEACON_RANGE_LVL1_OVERLAY_COLOR.setValueChangeCallback(config -> KeyCallbacks.updateBeaconOverlay());
        Configs.Colors.BEACON_RANGE_LVL2_OVERLAY_COLOR.setValueChangeCallback(config -> KeyCallbacks.updateBeaconOverlay());
        Configs.Colors.BEACON_RANGE_LVL3_OVERLAY_COLOR.setValueChangeCallback(config -> KeyCallbacks.updateBeaconOverlay());
        Configs.Colors.BEACON_RANGE_LVL4_OVERLAY_COLOR.setValueChangeCallback(config -> KeyCallbacks.updateBeaconOverlay());
        Configs.Colors.CONDUIT_RANGE_OVERLAY_COLOR.setValueChangeCallback(config -> KeyCallbacks.updateConduitOverlay());
        Configs.Generic.LIGHT_LEVEL_RANGE.setValueChangeCallback(config -> OverlayRendererLightLevel.setNeedsUpdate());
        Configs.Generic.LIGHT_LEVEL_RENDER_THROUGH.setValueChangeCallback(config -> OverlayRendererLightLevel.INSTANCE.setRenderThrough(config.getBooleanValue()));
        Configs.Generic.STRUCTURES_RENDER_THROUGH.setValueChangeCallback(config -> OverlayRendererStructures.INSTANCE.setRenderThrough(config.getBooleanValue()));
        RendererToggle.OVERLAY_SLIME_CHUNKS_OVERLAY.getKeybind().setCallback((IHotkeyCallback)new KeyCallbackAdjustable((IConfigBoolean)RendererToggle.OVERLAY_SLIME_CHUNKS_OVERLAY, (IHotkeyCallback)new KeyCallbackToggleRenderer((IConfigBoolean)RendererToggle.OVERLAY_SLIME_CHUNKS_OVERLAY)));
        RendererToggle.OVERLAY_BEACON_RANGE.setValueChangeCallback((IValueChangeCallback<IConfigBoolean>)((IValueChangeCallback)config -> KeyCallbacks.updateBeaconOverlay()));
        RendererToggle.OVERLAY_BIOME_BORDER.setValueChangeCallback((IValueChangeCallback<IConfigBoolean>)((IValueChangeCallback)config -> OverlayRendererBiomeBorders.INSTANCE.setNeedsUpdate()));
        RendererToggle.OVERLAY_SLIME_CHUNKS_OVERLAY.setValueChangeCallback((IValueChangeCallback<IConfigBoolean>)((IValueChangeCallback)KeyCallbacks::updateSlimeChunkOverlay));
        RendererToggle.OVERLAY_CONDUIT_RANGE.setValueChangeCallback((IValueChangeCallback<IConfigBoolean>)((IValueChangeCallback)config -> KeyCallbacks.updateConduitOverlay()));
        RendererToggle.DEBUG_CHUNK_BORDER.setValueChangeCallback((IValueChangeCallback<IConfigBoolean>)((IValueChangeCallback)DebugInfoUtils::toggleDebugRenderer));
        RendererToggle.DEBUG_CHUNK_INFO.setValueChangeCallback((IValueChangeCallback<IConfigBoolean>)((IValueChangeCallback)DebugInfoUtils::toggleDebugRenderer));
        RendererToggle.DEBUG_CHUNK_OCCLUSION.setValueChangeCallback((IValueChangeCallback<IConfigBoolean>)((IValueChangeCallback)DebugInfoUtils::toggleDebugRenderer));
        RendererToggle.DEBUG_NEIGHBOR_UPDATES.setValueChangeCallback((IValueChangeCallback<IConfigBoolean>)((IValueChangeCallback)DebugInfoUtils::toggleDebugRenderer));
        RendererToggle.DEBUG_PATH_FINDING.setValueChangeCallback((IValueChangeCallback<IConfigBoolean>)((IValueChangeCallback)DebugInfoUtils::toggleDebugRenderer));
    }

    private static void updateSlimeChunkOverlay(IConfigBoolean config) {
        if (config.getBooleanValue()) {
            OverlayRendererSlimeChunks.onEnabled();
        }
    }

    private static void updateBeaconOverlay() {
        OverlayRendererBeaconRange.INSTANCE.setNeedsUpdate();
    }

    private static void updateConduitOverlay() {
        OverlayRendererConduitRange.INSTANCE.setNeedsUpdate();
    }

    public static class Callbacks
    implements IHotkeyCallback {
        public boolean onKeyAction(KeyAction action, IKeybind key) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ == null) {
                return false;
            }
            if (key == Configs.Generic.OPEN_CONFIG_GUI.getKeybind()) {
                GuiBase.openGui((Screen)new GuiConfigs());
            } else if (key == Configs.Generic.SET_DISTANCE_REFERENCE_POINT.getKeybind()) {
                Entity entity = mc.m_91288_() != null ? mc.m_91288_() : mc.f_91074_;
                DataStorage.getInstance().setDistanceReferencePoint(entity.m_20182_());
            } else if (key == Configs.Generic.SHAPE_EDITOR.getKeybind()) {
                ShapeBase shape = ShapeManager.INSTANCE.getSelectedShape();
                if (shape != null) {
                    GuiBase.openGui((Screen)new GuiShapeEditor(shape));
                } else {
                    GuiConfigs.tab = GuiConfigs.ConfigGuiTab.SHAPES;
                    GuiBase.openGui((Screen)new GuiShapeManager());
                }
            }
            return true;
        }
    }
}

