/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.data;

import fi.dy.masa.minihud.data.MobCapDataHandler;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.world.entity.MobCategory;

public class MobCapData {
    protected static final int CAP_COUNT = MobCapDataHandler.ENTITY_CATEGORIES.length;
    protected static final int MAX_DATA_AGE_TICKS = 100;
    protected final Cap[] data = MobCapData.createCapArray();
    protected final Cap[] stagingData = MobCapData.createCapArray();
    protected final boolean[] dataValid = new boolean[CAP_COUNT];
    protected final long[] worldTicks = new long[CAP_COUNT];
    protected boolean hasValidData;
    protected long completionWorldTick;

    public static Cap[] createCapArray() {
        Cap[] data = new Cap[CAP_COUNT];
        for (int i = 0; i < data.length; ++i) {
            data[i] = new Cap();
        }
        return data;
    }

    public boolean getHasValidData() {
        return this.hasValidData;
    }

    public boolean getHasRecentValidData(long worldTick) {
        return this.hasValidData && worldTick - this.completionWorldTick <= 100L;
    }

    public void clear() {
        this.clearStaging();
        this.hasValidData = false;
        this.completionWorldTick = -1L;
    }

    public Cap getCap(EntityCategory type) {
        return this.data[type.ordinal()];
    }

    public void setCurrentValue(EntityCategory type, int currentValue, long worldTick) {
        int index = type.ordinal();
        Cap cap = this.stagingData[index];
        cap.setCurrent(currentValue);
        this.checkCapComplete(index, cap, worldTick);
    }

    public void setCapValue(EntityCategory type, int capValue, long worldTick) {
        int index = type.ordinal();
        Cap cap = this.stagingData[index];
        cap.setCap(capValue);
        this.checkCapComplete(index, cap, worldTick);
    }

    public void setCurrentAndCapValues(EntityCategory type, int currentValue, int capValue, long worldTick) {
        int index = type.ordinal();
        this.stagingData[index].setCurrentAndCap(currentValue, capValue);
        this.dataValid[index] = true;
        this.worldTicks[index] = worldTick;
        this.checkStagingComplete(worldTick);
    }

    protected void clearStaging() {
        for (Cap data : this.stagingData) {
            data.setCurrentAndCap(-1, -1);
        }
        Arrays.fill(this.dataValid, false);
        Arrays.fill(this.worldTicks, -1L);
    }

    protected void checkCapComplete(int index, Cap cap, long worldTick) {
        if (cap.getCurrent() >= 0 && cap.getCap() >= 0) {
            this.dataValid[index] = true;
            this.worldTicks[index] = worldTick;
            this.checkStagingComplete(worldTick);
        }
    }

    protected void checkStagingComplete(long worldTick) {
        for (boolean b : this.dataValid) {
            if (b) continue;
            return;
        }
        long min = MobCapData.getMinValue(this.worldTicks);
        long max = MobCapData.getMaxValue(this.worldTicks);
        if (max - min <= 60L) {
            for (int i = 0; i < this.stagingData.length; ++i) {
                this.data[i].setFrom(this.stagingData[i]);
            }
            this.clearStaging();
        }
        this.hasValidData = true;
        this.completionWorldTick = worldTick;
    }

    public static long getMinValue(long[] arr) {
        if (arr.length == 0) {
            throw new IllegalArgumentException("Empty array");
        }
        int size = arr.length;
        long minValue = arr[0];
        for (int i = 1; i < size; ++i) {
            if (arr[i] >= minValue) continue;
            minValue = arr[i];
        }
        return minValue;
    }

    public static long getMaxValue(long[] arr) {
        if (arr.length == 0) {
            throw new IllegalArgumentException("Empty array");
        }
        int size = arr.length;
        long maxValue = arr[0];
        for (int i = 1; i < size; ++i) {
            if (arr[i] <= maxValue) continue;
            maxValue = arr[i];
        }
        return maxValue;
    }

    public static class Cap {
        protected int current;
        protected int cap;

        public int getCurrent() {
            return this.current;
        }

        public int getCap() {
            return this.cap;
        }

        public boolean isFull() {
            return this.current >= this.cap && this.cap >= 0;
        }

        public void setCurrent(int current) {
            this.current = current;
        }

        public void setCap(int cap) {
            this.cap = cap;
        }

        public void setCurrentAndCap(int current, int cap) {
            this.current = current;
            this.cap = cap;
        }

        public void setFrom(Cap other) {
            this.current = other.current;
            this.cap = other.cap;
        }
    }

    public static enum EntityCategory {
        MONSTER("monster", MobCategory.MONSTER),
        CREATURE("creature", MobCategory.CREATURE),
        AMBIENT("ambient", MobCategory.AMBIENT),
        AXOLOTLS("axolotls", MobCategory.AXOLOTLS),
        UNDERGROUND_WATER_CREATURE("underground_water_creature", MobCategory.UNDERGROUND_WATER_CREATURE),
        WATER_CREATURE("water_creature", MobCategory.WATER_CREATURE),
        WATER_AMBIENT("water_ambient", MobCategory.WATER_AMBIENT),
        MISC("misc", MobCategory.MISC);

        private final MobCategory vanillaCategory;
        private final String name;

        private EntityCategory(String name, MobCategory vanillaCategory) {
            this.name = name;
            this.vanillaCategory = vanillaCategory;
        }

        public String getName() {
            return this.name;
        }

        public MobCategory getVanillaCategory() {
            return this.vanillaCategory;
        }

        public static EntityCategory fromVanillaCategory(MobCategory type) {
            switch (type) {
                case MONSTER: {
                    return MONSTER;
                }
                case CREATURE: {
                    return CREATURE;
                }
                case AMBIENT: {
                    return AMBIENT;
                }
                case AXOLOTLS: {
                    return AXOLOTLS;
                }
                case UNDERGROUND_WATER_CREATURE: {
                    return UNDERGROUND_WATER_CREATURE;
                }
                case WATER_CREATURE: {
                    return WATER_CREATURE;
                }
                case WATER_AMBIENT: {
                    return WATER_AMBIENT;
                }
                case MISC: {
                    return MISC;
                }
            }
            return null;
        }

        @Nullable
        public static EntityCategory fromVanillaCategoryName(String name) {
            switch (name) {
                case "monster": {
                    return MONSTER;
                }
                case "creature": {
                    return CREATURE;
                }
                case "ambient": {
                    return AMBIENT;
                }
                case "axolotls": {
                    return AXOLOTLS;
                }
                case "underground_water_creature": {
                    return UNDERGROUND_WATER_CREATURE;
                }
                case "water_creature": {
                    return WATER_CREATURE;
                }
                case "water_ambient": {
                    return WATER_AMBIENT;
                }
                case "misc": {
                    return MISC;
                }
            }
            return null;
        }
    }
}

