/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.modules.furnish;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.wouink.furnish.block.Bench;
import io.github.wouink.furnish.block.BookshelfChest;
import io.github.wouink.furnish.block.Cabinet;
import io.github.wouink.furnish.block.Chair;
import io.github.wouink.furnish.block.Coffin;
import io.github.wouink.furnish.block.Crate;
import io.github.wouink.furnish.block.InventoryFurniture;
import io.github.wouink.furnish.block.Ladder;
import io.github.wouink.furnish.block.LogBench;
import io.github.wouink.furnish.block.Shelf;
import io.github.wouink.furnish.block.Shutter;
import io.github.wouink.furnish.block.SimpleFurniture;
import io.github.wouink.furnish.block.Table;
import io.github.wouink.furnish.block.Wardrobe;
import io.github.wouink.furnish.block.util.VoxelShapeHelper;
import io.github.wouink.furnish.setup.FurnishBlocks;
import io.github.wouink.furnish.setup.FurnishRegistries;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.EntrySet;
import net.mehvahdjukaar.every_compat.api.RenderLayer;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.misc.ResourcesUtils;
import net.mehvahdjukaar.every_compat.misc.SpriteHelper;
import net.mehvahdjukaar.moonlight.api.resources.BlockTypeResTransformer;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.recipe.IRecipeTemplate;
import net.mehvahdjukaar.moonlight.api.resources.recipe.TemplateRecipeManager;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FurnishModule
extends SimpleModule {
    public final SimpleEntrySet<WoodType, Block> bedsideTable;
    public final SimpleEntrySet<WoodType, Block> bench;
    public final SimpleEntrySet<WoodType, Block> cabinet;
    public final SimpleEntrySet<WoodType, Block> chair;
    public final SimpleEntrySet<WoodType, Block> coffin;
    public final SimpleEntrySet<WoodType, Block> crate;
    public final SimpleEntrySet<WoodType, Block> kitchenCabinet;
    public final SimpleEntrySet<WoodType, Block> ladder;
    public final SimpleEntrySet<WoodType, Block> logBenches;
    public final SimpleEntrySet<WoodType, Block> pedestalTable;
    public final SimpleEntrySet<WoodType, Block> shelf;
    public final SimpleEntrySet<WoodType, Block> shutter;
    public final SimpleEntrySet<WoodType, Block> squareTable;
    public final SimpleEntrySet<WoodType, Block> stool;
    public final SimpleEntrySet<WoodType, Block> table;
    public final SimpleEntrySet<WoodType, Block> wardrobe;
    public final SimpleEntrySet<WoodType, Block> bookshelfChest;

    public FurnishModule(String modId) {
        super(modId, "fur");
        ResourceLocation tab = this.modRes("furnish");
        TemplateRecipeManager.registerTemplate((ResourceLocation)this.modRes("furniture_making"), x$0 -> new FurnishRecipeTemplate((JsonObject)x$0));
        this.table = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "table", this.getModBlock("oak_table"), () -> VanillaWoodTypes.OAK, w -> new Table(Utils.copyPropertySafe((Block)w.log))).requiresChildren(new String[]{"stripped_log"})).addTag(this.modRes("wooden_furniture"), Registries.f_256747_)).addTag(BlockTags.f_144280_, Registries.f_256747_)).addRecipe(this.modRes("furniture_making/oak_table"))).setTabKey(tab)).build();
        this.addEntry(this.table);
        this.squareTable = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "square_table", this.getModBlock("oak_square_table"), () -> VanillaWoodTypes.OAK, w -> new SimpleFurniture(Utils.copyPropertySafe((Block)w.log))).requiresChildren(new String[]{"stripped_log"})).addTag(this.modRes("wooden_furniture"), Registries.f_256747_)).addTag(BlockTags.f_144280_, Registries.f_256747_)).addRecipe(this.modRes("furniture_making/oak_square_table"))).setTabKey(tab)).build();
        this.addEntry(this.squareTable);
        this.pedestalTable = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "pedestal_table", this.getModBlock("oak_pedestal_table"), () -> VanillaWoodTypes.OAK, w -> new SimpleFurniture(Utils.copyPropertySafe((Block)w.log))).requiresChildren(new String[]{"stripped_log"})).addTag(this.modRes("wooden_furniture"), Registries.f_256747_)).addTag(BlockTags.f_144280_, Registries.f_256747_)).addRecipe(this.modRes("furniture_making/oak_pedestal_table"))).setTabKey(tab)).build();
        this.addEntry(this.pedestalTable);
        this.bedsideTable = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "bedside_table", this.getModBlock("oak_bedside_table"), () -> VanillaWoodTypes.OAK, w -> new InventoryFurniture(Utils.copyPropertySafe((Block)w.log), FurnishRegistries.Drawers_Open_Sound, FurnishRegistries.Drawers_Close_Sound)).requiresChildren(new String[]{"stripped_log"})).addTag(this.modRes("wooden_furniture"), Registries.f_256747_)).addTag(BlockTags.f_144280_, Registries.f_256747_)).addTile(FurnishRegistries.Furniture_BlockEntity).addRecipe(this.modRes("furniture_making/oak_bedside_table"))).setTabKey(tab)).build();
        this.addEntry(this.bedsideTable);
        this.kitchenCabinet = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "kitchen_cabinet", FurnishBlocks.Oak_Kitchen_Cabinet, () -> VanillaWoodTypes.OAK, w -> new InventoryFurniture(Utils.copyPropertySafe((Block)w.planks), FurnishRegistries.Drawers_Open_Sound, FurnishRegistries.Drawers_Close_Sound)).requiresChildren(new String[]{"stripped_log"})).addTag(this.modRes("wooden_furniture"), Registries.f_256747_)).addTag(BlockTags.f_144280_, Registries.f_256747_)).addTile(FurnishRegistries.Furniture_BlockEntity).addRecipe(this.modRes("furniture_making/oak_kitchen_cabinet"))).setTabKey(tab)).build();
        this.addEntry(this.kitchenCabinet);
        this.cabinet = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "cabinet", FurnishBlocks.Birch_Cabinet, () -> VanillaWoodTypes.BIRCH, w -> new Cabinet(Utils.copyPropertySafe((Block)w.log), FurnishRegistries.Cabinet_Open_Sound, FurnishRegistries.Cabinet_Close_Sound)).requiresChildren(new String[]{"stripped_log"})).addTag(this.modRes("wooden_furniture"), Registries.f_256747_)).addTag(BlockTags.f_144280_, Registries.f_256747_)).addTile(FurnishRegistries.Furniture_BlockEntity).addTexture(this.modRes("block/birch_cabinet_door_right"))).addTexture(this.modRes("block/birch_cabinet_door_left"))).addRecipe(this.modRes("furniture_making/birch_cabinet"))).setTabKey(tab)).build();
        this.addEntry(this.cabinet);
        this.wardrobe = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "wardrobe", FurnishBlocks.Birch_Wardrobe, () -> VanillaWoodTypes.BIRCH, w -> new Wardrobe(Utils.copyPropertySafe((Block)w.log), FurnishRegistries.Cabinet_Open_Sound, FurnishRegistries.Cabinet_Close_Sound)).requiresChildren(new String[]{"stripped_log"})).addTag(this.modRes("wooden_furniture"), Registries.f_256747_)).addTag(BlockTags.f_144280_, Registries.f_256747_)).addTile(FurnishRegistries.Large_Furniture_BlockEntity).addTexture(this.modRes("block/birch_wardrobe_door_bottom_right"))).addTexture(this.modRes("block/birch_wardrobe_door_bottom_left"))).addTexture(this.modRes("block/birch_wardrobe_door_top_right"))).addTexture(this.modRes("block/birch_wardrobe_door_top_left"))).addRecipe(this.modRes("furniture_making/birch_wardrobe"))).setTabKey(tab)).build();
        this.addEntry(this.wardrobe);
        this.stool = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "stool", FurnishBlocks.Oak_Stool, () -> VanillaWoodTypes.OAK, w -> new Chair(Utils.copyPropertySafe((Block)w.log), Chair.BASE_SHAPES)).requiresChildren(new String[]{"stripped_log"})).addTag(this.modRes("wooden_furniture"), Registries.f_256747_)).addTag(BlockTags.f_144280_, Registries.f_256747_)).addRecipe(this.modRes("furniture_making/oak_stool"))).setTabKey(tab)).build();
        this.addEntry(this.stool);
        this.chair = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "chair", FurnishBlocks.Oak_Chair, () -> VanillaWoodTypes.OAK, w -> new Chair(Utils.copyPropertySafe((Block)w.log), VoxelShapeHelper.getMergedShapes((VoxelShape[][])new VoxelShape[][]{Chair.BASE_SHAPES, Chair.CHAIR_SEAT}))).requiresChildren(new String[]{"stripped_log"})).addTag(this.modRes("wooden_furniture"), Registries.f_256747_)).addTag(BlockTags.f_144280_, Registries.f_256747_)).addRecipe(this.modRes("furniture_making/oak_chair"))).setTabKey(tab)).build();
        this.addEntry(this.chair);
        this.shutter = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "shutter", FurnishBlocks.Oak_Shutter, () -> VanillaWoodTypes.OAK, w -> new Shutter(Utils.copyPropertySafe((Block)w.planks))).requiresChildren(new String[]{"trapdoor"})).addTag(this.modRes("wooden_furniture"), Registries.f_256747_)).addTag(BlockTags.f_144280_, Registries.f_256747_)).addRecipe(this.modRes("furniture_making/oak_shutter"))).addTexture(this.modRes("block/oak_shutter"))).setTabKey(tab)).build();
        this.addEntry(this.shutter);
        this.crate = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "crate", FurnishBlocks.Oak_Crate, () -> VanillaWoodTypes.OAK, w -> new Crate(Utils.copyPropertySafe((Block)w.planks))).addTag(BlockTags.f_144280_, Registries.f_256747_)).addTag(this.modRes("wooden_furniture"), Registries.f_256747_)).addTag(this.modRes("crates"), Registries.f_256747_)).addTag(this.modRes("wooden_furniture"), Registries.f_256913_)).addTag(this.modRes("mail"), Registries.f_256913_)).addTag(this.modRes("crates"), Registries.f_256913_)).addTag(this.modRes("crate_blacklist"), Registries.f_256913_)).addRecipe(this.modRes("furniture_making/oak_crate"))).addTexture(this.modRes("block/oak_crate_side"))).addTexture(this.modRes("block/oak_crate_top"))).setTabKey(tab)).addCustomItem((woodType, block, properties) -> new BlockItem(block, properties.m_41487_(1))).copyParentDrop().build();
        this.addEntry(this.crate);
        this.shelf = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "shelf", FurnishBlocks.Oak_Shelf, () -> VanillaWoodTypes.OAK, w -> new Shelf(Utils.copyPropertySafe((Block)w.planks))).requiresChildren(new String[]{"stripped_log"})).addTag(this.modRes("wooden_furniture"), Registries.f_256747_)).addTag(BlockTags.f_144280_, Registries.f_256747_)).addTile(FurnishRegistries.Shelf_BlockEntity).addRecipe(this.modRes("furniture_making/oak_shelf"))).setTabKey(tab)).build();
        this.addEntry(this.shelf);
        this.bench = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "bench", FurnishBlocks.Oak_Bench, () -> VanillaWoodTypes.OAK, w -> new Bench(Utils.copyPropertySafe((Block)w.planks))).requiresChildren(new String[]{"stripped_log"})).addTag(this.modRes("wooden_furniture"), Registries.f_256747_)).addTag(BlockTags.f_144280_, Registries.f_256747_)).addRecipe(this.modRes("furniture_making/oak_bench"))).setTabKey(tab)).build();
        this.addEntry(this.bench);
        this.logBenches = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "log_bench", FurnishBlocks.Oak_Log_Bench, () -> VanillaWoodTypes.OAK, w -> new LogBench(Utils.copyPropertySafe((Block)w.log))).addTag(this.modRes("wooden_furniture"), Registries.f_256747_)).addTag(BlockTags.f_144280_, Registries.f_256747_)).addRecipe(this.modRes("furniture_making/oak_log_bench"))).addTexture(this.modRes("block/oak_log_bench_top"))).setRenderType(RenderLayer.CUTOUT).setTabKey(tab)).build();
        this.addEntry(this.logBenches);
        this.ladder = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "ladder", FurnishBlocks.Oak_Ladder, () -> VanillaWoodTypes.OAK, w -> new Ladder(Utils.copyPropertySafe((Block)w.log))).requiresChildren(new String[]{"stripped_log"})).addTag(this.modRes("wooden_furniture"), Registries.f_256747_)).addTag(BlockTags.f_144280_, Registries.f_256747_)).addTag(BlockTags.f_13082_, Registries.f_256747_)).addRecipe(this.modRes("furniture_making/oak_ladder"))).setTabKey(tab)).build();
        this.addEntry(this.ladder);
        this.coffin = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "coffin", FurnishBlocks.Jungle_Coffin, () -> VanillaWoodTypes.JUNGLE, w -> new Coffin(Utils.copyPropertySafe((Block)w.planks))).addTag(this.modRes("wooden_furniture"), Registries.f_256747_)).addTag(BlockTags.f_144280_, Registries.f_256747_)).addRecipe(this.modRes("furniture_making/jungle_coffin"))).addTexture(this.modRes("block/jungle_coffin_sides"))).setTabKey(tab)).build();
        this.addEntry(this.coffin);
        this.bookshelfChest = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "bookshelf_chest", FurnishBlocks.Dark_Oak_Bookshelf_Chest, () -> VanillaWoodTypes.DARK_OAK, w -> new BookshelfChest(Utils.copyPropertySafe((Block)w.planks).m_278166_(PushReaction.BLOCK))).addTag(BlockTags.f_144280_, Registries.f_256747_)).addTag(this.modRes("bookshelf_chest"), Registries.f_256747_)).addTag(this.modRes("wooden_furniture"), Registries.f_256747_)).addTag(this.modRes("wooden_furniture"), Registries.f_256913_)).addTag(this.modRes("bookshelf_chests"), Registries.f_256913_)).addRecipe(this.modRes("furniture_making/dark_oak_bookshelf_chest"))).addTextureM(this.modRes("block/bookshelf/dark_oak_bookshelf"), EveryCompat.res("block/fur/dark_oak_bookshelf_chest_m"))).addTextureM(this.modRes("block/bookshelf/dark_oak_bookshelf_chest_empty"), EveryCompat.res("block/fur/dark_oak_bookshelf_chest_m"))).addTextureM(this.modRes("block/bookshelf/dark_oak_bookshelf_chest_plenty"), EveryCompat.res("block/fur/dark_oak_bookshelf_chest_m"))).addTextureM(this.modRes("block/bookshelf/dark_oak_bookshelf_chest_sparse"), EveryCompat.res("block/fur/dark_oak_bookshelf_chest_m"))).addTile(FurnishRegistries.BookshelfChest_BlockEntity).setTabKey(tab)).build();
        this.addEntry(this.bookshelfChest);
    }

    @Override
    public void addDynamicServerResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicServerResources(executor);
        executor.accept((manager, handler) -> {
            for (WoodType w : WoodTypeRegistry.INSTANCE) {
                boolean hasSomething = false;
                SimpleTagBuilder itemTag = SimpleTagBuilder.of((ResourceLocation)this.modRes(w.getTypeName() + "_furniture"));
                for (EntrySet<?> entry : this.getEntries()) {
                    Item b = (Item)((SimpleEntrySet)entry).items.get(w);
                    if (b == null) continue;
                    hasSomething = true;
                    itemTag.addEntry((Object)b);
                }
                if (!hasSomething) continue;
                handler.addTag(itemTag, Registries.f_256913_);
                handler.addTag(itemTag, Registries.f_256747_);
            }
        });
    }

    @Override
    public void addDynamicClientResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicClientResources(executor);
        executor.accept((manager, handler) -> {
            this.logBenches.blocks.forEach((w, block) -> {
                ResourceLocation id = Utils.getID((Block)block);
                try (TextureImage topTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)w.log, SpriteHelper.LOOKS_LIKE_TOP_LOG_TEXTURE));){
                    String newId = BlockTypeResTransformer.replaceTypeNoNamespace((String)"block/oak_log_bench_top", (BlockType)w, (ResourceLocation)id, (String)"oak");
                    TextureImage newTexture = topTexture.makeCopy();
                    handler.addTextureIfNotPresent(manager, newId, () -> newTexture);
                    TextureImage newTop = topTexture.makeCopy();
                    this.createTopTexture(topTexture, newTop);
                    handler.addTextureIfNotPresent(manager, newId + "_top", () -> newTop);
                }
                catch (Exception e) {
                    EveryCompat.LOGGER.error("Failed to generate Log Bench block texture for for {} : {}", block, (Object)e);
                }
            });
            this.coffin.blocks.forEach((w, block) -> {
                ResourceLocation id = Utils.getID((Block)block);
                try (TextureImage topTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)w.log, SpriteHelper.LOOKS_LIKE_TOP_LOG_TEXTURE));){
                    String newId = BlockTypeResTransformer.replaceTypeNoNamespace((String)"block/jungle_coffin_sides", (BlockType)w, (ResourceLocation)id, (String)"jungle");
                    TextureImage newTexture = topTexture.makeCopy();
                    handler.addTextureIfNotPresent(manager, newId, () -> newTexture);
                    TextureImage newTop = topTexture.makeCopy();
                    this.createTopTexture(topTexture, newTop);
                    handler.addTextureIfNotPresent(manager, newId + "_top", () -> newTop);
                }
                catch (Exception e) {
                    EveryCompat.LOGGER.error("Failed to generate coffin block texture for for {} : {}", block, (Object)e);
                }
            });
        });
    }

    private void createTopTexture(TextureImage original, TextureImage newImage) {
        original.forEachFramePixel((i, x, y) -> {
            int localX = x - original.getFrameStartX(i.intValue());
            int localY = y - original.getFrameStartY(i.intValue());
            if (localX >= 5 && localX <= 10 && localY >= 5 && localY <= 10) {
                newImage.getImage().m_84988_(x - 3, y - 3, original.getImage().m_84985_(x.intValue(), y.intValue()));
            } else if (localX >= 10 && localY > 0 && localY <= 7) {
                newImage.getImage().m_84988_(x - 6, y.intValue(), original.getImage().m_84985_(x.intValue(), y.intValue()));
                newImage.getImage().m_84988_(x.intValue(), y.intValue(), 0);
            } else if (localY >= 10 && localX > 0 && localX <= 7) {
                newImage.getImage().m_84988_(x.intValue(), y - 6, original.getImage().m_84985_(x.intValue(), y.intValue()));
                newImage.getImage().m_84988_(x.intValue(), y.intValue(), 0);
            } else if (localX >= 10 && localY >= 10) {
                newImage.getImage().m_84988_(x - 6, y - 6, original.getImage().m_84985_(x.intValue(), y.intValue()));
            } else if (localX >= 10 || localY >= 10) {
                newImage.getImage().m_84988_(x.intValue(), y.intValue(), 0);
            }
        });
    }

    public class FurnishRecipeTemplate
    implements IRecipeTemplate<FurnishFinishedRecipe> {
        private final List<Object> conditions = new ArrayList<Object>();
        public final ItemStack result;
        public final String group;
        public final Ingredient ingredient;

        public FurnishRecipeTemplate(JsonObject json) {
            JsonElement g = json.get("group");
            this.group = g == null ? "" : g.getAsString();
            this.ingredient = Ingredient.m_43917_((JsonElement)json.get("ingredient"));
            String s1 = GsonHelper.m_13906_((JsonObject)json, (String)"result");
            int i = GsonHelper.m_13927_((JsonObject)json, (String)"count");
            this.result = new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(s1)), i);
        }

        public <T extends BlockType> FurnishFinishedRecipe createSimilar(T originalMat, T destinationMat, Item unlockItem, String id) {
            Item newRes = BlockType.changeItemType((Item)this.result.m_41720_(), originalMat, destinationMat);
            if (newRes == null) {
                throw new UnsupportedOperationException(String.format("Could not convert output item %s from type %s to %s", this.result, originalMat, destinationMat));
            }
            ItemStack newResult = new ItemStack((ItemLike)newRes);
            if (this.result.m_41782_()) {
                newResult.m_41751_(this.result.m_41784_().m_6426_());
            }
            if (id == null) {
                id = BuiltInRegistries.f_257033_.m_7981_((Object)newRes.m_5456_()).toString();
            }
            Ingredient newIng = ResourcesUtils.convertIngredient(this.ingredient, originalMat, destinationMat);
            Advancement.Builder advancement = Advancement.Builder.m_138353_();
            advancement.m_138386_("has_planks", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{unlockItem}));
            ResourceLocation res = new ResourceLocation(id);
            return new FurnishFinishedRecipe(res, this.group, newIng, newResult, advancement, FurnishModule.this.modRes("recipes/furnish/" + res.m_135815_()));
        }

        public void addCondition(Object condition) {
            this.conditions.add(condition);
        }

        public List<Object> getConditions() {
            return this.conditions;
        }
    }

    public static class FurnishFinishedRecipe
    implements FinishedRecipe {
        protected final Ingredient ingredient;
        protected final ItemStack result;
        protected final ResourceLocation id;
        protected final String group;
        private final Advancement.Builder advancement;
        protected final ResourceLocation advancementId;

        public FurnishFinishedRecipe(ResourceLocation resourceLocation, String group, Ingredient ingredient, ItemStack result, Advancement.Builder advancement, ResourceLocation advancementId) {
            this.id = resourceLocation;
            this.group = group;
            this.ingredient = ingredient;
            this.result = result;
            this.advancement = advancement;
            this.advancementId = advancementId;
        }

        public void m_7917_(@NotNull JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            json.addProperty("id", this.id.toString());
            json.add("ingredient", this.ingredient.m_43942_());
            json.addProperty("result", Utils.getID((Item)this.result.m_41720_()).toString());
            json.addProperty("count", (Number)this.result.m_41613_());
        }

        @NotNull
        public ResourceLocation m_6445_() {
            return this.id;
        }

        @NotNull
        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)FurnishRegistries.Furniture_Recipe_Serializer.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

