/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.modules.beautiful_campfires;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.common_classes.TagUtility;
import net.mehvahdjukaar.every_compat.misc.SpriteHelper;
import net.mehvahdjukaar.moonlight.api.resources.BlockTypeResTransformer;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.NotNull;

public class BeautifulCampfiresModule
extends SimpleModule {
    public final SimpleEntrySet<WoodType, CampfireBlock> campfires;
    public final SimpleEntrySet<WoodType, CampfireBlock> soul_campfires;

    public BeautifulCampfiresModule(String modId) {
        super(modId, "bc");
        ResourceKey tab = CreativeModeTabs.f_256791_;
        this.campfires = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "campfire", this.getModBlock("acacia_campfire", CampfireBlock.class), () -> WoodTypeRegistry.getValue((String)"acacia"), w -> new CampfireBlock(true, 1, this.copyProperties(15))).addTile(() -> BlockEntityType.f_58911_).addTextureM(this.modRes("item/acacia_campfire"), EveryCompat.res("item/bc/campfire_m"))).addTextureM(this.modRes("item/acacia_soul_campfire"), EveryCompat.res("item/bc/campfire_m"))).addTag(BlockTags.f_144280_, Registries.f_256747_)).addTag(BlockTags.f_13087_, Registries.f_256747_)).setTabKey(tab)).build();
        this.addEntry(this.campfires);
        this.soul_campfires = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "soul_campfire", this.getModBlock("acacia_soul_campfire", CampfireBlock.class), () -> WoodTypeRegistry.getValue((String)"acacia"), w -> new CampfireBlock(true, 2, this.copyProperties(10))).addTile(() -> BlockEntityType.f_58911_).createPaletteFromChild("log")).addTextureM(this.modRes("block/acacia_campfire_log_lit"), EveryCompat.res("block/bc/campfire_log_lit_m"))).addTextureM(this.modRes("block/acacia_soul_campfire_log_lit"), EveryCompat.res("block/bc/campfire_log_lit_m"))).addTag(BlockTags.f_144280_, Registries.f_256747_)).addTag(BlockTags.f_13087_, Registries.f_256747_)).addTag(BlockTags.f_13042_, Registries.f_256747_)).setTabKey(tab)).build();
        this.addEntry(this.soul_campfires);
    }

    public BlockBehaviour.Properties copyProperties(int pLightValue) {
        return BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283819_).m_280658_(NoteBlockInstrument.BASS).m_60978_(2.0f).m_60918_(SoundType.f_56736_).m_60953_(BeautifulCampfiresModule.litBlockEmission(pLightValue)).m_60955_().m_278183_();
    }

    @NotNull
    private static ToIntFunction<BlockState> litBlockEmission(int pLightValue) {
        return state -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? pLightValue : 0;
    }

    @Override
    public void addDynamicServerResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicServerResources(executor);
        executor.accept((manager, handler) -> {
            ResourceLocation campfireLoc = this.modRes("acacia_campfire");
            ResourceLocation soulCampfireLoc = this.modRes("acacia_soul_campfire");
            this.campfires.blocks.forEach((wood, block) -> {
                this.createRecipe("campfire", (WoodType)wood, (Block)block, campfireLoc, handler, manager);
                this.createRecipe("soul_campfire", (WoodType)wood, (Block)this.soul_campfires.blocks.get(wood), soulCampfireLoc, handler, manager);
            });
        });
    }

    public void createRecipe(String recipeName, WoodType woodType, Block output, ResourceLocation recipeLoc, ResourceSink handler, ResourceManager manager) {
        try (InputStream recipeStream = ((Resource)manager.m_213713_(ResType.RECIPES.getPath(recipeLoc)).orElseThrow(() -> new FileNotFoundException("File not found @ " + String.valueOf(recipeLoc)))).m_215507_();){
            JsonObject recipe = RPUtils.deserializeJson((InputStream)recipeStream);
            recipe.getAsJsonObject("key").getAsJsonObject("L").addProperty("tag", TagUtility.getATagOrCreateANew("logs", "caps", (BlockType)woodType, handler, manager).toString());
            recipe.getAsJsonObject("result").addProperty("item", Utils.getID((Block)output).toString());
            handler.addJson(EveryCompat.res(this.shortenedId() + "/" + woodType.getAppendableId() + "_" + recipeName), (JsonElement)recipe, ResType.RECIPES);
        }
        catch (IOException e) {
            EveryCompat.LOGGER.error("Failed to generate the {} recipe for {} : {}", (Object)recipeName, (Object)woodType.getId(), (Object)e);
        }
    }

    @Override
    public void addDynamicClientResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicClientResources(executor);
        executor.accept(this::makeCampfireTextures);
    }

    private void makeCampfireTextures(ResourceManager manager, ResourceSink sink) {
        String campfirePath = "block/acacia_campfire_log";
        ResourceLocation campfireImage = this.modRes(campfirePath);
        ResourceLocation targetLogMask = EveryCompat.res("block/bc/campfire_log_m");
        ResourceLocation targetPlankMask = EveryCompat.res("block/bc/campfire_plank_m");
        try (TextureImage textureImage = TextureImage.open((ResourceManager)manager, (ResourceLocation)campfireImage);
             TextureImage targetLogImage = TextureImage.open((ResourceManager)manager, (ResourceLocation)targetLogMask);
             TextureImage targetPlankImage = TextureImage.open((ResourceManager)manager, (ResourceLocation)targetPlankMask);){
            this.campfires.blocks.forEach((wood, block) -> {
                ResourceLocation id = Utils.getID((Block)block);
                try (TextureImage plankTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)wood.planks));
                     TextureImage logTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)wood.log, SpriteHelper.LOOKS_LIKE_SIDE_LOG_TEXTURE));){
                    String newPath = BlockTypeResTransformer.replaceTypeNoNamespace((String)campfirePath, (BlockType)wood, (ResourceLocation)id, (String)"acacia");
                    Respriter respriterLog = Respriter.masked((TextureImage)textureImage, (TextureImage)targetLogImage);
                    TextureImage recoloredLog = respriterLog.recolorWithAnimationOf(logTexture);
                    Respriter respriterPlank = Respriter.masked((TextureImage)recoloredLog, (TextureImage)targetPlankImage);
                    TextureImage finishedImage = respriterPlank.recolorWithAnimationOf(plankTexture);
                    sink.addTextureIfNotPresent(manager, newPath, () -> finishedImage);
                }
                catch (IOException e) {
                    EveryCompat.LOGGER.error("Failed to open log/plank texture file: ", (Throwable)e);
                }
            });
        }
        catch (IOException e) {
            EveryCompat.LOGGER.error("Failed to open texture file: ", (Throwable)e);
        }
    }
}

