/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block.entity.spawner;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.ForgeEventFactory;
import twilightforest.block.entity.spawner.BossSpawnerBlockEntity;
import twilightforest.entity.boss.KnightPhantom;
import twilightforest.init.TFBlockEntities;
import twilightforest.init.TFEntities;
import twilightforest.init.TFItems;
import twilightforest.init.TFParticleType;

public class KnightPhantomSpawnerBlockEntity
extends BossSpawnerBlockEntity<KnightPhantom> {
    private static final int COUNT = 6;
    private int spawned = 0;

    public KnightPhantomSpawnerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFBlockEntities.KNIGHT_PHANTOM_SPAWNER.get(), (EntityType)TFEntities.KNIGHT_PHANTOM.get(), pos, state);
    }

    @Override
    public boolean anyPlayerInRange() {
        Player closestPlayer = this.m_58904_().m_45924_((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5, (double)this.getRange(), false);
        return closestPlayer != null && closestPlayer.m_20186_() > (double)(this.m_58899_().m_123342_() - 2);
    }

    @Override
    protected boolean spawnMyBoss(ServerLevelAccessor accessor) {
        for (int i = this.spawned; i < 6; ++i) {
            KnightPhantom myCreature = (KnightPhantom)this.makeMyCreature();
            float angle = 60.0f * (float)i;
            float distance = 4.0f;
            double rx = (double)this.m_58899_().m_123341_() + 0.5 + Math.cos((double)angle * Math.PI / 180.0) * 4.0;
            double ry = this.m_58899_().m_123342_();
            double rz = (double)this.m_58899_().m_123343_() + 0.5 + Math.sin((double)angle * Math.PI / 180.0) * 4.0;
            myCreature.m_7678_(rx, ry, rz, accessor.m_6018_().m_213780_().m_188501_() * 360.0f, 0.0f);
            ForgeEventFactory.onFinalizeSpawn((Mob)myCreature, (ServerLevelAccessor)accessor, (DifficultyInstance)accessor.m_6436_(new BlockPos((Vec3i)myCreature.m_20183_())), (MobSpawnType)MobSpawnType.SPAWNER, null, null);
            if (i == 5 && accessor.m_46791_() == Difficulty.HARD) {
                myCreature.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)TFItems.KNIGHTMETAL_SHIELD.get()));
            }
            this.initializeCreature(myCreature);
            myCreature.setNumber(i);
            if (!accessor.m_7967_((Entity)myCreature)) continue;
            ++this.spawned;
        }
        return this.spawned == 6;
    }

    @Override
    public ParticleOptions getSpawnerParticle() {
        return (ParticleOptions)TFParticleType.OMINOUS_FLAME.get();
    }
}

