/*
 * Decompiled with CFR 0.152.
 */
package kalrog.cc_printers_plus.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import kalrog.cc_printers_plus.data.PrintData;
import kalrog.cc_printers_plus.data.Shape;
import kalrog.cc_printers_plus.data.ShapesCollection;
import kalrog.cc_printers_plus.item.PrintItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import org.joml.Matrix4f;

public class PrintItemRenderer
extends BlockEntityWithoutLevelRenderer {
    public PrintItemRenderer(BlockEntityRenderDispatcher dispatcher, Minecraft mc) {
        super(dispatcher, mc.m_167973_());
    }

    public void m_108829_(ItemStack stack, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        PrintData printData = PrintItem.getPrintData(stack);
        if (printData == null || printData.isEmpty()) {
            return;
        }
        poseStack.m_85836_();
        this.applyItemTransforms(poseStack, displayContext);
        ShapesCollection shapes = printData.getShapesOff();
        VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_110463_());
        for (Shape shape : shapes) {
            this.renderShape(shape, poseStack, consumer, packedLight, packedOverlay);
        }
        poseStack.m_85849_();
    }

    private void applyItemTransforms(PoseStack poseStack, ItemDisplayContext context) {
        poseStack.m_85837_(0.5, 0.5, 0.5);
        switch (context) {
            case GUI: {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(30.0f));
                poseStack.m_252781_(Axis.f_252436_.m_252977_(225.0f));
                poseStack.m_85841_(0.625f, 0.625f, 0.625f);
                break;
            }
            case FIRST_PERSON_RIGHT_HAND: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(45.0f));
                poseStack.m_85841_(0.4f, 0.4f, 0.4f);
                break;
            }
            case FIRST_PERSON_LEFT_HAND: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(-135.0f));
                poseStack.m_85841_(0.4f, 0.4f, 0.4f);
                break;
            }
            case THIRD_PERSON_RIGHT_HAND: 
            case THIRD_PERSON_LEFT_HAND: {
                poseStack.m_85837_(0.0, 0.15625, 0.0);
                poseStack.m_252781_(Axis.f_252529_.m_252977_(75.0f));
                poseStack.m_252781_(Axis.f_252436_.m_252977_(45.0f));
                poseStack.m_85841_(0.375f, 0.375f, 0.375f);
                break;
            }
            case GROUND: {
                poseStack.m_85837_(0.0, 0.1875, 0.0);
                poseStack.m_85841_(0.25f, 0.25f, 0.25f);
                break;
            }
            case FIXED: {
                poseStack.m_85841_(0.5f, 0.5f, 0.5f);
                break;
            }
            case HEAD: {
                break;
            }
            default: {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(30.0f));
                poseStack.m_252781_(Axis.f_252436_.m_252977_(225.0f));
                poseStack.m_85841_(0.625f, 0.625f, 0.625f);
            }
        }
    }

    private void renderShape(Shape shape, PoseStack poseStack, VertexConsumer consumer, int packedLight, int packedOverlay) {
        AABB bounds = shape.getBounds();
        ResourceLocation texture = shape.getTexture();
        Integer tint = shape.getTint();
        if (texture == null) {
            return;
        }
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(texture);
        int color = tint != null ? tint | 0xFF000000 : -1;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float minX = (float)(bounds.f_82288_ / 16.0) - 0.5f;
        float minY = (float)(bounds.f_82289_ / 16.0) - 0.5f;
        float minZ = (float)(bounds.f_82290_ / 16.0) - 0.5f;
        float maxX = (float)(bounds.f_82291_ / 16.0) - 0.5f;
        float maxY = (float)(bounds.f_82292_ / 16.0) - 0.5f;
        float maxZ = (float)(bounds.f_82293_ / 16.0) - 0.5f;
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        this.renderFace(consumer, matrix, Direction.DOWN, minX, minY, minZ, maxX, maxY, maxZ, sprite, r, g, b, a, packedLight, packedOverlay);
        this.renderFace(consumer, matrix, Direction.UP, minX, minY, minZ, maxX, maxY, maxZ, sprite, r, g, b, a, packedLight, packedOverlay);
        this.renderFace(consumer, matrix, Direction.NORTH, minX, minY, minZ, maxX, maxY, maxZ, sprite, r, g, b, a, packedLight, packedOverlay);
        this.renderFace(consumer, matrix, Direction.SOUTH, minX, minY, minZ, maxX, maxY, maxZ, sprite, r, g, b, a, packedLight, packedOverlay);
        this.renderFace(consumer, matrix, Direction.WEST, minX, minY, minZ, maxX, maxY, maxZ, sprite, r, g, b, a, packedLight, packedOverlay);
        this.renderFace(consumer, matrix, Direction.EAST, minX, minY, minZ, maxX, maxY, maxZ, sprite, r, g, b, a, packedLight, packedOverlay);
    }

    private void renderFace(VertexConsumer consumer, Matrix4f matrix, Direction face, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, TextureAtlasSprite sprite, float r, float g, float b, float a, int packedLight, int packedOverlay) {
        float offsetX = 8.0f;
        float offsetY = 8.0f;
        float offsetZ = 8.0f;
        switch (face) {
            case DOWN: {
                consumer.m_252986_(matrix, minX, minY, minZ).m_85950_(r, g, b, a).m_7421_(sprite.m_118367_((double)(minX * 16.0f + offsetX)), sprite.m_118393_((double)(minZ * 16.0f + offsetZ))).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                consumer.m_252986_(matrix, maxX, minY, minZ).m_85950_(r, g, b, a).m_7421_(sprite.m_118367_((double)(maxX * 16.0f + offsetX)), sprite.m_118393_((double)(minZ * 16.0f + offsetZ))).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                consumer.m_252986_(matrix, maxX, minY, maxZ).m_85950_(r, g, b, a).m_7421_(sprite.m_118367_((double)(maxX * 16.0f + offsetX)), sprite.m_118393_((double)(maxZ * 16.0f + offsetZ))).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                consumer.m_252986_(matrix, minX, minY, maxZ).m_85950_(r, g, b, a).m_7421_(sprite.m_118367_((double)(minX * 16.0f + offsetX)), sprite.m_118393_((double)(maxZ * 16.0f + offsetZ))).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                break;
            }
            case UP: {
                consumer.m_252986_(matrix, minX, maxY, minZ).m_85950_(r, g, b, a).m_7421_(sprite.m_118367_((double)(minX * 16.0f + offsetX)), sprite.m_118393_((double)(minZ * 16.0f + offsetZ))).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                consumer.m_252986_(matrix, minX, maxY, maxZ).m_85950_(r, g, b, a).m_7421_(sprite.m_118367_((double)(minX * 16.0f + offsetX)), sprite.m_118393_((double)(maxZ * 16.0f + offsetZ))).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                consumer.m_252986_(matrix, maxX, maxY, maxZ).m_85950_(r, g, b, a).m_7421_(sprite.m_118367_((double)(maxX * 16.0f + offsetX)), sprite.m_118393_((double)(maxZ * 16.0f + offsetZ))).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                consumer.m_252986_(matrix, maxX, maxY, minZ).m_85950_(r, g, b, a).m_7421_(sprite.m_118367_((double)(maxX * 16.0f + offsetX)), sprite.m_118393_((double)(minZ * 16.0f + offsetZ))).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                break;
            }
            case NORTH: {
                consumer.m_252986_(matrix, minX, minY, minZ).m_85950_(r, g, b, a).m_7421_(sprite.m_118367_((double)(minX * 16.0f + offsetX)), sprite.m_118393_((double)(16.0f - (minY * 16.0f + offsetY)))).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                consumer.m_252986_(matrix, minX, maxY, minZ).m_85950_(r, g, b, a).m_7421_(sprite.m_118367_((double)(minX * 16.0f + offsetX)), sprite.m_118393_((double)(16.0f - (maxY * 16.0f + offsetY)))).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                consumer.m_252986_(matrix, maxX, maxY, minZ).m_85950_(r, g, b, a).m_7421_(sprite.m_118367_((double)(maxX * 16.0f + offsetX)), sprite.m_118393_((double)(16.0f - (maxY * 16.0f + offsetY)))).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                consumer.m_252986_(matrix, maxX, minY, minZ).m_85950_(r, g, b, a).m_7421_(sprite.m_118367_((double)(maxX * 16.0f + offsetX)), sprite.m_118393_((double)(16.0f - (minY * 16.0f + offsetY)))).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                break;
            }
            case SOUTH: {
                consumer.m_252986_(matrix, minX, minY, maxZ).m_85950_(r, g, b, a).m_7421_(sprite.m_118367_((double)(16.0f - (minX * 16.0f + offsetX))), sprite.m_118393_((double)(16.0f - (minY * 16.0f + offsetY)))).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                consumer.m_252986_(matrix, maxX, minY, maxZ).m_85950_(r, g, b, a).m_7421_(sprite.m_118367_((double)(16.0f - (maxX * 16.0f + offsetX))), sprite.m_118393_((double)(16.0f - (minY * 16.0f + offsetY)))).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                consumer.m_252986_(matrix, maxX, maxY, maxZ).m_85950_(r, g, b, a).m_7421_(sprite.m_118367_((double)(16.0f - (maxX * 16.0f + offsetX))), sprite.m_118393_((double)(16.0f - (maxY * 16.0f + offsetY)))).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                consumer.m_252986_(matrix, minX, maxY, maxZ).m_85950_(r, g, b, a).m_7421_(sprite.m_118367_((double)(16.0f - (minX * 16.0f + offsetX))), sprite.m_118393_((double)(16.0f - (maxY * 16.0f + offsetY)))).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                break;
            }
            case WEST: {
                consumer.m_252986_(matrix, minX, minY, minZ).m_85950_(r, g, b, a).m_7421_(sprite.m_118367_((double)(minZ * 16.0f + offsetZ)), sprite.m_118393_((double)(16.0f - (minY * 16.0f + offsetY)))).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                consumer.m_252986_(matrix, minX, minY, maxZ).m_85950_(r, g, b, a).m_7421_(sprite.m_118367_((double)(maxZ * 16.0f + offsetZ)), sprite.m_118393_((double)(16.0f - (minY * 16.0f + offsetY)))).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                consumer.m_252986_(matrix, minX, maxY, maxZ).m_85950_(r, g, b, a).m_7421_(sprite.m_118367_((double)(maxZ * 16.0f + offsetZ)), sprite.m_118393_((double)(16.0f - (maxY * 16.0f + offsetY)))).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                consumer.m_252986_(matrix, minX, maxY, minZ).m_85950_(r, g, b, a).m_7421_(sprite.m_118367_((double)(minZ * 16.0f + offsetZ)), sprite.m_118393_((double)(16.0f - (minY * 16.0f + offsetY)))).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                break;
            }
            case EAST: {
                consumer.m_252986_(matrix, maxX, minY, minZ).m_85950_(r, g, b, a).m_7421_(sprite.m_118367_((double)(16.0f - (minZ * 16.0f + offsetZ))), sprite.m_118393_((double)(16.0f - (minY * 16.0f + offsetY)))).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                consumer.m_252986_(matrix, maxX, maxY, minZ).m_85950_(r, g, b, a).m_7421_(sprite.m_118367_((double)(16.0f - (minZ * 16.0f + offsetZ))), sprite.m_118393_((double)(16.0f - (maxY * 16.0f + offsetY)))).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                consumer.m_252986_(matrix, maxX, maxY, maxZ).m_85950_(r, g, b, a).m_7421_(sprite.m_118367_((double)(16.0f - (maxZ * 16.0f + offsetZ))), sprite.m_118393_((double)(16.0f - (maxY * 16.0f + offsetY)))).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                consumer.m_252986_(matrix, maxX, minY, maxZ).m_85950_(r, g, b, a).m_7421_(sprite.m_118367_((double)(16.0f - (maxZ * 16.0f + offsetZ))), sprite.m_118393_((double)(16.0f - (minY * 16.0f + offsetY)))).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
            }
        }
    }
}

