/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.util;

import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.minihud.mixin.IMixinAbstractFurnaceBlockEntity;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public class MiscUtils {
    private static final Random RAND = new Random();
    private static final int[] AXOLOTL_COLORS = new int[]{16762860, 9202768, 16438299, 15267835, 11974142};

    public static long bytesToMb(long bytes) {
        return bytes / 1024L / 1024L;
    }

    public static double intAverage(int[] values) {
        long sum = 0L;
        for (int value : values) {
            sum += (long)value;
        }
        return (double)sum / (double)values.length;
    }

    public static long longAverage(long[] values) {
        long sum = 0L;
        for (long value : values) {
            sum += value;
        }
        return sum / (long)values.length;
    }

    public static boolean canSlimeSpawnAt(int posX, int posZ, long worldSeed) {
        return MiscUtils.canSlimeSpawnInChunk(posX >> 4, posZ >> 4, worldSeed);
    }

    public static boolean canSlimeSpawnInChunk(int chunkX, int chunkZ, long worldSeed) {
        long slimeSeed = 987234911L;
        long rngSeed = worldSeed + (long)(chunkX * chunkX * 4987142) + (long)(chunkX * 5947611) + (long)(chunkZ * chunkZ) * 4392871L + (long)(chunkZ * 389711) ^ slimeSeed;
        RAND.setSeed(rngSeed);
        return RAND.nextInt(10) == 0;
    }

    public static boolean isOverworld(Level world) {
        return world.m_6042_().f_63858_();
    }

    public static boolean isStructureWithinRange(@Nullable BoundingBox bb, BlockPos playerPos, int maxRange) {
        return bb != null && playerPos.m_123341_() >= bb.m_162395_() - maxRange && playerPos.m_123341_() <= bb.m_162399_() + maxRange && playerPos.m_123343_() >= bb.m_162398_() - maxRange && playerPos.m_123343_() <= bb.m_162401_() + maxRange;
    }

    public static boolean isStructureWithinRange(@Nullable IntBoundingBox bb, BlockPos playerPos, int maxRange) {
        return bb != null && playerPos.m_123341_() >= bb.minX - maxRange && playerPos.m_123341_() <= bb.maxX + maxRange && playerPos.m_123343_() >= bb.minZ - maxRange && playerPos.m_123343_() <= bb.maxZ + maxRange;
    }

    public static boolean areBoxesEqual(IntBoundingBox bb1, IntBoundingBox bb2) {
        return bb1.minX == bb2.minX && bb1.minY == bb2.minY && bb1.minZ == bb2.minZ && bb1.maxX == bb2.maxX && bb1.maxY == bb2.maxY && bb1.maxZ == bb2.maxZ;
    }

    public static void addAxolotlTooltip(ItemStack stack, List<Component> lines) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_("Variant", 3)) {
            int variantId = tag.m_128451_("Variant");
            Axolotl.Variant variant = Axolotl.Variant.m_262843_((int)variantId);
            String variantName = variant.m_149253_();
            MutableComponent labelText = Component.m_237115_((String)"minihud.label.axolotl_tooltip.label");
            MutableComponent valueText = Component.m_237110_((String)"minihud.label.axolotl_tooltip.value", (Object[])new Object[]{variantName, variantId});
            if (variantId < AXOLOTL_COLORS.length) {
                valueText.m_6270_(Style.f_131099_.m_178520_(AXOLOTL_COLORS[variantId]));
            }
            lines.add(Math.min(1, lines.size()), (Component)labelText.m_7220_((Component)valueText));
        }
    }

    public static void addBeeTooltip(ItemStack stack, List<Component> lines) {
        CompoundTag stackTag = stack.m_41783_();
        if (stackTag != null && stackTag.m_128425_("BlockEntityTag", 10)) {
            CompoundTag beTag = stackTag.m_128469_("BlockEntityTag");
            ListTag bees = beTag.m_128437_("Bees", 10);
            int count = bees.size();
            int babyCount = 0;
            for (int i = 0; i < count; ++i) {
                CompoundTag beeTag = bees.m_128728_(i);
                CompoundTag entityDataTag = beeTag.m_128469_("EntityData");
                if (entityDataTag.m_128425_("CustomName", 8)) {
                    String beeName = entityDataTag.m_128461_("CustomName");
                    lines.add(Math.min(1, lines.size()), (Component)Component.m_237110_((String)"minihud.label.bee_tooltip.name", (Object[])new Object[]{Component.Serializer.m_130701_((String)beeName).getString()}));
                }
                if (!entityDataTag.m_128425_("Age", 3) || entityDataTag.m_128451_("Age") + beeTag.m_128451_("TickInHive") >= 0) continue;
                ++babyCount;
            }
            MutableComponent text = babyCount > 0 ? Component.m_237110_((String)"minihud.label.bee_tooltip.count_babies", (Object[])new Object[]{String.valueOf(count), String.valueOf(babyCount)}) : Component.m_237110_((String)"minihud.label.bee_tooltip.count", (Object[])new Object[]{String.valueOf(count)});
            lines.add(Math.min(1, lines.size()), (Component)text);
        }
    }

    public static void addHoneyTooltip(ItemStack stack, List<Component> lines) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_("BlockStateTag", 10)) {
            tag = tag.m_128469_("BlockStateTag");
            String honeyLevel = "0";
            if (tag != null && tag.m_128425_("honey_level", 8)) {
                honeyLevel = tag.m_128461_("honey_level");
            } else if (tag != null && tag.m_128425_("honey_level", 3)) {
                honeyLevel = String.valueOf(tag.m_128451_("honey_level"));
            }
            lines.add(Math.min(1, lines.size()), (Component)Component.m_237110_((String)"minihud.label.honey_info.level", (Object[])new Object[]{honeyLevel}));
        }
    }

    public static int getFurnaceXpAmount(AbstractFurnaceBlockEntity be) {
        Object2IntOpenHashMap<ResourceLocation> recipes = ((IMixinAbstractFurnaceBlockEntity)be).minihud_getUsedRecipes();
        Level world = be.m_58904_();
        double xp = 0.0;
        for (Object2IntMap.Entry entry : recipes.object2IntEntrySet()) {
            Object t;
            Optional recipeOpt = world.m_7465_().m_44043_((ResourceLocation)entry.getKey());
            if (!recipeOpt.isPresent() || !((t = recipeOpt.get()) instanceof AbstractCookingRecipe)) continue;
            AbstractCookingRecipe recipe = (AbstractCookingRecipe)t;
            xp += (double)((float)entry.getIntValue() * recipe.m_43750_());
        }
        return (int)xp;
    }
}

