/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.util;

import com.google.common.collect.MapMaker;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import fi.dy.masa.malilib.config.IConfigBoolean;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.mixin.IMixinEntityNavigation;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.client.renderer.debug.NeighborsUpdateRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundCustomPayloadPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;

public class DebugInfoUtils {
    private static boolean neighborUpdateEnabled;
    private static boolean pathfindingEnabled;
    private static int tickCounter;
    private static final Map<Entity, Path> OLD_PATHS;

    public static void sendPacketDebugPath(MinecraftServer server, int entityId, Path path, float maxDistance) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        buffer.writeInt(entityId);
        buffer.writeFloat(maxDistance);
        DebugInfoUtils.writePathToBuffer(buffer, path);
        ClientboundCustomPayloadPacket packet = new ClientboundCustomPayloadPacket(ClientboundCustomPayloadPacket.f_132013_, buffer);
        server.m_6846_().m_11268_((Packet)packet);
    }

    private static void writeBlockPosToBuffer(FriendlyByteBuf buf, BlockPos pos) {
        buf.writeInt(pos.m_123341_());
        buf.writeInt(pos.m_123342_());
        buf.writeInt(pos.m_123343_());
    }

    private static void writePathPointToBuffer(FriendlyByteBuf buf, Node node) {
        buf.writeInt(node.f_77271_);
        buf.writeInt(node.f_77272_);
        buf.writeInt(node.f_77273_);
        buf.writeFloat(node.f_77280_);
        buf.writeFloat(node.f_77281_);
        buf.writeBoolean(node.f_77279_);
        buf.writeInt(node.f_77282_.ordinal());
        buf.writeFloat(node.f_77277_);
    }

    public static FriendlyByteBuf writePathTobuffer(Path path) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        DebugInfoUtils.writePathToBuffer(buffer, path);
        return buffer;
    }

    private static void writePathToBuffer(FriendlyByteBuf buf, Path path) {
        Node destination = path.m_77395_();
        BlockPos target = path.m_77406_();
        if (destination != null) {
            buf.writeBoolean(path.m_77403_());
            buf.writeInt(path.m_77399_());
            buf.writeInt(0);
            DebugInfoUtils.writeBlockPosToBuffer(buf, target);
            Node[] openSet = path.m_77404_();
            Node[] closedSet = path.m_77405_();
            int length = path.m_77398_();
            buf.writeInt(length);
            for (int i = 0; i < length; ++i) {
                Node point = path.m_77375_(i);
                DebugInfoUtils.writePathPointToBuffer(buf, point);
            }
            buf.writeInt(openSet.length);
            for (Node point : openSet) {
                DebugInfoUtils.writePathPointToBuffer(buf, point);
            }
            buf.writeInt(closedSet.length);
            for (Node point : closedSet) {
                DebugInfoUtils.writePathPointToBuffer(buf, point);
            }
        }
    }

    public static void onNeighborUpdate(Level world, BlockPos pos) {
        if (neighborUpdateEnabled && !world.f_46443_) {
            Minecraft mc = Minecraft.m_91087_();
            mc.execute(() -> ((NeighborsUpdateRenderer)mc.f_91064_.f_113418_).m_113596_(world.m_46467_(), pos.m_7949_()));
        }
    }

    public static void onServerTickEnd(MinecraftServer server) {
        Minecraft mc = Minecraft.m_91087_();
        if (pathfindingEnabled && mc.f_91073_ != null && ++tickCounter >= 10) {
            tickCounter = 0;
            ServerLevel world = server.m_129880_(mc.f_91073_.m_46472_());
            if (world != null) {
                EntityTypeTest filter = EntityTypeTest.m_156916_(Mob.class);
                Predicate<Mob> predicate = LivingEntity::m_6084_;
                for (Mob entity : world.m_143280_(filter, predicate)) {
                    boolean isSamepath;
                    PathNavigation navigator = entity.m_21573_();
                    if (navigator == null || !DebugInfoUtils.isAnyPlayerWithinRange(world, (Entity)entity, 64.0)) continue;
                    Path path = navigator.m_26570_();
                    Path old = OLD_PATHS.get(entity);
                    if (path == null) continue;
                    boolean bl = isSamepath = old != null && old.m_77385_(path);
                    if (old != null && isSamepath && old.m_77399_() == path.m_77399_()) continue;
                    int id = entity.m_19879_();
                    float maxDistance = Configs.Generic.DEBUG_RENDERER_PATH_MAX_DIST.getBooleanValue() ? ((IMixinEntityNavigation)navigator).getMaxDistanceToWaypoint() : 0.0f;
                    DebugInfoUtils.sendPacketDebugPath(server, id, path, maxDistance);
                    if (!isSamepath) {
                        FriendlyByteBuf buf = DebugInfoUtils.writePathTobuffer(path);
                        OLD_PATHS.put((Entity)entity, Path.m_77390_((FriendlyByteBuf)buf));
                        continue;
                    }
                    old.m_77393_(path.m_77399_());
                }
            }
        }
    }

    private static boolean isAnyPlayerWithinRange(ServerLevel world, Entity entity, double range) {
        List players = world.m_6907_();
        double squaredRange = range * range;
        for (Player player : players) {
            double distSq = player.m_20275_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            if (!(range < 0.0) && !(distSq < squaredRange)) continue;
            return true;
        }
        return false;
    }

    public static void toggleDebugRenderer(IConfigBoolean config) {
        if (config == RendererToggle.DEBUG_NEIGHBOR_UPDATES) {
            neighborUpdateEnabled = config.getBooleanValue();
        } else if (config == RendererToggle.DEBUG_PATH_FINDING) {
            pathfindingEnabled = config.getBooleanValue();
        } else if (config == RendererToggle.DEBUG_CHUNK_BORDER) {
            boolean enabled = Minecraft.m_91087_().f_91064_.m_113506_();
            DebugInfoUtils.debugWarn(enabled ? "debug.chunk_boundaries.on" : "debug.chunk_boundaries.off", new Object[0]);
        } else if (config == RendererToggle.DEBUG_CHUNK_INFO) {
            Minecraft.m_91087_().f_90978_ = config.getBooleanValue();
        } else if (config == RendererToggle.DEBUG_CHUNK_OCCLUSION) {
            Minecraft.m_91087_().f_90979_ = config.getBooleanValue();
        }
    }

    private static void debugWarn(String key, Object ... args) {
        Minecraft.m_91087_().f_91065_.m_93076_().m_93785_((Component)Component.m_237119_().m_7220_((Component)Component.m_237115_((String)"debug.prefix").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD})).m_130946_(" ").m_7220_((Component)Component.m_237110_((String)key, (Object[])args)));
    }

    public static void renderVanillaDebug(PoseStack matrixStack, MultiBufferSource.BufferSource vtx, double cameraX, double cameraY, double cameraZ) {
        DebugRenderer renderer = Minecraft.m_91087_().f_91064_;
        if (RendererToggle.DEBUG_COLLISION_BOXES.getBooleanValue()) {
            renderer.f_113417_.m_7790_(matrixStack, (MultiBufferSource)vtx, cameraX, cameraY, cameraZ);
        }
        if (RendererToggle.DEBUG_NEIGHBOR_UPDATES.getBooleanValue()) {
            renderer.f_113418_.m_7790_(matrixStack, (MultiBufferSource)vtx, cameraX, cameraY, cameraZ);
        }
        if (RendererToggle.DEBUG_PATH_FINDING.getBooleanValue()) {
            renderer.f_113413_.m_7790_(matrixStack, (MultiBufferSource)vtx, cameraX, cameraY, cameraZ);
        }
        if (RendererToggle.DEBUG_SOLID_FACES.getBooleanValue()) {
            RenderSystem.enableDepthTest();
            renderer.f_113423_.m_7790_(matrixStack, (MultiBufferSource)vtx, cameraX, cameraY, cameraZ);
        }
        if (RendererToggle.DEBUG_WATER.getBooleanValue()) {
            renderer.f_113414_.m_7790_(matrixStack, (MultiBufferSource)vtx, cameraX, cameraY, cameraZ);
        }
    }

    static {
        OLD_PATHS = new MapMaker().weakKeys().weakValues().makeMap();
    }
}

