/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.util;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Queues;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.malilib.network.ClientPacketChannelHandler;
import fi.dy.masa.malilib.network.IPluginChannelHandler;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.PositionUtils;
import fi.dy.masa.minihud.MiniHUD;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.data.MobCapDataHandler;
import fi.dy.masa.minihud.network.StructurePacketHandlerCarpet;
import fi.dy.masa.minihud.network.StructurePacketHandlerServux;
import fi.dy.masa.minihud.renderer.OverlayRendererBeaconRange;
import fi.dy.masa.minihud.renderer.OverlayRendererBiomeBorders;
import fi.dy.masa.minihud.renderer.OverlayRendererConduitRange;
import fi.dy.masa.minihud.renderer.OverlayRendererLightLevel;
import fi.dy.masa.minihud.renderer.OverlayRendererSpawnableColumnHeights;
import fi.dy.masa.minihud.renderer.shapes.ShapeManager;
import fi.dy.masa.minihud.renderer.worker.ChunkTask;
import fi.dy.masa.minihud.renderer.worker.ThreadWorker;
import fi.dy.masa.minihud.util.MiscUtils;
import fi.dy.masa.minihud.util.StructureData;
import fi.dy.masa.minihud.util.StructureType;
import java.util.List;
import java.util.Map;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.Vec3;

public class DataStorage {
    private static final ThreadFactory THREAD_FACTORY = new ThreadFactoryBuilder().setNameFormat("MiniHUD Worker Thread %d").setDaemon(true).build();
    private static final Pattern PATTERN_CARPET_TPS = Pattern.compile("TPS: (?<tps>[0-9]+[\\.,][0-9]) MSPT: (?<mspt>[0-9]+[\\.,][0-9])");
    public static final DataStorage INSTANCE = new DataStorage();
    public static final int CARPET_ID_BOUNDINGBOX_MARKERS = 3;
    public static final int CARPET_ID_LARGE_BOUNDINGBOX_MARKERS_START = 7;
    public static final int CARPET_ID_LARGE_BOUNDINGBOX_MARKERS = 8;
    private final MobCapDataHandler mobCapData = new MobCapDataHandler();
    private boolean worldSeedValid;
    private boolean serverTPSValid;
    private boolean hasSyncedTime;
    private boolean carpetServer;
    private boolean servuxServer;
    private boolean worldSpawnValid;
    private boolean hasStructureDataFromServer;
    private boolean structureRendererNeedsUpdate;
    private boolean structuresNeedUpdating;
    private boolean shouldRegisterStructureChannel;
    private int structureDataTimeout = 600;
    private long worldSeed;
    private long lastServerTick;
    private long lastServerTimeUpdate;
    private BlockPos lastStructureUpdatePos;
    private double serverTPS;
    private double serverMSPT;
    private BlockPos worldSpawn = BlockPos.f_121853_;
    private Vec3 distanceReferencePoint = Vec3.f_82478_;
    private final int[] blockBreakCounter = new int[100];
    private final ArrayListMultimap<StructureType, StructureData> structures = ArrayListMultimap.create();
    private final Minecraft mc = Minecraft.m_91087_();
    private final PriorityBlockingQueue<ChunkTask> taskQueue = Queues.newPriorityBlockingQueue();
    private final Thread workerThread;
    private final ThreadWorker worker = new ThreadWorker();

    private DataStorage() {
        this.workerThread = THREAD_FACTORY.newThread(this.worker);
        this.workerThread.start();
    }

    public static DataStorage getInstance() {
        return INSTANCE;
    }

    public MobCapDataHandler getMobCapData() {
        return this.mobCapData;
    }

    public void reset(boolean isLogout) {
        if (isLogout) {
            MiniHUD.printDebug("DataStorage#reset() - log-out", new Object[0]);
        } else {
            MiniHUD.printDebug("DataStorage#reset() - dimension change or log-in", new Object[0]);
        }
        this.mobCapData.clear();
        this.serverTPSValid = false;
        this.hasSyncedTime = false;
        this.carpetServer = false;
        this.worldSpawnValid = false;
        this.structuresNeedUpdating = true;
        this.hasStructureDataFromServer = false;
        this.structureRendererNeedsUpdate = true;
        this.lastStructureUpdatePos = null;
        this.structures.clear();
        this.worldSpawn = BlockPos.f_121853_;
        this.clearTasks();
        StructurePacketHandlerCarpet.INSTANCE.reset();
        StructurePacketHandlerServux.INSTANCE.reset();
        ShapeManager.INSTANCE.clear();
        OverlayRendererBeaconRange.INSTANCE.clear();
        OverlayRendererConduitRange.INSTANCE.clear();
        OverlayRendererBiomeBorders.INSTANCE.clear();
        OverlayRendererLightLevel.reset();
        if (isLogout || !Configs.Generic.DONT_RESET_SEED_ON_DIMENSION_CHANGE.getBooleanValue()) {
            this.worldSeedValid = false;
            this.worldSeed = 0L;
        }
        if (isLogout) {
            this.servuxServer = false;
            this.structureDataTimeout = 600;
        }
    }

    public void clearTasks() {
        this.taskQueue.clear();
    }

    public ChunkTask getNextTask() throws InterruptedException {
        return this.taskQueue.take();
    }

    public void addTask(Runnable task, ChunkPos pos, Vec3i playerPos) {
        if (this.taskQueue.size() < 64000) {
            this.taskQueue.offer(new ChunkTask(task, pos, playerPos));
        }
    }

    public void setIsServuxServer() {
        MiniHUD.printDebug("DataStorage#setIsServuxServer()", new Object[0]);
        this.servuxServer = true;
        ClientPacketChannelHandler.getInstance().unregisterClientChannelHandler((IPluginChannelHandler)StructurePacketHandlerCarpet.INSTANCE);
    }

    public void onWorldJoin() {
        MiniHUD.printDebug("DataStorage#onWorldJoin()", new Object[0]);
        OverlayRendererBeaconRange.INSTANCE.setNeedsUpdate();
        OverlayRendererConduitRange.INSTANCE.setNeedsUpdate();
        if (!this.mc.m_91091_() && RendererToggle.OVERLAY_STRUCTURE_MAIN_TOGGLE.getBooleanValue()) {
            this.shouldRegisterStructureChannel = true;
        }
    }

    public void setWorldSeed(long seed) {
        this.worldSeed = seed;
        this.worldSeedValid = true;
    }

    public void setWorldSpawn(BlockPos spawn) {
        this.worldSpawn = spawn;
        this.worldSpawnValid = true;
    }

    public void setWorldSpawnIfUnknown(BlockPos spawn) {
        if (!this.worldSpawnValid) {
            this.setWorldSpawn(spawn);
        }
    }

    public boolean isWorldSeedKnown(Level world) {
        if (this.worldSeedValid) {
            return true;
        }
        if (this.mc.m_91091_()) {
            IntegratedServer server = this.mc.m_91092_();
            ServerLevel worldTmp = server.m_129880_(world.m_46472_());
            return worldTmp != null;
        }
        return false;
    }

    public boolean hasStoredWorldSeed() {
        return this.worldSeedValid;
    }

    public long getWorldSeed(Level world) {
        IntegratedServer server;
        ServerLevel worldTmp;
        if (!this.worldSeedValid && this.mc.m_91091_() && (worldTmp = (server = this.mc.m_91092_()).m_129880_(world.m_46472_())) != null) {
            this.setWorldSeed(worldTmp.m_7328_());
        }
        return this.worldSeed;
    }

    public boolean isWorldSpawnKnown() {
        return this.worldSpawnValid;
    }

    public BlockPos getWorldSpawn() {
        return this.worldSpawn;
    }

    public boolean hasTPSData() {
        return this.serverTPSValid;
    }

    public boolean isCarpetServer() {
        return this.carpetServer;
    }

    public double getServerTPS() {
        return this.serverTPS;
    }

    public double getServerMSPT() {
        return this.serverMSPT;
    }

    public boolean structureRendererNeedsUpdate() {
        return this.structureRendererNeedsUpdate;
    }

    public void setStructuresNeedUpdating() {
        this.structuresNeedUpdating = true;
    }

    public void setStructureRendererNeedsUpdate() {
        this.structureRendererNeedsUpdate = true;
    }

    public Vec3 getDistanceReferencePoint() {
        return this.distanceReferencePoint;
    }

    public void setDistanceReferencePoint(Vec3 pos) {
        this.distanceReferencePoint = pos;
        String str = String.format("x: %.2f, y: %.2f, z: %.2f", pos.f_82479_, pos.f_82480_, pos.f_82481_);
        InfoUtils.printActionbarMessage((String)"minihud.message.distance_reference_point_set", (Object[])new Object[]{str});
    }

    public void markChunkForHeightmapCheck(int chunkX, int chunkZ) {
        Entity entity = Minecraft.m_91087_().m_91288_();
        if (entity != null) {
            Vec3 pos = entity.m_20182_();
            if (Math.abs(pos.f_82479_ - (double)(chunkX << 4) - 8.0) <= 48.0 || Math.abs(pos.f_82481_ - (double)(chunkZ << 4) - 8.0) <= 48.0) {
                OverlayRendererSpawnableColumnHeights.markChunkChanged(chunkX, chunkZ);
                OverlayRendererLightLevel.setNeedsUpdate();
            }
        }
    }

    public void onClientTickPre(Minecraft mc) {
        if (mc.f_91073_ != null) {
            int tick = (int)(mc.f_91073_.m_46467_() % (long)this.blockBreakCounter.length);
            this.blockBreakCounter[tick] = 0;
        }
    }

    public void onPlayerBlockBreak(Minecraft mc) {
        if (mc.f_91073_ != null) {
            int tick;
            int n = tick = (int)(mc.f_91073_.m_46467_() % (long)this.blockBreakCounter.length);
            this.blockBreakCounter[n] = this.blockBreakCounter[n] + 1;
        }
    }

    public double getBlockBreakingSpeed() {
        return MiscUtils.intAverage(this.blockBreakCounter) * 20.0;
    }

    public boolean onSendChatMessage(String message) {
        String[] parts = message.split(" ");
        if (parts.length > 0 && (parts[0].equals("minihud-seed") || parts[0].equals("/minihud-seed"))) {
            if (parts.length == 2) {
                try {
                    this.setWorldSeed(Long.parseLong(parts[1]));
                    InfoUtils.printActionbarMessage((String)"minihud.message.seed_set", (Object[])new Object[]{this.worldSeed});
                }
                catch (NumberFormatException e) {
                    InfoUtils.printActionbarMessage((String)"minihud.message.error.invalid_seed", (Object[])new Object[0]);
                }
            } else if (parts.length == 1) {
                if (this.worldSeedValid) {
                    InfoUtils.printActionbarMessage((String)"minihud.message.seed_is", (Object[])new Object[]{this.worldSeed});
                } else {
                    InfoUtils.printActionbarMessage((String)"minihud.message.no_seed", (Object[])new Object[0]);
                }
            }
            return true;
        }
        return false;
    }

    public void onChatMessage(Component message) {
        MutableComponent mutableText;
        ComponentContents componentContents;
        if (message instanceof MutableComponent && (componentContents = (mutableText = (MutableComponent)message).m_214077_()) instanceof TranslatableContents) {
            TranslatableContents text = (TranslatableContents)componentContents;
            if ("commands.seed.success".equals(text.m_237508_()) && text.m_237523_().length == 1) {
                try {
                    MutableComponent m = (MutableComponent)text.m_237523_()[0];
                    TranslatableContents t = (TranslatableContents)m.m_214077_();
                    LiteralContents l = (LiteralContents)((MutableComponent)t.m_237523_()[0]).m_214077_();
                    String str = l.f_237368_();
                    this.setWorldSeed(Long.parseLong(str));
                    MiniHUD.logger.info("Received world seed from the vanilla /seed command: {}", (Object)this.worldSeed);
                    InfoUtils.printActionbarMessage((String)"minihud.message.seed_set", (Object[])new Object[]{this.worldSeed});
                }
                catch (Exception e) {
                    MiniHUD.logger.warn("Failed to read the world seed from '{}'", text.m_237523_()[0]);
                }
            } else if ("jed.commands.seed.success".equals(text.m_237508_())) {
                try {
                    this.setWorldSeed(Long.parseLong(text.m_237523_()[1].toString()));
                    MiniHUD.logger.info("Received world seed from the JED '/jed seed' command: {}", (Object)this.worldSeed);
                    InfoUtils.printActionbarMessage((String)"minihud.message.seed_set", (Object[])new Object[]{this.worldSeed});
                }
                catch (Exception e) {
                    MiniHUD.logger.warn("Failed to read the world seed from '{}'", text.m_237523_()[1], (Object)e);
                }
            } else if ("commands.setworldspawn.success".equals(text.m_237508_()) && text.m_237523_().length == 3) {
                try {
                    Object[] o = text.m_237523_();
                    int x = Integer.parseInt(o[0].toString());
                    int y = Integer.parseInt(o[1].toString());
                    int z = Integer.parseInt(o[2].toString());
                    this.setWorldSpawn(new BlockPos(x, y, z));
                    String spawnStr = String.format("x: %d, y: %d, z: %d", this.worldSpawn.m_123341_(), this.worldSpawn.m_123342_(), this.worldSpawn.m_123343_());
                    MiniHUD.logger.info("Received world spawn from the vanilla /setworldspawn command: {}", (Object)spawnStr);
                    InfoUtils.printActionbarMessage((String)"minihud.message.spawn_set", (Object[])new Object[]{spawnStr});
                }
                catch (Exception e) {
                    MiniHUD.logger.warn("Failed to read the world spawn point from '{}'", (Object)text.m_237523_(), (Object)e);
                }
            }
        }
    }

    public void onServerTimeUpdate(long totalWorldTime) {
        if (!this.carpetServer && !this.mc.m_91090_()) {
            long elapsedTicks;
            long currentTime = System.nanoTime();
            if (this.hasSyncedTime && (elapsedTicks = totalWorldTime - this.lastServerTick) > 0L) {
                this.serverMSPT = (double)(currentTime - this.lastServerTimeUpdate) / (double)elapsedTicks / 1000000.0;
                this.serverTPS = this.serverMSPT <= 50.0 ? 20.0 : 1000.0 / this.serverMSPT;
                this.serverTPSValid = true;
            }
            this.lastServerTick = totalWorldTime;
            this.lastServerTimeUpdate = currentTime;
            this.hasSyncedTime = true;
        }
    }

    public void updateIntegratedServerTPS() {
        if (this.mc != null && this.mc.f_91074_ != null && this.mc.m_91092_() != null) {
            this.serverMSPT = (double)MiscUtils.longAverage(this.mc.m_91092_().f_129748_) / 1000000.0;
            this.serverTPS = this.serverMSPT <= 50.0 ? 20.0 : 1000.0 / this.serverMSPT;
            this.serverTPSValid = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayListMultimap<StructureType, StructureData> getCopyOfStructureData() {
        ArrayListMultimap copy = ArrayListMultimap.create();
        if (!RendererToggle.OVERLAY_STRUCTURE_MAIN_TOGGLE.getBooleanValue()) {
            return copy;
        }
        ArrayListMultimap<StructureType, StructureData> arrayListMultimap = this.structures;
        synchronized (arrayListMultimap) {
            for (StructureType type : StructureType.VALUES) {
                List values = this.structures.get((Object)type);
                if (values.isEmpty()) continue;
                copy.putAll((Object)type, (Iterable)values);
            }
            this.structureRendererNeedsUpdate = false;
        }
        return copy;
    }

    public void updateStructureData() {
        long currentTime;
        if (this.mc != null && this.mc.f_91073_ != null && this.mc.f_91074_ != null && (currentTime = this.mc.f_91073_.m_46467_()) % 20L == 0L) {
            if (this.mc.m_91091_()) {
                BlockPos playerPos;
                if (RendererToggle.OVERLAY_STRUCTURE_MAIN_TOGGLE.getBooleanValue() && this.structuresNeedUpdating(playerPos = PositionUtils.getEntityBlockPos((Entity)this.mc.f_91074_), 32)) {
                    this.updateStructureDataFromIntegratedServer(playerPos);
                }
            } else if (this.hasStructureDataFromServer) {
                this.removeExpiredStructures(currentTime, this.structureDataTimeout);
            } else if (this.shouldRegisterStructureChannel && this.mc.m_91403_() != null) {
                if (RendererToggle.OVERLAY_STRUCTURE_MAIN_TOGGLE.getBooleanValue()) {
                    MiniHUD.printDebug("DataStorage#updateStructureData(): Unregister channels", new Object[0]);
                    ClientPacketChannelHandler.getInstance().unregisterClientChannelHandler((IPluginChannelHandler)StructurePacketHandlerCarpet.INSTANCE);
                    ClientPacketChannelHandler.getInstance().unregisterClientChannelHandler((IPluginChannelHandler)StructurePacketHandlerServux.INSTANCE);
                    this.registerStructureChannel();
                }
                this.shouldRegisterStructureChannel = false;
            }
        }
    }

    public void registerStructureChannel() {
        MiniHUD.printDebug("DataStorage#registerStructureChannel(): Servux", new Object[0]);
        ClientPacketChannelHandler.getInstance().registerClientChannelHandler((IPluginChannelHandler)StructurePacketHandlerServux.INSTANCE);
        if (!this.servuxServer) {
            MiniHUD.printDebug("DataStorage#registerStructureChannel(): Carpet", new Object[0]);
            ClientPacketChannelHandler.getInstance().registerClientChannelHandler((IPluginChannelHandler)StructurePacketHandlerCarpet.INSTANCE);
        }
    }

    private boolean structuresNeedUpdating(BlockPos playerPos, int hysteresis) {
        return this.structuresNeedUpdating || this.lastStructureUpdatePos == null || Math.abs(playerPos.m_123341_() - this.lastStructureUpdatePos.m_123341_()) >= hysteresis || Math.abs(playerPos.m_123342_() - this.lastStructureUpdatePos.m_123342_()) >= hysteresis || Math.abs(playerPos.m_123343_() - this.lastStructureUpdatePos.m_123343_()) >= hysteresis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStructureDataFromIntegratedServer(BlockPos playerPos) {
        ResourceKey worldId = this.mc.f_91074_.m_20193_().m_46472_();
        ServerLevel world = this.mc.m_91092_().m_129880_(worldId);
        if (world != null) {
            IntegratedServer server = this.mc.m_91092_();
            int maxChunkRange = (Integer)this.mc.f_91066_.m_231984_().m_231551_() + 2;
            server.m_6937_((Runnable)new TickTask(server.m_129921_(), () -> {
                ArrayListMultimap<StructureType, StructureData> arrayListMultimap = this.structures;
                synchronized (arrayListMultimap) {
                    this.addStructureDataFromGenerator(world, playerPos, maxChunkRange);
                }
            }));
        } else {
            ArrayListMultimap<StructureType, StructureData> arrayListMultimap = this.structures;
            synchronized (arrayListMultimap) {
                this.structures.clear();
            }
        }
        this.lastStructureUpdatePos = playerPos;
        this.structuresNeedUpdating = false;
    }

    public void addOrUpdateStructuresFromServer(ListTag structures, int timeout, boolean isServux) {
        MiniHUD.printDebug("DataStorage#addOrUpdateStructuresFromServer(): start", new Object[0]);
        if (this.servuxServer && !isServux) {
            return;
        }
        if (structures.m_7264_() == 10) {
            MiniHUD.printDebug("DataStorage#addOrUpdateStructuresFromServer(): count: " + structures.size(), new Object[0]);
            this.structureDataTimeout = timeout + 200;
            long currentTime = this.mc.f_91073_.m_46467_();
            int count = structures.size();
            this.removeExpiredStructures(currentTime, this.structureDataTimeout);
            for (int i = 0; i < count; ++i) {
                CompoundTag tag = structures.m_128728_(i);
                StructureData data = StructureData.fromStructureStartTag(tag, currentTime);
                if (data == null) continue;
                if (this.structures.containsEntry((Object)data.getStructureType(), (Object)data)) {
                    this.structures.remove((Object)data.getStructureType(), (Object)data);
                }
                this.structures.put((Object)data.getStructureType(), (Object)data);
            }
            this.structureRendererNeedsUpdate = true;
            this.hasStructureDataFromServer = true;
        }
    }

    private void removeExpiredStructures(long currentTime, int timeout) {
        long maxAge = timeout;
        this.structures.values().removeIf(data -> currentTime > data.getRefreshTime() + maxAge);
    }

    private void addStructureDataFromGenerator(ServerLevel world, BlockPos playerPos, int maxChunkRange) {
        this.structures.clear();
        int minCX = (playerPos.m_123341_() >> 4) - maxChunkRange;
        int minCZ = (playerPos.m_123343_() >> 4) - maxChunkRange;
        int maxCX = (playerPos.m_123341_() >> 4) + maxChunkRange;
        int maxCZ = (playerPos.m_123343_() >> 4) + maxChunkRange;
        for (int cz = minCZ; cz <= maxCZ; ++cz) {
            for (int cx = minCX; cx <= maxCX; ++cx) {
                ChunkAccess chunk = world.m_6522_(cx, cz, ChunkStatus.f_62326_, false);
                if (chunk == null) continue;
                for (Map.Entry entry : chunk.m_6633_().entrySet()) {
                    Structure structure = (Structure)entry.getKey();
                    StructureStart start = (StructureStart)entry.getValue();
                    ResourceLocation id = world.m_9598_().m_175515_(Registries.f_256944_).m_7981_((Object)structure);
                    StructureType type = StructureType.fromStructureId(id != null ? id.toString() : "?");
                    if (!type.isEnabled() || !start.m_73603_() || !MiscUtils.isStructureWithinRange(start.m_73601_(), playerPos, maxChunkRange << 4)) continue;
                    this.structures.put((Object)type, (Object)StructureData.fromStructureStart(type, start));
                }
            }
        }
        this.structureRendererNeedsUpdate = true;
    }

    public void handleCarpetServerTPSData(Component textComponent) {
        if (!textComponent.getString().isEmpty()) {
            String[] lines;
            String text = ChatFormatting.m_126649_((String)textComponent.getString());
            for (String line : lines = text.split("\n")) {
                Matcher matcher = PATTERN_CARPET_TPS.matcher(line);
                if (!matcher.matches()) continue;
                try {
                    this.serverTPS = Double.parseDouble(matcher.group("tps"));
                    this.serverMSPT = Double.parseDouble(matcher.group("mspt"));
                    this.serverTPSValid = true;
                    this.carpetServer = true;
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        obj.add("distance_pos", (JsonElement)JsonUtils.vec3dToJson((Vec3)this.distanceReferencePoint));
        if (this.worldSeedValid) {
            obj.add("seed", (JsonElement)new JsonPrimitive((Number)this.worldSeed));
        }
        return obj;
    }

    public void fromJson(JsonObject obj) {
        Vec3 pos = JsonUtils.vec3dFromJson((JsonObject)obj, (String)"distance_pos");
        this.distanceReferencePoint = pos != null ? pos : Vec3.f_82478_;
        if (JsonUtils.hasLong((JsonObject)obj, (String)"seed")) {
            this.worldSeed = JsonUtils.getLong((JsonObject)obj, (String)"seed");
            this.worldSeedValid = true;
        }
    }
}

