/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer.shapes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.Quadrant;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.renderer.shapes.ShapeSphereBlocky;
import fi.dy.masa.minihud.renderer.shapes.ShapeType;
import fi.dy.masa.minihud.util.shape.SphereUtils;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class ShapeSpawnSphere
extends ShapeSphereBlocky {
    protected Vec3[] quadrantCenters;
    protected boolean useCornerQuadrants;
    protected double margin = 0.0;

    public ShapeSpawnSphere() {
        this(ShapeType.ADJUSTABLE_SPAWN_SPHERE, Configs.Colors.SHAPE_ADJUSTABLE_SPAWN_SPHERE.getColor(), 24.0);
    }

    public ShapeSpawnSphere(ShapeType shape, Color4f color, double radius) {
        super(shape, color, radius);
        this.updateQuadrantPoints();
    }

    public boolean getUseCornerQuadrants() {
        return this.useCornerQuadrants;
    }

    public void toggleUseCornerQuadrants() {
        this.useCornerQuadrants = !this.useCornerQuadrants;
        this.setNeedsUpdate();
    }

    @Override
    protected void updateEffectiveCenter() {
        super.updateEffectiveCenter();
        this.updateQuadrantPoints();
    }

    private void updateQuadrantPoints() {
        Vec3 center = this.getEffectiveCenter();
        if (this.quadrantCenters == null) {
            this.quadrantCenters = new Vec3[4];
        }
        this.quadrantCenters[Quadrant.NORTH_WEST.ordinal()] = new Vec3(center.f_82479_ - this.margin, center.f_82480_, center.f_82481_ - this.margin);
        this.quadrantCenters[Quadrant.NORTH_EAST.ordinal()] = new Vec3(center.f_82479_ + this.margin, center.f_82480_, center.f_82481_ - this.margin);
        this.quadrantCenters[Quadrant.SOUTH_WEST.ordinal()] = new Vec3(center.f_82479_ - this.margin, center.f_82480_, center.f_82481_ + this.margin);
        this.quadrantCenters[Quadrant.SOUTH_EAST.ordinal()] = new Vec3(center.f_82479_ + this.margin, center.f_82480_, center.f_82481_ + this.margin);
        this.setNeedsUpdate();
    }

    public double getMargin() {
        return this.margin;
    }

    public void setMargin(double margin) {
        this.margin = margin;
        this.updateQuadrantPoints();
    }

    @Override
    protected double getTotalRadius() {
        return this.getRadius() + this.margin;
    }

    @Override
    public List<String> getWidgetHoverLines() {
        List<String> lines = super.getWidgetHoverLines();
        lines.add(2, StringUtils.translate((String)"minihud.gui.hover.shape.margin_value", (Object[])new Object[]{ShapeSpawnSphere.d2(this.margin)}));
        return lines;
    }

    @Override
    public JsonObject toJson() {
        JsonObject obj = super.toJson();
        obj.add("margin", (JsonElement)new JsonPrimitive((Number)this.margin));
        return obj;
    }

    @Override
    public void fromJson(JsonObject obj) {
        super.fromJson(obj);
        this.setMargin(JsonUtils.getDouble((JsonObject)obj, (String)"margin"));
    }

    @Override
    protected SphereUtils.RingPositionTest getPositionTest() {
        return this::isPositionOnOrInsideRing;
    }

    protected boolean isPositionOnOrInsideRing(int x, int y, int z, Direction outSide) {
        double centerZ;
        double distZ;
        double centerY;
        double distY;
        Vec3 effectiveCenter = this.getEffectiveCenter();
        double maxDistSq = this.getSquaredRadius();
        double posX = (double)x + 0.5;
        double posY = y + 1;
        double posZ = (double)z + 0.5;
        if (this.useCornerQuadrants) {
            Vec3 quadrantCenter = this.quadrantCenters[Quadrant.getQuadrant((int)x, (int)z, (Vec3)effectiveCenter).ordinal()];
            return quadrantCenter.m_82531_(posX, posY, posZ) < maxDistSq || effectiveCenter.m_82531_(posX, posY, posZ) < maxDistSq;
        }
        double margin = this.margin;
        double centerX = Mth.m_14008_((double)posX, (double)(effectiveCenter.f_82479_ - margin), (double)(effectiveCenter.f_82479_ + margin));
        double distX = posX - centerX;
        double distSq = distX * distX + (distY = posY - (centerY = effectiveCenter.f_82480_)) * distY + (distZ = posZ - (centerZ = Mth.m_14008_((double)posZ, (double)(effectiveCenter.f_82481_ - margin), (double)(effectiveCenter.f_82481_ + margin)))) * distZ;
        return distSq < maxDistSq;
    }
}

