/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer.shapes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import fi.dy.masa.malilib.util.BlockSnap;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.minihud.renderer.RenderObjectBase;
import fi.dy.masa.minihud.renderer.shapes.ShapeBase;
import fi.dy.masa.minihud.renderer.shapes.ShapeBox;
import fi.dy.masa.minihud.renderer.shapes.ShapeType;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public abstract class ShapeBlocky
extends ShapeBase {
    private BlockSnap snap = BlockSnap.CENTER;
    protected AABB renderPerimeter = ShapeBox.DEFAULT_BOX;
    private boolean combineQuads;

    public ShapeBlocky(ShapeType type, Color4f color) {
        super(type, color);
    }

    public BlockSnap getBlockSnap() {
        return this.snap;
    }

    public void setBlockSnap(BlockSnap snap) {
        this.snap = snap;
    }

    public boolean getCombineQuads() {
        return this.combineQuads;
    }

    public boolean toggleCombineQuads() {
        this.combineQuads = !this.combineQuads;
        this.setNeedsUpdate();
        return this.combineQuads;
    }

    protected void setRenderPerimeter(Vec3 center, double range) {
        this.renderPerimeter = new AABB(center.f_82479_ - range, center.f_82480_ - range, center.f_82481_ - range, center.f_82479_ + range, center.f_82480_ + range, center.f_82481_ + range);
    }

    protected Vec3 getBlockSnappedPosition(Vec3 pos) {
        BlockSnap snap = this.getBlockSnap();
        if (snap == BlockSnap.CENTER) {
            return new Vec3(Math.floor(pos.f_82479_) + 0.5, Math.floor(pos.f_82480_), Math.floor(pos.f_82481_) + 0.5);
        }
        if (snap == BlockSnap.CORNER) {
            return new Vec3(Math.floor(pos.f_82479_), Math.floor(pos.f_82480_), Math.floor(pos.f_82481_));
        }
        return pos;
    }

    @Override
    public boolean shouldRender(Minecraft mc) {
        Entity entity = EntityUtils.getCameraEntity();
        return super.shouldRender(mc) && entity != null && this.renderPerimeter.m_82390_(entity.m_20182_());
    }

    @Override
    public void allocateGlResources() {
        this.allocateBuffer(VertexFormat.Mode.QUADS);
    }

    @Override
    public void draw(PoseStack matrixStack, Matrix4f projMatrix) {
        this.preRender();
        ((RenderObjectBase)this.renderObjects.get(0)).draw(matrixStack, projMatrix);
        RenderSystem.polygonMode((int)1032, (int)6913);
        RenderSystem.disableBlend();
        ((RenderObjectBase)this.renderObjects.get(0)).draw(matrixStack, projMatrix);
        RenderSystem.polygonMode((int)1032, (int)6914);
        RenderSystem.enableBlend();
        this.postRender();
    }

    @Override
    public List<String> getWidgetHoverLines() {
        List<String> lines = super.getWidgetHoverLines();
        BlockSnap snap = this.getBlockSnap();
        lines.add(StringUtils.translate((String)"minihud.gui.hover.shape.block_snap", (Object[])new Object[]{snap.getDisplayName()}));
        return lines;
    }

    @Override
    public JsonObject toJson() {
        JsonObject obj = super.toJson();
        obj.add("snap", (JsonElement)new JsonPrimitive(this.snap.getStringValue()));
        obj.add("combine_quads", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.combineQuads)));
        return obj;
    }

    @Override
    public void fromJson(JsonObject obj) {
        super.fromJson(obj);
        if (JsonUtils.hasString((JsonObject)obj, (String)"snap")) {
            this.snap = BlockSnap.fromStringStatic((String)JsonUtils.getString((JsonObject)obj, (String)"snap"));
        }
        this.combineQuads = JsonUtils.getBooleanOrDefault((JsonObject)obj, (String)"combine_quads", (boolean)false);
    }

    protected Consumer<BlockPos.MutableBlockPos> getPositionCollector(LongOpenHashSet positionsOut) {
        IntBoundingBox box = this.layerRange.getExpandedBox((Level)this.mc.f_91073_, 0);
        Consumer<BlockPos.MutableBlockPos> positionCollector = pos -> {
            if (box.containsPos((Vec3i)pos)) {
                positionsOut.add(pos.m_121878_());
            }
        };
        return positionCollector;
    }
}

