/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import fi.dy.masa.minihud.renderer.RenderObjectBase;
import java.util.function.Supplier;
import net.minecraft.client.renderer.ShaderInstance;
import org.joml.Matrix4f;

public class RenderObjectVbo
extends RenderObjectBase {
    protected final VertexBuffer vertexBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
    protected final VertexFormat format;
    protected final boolean hasTexture;

    public RenderObjectVbo(VertexFormat.Mode glMode, VertexFormat format, Supplier<ShaderInstance> shader) {
        super(glMode, shader);
        this.format = format;
        boolean hasTexture = false;
        for (VertexFormatElement el : this.format.m_86023_()) {
            if (el.m_86048_() != VertexFormatElement.Usage.UV) continue;
            hasTexture = true;
            break;
        }
        this.hasTexture = hasTexture;
    }

    @Override
    public void uploadData(BufferBuilder buffer) {
        BufferBuilder.RenderedBuffer builtBuffer = buffer.m_231175_();
        this.vertexBuffer.m_85921_();
        this.vertexBuffer.m_231221_(builtBuffer);
        VertexBuffer.m_85931_();
    }

    @Override
    public void draw(PoseStack matrixStack, Matrix4f projMatrix) {
        RenderSystem.setShader(this.getShader());
        this.vertexBuffer.m_85921_();
        this.vertexBuffer.m_253207_(matrixStack.m_85850_().m_252922_(), projMatrix, this.getShader().get());
        VertexBuffer.m_85931_();
    }

    @Override
    public void deleteGlResources() {
        this.vertexBuffer.close();
    }
}

