/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.renderer.RenderObjectBase;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class OverlayRendererSpawnableColumnHeights
extends OverlayRendererBase {
    private static final Set<Long> DIRTY_CHUNKS = new HashSet<Long>();
    private final BlockPos.MutableBlockPos posMutable = new BlockPos.MutableBlockPos();
    private long lastCheckTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markChunkChanged(int cx, int cz) {
        if (RendererToggle.OVERLAY_SPAWNABLE_COLUMN_HEIGHTS.getBooleanValue()) {
            Set<Long> set = DIRTY_CHUNKS;
            synchronized (set) {
                DIRTY_CHUNKS.add(ChunkPos.m_45589_((int)cx, (int)cz));
            }
        }
    }

    @Override
    public boolean shouldRender(Minecraft mc) {
        return RendererToggle.OVERLAY_SPAWNABLE_COLUMN_HEIGHTS.getBooleanValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean needsUpdate(Entity entity, Minecraft mc) {
        int ex = (int)Math.floor(entity.m_20185_());
        int ez = (int)Math.floor(entity.m_20189_());
        int lx = this.lastUpdatePos.m_123341_();
        int lz = this.lastUpdatePos.m_123343_();
        if (Math.abs(lx - ex) > 8 || Math.abs(lz - ez) > 8) {
            return true;
        }
        if (System.currentTimeMillis() - this.lastCheckTime > 1000L) {
            int radius = Mth.m_14045_((int)Configs.Generic.SPAWNABLE_COLUMNS_OVERLAY_RADIUS.getIntegerValue(), (int)0, (int)128);
            int xStart = (int)entity.m_20185_() - radius >> 4;
            int zStart = (int)entity.m_20189_() - radius >> 4;
            int xEnd = (int)entity.m_20185_() + radius >> 4;
            int zEnd = (int)entity.m_20189_() + radius >> 4;
            Set<Long> set = DIRTY_CHUNKS;
            synchronized (set) {
                for (int cx = xStart; cx <= xEnd; ++cx) {
                    for (int cz = zStart; cz <= zEnd; ++cz) {
                        if (!DIRTY_CHUNKS.contains(ChunkPos.m_45589_((int)cx, (int)cz))) continue;
                        return true;
                    }
                }
            }
            this.lastCheckTime = System.currentTimeMillis();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Vec3 cameraPos, Entity entity, Minecraft mc) {
        Color4f color = Configs.Colors.SPAWNABLE_COLUMNS_OVERLAY_COLOR.getColor();
        int radius = Mth.m_14045_((int)Configs.Generic.SPAWNABLE_COLUMNS_OVERLAY_RADIUS.getIntegerValue(), (int)0, (int)128);
        int xStart = (int)entity.m_20185_() - radius;
        int zStart = (int)entity.m_20189_() - radius;
        int xEnd = (int)entity.m_20185_() + radius;
        int zEnd = (int)entity.m_20189_() + radius;
        ClientLevel world = mc.f_91073_;
        RenderObjectBase renderQuads = (RenderObjectBase)this.renderObjects.get(0);
        RenderObjectBase renderLines = (RenderObjectBase)this.renderObjects.get(1);
        BUFFER_1.m_166779_(renderQuads.getGlMode(), DefaultVertexFormat.f_85815_);
        BUFFER_2.m_166779_(renderLines.getGlMode(), DefaultVertexFormat.f_85815_);
        for (int x = xStart; x <= xEnd; ++x) {
            double minX = (double)x + 0.25 - cameraPos.f_82479_;
            double maxX = minX + 0.5;
            for (int z = zStart; z <= zEnd; ++z) {
                int height = world.m_46745_((BlockPos)this.posMutable.m_122178_(x, 0, z)).m_5885_(Heightmap.Types.WORLD_SURFACE, x, z) + 1;
                double minY = (double)height - cameraPos.f_82480_;
                double maxY = minY + 0.09375;
                double minZ = (double)z + 0.25 - cameraPos.f_82481_;
                double maxZ = minZ + 0.5;
                RenderUtils.drawBoxHorizontalSidesBatchedQuads((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ, (Color4f)color, (BufferBuilder)BUFFER_1);
                RenderUtils.drawBoxTopBatchedQuads((double)minX, (double)minZ, (double)maxX, (double)maxY, (double)maxZ, (Color4f)color, (BufferBuilder)BUFFER_1);
                RenderUtils.drawBoxAllEdgesBatchedLines((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ, (Color4f)color, (BufferBuilder)BUFFER_2);
            }
        }
        renderQuads.uploadData(BUFFER_1);
        renderLines.uploadData(BUFFER_2);
        this.lastCheckTime = System.currentTimeMillis();
        Set<Long> set = DIRTY_CHUNKS;
        synchronized (set) {
            DIRTY_CHUNKS.clear();
        }
    }
}

