/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.renderer.RenderObjectBase;
import fi.dy.masa.minihud.renderer.RenderUtils;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class OverlayRendererRandomTickableChunks
extends OverlayRendererBase {
    protected static boolean needsUpdate = true;
    @Nullable
    public static Vec3 newPos;
    private static final Direction[] HORIZONTALS;
    protected final RendererToggle toggle;
    protected Vec3 pos = Vec3.f_82478_;
    protected double minX;
    protected double minZ;
    protected double maxX;
    protected double maxZ;

    public static void setNeedsUpdate() {
        needsUpdate = true;
    }

    public OverlayRendererRandomTickableChunks(RendererToggle toggle) {
        this.toggle = toggle;
    }

    @Override
    public boolean shouldRender(Minecraft mc) {
        return this.toggle.getBooleanValue();
    }

    @Override
    public boolean needsUpdate(Entity entity, Minecraft mc) {
        if (needsUpdate) {
            return true;
        }
        if (this.toggle == RendererToggle.OVERLAY_RANDOM_TICKS_FIXED) {
            return newPos != null;
        }
        if (this.toggle == RendererToggle.OVERLAY_RANDOM_TICKS_PLAYER) {
            return entity.m_20185_() != this.pos.f_82479_ || entity.m_20189_() != this.pos.f_82481_;
        }
        return false;
    }

    @Override
    public void update(Vec3 cameraPos, Entity entity, Minecraft mc) {
        if (this.toggle == RendererToggle.OVERLAY_RANDOM_TICKS_PLAYER) {
            this.pos = entity.m_20182_();
        } else if (newPos != null) {
            this.pos = newPos;
            newPos = null;
        }
        Color4f color = this.toggle == RendererToggle.OVERLAY_RANDOM_TICKS_PLAYER ? Configs.Colors.RANDOM_TICKS_PLAYER_OVERLAY_COLOR.getColor() : Configs.Colors.RANDOM_TICKS_FIXED_OVERLAY_COLOR.getColor();
        RenderObjectBase renderQuads = (RenderObjectBase)this.renderObjects.get(0);
        RenderObjectBase renderLines = (RenderObjectBase)this.renderObjects.get(1);
        BUFFER_1.m_166779_(renderQuads.getGlMode(), DefaultVertexFormat.f_85815_);
        BUFFER_2.m_166779_(renderLines.getGlMode(), DefaultVertexFormat.f_85815_);
        Set<ChunkPos> chunks = this.getRandomTickableChunks(this.pos);
        for (ChunkPos pos : chunks) {
            this.renderChunkEdgesIfApplicable(cameraPos, pos, chunks, entity.m_20193_(), color);
        }
        renderQuads.uploadData(BUFFER_1);
        renderLines.uploadData(BUFFER_2);
        needsUpdate = false;
    }

    protected Set<ChunkPos> getRandomTickableChunks(Vec3 posCenter) {
        HashSet<ChunkPos> set = new HashSet<ChunkPos>();
        int centerChunkX = (int)Math.floor(posCenter.f_82479_) >> 4;
        int centerChunkZ = (int)Math.floor(posCenter.f_82481_) >> 4;
        double maxRange = 16384.0;
        int r = 9;
        for (int cz = centerChunkZ - 9; cz <= centerChunkZ + 9; ++cz) {
            for (int cx = centerChunkX - 9; cx <= centerChunkX + 9; ++cx) {
                double dx = (double)(cx * 16 + 8) - posCenter.f_82479_;
                double dz = (double)(cz * 16 + 8) - posCenter.f_82481_;
                if (!(dx * dx + dz * dz < 16384.0)) continue;
                set.add(new ChunkPos(cx, cz));
            }
        }
        return set;
    }

    protected void renderChunkEdgesIfApplicable(Vec3 cameraPos, ChunkPos pos, Set<ChunkPos> chunks, Level world, Color4f color) {
        for (Direction side : HORIZONTALS) {
            ChunkPos posAdj = new ChunkPos(pos.f_45578_ + side.m_122429_(), pos.f_45579_ + side.m_122431_());
            if (chunks.contains(posAdj)) continue;
            this.renderChunkEdge(pos, side, cameraPos, color, world);
        }
    }

    private void renderChunkEdge(ChunkPos pos, Direction side, Vec3 cameraPos, Color4f color, Level world) {
        double maxZ;
        double maxX;
        double minZ;
        double minX;
        switch (side) {
            case NORTH: {
                minX = pos.f_45578_ << 4;
                minZ = pos.f_45579_ << 4;
                maxX = (double)(pos.f_45578_ << 4) + 16.0;
                maxZ = pos.f_45579_ << 4;
                break;
            }
            case SOUTH: {
                minX = pos.f_45578_ << 4;
                minZ = (double)(pos.f_45579_ << 4) + 16.0;
                maxX = (double)(pos.f_45578_ << 4) + 16.0;
                maxZ = (double)(pos.f_45579_ << 4) + 16.0;
                break;
            }
            case WEST: {
                minX = pos.f_45578_ << 4;
                minZ = pos.f_45579_ << 4;
                maxX = pos.f_45578_ << 4;
                maxZ = (double)(pos.f_45579_ << 4) + 16.0;
                break;
            }
            case EAST: {
                minX = (double)(pos.f_45578_ << 4) + 16.0;
                minZ = pos.f_45579_ << 4;
                maxX = (double)(pos.f_45578_ << 4) + 16.0;
                maxZ = (double)(pos.f_45579_ << 4) + 16.0;
                break;
            }
            default: {
                return;
            }
        }
        int minY = world != null ? world.m_141937_() : -64;
        int maxY = world != null ? world.m_151558_() : 320;
        RenderUtils.renderWallWithLines(minX, minY, minZ, maxX, maxY, maxZ, 16.0, 16.0, true, cameraPos, color, BUFFER_1, BUFFER_2);
    }

    @Override
    public String getSaveId() {
        return this.toggle == RendererToggle.OVERLAY_RANDOM_TICKS_FIXED ? "random_tickable_chunks" : "";
    }

    @Override
    @Nullable
    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        obj.add("pos", (JsonElement)JsonUtils.vec3dToJson((Vec3)this.pos));
        return obj;
    }

    @Override
    public void fromJson(JsonObject obj) {
        Vec3 pos = JsonUtils.vec3dFromJson((JsonObject)obj, (String)"pos");
        if (pos != null && this.toggle == RendererToggle.OVERLAY_RANDOM_TICKS_FIXED) {
            newPos = pos;
        }
    }

    static {
        HORIZONTALS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
    }
}

