/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import fi.dy.masa.malilib.config.IConfigBoolean;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.renderer.RenderObjectBase;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientChunkCache;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;

public abstract class BaseBlockRangeOverlay<T extends BlockEntity>
extends OverlayRendererBase {
    protected final IConfigBoolean renderToggleConfig;
    protected final LongOpenHashSet blockPositions = new LongOpenHashSet();
    protected final BlockEntityType<T> blockEntityType;
    protected final Class<T> blockEntityClass;
    protected boolean needsFullRebuild;
    protected boolean needsUpdate;
    protected int updateDistance = 48;

    protected BaseBlockRangeOverlay(IConfigBoolean renderToggleConfig, BlockEntityType<T> blockEntityType, Class<T> blockEntityClass) {
        this.renderToggleConfig = renderToggleConfig;
        this.blockEntityType = blockEntityType;
        this.blockEntityClass = blockEntityClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        LongOpenHashSet longOpenHashSet = this.blockPositions;
        synchronized (longOpenHashSet) {
            this.blockPositions.clear();
        }
    }

    public void setNeedsUpdate() {
        if (!this.renderToggleConfig.getBooleanValue()) {
            this.clear();
            return;
        }
        this.needsUpdate = true;
        this.needsFullRebuild = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onBlockStatusChange(BlockPos pos) {
        if (this.renderToggleConfig.getBooleanValue()) {
            LongOpenHashSet longOpenHashSet = this.blockPositions;
            synchronized (longOpenHashSet) {
                this.blockPositions.add(pos.m_121878_());
                this.needsUpdate = true;
            }
        }
    }

    @Override
    public boolean shouldRender(Minecraft mc) {
        return this.renderToggleConfig.getBooleanValue();
    }

    @Override
    public boolean needsUpdate(Entity cameraEntity, Minecraft mc) {
        return this.needsUpdate || this.lastUpdatePos == null || Math.abs(cameraEntity.m_20185_() - (double)this.lastUpdatePos.m_123341_()) > (double)this.updateDistance || Math.abs(cameraEntity.m_20189_() - (double)this.lastUpdatePos.m_123343_()) > (double)this.updateDistance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Vec3 cameraPos, Entity entity, Minecraft mc) {
        this.startBuffers();
        LongOpenHashSet longOpenHashSet = this.blockPositions;
        synchronized (longOpenHashSet) {
            if (this.needsFullRebuild) {
                this.blockPositions.clear();
                this.fetchAllTargetBlockEntityPositions(mc.f_91073_, entity.m_20183_(), mc);
                this.needsFullRebuild = false;
            }
            this.renderBlockRanges(entity.m_20193_(), cameraPos, mc);
        }
        this.uploadBuffers();
        this.needsUpdate = false;
    }

    protected void startBuffers() {
        BUFFER_1.m_166779_(((RenderObjectBase)this.renderObjects.get(0)).getGlMode(), DefaultVertexFormat.f_85815_);
        BUFFER_2.m_166779_(((RenderObjectBase)this.renderObjects.get(1)).getGlMode(), DefaultVertexFormat.f_85815_);
    }

    protected void uploadBuffers() {
        ((RenderObjectBase)this.renderObjects.get(0)).uploadData(BUFFER_1);
        ((RenderObjectBase)this.renderObjects.get(1)).uploadData(BUFFER_2);
    }

    protected void fetchAllTargetBlockEntityPositions(ClientLevel world, BlockPos centerPos, Minecraft mc) {
        ClientChunkCache chunkManager = world.m_7726_();
        int centerCX = centerPos.m_123341_() >> 4;
        int centerCZ = centerPos.m_123343_() >> 4;
        int chunkRadius = (Integer)mc.f_91066_.m_231984_().m_231551_();
        for (int cz = centerCZ - chunkRadius; cz <= centerCZ + chunkRadius; ++cz) {
            for (int cx = centerCX - chunkRadius; cx <= centerCX + chunkRadius; ++cx) {
                LevelChunk chunk = chunkManager.m_7587_(cx, cz, ChunkStatus.f_62326_, false);
                if (chunk == null) continue;
                for (BlockEntity be : chunk.m_62954_().values()) {
                    if (be.m_58903_() != this.blockEntityType) continue;
                    this.blockPositions.add(be.m_58899_().m_121878_());
                }
            }
        }
    }

    protected void renderBlockRanges(Level world, Vec3 cameraPos, Minecraft mc) {
        LongIterator it = this.blockPositions.iterator();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        double max = ((Integer)mc.f_91066_.m_231984_().m_231551_() + 2) * 16;
        max *= max;
        while (it.hasNext()) {
            mutablePos.m_122188_(it.nextLong());
            BlockEntity be = world.m_7702_((BlockPos)mutablePos);
            if (be == null || !this.blockEntityClass.isAssignableFrom(be.getClass())) {
                it.remove();
                continue;
            }
            double distSq = (cameraPos.f_82479_ - (double)mutablePos.m_123341_()) * (cameraPos.f_82479_ - (double)mutablePos.m_123341_()) + (cameraPos.f_82481_ - (double)mutablePos.m_123343_()) * (cameraPos.f_82481_ - (double)mutablePos.m_123343_());
            if (distSq > max) continue;
            BlockEntity castBe = (BlockEntity)this.blockEntityClass.cast(be);
            this.renderBlockRange(world, (BlockPos)mutablePos, castBe, cameraPos);
        }
    }

    protected int getTopYOverTerrain(Level world, BlockPos pos, int range) {
        int minX = pos.m_123341_() - range;
        int minZ = pos.m_123343_() - range;
        int maxX = pos.m_123341_() + range;
        int maxZ = pos.m_123343_() + range;
        int minCX = minX >> 4;
        int minCZ = minZ >> 4;
        int maxCX = maxX >> 4;
        int maxCZ = maxZ >> 4;
        int maxY = 0;
        for (int cz = minCZ; cz <= maxCZ; ++cz) {
            for (int cx = minCX; cx <= maxCX; ++cx) {
                LevelChunk chunk = world.m_6325_(cx, cz);
                int height = chunk.m_62098_() + 15;
                if (height <= maxY) continue;
                maxY = height;
            }
        }
        return maxY + 4;
    }

    protected abstract void renderBlockRange(Level var1, BlockPos var2, T var3, Vec3 var4);
}

