/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.event;

import com.mojang.blaze3d.vertex.PoseStack;
import fi.dy.masa.malilib.config.HudAlignment;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.interfaces.IRenderer;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.BlockUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.WorldUtils;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.InfoToggle;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.data.MobCapDataHandler;
import fi.dy.masa.minihud.mixin.IMixinServerWorld;
import fi.dy.masa.minihud.mixin.IMixinWorldRenderer;
import fi.dy.masa.minihud.renderer.OverlayRenderer;
import fi.dy.masa.minihud.util.DataStorage;
import fi.dy.masa.minihud.util.IServerEntityManager;
import fi.dy.masa.minihud.util.MiscUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class RenderHandler
implements IRenderer {
    private static final RenderHandler INSTANCE = new RenderHandler();
    private final Minecraft mc;
    private final DataStorage data;
    private final Date date;
    private final Map<ChunkPos, CompletableFuture<LevelChunk>> chunkFutures = new HashMap<ChunkPos, CompletableFuture<LevelChunk>>();
    private final Set<InfoToggle> addedTypes = new HashSet<InfoToggle>();
    @Nullable
    private LevelChunk cachedClientChunk;
    private long infoUpdateTime;
    private final List<StringHolder> lineWrappers = new ArrayList<StringHolder>();
    private final List<String> lines = new ArrayList<String>();

    public RenderHandler() {
        this.mc = Minecraft.m_91087_();
        this.data = DataStorage.getInstance();
        this.date = new Date();
    }

    public static RenderHandler getInstance() {
        return INSTANCE;
    }

    public DataStorage getDataStorage() {
        return this.data;
    }

    public static void fixDebugRendererState() {
        if (Configs.Generic.FIX_VANILLA_DEBUG_RENDERERS.getBooleanValue()) {
            // empty if block
        }
    }

    public void onRenderGameOverlayPost(GuiGraphics context) {
        if (!Configs.Generic.MAIN_RENDERING_TOGGLE.getBooleanValue()) {
            this.resetCachedChunks();
            return;
        }
        if (!(this.mc.f_91066_.f_92063_ || this.mc.f_91074_ == null || this.mc.f_91066_.f_92062_ || Configs.Generic.REQUIRE_SNEAK.getBooleanValue() && !this.mc.f_91074_.m_6144_() || !Configs.Generic.REQUIRED_KEY.getKeybind().isKeybindHeld())) {
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.infoUpdateTime >= 50L) {
                this.updateLines();
                this.infoUpdateTime = currentTime;
            }
            int x = Configs.Generic.TEXT_POS_X.getIntegerValue();
            int y = Configs.Generic.TEXT_POS_Y.getIntegerValue();
            int textColor = Configs.Colors.TEXT_COLOR.getIntegerValue();
            int bgColor = Configs.Colors.TEXT_BACKGROUND_COLOR.getIntegerValue();
            HudAlignment alignment = (HudAlignment)Configs.Generic.HUD_ALIGNMENT.getOptionListValue();
            boolean useBackground = Configs.Generic.USE_TEXT_BACKGROUND.getBooleanValue();
            boolean useShadow = Configs.Generic.USE_FONT_SHADOW.getBooleanValue();
            RenderUtils.renderText((int)x, (int)y, (double)Configs.Generic.FONT_SCALE.getDoubleValue(), (int)textColor, (int)bgColor, (HudAlignment)alignment, (boolean)useBackground, (boolean)useShadow, this.lines, (GuiGraphics)context);
        }
    }

    public void onRenderTooltipLast(GuiGraphics drawContext, ItemStack stack, int x, int y) {
        if (stack.m_41720_() instanceof MapItem) {
            if (Configs.Generic.MAP_PREVIEW.getBooleanValue()) {
                RenderUtils.renderMapPreview((ItemStack)stack, (int)x, (int)y, (int)Configs.Generic.MAP_PREVIEW_SIZE.getIntegerValue());
            }
        } else if (Configs.Generic.SHULKER_BOX_PREVIEW.getBooleanValue()) {
            boolean render;
            boolean bl = render = !Configs.Generic.SHULKER_DISPLAY_REQUIRE_SHIFT.getBooleanValue() || GuiBase.isShiftDown();
            if (render) {
                RenderUtils.renderShulkerBoxPreview((ItemStack)stack, (int)x, (int)y, (boolean)Configs.Generic.SHULKER_DISPLAY_BACKGROUND_COLOR.getBooleanValue(), (GuiGraphics)drawContext);
            }
        }
    }

    public void onRenderWorldLast(PoseStack matrixStack, Matrix4f projMatrix) {
        if (Configs.Generic.MAIN_RENDERING_TOGGLE.getBooleanValue() && this.mc.f_91073_ != null && this.mc.f_91074_ != null && !this.mc.f_91066_.f_92062_) {
            OverlayRenderer.renderOverlays(matrixStack, projMatrix, this.mc);
        }
    }

    public int getSubtitleOffset() {
        if (Configs.Generic.OFFSET_SUBTITLE_HUD.getBooleanValue() && Configs.Generic.MAIN_RENDERING_TOGGLE.getBooleanValue() && Configs.Generic.HUD_ALIGNMENT.getOptionListValue() == HudAlignment.BOTTOM_RIGHT) {
            int offset = (int)((double)(this.lineWrappers.size() * (StringUtils.getFontHeight() + 2)) * Configs.Generic.FONT_SCALE.getDoubleValue());
            return -(offset - 16);
        }
        return 0;
    }

    public void updateData(Minecraft mc) {
        if (mc.f_91073_ != null && RendererToggle.OVERLAY_STRUCTURE_MAIN_TOGGLE.getBooleanValue()) {
            DataStorage.getInstance().updateStructureData();
        }
    }

    private void updateLines() {
        this.lineWrappers.clear();
        this.addedTypes.clear();
        if (this.chunkFutures.size() >= 4) {
            this.resetCachedChunks();
        }
        ArrayList<LinePos> positions = new ArrayList<LinePos>();
        for (InfoToggle toggle : InfoToggle.values()) {
            if (!toggle.getBooleanValue()) continue;
            positions.add(new LinePos(toggle.getIntegerValue(), toggle));
        }
        Collections.sort(positions);
        for (LinePos pos : positions) {
            try {
                this.addLine(pos.type);
            }
            catch (Exception e) {
                this.addLine(pos.type.getName() + ": exception");
            }
        }
        if (Configs.Generic.SORT_LINES_BY_LENGTH.getBooleanValue()) {
            Collections.sort(this.lineWrappers);
            if (Configs.Generic.SORT_LINES_REVERSED.getBooleanValue()) {
                Collections.reverse(this.lineWrappers);
            }
        }
        this.lines.clear();
        for (StringHolder holder : this.lineWrappers) {
            this.lines.add(holder.str);
        }
    }

    private void addLine(String text) {
        this.lineWrappers.add(new StringHolder(text));
    }

    private void addLine(InfoToggle type) {
        Minecraft mc = this.mc;
        Entity entity = mc.m_91288_();
        Level world = entity.m_20193_();
        double y = entity.m_20186_();
        BlockPos pos = BlockPos.m_274561_((double)entity.m_20185_(), (double)y, (double)entity.m_20189_());
        ChunkPos chunkPos = new ChunkPos(pos);
        boolean isChunkLoaded = mc.f_91073_.m_46805_(pos);
        if (!isChunkLoaded) {
            return;
        }
        if (type == InfoToggle.FPS) {
            this.addLine(String.format("%d fps", Minecraft.m_91087_().m_260875_()));
        } else if (type == InfoToggle.MEMORY_USAGE) {
            long memMax = Runtime.getRuntime().maxMemory();
            long memTotal = Runtime.getRuntime().totalMemory();
            long memFree = Runtime.getRuntime().freeMemory();
            long memUsed = memTotal - memFree;
            this.addLine(String.format("Mem: % 2d%% %03d/%03dMB | Allocated: % 2d%% %03dMB", memUsed * 100L / memMax, MiscUtils.bytesToMb(memUsed), MiscUtils.bytesToMb(memMax), memTotal * 100L / memMax, MiscUtils.bytesToMb(memTotal)));
        } else if (type == InfoToggle.TIME_REAL) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(Configs.Generic.DATE_FORMAT_REAL.getStringValue());
                this.date.setTime(System.currentTimeMillis());
                this.addLine(sdf.format(this.date));
            }
            catch (Exception e) {
                this.addLine("Date formatting failed - Invalid date format string?");
            }
        } else if (type == InfoToggle.TIME_WORLD) {
            long current = world.m_46468_();
            long total = world.m_46467_();
            this.addLine(String.format("World time: %5d - total: %d", current, total));
        } else if (type == InfoToggle.TIME_WORLD_FORMATTED) {
            try {
                long timeDay = world.m_46468_();
                long day = (int)(timeDay / 24000L);
                int dayTicks = (int)(timeDay % 24000L);
                int hour = (dayTicks / 1000 + 6) % 24;
                int min = (int)((double)dayTicks / 16.666666) % 60;
                int sec = (int)((double)dayTicks / 0.277777) % 60;
                String moon = "Invalid";
                switch ((int)day % 8) {
                    case 0: {
                        moon = "Full moon";
                        break;
                    }
                    case 1: {
                        moon = "Waning gibbous";
                        break;
                    }
                    case 2: {
                        moon = "Last quarter";
                        break;
                    }
                    case 3: {
                        moon = "Waning crescent";
                        break;
                    }
                    case 4: {
                        moon = "New moon";
                        break;
                    }
                    case 5: {
                        moon = "Waxing crescent";
                        break;
                    }
                    case 6: {
                        moon = "First quarter";
                        break;
                    }
                    case 7: {
                        moon = "Waxing gibbous";
                        break;
                    }
                }
                String str = Configs.Generic.DATE_FORMAT_MINECRAFT.getStringValue();
                str = str.replace("{DAY}", String.format("%d", day));
                str = str.replace("{DAY_1}", String.format("%d", day + 1L));
                str = str.replace("{HOUR}", String.format("%02d", hour));
                str = str.replace("{MIN}", String.format("%02d", min));
                str = str.replace("{SEC}", String.format("%02d", sec));
                str = str.replace("{MOON}", String.format("%s", moon));
                this.addLine(str);
            }
            catch (Exception e) {
                this.addLine("Date formatting failed - Invalid date format string?");
            }
        } else if (type == InfoToggle.TIME_DAY_MODULO) {
            int mod = Configs.Generic.TIME_DAY_DIVISOR.getIntegerValue();
            long current = world.m_46468_() % (long)mod;
            this.addLine(String.format("Day time %% %d: %5d", mod, current));
        } else if (type == InfoToggle.TIME_TOTAL_MODULO) {
            int mod = Configs.Generic.TIME_TOTAL_DIVISOR.getIntegerValue();
            long current = world.m_46467_() % (long)mod;
            this.addLine(String.format("Total time %% %d: %5d", mod, current));
        } else if (type == InfoToggle.SERVER_TPS) {
            if (mc.m_91091_() && mc.m_91092_().m_129921_() % 10 == 0) {
                this.data.updateIntegratedServerTPS();
            }
            if (this.data.hasTPSData()) {
                String preTps;
                double tps = this.data.getServerTPS();
                double mspt = this.data.getServerMSPT();
                String rst = GuiBase.TXT_RST;
                String string = preTps = tps >= 20.0 ? GuiBase.TXT_GREEN : GuiBase.TXT_RED;
                if (this.data.isCarpetServer() || mc.m_91090_()) {
                    String preMspt = mspt <= 40.0 ? GuiBase.TXT_GREEN : (mspt <= 45.0 ? GuiBase.TXT_YELLOW : (mspt <= 50.0 ? GuiBase.TXT_GOLD : GuiBase.TXT_RED));
                    this.addLine(String.format("Server TPS: %s%.1f%s MSPT: %s%.1f%s", preTps, tps, rst, preMspt, mspt, rst));
                } else {
                    String preMspt = mspt <= 51.0 ? GuiBase.TXT_GREEN : GuiBase.TXT_RED;
                    this.addLine(String.format("Server TPS: %s%.1f%s (MSPT [est]: %s%.1f%s)", preTps, tps, rst, preMspt, mspt, rst));
                }
            } else {
                this.addLine("Server TPS: <no valid data>");
            }
        } else if (type == InfoToggle.MOB_CAPS) {
            MobCapDataHandler mobCapData = this.data.getMobCapData();
            if (mc.m_91091_() && mc.m_91092_().m_129921_() % 100 == 0) {
                mobCapData.updateIntegratedServerMobCaps();
            }
            if (mobCapData.getHasValidData()) {
                this.addLine(mobCapData.getFormattedInfoLine());
            }
        } else if (type == InfoToggle.PING) {
            PlayerInfo info = mc.f_91074_.f_108617_.m_104949_(mc.f_91074_.m_20148_());
            if (info != null) {
                this.addLine("Ping: " + info.m_105330_() + " ms");
            }
        } else if (type == InfoToggle.COORDINATES || type == InfoToggle.COORDINATES_SCALED || type == InfoToggle.DIMENSION) {
            if (this.addedTypes.contains((Object)InfoToggle.COORDINATES) || this.addedTypes.contains((Object)InfoToggle.COORDINATES_SCALED) || this.addedTypes.contains((Object)InfoToggle.DIMENSION)) {
                return;
            }
            String pre = "";
            StringBuilder str = new StringBuilder(128);
            String fmtStr = Configs.Generic.COORDINATE_FORMAT_STRING.getStringValue();
            double x = entity.m_20185_();
            double z = entity.m_20189_();
            if (InfoToggle.COORDINATES.getBooleanValue()) {
                if (Configs.Generic.USE_CUSTOMIZED_COORDINATES.getBooleanValue()) {
                    try {
                        str.append(String.format(fmtStr, x, y, z));
                    }
                    catch (Exception e) {
                        str.append("broken coordinate format string!");
                    }
                } else {
                    str.append(String.format("XYZ: %.2f / %.4f / %.2f", x, y, z));
                }
                pre = " / ";
            }
            if (InfoToggle.COORDINATES_SCALED.getBooleanValue() && (world.m_46472_() == Level.f_46429_ || world.m_46472_() == Level.f_46428_)) {
                boolean isNether = world.m_46472_() == Level.f_46429_;
                double scale = isNether ? 8.0 : 0.125;
                x *= scale;
                z *= scale;
                str.append(pre);
                if (isNether) {
                    str.append("Overworld: ");
                } else {
                    str.append("Nether: ");
                }
                if (Configs.Generic.USE_CUSTOMIZED_COORDINATES.getBooleanValue()) {
                    try {
                        str.append(String.format(fmtStr, x, y, z));
                    }
                    catch (Exception e) {
                        str.append("broken coordinate format string!");
                    }
                } else {
                    str.append(String.format("XYZ: %.2f / %.4f / %.2f", x, y, z));
                }
                pre = " / ";
            }
            if (InfoToggle.DIMENSION.getBooleanValue()) {
                String dimName = world.m_46472_().m_135782_().toString();
                str.append(pre).append("dim: ").append(dimName);
            }
            this.addLine(str.toString());
            this.addedTypes.add(InfoToggle.COORDINATES);
            this.addedTypes.add(InfoToggle.COORDINATES_SCALED);
            this.addedTypes.add(InfoToggle.DIMENSION);
        } else if (type == InfoToggle.BLOCK_POS || type == InfoToggle.CHUNK_POS || type == InfoToggle.REGION_FILE) {
            if (this.addedTypes.contains((Object)InfoToggle.BLOCK_POS) || this.addedTypes.contains((Object)InfoToggle.CHUNK_POS) || this.addedTypes.contains((Object)InfoToggle.REGION_FILE)) {
                return;
            }
            String pre = "";
            StringBuilder str = new StringBuilder(256);
            if (InfoToggle.BLOCK_POS.getBooleanValue()) {
                str.append(String.format("Block: %d, %d, %d", pos.m_123341_(), pos.m_123342_(), pos.m_123343_()));
                pre = " / ";
            }
            if (InfoToggle.CHUNK_POS.getBooleanValue()) {
                str.append(pre).append(String.format("Sub-Chunk: %d, %d, %d", chunkPos.f_45578_, pos.m_123342_() >> 4, chunkPos.f_45579_));
                pre = " / ";
            }
            if (InfoToggle.REGION_FILE.getBooleanValue()) {
                str.append(pre).append(String.format("Region: r.%d.%d", pos.m_123341_() >> 9, pos.m_123343_() >> 9));
            }
            this.addLine(str.toString());
            this.addedTypes.add(InfoToggle.BLOCK_POS);
            this.addedTypes.add(InfoToggle.CHUNK_POS);
            this.addedTypes.add(InfoToggle.REGION_FILE);
        } else if (type == InfoToggle.BLOCK_IN_CHUNK) {
            this.addLine(String.format("Block: %d, %d, %d within Sub-Chunk: %d, %d, %d", pos.m_123341_() & 0xF, pos.m_123342_() & 0xF, pos.m_123343_() & 0xF, chunkPos.f_45578_, pos.m_123342_() >> 4, chunkPos.f_45579_));
        } else if (type == InfoToggle.BLOCK_BREAK_SPEED) {
            this.addLine(String.format("BBS: %.2f", DataStorage.getInstance().getBlockBreakingSpeed()));
        } else if (type == InfoToggle.SPRINTING && mc.f_91074_.m_20142_()) {
            this.addLine("\u00a76Sprinting");
        } else if (type == InfoToggle.DISTANCE) {
            Vec3 ref = DataStorage.getInstance().getDistanceReferencePoint();
            double dist = Math.sqrt(ref.m_82531_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_()));
            this.addLine(String.format("Distance: %.2f (x: %.2f y: %.2f z: %.2f) [to x: %.2f y: %.2f z: %.2f]", dist, entity.m_20185_() - ref.f_82479_, entity.m_20186_() - ref.f_82480_, entity.m_20189_() - ref.f_82481_, ref.f_82479_, ref.f_82480_, ref.f_82481_));
        } else if (type == InfoToggle.FACING) {
            Direction facing = entity.m_6350_();
            String str = "Invalid";
            switch (facing) {
                case NORTH: {
                    str = "Negative Z";
                    break;
                }
                case SOUTH: {
                    str = "Positive Z";
                    break;
                }
                case WEST: {
                    str = "Negative X";
                    break;
                }
                case EAST: {
                    str = "Positive X";
                    break;
                }
            }
            this.addLine(String.format("Facing: %s (%s)", facing, str));
        } else if (type == InfoToggle.LIGHT_LEVEL) {
            LevelChunk clientChunk = this.getClientChunk(chunkPos);
            if (!clientChunk.m_6430_()) {
                LevelLightEngine lightingProvider = world.m_7726_().m_7827_();
                this.addLine(String.format("Light (block): %d", lightingProvider.m_75814_(LightLayer.BLOCK).m_7768_(pos)));
            }
        } else if (type == InfoToggle.BEE_COUNT) {
            Level bestWorld = WorldUtils.getBestWorld((Minecraft)mc);
            BlockEntity be = this.getTargetedBlockEntity(bestWorld, mc);
            if (be instanceof BeehiveBlockEntity) {
                this.addLine("Bees: " + GuiBase.TXT_AQUA + ((BeehiveBlockEntity)be).m_58776_());
            }
        } else if (type == InfoToggle.FURNACE_XP) {
            Level bestWorld = WorldUtils.getBestWorld((Minecraft)mc);
            BlockEntity be = this.getTargetedBlockEntity(bestWorld, mc);
            if (be instanceof AbstractFurnaceBlockEntity) {
                AbstractFurnaceBlockEntity furnace = (AbstractFurnaceBlockEntity)be;
                this.addLine("Furnace XP: " + GuiBase.TXT_AQUA + MiscUtils.getFurnaceXpAmount(furnace));
            }
        } else if (type == InfoToggle.HONEY_LEVEL) {
            BlockState state = this.getTargetedBlock(mc);
            if (state != null && state.m_60734_() instanceof BeehiveBlock) {
                this.addLine("Honey: " + GuiBase.TXT_AQUA + BeehiveBlockEntity.m_58752_((BlockState)state));
            }
        } else if (type == InfoToggle.HORSE_SPEED || type == InfoToggle.HORSE_JUMP) {
            if (this.addedTypes.contains((Object)InfoToggle.HORSE_SPEED) || this.addedTypes.contains((Object)InfoToggle.HORSE_JUMP)) {
                return;
            }
            Entity vehicle = this.mc.f_91074_.m_20202_();
            if (!(vehicle instanceof AbstractHorse)) {
                return;
            }
            AbstractHorse horse = (AbstractHorse)vehicle;
            if (horse.m_6254_()) {
                if (InfoToggle.HORSE_SPEED.getBooleanValue()) {
                    float speed = horse.m_6113_();
                    this.addLine(String.format("Horse Speed: %.3f m/s", Float.valueOf(speed *= 42.163f)));
                }
                if (InfoToggle.HORSE_JUMP.getBooleanValue()) {
                    double jump = horse.m_30626_();
                    double calculatedJumpHeight = -0.1817584952 * jump * jump * jump + 3.689713992 * jump * jump + 2.128599134 * jump + -0.343930367;
                    this.addLine(String.format("Horse Jump: %.3f m", calculatedJumpHeight));
                }
                this.addedTypes.add(InfoToggle.HORSE_SPEED);
                this.addedTypes.add(InfoToggle.HORSE_JUMP);
            }
        } else if (type == InfoToggle.ROTATION_YAW || type == InfoToggle.ROTATION_PITCH || type == InfoToggle.SPEED) {
            if (this.addedTypes.contains((Object)InfoToggle.ROTATION_YAW) || this.addedTypes.contains((Object)InfoToggle.ROTATION_PITCH) || this.addedTypes.contains((Object)InfoToggle.SPEED)) {
                return;
            }
            String pre = "";
            StringBuilder str = new StringBuilder(128);
            if (InfoToggle.ROTATION_YAW.getBooleanValue()) {
                str.append(String.format("yaw: %.1f", Float.valueOf(Mth.m_14177_((float)entity.m_146908_()))));
                pre = " / ";
            }
            if (InfoToggle.ROTATION_PITCH.getBooleanValue()) {
                str.append(pre).append(String.format("pitch: %.1f", Float.valueOf(Mth.m_14177_((float)entity.m_146909_()))));
                pre = " / ";
            }
            if (InfoToggle.SPEED.getBooleanValue()) {
                double dx = entity.m_20185_() - entity.f_19790_;
                double dy = entity.m_20186_() - entity.f_19791_;
                double dz = entity.m_20189_() - entity.f_19792_;
                double dist = Math.sqrt(dx * dx + dy * dy + dz * dz);
                str.append(pre).append(String.format("speed: %.3f m/s", dist * 20.0));
            }
            this.addLine(str.toString());
            this.addedTypes.add(InfoToggle.ROTATION_YAW);
            this.addedTypes.add(InfoToggle.ROTATION_PITCH);
            this.addedTypes.add(InfoToggle.SPEED);
        } else if (type == InfoToggle.SPEED_HV) {
            double dx = entity.m_20185_() - entity.f_19790_;
            double dy = entity.m_20186_() - entity.f_19791_;
            double dz = entity.m_20189_() - entity.f_19792_;
            this.addLine(String.format("speed: xz: %.3f y: %.3f m/s", Math.sqrt(dx * dx + dz * dz) * 20.0, dy * 20.0));
        } else if (type == InfoToggle.SPEED_AXIS) {
            double dx = entity.m_20185_() - entity.f_19790_;
            double dy = entity.m_20186_() - entity.f_19791_;
            double dz = entity.m_20189_() - entity.f_19792_;
            this.addLine(String.format("speed: x: %.3f y: %.3f z: %.3f m/s", dx * 20.0, dy * 20.0, dz * 20.0));
        } else if (type == InfoToggle.CHUNK_SECTIONS) {
            this.addLine(String.format("C: %d", ((IMixinWorldRenderer)mc.f_91060_).getRenderedChunksInvoker()));
        } else if (type == InfoToggle.CHUNK_SECTIONS_FULL) {
            this.addLine(mc.f_91060_.m_109820_());
        } else if (type == InfoToggle.CHUNK_UPDATES) {
            this.addLine("TODO");
        } else if (type == InfoToggle.LOADED_CHUNKS_COUNT) {
            String chunksClient = mc.f_91073_.m_46464_();
            Level worldServer = WorldUtils.getBestWorld((Minecraft)mc);
            if (worldServer != null && worldServer != mc.f_91073_) {
                int chunksServer = ((ServerChunkCache)worldServer.m_7726_()).m_8482_();
                int chunksServerTot = ((ServerChunkCache)worldServer.m_7726_()).m_8427_();
                this.addLine(String.format("Server: %d / %d - Client: %s", chunksServer, chunksServerTot, chunksClient));
            } else {
                this.addLine(chunksClient);
            }
        } else if (type == InfoToggle.PARTICLE_COUNT) {
            this.addLine(String.format("P: %s", mc.f_91061_.m_107403_()));
        } else if (type == InfoToggle.DIFFICULTY) {
            long chunkInhabitedTime = 0L;
            float moonPhaseFactor = 0.0f;
            LevelChunk serverChunk = this.getChunk(chunkPos);
            if (serverChunk != null) {
                moonPhaseFactor = mc.f_91073_.m_46940_();
                chunkInhabitedTime = serverChunk.m_6319_();
            }
            DifficultyInstance diff = new DifficultyInstance(mc.f_91073_.m_46791_(), mc.f_91073_.m_46468_(), chunkInhabitedTime, moonPhaseFactor);
            this.addLine(String.format("Local Difficulty: %.2f // %.2f (Day %d)", Float.valueOf(diff.m_19056_()), Float.valueOf(diff.m_19057_()), mc.f_91073_.m_46468_() / 24000L));
        } else if (type == InfoToggle.BIOME) {
            LevelChunk clientChunk = this.getClientChunk(chunkPos);
            if (!clientChunk.m_6430_()) {
                Biome biome = (Biome)mc.f_91073_.m_204166_(pos).m_203334_();
                ResourceLocation id = mc.f_91073_.m_9598_().m_175515_(Registries.f_256952_).m_7981_((Object)biome);
                this.addLine("Biome: " + StringUtils.translate((String)("biome." + id.toString().replace(":", ".")), (Object[])new Object[0]));
            }
        } else if (type == InfoToggle.BIOME_REG_NAME) {
            LevelChunk clientChunk = this.getClientChunk(chunkPos);
            if (!clientChunk.m_6430_()) {
                Biome biome = (Biome)mc.f_91073_.m_204166_(pos).m_203334_();
                ResourceLocation rl = mc.f_91073_.m_9598_().m_175515_(Registries.f_256952_).m_7981_((Object)biome);
                String name = rl != null ? rl.toString() : "?";
                this.addLine("Biome reg name: " + name);
            }
        } else if (type == InfoToggle.ENTITIES) {
            String ent = mc.f_91060_.m_109822_();
            int p = ent.indexOf(",");
            if (p != -1) {
                ent = ent.substring(0, p);
            }
            this.addLine(ent);
        } else if (type == InfoToggle.TILE_ENTITIES) {
            this.addLine("Client world TE - L: ?, T: ? - TODO 1.17");
        } else if (type == InfoToggle.ENTITIES_CLIENT_WORLD) {
            Level serverWorld;
            int countClient = mc.f_91073_.m_104813_();
            if (mc.m_91091_() && (serverWorld = WorldUtils.getBestWorld((Minecraft)mc)) instanceof ServerLevel) {
                IServerEntityManager manager = (IServerEntityManager)((IMixinServerWorld)serverWorld).minihud_getEntityManager();
                int indexSize = manager.getIndexSize();
                this.addLine(String.format("Entities - Client: %d - Server: %d", countClient, indexSize));
                return;
            }
            this.addLine(String.format("Entities - Client: %d", countClient));
        } else if (type == InfoToggle.SLIME_CHUNK) {
            Object result;
            if (!MiscUtils.isOverworld(world)) {
                return;
            }
            if (this.data.isWorldSeedKnown(world)) {
                long seed = this.data.getWorldSeed(world);
                result = MiscUtils.canSlimeSpawnAt(pos.m_123341_(), pos.m_123343_(), seed) ? GuiBase.TXT_GREEN + "YES" + GuiBase.TXT_RST : GuiBase.TXT_RED + "NO" + GuiBase.TXT_RST;
            } else {
                result = "<world seed not known>";
            }
            this.addLine("Slime chunk: " + (String)result);
        } else if (type == InfoToggle.LOOKING_AT_ENTITY) {
            if (mc.f_91077_ != null && mc.f_91077_.m_6662_() == HitResult.Type.ENTITY) {
                Entity lookedEntity = ((EntityHitResult)mc.f_91077_).m_82443_();
                if (lookedEntity instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)lookedEntity;
                    this.addLine(String.format("Entity: %s - HP: %.1f / %.1f", living.m_7755_().getString(), Float.valueOf(living.m_21223_()), Float.valueOf(living.m_21233_())));
                } else {
                    this.addLine(String.format("Entity: %s", lookedEntity.m_7755_().getString()));
                }
            }
        } else if (type == InfoToggle.ENTITY_REG_NAME) {
            Entity lookedEntity;
            ResourceLocation regName;
            if (mc.f_91077_ != null && mc.f_91077_.m_6662_() == HitResult.Type.ENTITY && (regName = EntityType.m_20613_((EntityType)(lookedEntity = ((EntityHitResult)mc.f_91077_).m_82443_()).m_6095_())) != null) {
                this.addLine(String.format("Entity reg name: %s", regName.toString()));
            }
        } else if (type == InfoToggle.LOOKING_AT_BLOCK || type == InfoToggle.LOOKING_AT_BLOCK_CHUNK) {
            if (this.addedTypes.contains((Object)InfoToggle.LOOKING_AT_BLOCK) || this.addedTypes.contains((Object)InfoToggle.LOOKING_AT_BLOCK_CHUNK)) {
                return;
            }
            if (mc.f_91077_ != null && mc.f_91077_.m_6662_() == HitResult.Type.BLOCK) {
                BlockPos lookPos = ((BlockHitResult)mc.f_91077_).m_82425_();
                String pre = "";
                StringBuilder str = new StringBuilder(128);
                if (InfoToggle.LOOKING_AT_BLOCK.getBooleanValue()) {
                    str.append(String.format("Looking at block: %d, %d, %d", lookPos.m_123341_(), lookPos.m_123342_(), lookPos.m_123343_()));
                    pre = " // ";
                }
                if (InfoToggle.LOOKING_AT_BLOCK_CHUNK.getBooleanValue()) {
                    str.append(pre).append(String.format("Block: %d, %d, %d in Sub-Chunk: %d, %d, %d", lookPos.m_123341_() & 0xF, lookPos.m_123342_() & 0xF, lookPos.m_123343_() & 0xF, lookPos.m_123341_() >> 4, lookPos.m_123342_() >> 4, lookPos.m_123343_() >> 4));
                }
                this.addLine(str.toString());
                this.addedTypes.add(InfoToggle.LOOKING_AT_BLOCK);
                this.addedTypes.add(InfoToggle.LOOKING_AT_BLOCK_CHUNK);
            }
        } else if (type == InfoToggle.BLOCK_PROPS) {
            this.getBlockProperties(mc);
        }
    }

    @Nullable
    private BlockEntity getTargetedBlockEntity(Level world, Minecraft mc) {
        if (mc.f_91077_ != null && mc.f_91077_.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos posLooking = ((BlockHitResult)mc.f_91077_).m_82425_();
            LevelChunk chunk = this.getChunk(new ChunkPos(posLooking));
            return chunk != null ? chunk.m_7702_(posLooking) : null;
        }
        return null;
    }

    @Nullable
    private BlockState getTargetedBlock(Minecraft mc) {
        if (mc.f_91077_ != null && mc.f_91077_.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos posLooking = ((BlockHitResult)mc.f_91077_).m_82425_();
            return mc.f_91073_.m_8055_(posLooking);
        }
        return null;
    }

    private <T extends Comparable<T>> void getBlockProperties(Minecraft mc) {
        if (mc.f_91077_ != null && mc.f_91077_.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos posLooking = ((BlockHitResult)mc.f_91077_).m_82425_();
            BlockState state = mc.f_91073_.m_8055_(posLooking);
            ResourceLocation rl = BuiltInRegistries.f_256975_.m_7981_((Object)state.m_60734_());
            this.addLine(rl != null ? rl.toString() : "<null>");
            for (String line : BlockUtils.getFormattedBlockStateProperties((BlockState)state)) {
                this.addLine(line);
            }
        }
    }

    @Nullable
    private LevelChunk getChunk(ChunkPos chunkPos) {
        CompletableFuture<LevelChunk> future = this.chunkFutures.get(chunkPos);
        if (future == null) {
            future = this.setupChunkFuture(chunkPos);
        }
        return future.getNow(null);
    }

    private CompletableFuture<LevelChunk> setupChunkFuture(ChunkPos chunkPos) {
        ServerLevel world;
        IntegratedServer server = this.mc.m_91092_();
        CompletionStage<Object> future = null;
        if (server != null && (world = server.m_129880_(this.mc.f_91073_.m_46472_())) != null) {
            future = world.m_7726_().m_8431_(chunkPos.f_45578_, chunkPos.f_45579_, ChunkStatus.f_62326_, false).thenApply(either -> (LevelChunk)either.map(chunk -> (LevelChunk)chunk, unloaded -> null));
        }
        if (future == null) {
            future = CompletableFuture.completedFuture(this.getClientChunk(chunkPos));
        }
        this.chunkFutures.put(chunkPos, (CompletableFuture<LevelChunk>)future);
        return future;
    }

    private LevelChunk getClientChunk(ChunkPos chunkPos) {
        if (this.cachedClientChunk == null || !this.cachedClientChunk.m_7697_().equals((Object)chunkPos)) {
            this.cachedClientChunk = this.mc.f_91073_.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_);
        }
        return this.cachedClientChunk;
    }

    private void resetCachedChunks() {
        this.chunkFutures.clear();
        this.cachedClientChunk = null;
    }

    private static class LinePos
    implements Comparable<LinePos> {
        private final int position;
        private final InfoToggle type;

        private LinePos(int position, InfoToggle type) {
            this.position = position;
            this.type = type;
        }

        @Override
        public int compareTo(LinePos other) {
            if (this.position < 0) {
                return other.position >= 0 ? 1 : 0;
            }
            if (other.position < 0 && this.position >= 0) {
                return -1;
            }
            return this.position < other.position ? -1 : (this.position > other.position ? 1 : 0);
        }
    }

    private class StringHolder
    implements Comparable<StringHolder> {
        public final String str;

        public StringHolder(String str) {
            this.str = str;
        }

        @Override
        public int compareTo(StringHolder other) {
            int lenOther;
            int lenThis = this.str.length();
            if (lenThis == (lenOther = other.str.length())) {
                return 0;
            }
            return this.str.length() > other.str.length() ? -1 : 1;
        }
    }
}

