/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.corpsecurioscompat.mixin;

import com.leclowndu93150.corpsecurioscompat.Config;
import de.maxhenkel.gravestone.blocks.GraveStoneBlock;
import de.maxhenkel.gravestone.corelib.death.Death;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

@Mixin(value={GraveStoneBlock.class})
public abstract class GraveStoneBlockMixin {
    @Unique
    private static final String CURIO_SLOT_TAG = "CorpseCuriosSlot";
    @Unique
    private static final String CURIO_SLOT_TYPE = "SlotType";
    @Unique
    private static final String CURIO_SLOT_INDEX = "SlotIndex";
    @Unique
    private static final String WAS_EQUIPPED = "WasEquipped";

    @Overwrite(remap=false)
    public NonNullList<ItemStack> fillPlayerInventory(Player player, Death death) {
        NonNullList unaddedItems = NonNullList.m_122779_();
        Optional curiosOpt = CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).resolve();
        if (curiosOpt.isPresent()) {
            ICuriosItemHandler curiosHandler = (ICuriosItemHandler)curiosOpt.get();
            Map curios = curiosHandler.getCurios();
            this.transferCuriosItems((NonNullList<ItemStack>)death.getMainInventory(), curios);
            this.transferCuriosItems((NonNullList<ItemStack>)death.getArmorInventory(), curios);
            this.transferCuriosItems((NonNullList<ItemStack>)death.getOffHandInventory(), curios);
            this.transferCuriosItems((NonNullList<ItemStack>)death.getAdditionalItems(), curios);
        }
        this.transferInventory((NonNullList<ItemStack>)death.getMainInventory(), (NonNullList<ItemStack>)player.m_150109_().f_35974_, (NonNullList<ItemStack>)unaddedItems);
        this.transferInventory((NonNullList<ItemStack>)death.getArmorInventory(), (NonNullList<ItemStack>)player.m_150109_().f_35975_, (NonNullList<ItemStack>)unaddedItems);
        this.transferInventory((NonNullList<ItemStack>)death.getOffHandInventory(), (NonNullList<ItemStack>)player.m_150109_().f_35976_, (NonNullList<ItemStack>)unaddedItems);
        death.getAdditionalItems().forEach(arg_0 -> unaddedItems.add(arg_0));
        NonNullList overflow = NonNullList.m_122779_();
        for (ItemStack stack : unaddedItems) {
            if (player.m_150109_().m_36054_(stack)) continue;
            overflow.add((Object)stack);
        }
        death.getAdditionalItems().clear();
        return overflow;
    }

    @Unique
    private void transferCuriosItems(NonNullList<ItemStack> inventory, Map<String, ICurioStacksHandler> curios) {
        for (int i = 0; i < inventory.size(); ++i) {
            ItemStack stack = (ItemStack)inventory.get(i);
            if (stack.m_41619_() || !this.tryTransferPreviouslyEquippedCurio(stack, curios)) continue;
            inventory.set(i, (Object)ItemStack.f_41583_);
        }
    }

    @Unique
    private boolean tryTransferPreviouslyEquippedCurio(ItemStack stack, Map<String, ICurioStacksHandler> curios) {
        if (stack.m_41619_()) {
            return false;
        }
        if (CuriosApi.getCuriosHelper().getCurioTags(stack.m_41720_()).isEmpty()) {
            return false;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_(CURIO_SLOT_TAG)) {
            return false;
        }
        CompoundTag slotData = tag.m_128469_(CURIO_SLOT_TAG);
        boolean wasEquipped = slotData.m_128471_(WAS_EQUIPPED);
        if (!wasEquipped) {
            return false;
        }
        if (Config.isItemBlacklisted(stack.m_41720_())) {
            return false;
        }
        String slotType = slotData.m_128461_(CURIO_SLOT_TYPE);
        int slotIndex = slotData.m_128451_(CURIO_SLOT_INDEX);
        ICurioStacksHandler handler = curios.get(slotType);
        if (handler != null && slotIndex >= 0 && slotIndex < handler.getSlots()) {
            try {
                ItemStack existingStack = handler.getStacks().getStackInSlot(slotIndex);
                if (existingStack.m_41619_()) {
                    ItemStack cleanStack = stack.m_41777_();
                    this.cleanNbtData(cleanStack);
                    handler.getStacks().setStackInSlot(slotIndex, cleanStack);
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.tryFindAnyCompatibleSlot(stack, curios);
    }

    @Unique
    private boolean tryFindAnyCompatibleSlot(ItemStack stack, Map<String, ICurioStacksHandler> curios) {
        for (String slotType : CuriosApi.getCuriosHelper().getCurioTags(stack.m_41720_())) {
            ICurioStacksHandler handler = curios.get(slotType);
            if (handler == null) continue;
            for (int slot = 0; slot < handler.getSlots(); ++slot) {
                try {
                    if (!handler.getStacks().getStackInSlot(slot).m_41619_()) continue;
                    ItemStack cleanStack = stack.m_41777_();
                    this.cleanNbtData(cleanStack);
                    handler.getStacks().setStackInSlot(slot, cleanStack);
                    return true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    @Unique
    private void cleanNbtData(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_(CURIO_SLOT_TAG)) {
            tag.m_128473_(CURIO_SLOT_TAG);
            if (tag.m_128456_()) {
                stack.m_41751_(null);
            }
        }
    }

    @Unique
    private void transferInventory(NonNullList<ItemStack> source, NonNullList<ItemStack> destination, NonNullList<ItemStack> unaddedItems) {
        for (int i = 0; i < source.size() && i < destination.size(); ++i) {
            ItemStack stack = (ItemStack)source.get(i);
            if (stack.m_41619_()) continue;
            ItemStack currentStack = (ItemStack)destination.get(i);
            if (!currentStack.m_41619_()) {
                unaddedItems.add((Object)currentStack);
            }
            destination.set(i, (Object)stack);
            source.set(i, (Object)ItemStack.f_41583_);
        }
    }
}

