/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.compat.jei;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraftforge.registries.ForgeRegistries;
import net.p3pp3rf1y.sophisticatedcore.compat.jei.ClientRecipeHelper;
import net.p3pp3rf1y.sophisticatedstorage.crafting.DoubleChestTierUpgradeRecipe;
import net.p3pp3rf1y.sophisticatedstorage.crafting.DoubleChestTierUpgradeShapelessRecipe;
import net.p3pp3rf1y.sophisticatedstorage.crafting.StorageTierUpgradeRecipe;
import net.p3pp3rf1y.sophisticatedstorage.crafting.StorageTierUpgradeShapelessRecipe;
import net.p3pp3rf1y.sophisticatedstorage.item.ChestBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import org.jetbrains.annotations.NotNull;

public class TierUpgradeRecipesMaker {
    private TierUpgradeRecipesMaker() {
    }

    public static List<CraftingRecipe> getShapedCraftingRecipes() {
        RecipeConstructor<StorageTierUpgradeRecipe> constructRecipe = (originalRecipe, id, ingredients, result) -> new ShapedRecipe(id, "", CraftingBookCategory.MISC, originalRecipe.getRecipeWidth(), originalRecipe.getRecipeHeight(), ingredients, result);
        List<CraftingRecipe> craftingRecipes = TierUpgradeRecipesMaker.getCraftingRecipes(constructRecipe, StorageTierUpgradeRecipe.REGISTERED_RECIPES, StorageTierUpgradeRecipe.class, TierUpgradeRecipesMaker::getStorageItems);
        RecipeConstructor<DoubleChestTierUpgradeRecipe> constructDoubleChestRecipe = (originalRecipe, id, ingredients, result) -> new ShapedRecipe(id, "", CraftingBookCategory.MISC, originalRecipe.getRecipeWidth(), originalRecipe.getRecipeHeight(), ingredients, result);
        craftingRecipes.addAll(TierUpgradeRecipesMaker.getCraftingRecipes(constructDoubleChestRecipe, DoubleChestTierUpgradeRecipe.REGISTERED_RECIPES, DoubleChestTierUpgradeRecipe.class, TierUpgradeRecipesMaker::getDoubleChestItems));
        return craftingRecipes;
    }

    public static List<CraftingRecipe> getShapelessCraftingRecipes() {
        RecipeConstructor<StorageTierUpgradeShapelessRecipe> constructRecipe = (originalRecipe, id, ingredients, result) -> new ShapelessRecipe(id, "", CraftingBookCategory.MISC, result, ingredients);
        List<CraftingRecipe> craftingRecipes = TierUpgradeRecipesMaker.getCraftingRecipes(constructRecipe, StorageTierUpgradeShapelessRecipe.REGISTERED_RECIPES, StorageTierUpgradeShapelessRecipe.class, TierUpgradeRecipesMaker::getStorageItems);
        RecipeConstructor<DoubleChestTierUpgradeShapelessRecipe> constructDoubleChestRecipe = (originalRecipe, id, ingredients, result) -> new ShapelessRecipe(id, "", CraftingBookCategory.MISC, result, ingredients);
        craftingRecipes.addAll(TierUpgradeRecipesMaker.getCraftingRecipes(constructDoubleChestRecipe, DoubleChestTierUpgradeShapelessRecipe.REGISTERED_RECIPES, DoubleChestTierUpgradeShapelessRecipe.class, TierUpgradeRecipesMaker::getDoubleChestItems));
        return craftingRecipes;
    }

    @NotNull
    private static <T extends CraftingRecipe> List<CraftingRecipe> getCraftingRecipes(RecipeConstructor<T> constructRecipe, Set<ResourceLocation> registeredRecipes, Class<T> originalRecipeClass, Function<CraftingRecipe, List<ItemStack>> getStorageItems) {
        return ClientRecipeHelper.getAndTransformAvailableItemGroupRecipes(registeredRecipes, originalRecipeClass, recipe -> {
            ArrayList itemGroupRecipes = new ArrayList();
            ((List)getStorageItems.apply((CraftingRecipe)recipe)).forEach(storageItem -> {
                NonNullList ingredients = recipe.m_7527_();
                TransientCraftingContainer craftinginventory = new TransientCraftingContainer(new AbstractContainerMenu(null, -1){

                    public ItemStack m_7648_(Player pPlayer, int pIndex) {
                        return ItemStack.f_41583_;
                    }

                    public boolean m_6875_(Player playerIn) {
                        return false;
                    }
                }, 3, 3);
                NonNullList ingredientsCopy = NonNullList.m_182647_((int)ingredients.size());
                int i = 0;
                for (Ingredient ingredient : ingredients) {
                    ItemStack[] ingredientItems = ingredient.m_43908_();
                    if (ingredientItems.length == 1 && storageItem.m_41720_() == ingredientItems[0].m_41720_()) {
                        ingredientsCopy.add(i, (Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{storageItem}));
                        craftinginventory.m_6836_(i, storageItem.m_41777_());
                    } else {
                        ingredientsCopy.add(i, (Object)ingredient);
                        if (!ingredient.m_43947_()) {
                            craftinginventory.m_6836_(i, ingredientItems[0]);
                        }
                    }
                    ++i;
                }
                ItemStack result = ClientRecipeHelper.assemble((Recipe)recipe, (Container)craftinginventory);
                ResourceLocation id = new ResourceLocation("sophisticatedstorage", "tier_upgrade_" + ForgeRegistries.ITEMS.getKey((Object)storageItem.m_41720_()).m_135815_() + result.m_41784_().toString().toLowerCase(Locale.ROOT).replaceAll("[{\",}: ]", "_"));
                itemGroupRecipes.add(constructRecipe.construct(recipe, id, (NonNullList<Ingredient>)ingredientsCopy, result));
            });
            return itemGroupRecipes;
        });
    }

    private static List<ItemStack> getDoubleChestItems(CraftingRecipe recipe) {
        NonNullList doubleChestItems = NonNullList.m_122779_();
        for (Ingredient ingredient : recipe.m_7527_()) {
            ItemStack[] ingredientItems;
            for (ItemStack ingredientItem : ingredientItems = ingredient.m_43908_()) {
                Item item = ingredientItem.m_41720_();
                if (!(item instanceof ChestBlockItem)) continue;
                ChestBlockItem chestBlockItem = (ChestBlockItem)item;
                chestBlockItem.addCreativeTabItems(stack -> {
                    ChestBlockItem.setDoubleChest(stack, true);
                    doubleChestItems.add(stack);
                });
            }
        }
        return doubleChestItems;
    }

    private static List<ItemStack> getStorageItems(CraftingRecipe recipe) {
        NonNullList storageItems = NonNullList.m_122779_();
        for (Ingredient ingredient : recipe.m_7527_()) {
            ItemStack[] ingredientItems;
            for (ItemStack ingredientItem : ingredientItems = ingredient.m_43908_()) {
                Item item = ingredientItem.m_41720_();
                if (!(item instanceof StorageBlockItem)) continue;
                StorageBlockItem storageBlockItem = (StorageBlockItem)item;
                storageBlockItem.addCreativeTabItems(arg_0 -> storageItems.add(arg_0));
            }
        }
        return storageItems;
    }

    private static interface RecipeConstructor<T extends Recipe<?>> {
        public CraftingRecipe construct(T var1, ResourceLocation var2, NonNullList<Ingredient> var3, ItemStack var4);
    }
}

