/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.IItemHandlerSimpleInserter;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageIOBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StorageOutputBlockEntity
extends StorageIOBlockEntity {
    public StorageOutputBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlocks.STORAGE_OUTPUT_BLOCK_ENTITY_TYPE.get(), pos, state);
    }

    @Override
    @Nullable
    protected <T> Direction getAdjustedCapabilitySide(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return null;
        }
        return super.getAdjustedCapabilitySide(cap, side);
    }

    @Override
    protected <T> T wrapCapability(Capability<T> cap, T capability) {
        if (cap == ForgeCapabilities.ITEM_HANDLER && capability instanceof IItemHandlerSimpleInserter) {
            return (T)new OutputOnlyItemHandlerWrapper((IItemHandlerSimpleInserter)capability);
        }
        return super.wrapCapability(cap, capability);
    }

    private static class OutputOnlyItemHandlerWrapper
    implements IItemHandler {
        private final IItemHandlerSimpleInserter itemHandler;

        public OutputOnlyItemHandlerWrapper(IItemHandlerSimpleInserter itemHandler) {
            this.itemHandler = itemHandler;
        }

        public int getSlots() {
            return this.itemHandler.getSlots();
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return this.itemHandler.getStackInSlot(slot);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            return stack;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.itemHandler.extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return this.itemHandler.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return false;
        }
    }
}

