/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.IItemHandlerSimpleInserter;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageIOBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StorageInputBlockEntity
extends StorageIOBlockEntity {
    public StorageInputBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlocks.STORAGE_INPUT_BLOCK_ENTITY_TYPE.get(), pos, state);
    }

    @Override
    @Nullable
    protected <T> Direction getAdjustedCapabilitySide(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return null;
        }
        return super.getAdjustedCapabilitySide(cap, side);
    }

    @Override
    protected <T> T wrapCapability(Capability<T> cap, T capability) {
        if (cap == ForgeCapabilities.ITEM_HANDLER && capability instanceof IItemHandlerSimpleInserter) {
            return (T)new SingleSlotInputItemHandlerWrapper((IItemHandlerSimpleInserter)capability);
        }
        return super.wrapCapability(cap, capability);
    }

    private static class SingleSlotInputItemHandlerWrapper
    implements IItemHandler {
        private final IItemHandlerSimpleInserter itemHandler;

        public SingleSlotInputItemHandlerWrapper(IItemHandlerSimpleInserter itemHandler) {
            this.itemHandler = itemHandler;
        }

        public int getSlots() {
            return 1;
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return ItemStack.f_41583_;
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            return this.itemHandler.insertItem(stack, simulate);
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.f_41583_;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return true;
        }
    }
}

