/*
 * Decompiled with CFR 0.152.
 */
package kalrog.cc_printers_plus.data;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.AABB;

public class Shape {
    private final AABB bounds;
    @Nullable
    private final ResourceLocation texture;
    @Nullable
    private final Integer tint;

    public Shape(AABB bounds, @Nullable ResourceLocation texture, @Nullable Integer tint) {
        this.bounds = bounds;
        this.texture = texture;
        this.tint = tint;
    }

    public AABB getBounds() {
        return this.bounds;
    }

    @Nullable
    public ResourceLocation getTexture() {
        return this.texture;
    }

    @Nullable
    public Integer getTint() {
        return this.tint;
    }

    public CompoundTag toNbt() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128344_("minX", (byte)Shape.clamp((int)this.bounds.f_82288_, 0, 16));
        nbt.m_128344_("minY", (byte)Shape.clamp((int)this.bounds.f_82289_, 0, 16));
        nbt.m_128344_("minZ", (byte)Shape.clamp((int)this.bounds.f_82290_, 0, 16));
        nbt.m_128344_("maxX", (byte)Shape.clamp((int)this.bounds.f_82291_, 0, 16));
        nbt.m_128344_("maxY", (byte)Shape.clamp((int)this.bounds.f_82292_, 0, 16));
        nbt.m_128344_("maxZ", (byte)Shape.clamp((int)this.bounds.f_82293_, 0, 16));
        nbt.m_128359_("tex", this.texture != null ? this.texture.toString() : "");
        if (this.tint != null) {
            nbt.m_128405_("tint", this.tint.intValue());
        }
        return nbt;
    }

    public static Shape fromNbt(CompoundTag nbt) {
        AABB bounds = new AABB(Shape.byteToDouble(nbt.m_128445_("minX")), Shape.byteToDouble(nbt.m_128445_("minY")), Shape.byteToDouble(nbt.m_128445_("minZ")), Shape.byteToDouble(nbt.m_128445_("maxX")), Shape.byteToDouble(nbt.m_128445_("maxY")), Shape.byteToDouble(nbt.m_128445_("maxZ")));
        String texString = nbt.m_128461_("tex");
        ResourceLocation texture = texString.isEmpty() ? null : new ResourceLocation(texString);
        Integer tint = nbt.m_128441_("tint") ? Integer.valueOf(nbt.m_128451_("tint")) : null;
        return new Shape(bounds, texture, tint);
    }

    private static int clamp(int value, int min, int max) {
        return Math.max(min, Math.min(max, value));
    }

    private static double byteToDouble(byte b) {
        return b;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Shape shape = (Shape)o;
        return Objects.equals(this.bounds, shape.bounds) && Objects.equals(this.texture, shape.texture) && Objects.equals(this.tint, shape.tint);
    }

    public int hashCode() {
        return Objects.hash(this.bounds, this.texture, this.tint);
    }
}

