/*
 * Decompiled with CFR 0.152.
 */
package kalrog.cc_printers_plus.block.entity;

import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import kalrog.cc_printers_plus.Config;
import kalrog.cc_printers_plus.Registration;
import kalrog.cc_printers_plus.data.PrintData;
import kalrog.cc_printers_plus.item.PrintItem;
import kalrog.cc_printers_plus.menu.PrinterMenu;
import kalrog.cc_printers_plus.network.NetworkHandler;
import kalrog.cc_printers_plus.network.PrinterDataPacket;
import kalrog.cc_printers_plus.peripheral.PrinterPeripheral;
import kalrog.cc_printers_plus.util.BaseBlockEntity;
import kalrog.cc_printers_plus.util.ImplementedInventory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class PrinterBlockEntity
extends BaseBlockEntity
implements MenuProvider,
ImplementedInventory,
WorldlyContainer {
    public static final int INV_SIZE = 3;
    public static final int CHAMELIUM_SLOT = 0;
    public static final int INK_SLOT = 1;
    public static final int OUTPUT_SLOT = 2;
    public static final int MAX_CHAMELIUM = 256000;
    public static final int MAX_INK = 100000;
    private final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);
    private final Set<IComputerAccess> computers = Collections.newSetFromMap(new ConcurrentHashMap());
    public PrintData data = new PrintData();
    public boolean printing = false;
    public int printCount = 0;
    public int chamelium = 0;
    public int ink = 0;
    public int printProgress = 0;
    public int maxPrintProgress = Config.printerPrintTicks;
    public ItemStack outputStack = ItemStack.f_41583_;
    public PrintData previewData = null;
    public PrinterPeripheral peripheral = null;
    private final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> PrinterBlockEntity.this.chamelium & 0xFFFF;
                case 1 -> PrinterBlockEntity.this.chamelium >> 16 & 0xFFFF;
                case 2 -> PrinterBlockEntity.this.ink & 0xFFFF;
                case 3 -> PrinterBlockEntity.this.ink >> 16 & 0xFFFF;
                case 4 -> PrinterBlockEntity.this.printProgress;
                case 5 -> PrinterBlockEntity.this.maxPrintProgress;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    PrinterBlockEntity.this.chamelium = PrinterBlockEntity.this.chamelium & 0xFFFF0000 | value & 0xFFFF;
                    break;
                }
                case 1: {
                    PrinterBlockEntity.this.chamelium = PrinterBlockEntity.this.chamelium & 0xFFFF | (value & 0xFFFF) << 16;
                    break;
                }
                case 2: {
                    PrinterBlockEntity.this.ink = PrinterBlockEntity.this.ink & 0xFFFF0000 | value & 0xFFFF;
                    break;
                }
                case 3: {
                    PrinterBlockEntity.this.ink = PrinterBlockEntity.this.ink & 0xFFFF | (value & 0xFFFF) << 16;
                    break;
                }
                case 4: {
                    PrinterBlockEntity.this.printProgress = value;
                    break;
                }
                case 5: {
                    PrinterBlockEntity.this.maxPrintProgress = value;
                }
            }
        }

        public int m_6499_() {
            return 6;
        }
    };
    private static final int[] SLOTS_FOR_OUTPUT = new int[]{2};
    private static final int[] SLOTS_FOR_INPUT = new int[]{0, 1};
    private static final int[] ALL_SLOTS = new int[]{0, 1, 2};

    public PrinterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registration.PRINTER_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.cc_printers_plus.printer");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
        return new PrinterMenu(containerId, playerInventory, this, this.dataAccess);
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (level.f_46443_) {
            return;
        }
        this.processInputSlots();
        if (this.printing && this.outputStack.m_41619_() && this.printCount > 0) {
            if (this.canPrint() && this.canMergeOutput()) {
                PrintData.Pair<Integer, Integer> costs = this.data.computeCosts();
                if (costs != null) {
                    this.chamelium -= ((Integer)costs.first).intValue();
                    this.ink -= ((Integer)costs.second).intValue();
                }
                this.outputStack = this.data.toItemStack();
                this.printProgress = 0;
                --this.printCount;
                this.m_6596_();
                this.syncToClient();
            } else if (!this.canPrint()) {
                this.printing = false;
                this.printCount = 0;
                this.printProgress = 0;
                this.queueEvent("out_of_materials");
                this.m_6596_();
            }
        }
        if (!this.outputStack.m_41619_()) {
            ++this.printProgress;
            if (this.printProgress >= this.maxPrintProgress) {
                ItemStack existing = this.m_8020_(2);
                if (existing.m_41619_()) {
                    this.m_6836_(2, this.outputStack);
                    this.outputStack = ItemStack.f_41583_;
                    this.printProgress = 0;
                    if (this.printCount <= 0) {
                        this.printing = false;
                        this.queueEvent("complete");
                    } else {
                        this.queueEvent("progress");
                    }
                    this.m_6596_();
                } else if (ItemStack.m_150942_((ItemStack)existing, (ItemStack)this.outputStack) && existing.m_41613_() < existing.m_41741_()) {
                    existing.m_41769_(1);
                    this.outputStack = ItemStack.f_41583_;
                    this.printProgress = 0;
                    if (this.printCount <= 0) {
                        this.printing = false;
                        this.queueEvent("complete");
                    } else {
                        this.queueEvent("progress");
                    }
                    this.m_6596_();
                }
            }
        }
    }

    private void processInputSlots() {
        ItemStack removed;
        int inputInkValue;
        ItemStack inkStack;
        ItemStack removed2;
        int inputChameliumValue;
        ItemStack chameliumStack = this.m_8020_(0);
        if (!chameliumStack.m_41619_() && (inputChameliumValue = this.getChameliumValue(chameliumStack)) > 0 && 256000 - this.chamelium >= inputChameliumValue && !(removed2 = this.m_7407_(0, 1)).m_41619_()) {
            this.chamelium += inputChameliumValue;
            this.m_6596_();
            this.syncToClient();
        }
        if (!(inkStack = this.m_8020_(1)).m_41619_() && (inputInkValue = this.getInkValue(inkStack)) > 0 && 100000 - this.ink >= inputInkValue && !(removed = this.m_7407_(1, 1)).m_41619_()) {
            this.ink += inputInkValue;
            this.m_6596_();
            this.syncToClient();
            this.m_6836_(1, new ItemStack((ItemLike)Registration.EMPTY_INK_CARTRIDGE.get()));
        }
    }

    private int getChameliumValue(ItemStack stack) {
        PrintData.Pair<Integer, Integer> costs;
        PrintData data;
        if (stack.m_150930_((Item)Registration.CHAMELIUM_ITEM.get())) {
            return Config.printerChameliumValue;
        }
        if (stack.m_150930_((Item)Registration.PRINT_ITEM.get()) && (data = PrintItem.getPrintData(stack)) != null && (costs = data.computeCosts()) != null) {
            return (Integer)costs.first;
        }
        return 0;
    }

    private int getInkValue(ItemStack stack) {
        if (stack.m_150930_((Item)Registration.INK_CARTRIDGE.get())) {
            return Config.printerInkValue;
        }
        return 0;
    }

    private void queueEvent(String event) {
        for (IComputerAccess computer : this.computers) {
            computer.queueEvent(event, new Object[]{computer.getAttachmentName()});
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("chamelium", this.chamelium);
        tag.m_128405_("ink", this.ink);
        tag.m_128405_("printProgress", this.printProgress);
        tag.m_128379_("printing", this.printing);
        tag.m_128405_("printCount", this.printCount);
        ContainerHelper.m_18973_((CompoundTag)tag, this.inventory);
        if (!this.outputStack.m_41619_()) {
            tag.m_128365_("outputStack", (Tag)this.outputStack.m_41739_(new CompoundTag()));
        }
        if (this.data != null) {
            tag.m_128365_("printData", (Tag)this.data.toNbt());
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.chamelium = tag.m_128451_("chamelium");
        this.ink = tag.m_128451_("ink");
        this.printProgress = tag.m_128451_("printProgress");
        this.printing = tag.m_128471_("printing");
        this.printCount = tag.m_128451_("printCount");
        ContainerHelper.m_18980_((CompoundTag)tag, this.inventory);
        this.outputStack = tag.m_128441_("outputStack") ? ItemStack.m_41712_((CompoundTag)tag.m_128469_("outputStack")) : ItemStack.f_41583_;
        this.data = tag.m_128441_("printData") ? PrintData.fromNbt(tag.m_128469_("printData")) : new PrintData();
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    private void syncToClient() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public ItemStack getPreviewStack() {
        if (this.previewData != null && !this.previewData.isEmpty()) {
            return this.previewData.toItemStack();
        }
        return ItemStack.f_41583_;
    }

    public int getChamelium() {
        return this.chamelium;
    }

    public int getInk() {
        return this.ink;
    }

    public PrintData getData() {
        return this.data;
    }

    public void setData(PrintData data) {
        this.data = data;
        this.markDataDirty();
    }

    public void markDataDirty() {
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            NetworkHandler.sendToClientsTracking(new PrinterDataPacket(this.f_58858_, this.data), this.f_58857_, this.f_58858_);
        }
    }

    public boolean canPrint() {
        if (this.data == null || this.data.isEmpty()) {
            return false;
        }
        PrintData.Pair<Integer, Integer> costs = this.data.computeCosts();
        if (costs == null) {
            return false;
        }
        return this.chamelium >= (Integer)costs.first && this.ink >= (Integer)costs.second;
    }

    private boolean canMergeOutput() {
        ItemStack current = this.m_8020_(2);
        ItemStack output = this.data.toItemStack();
        return current.m_41619_() || ItemStack.m_150942_((ItemStack)current, (ItemStack)output);
    }

    public void setPrinting(boolean printing) {
        this.printing = printing;
        this.m_6596_();
    }

    public void setPrintCount(int count) {
        this.printCount = count;
        this.m_6596_();
    }

    public void dataUpdated() {
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public MethodResult getStatus() {
        if (this.printing) {
            return MethodResult.of((Object[])new Object[]{"busy", this.printProgress, this.maxPrintProgress});
        }
        return MethodResult.of((Object)"idle");
    }

    public void attachComputer(IComputerAccess computer) {
        this.computers.add(computer);
    }

    public void detachComputer(IComputerAccess computer) {
        this.computers.remove(computer);
    }

    public int[] m_7071_(Direction side) {
        return ALL_SLOTS;
    }

    public boolean m_7155_(int index, ItemStack stack, @Nullable Direction direction) {
        return index == 0 || index == 1;
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return index == 2 && direction == Direction.DOWN || direction != Direction.DOWN;
    }
}

