/*
 * Decompiled with CFR 0.152.
 */
package kalrog.cc_printers_plus.block.entity;

import javax.annotation.Nullable;
import kalrog.cc_printers_plus.Registration;
import kalrog.cc_printers_plus.block.PrintBlock;
import kalrog.cc_printers_plus.client.model.PrintBakedModel;
import kalrog.cc_printers_plus.data.PrintData;
import kalrog.cc_printers_plus.util.BaseBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;

public class PrintBlockEntity
extends BaseBlockEntity {
    private PrintData printData = null;

    public PrintBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registration.PRINT_BLOCK_ENTITY.get(), pos, state);
    }

    @Nullable
    public PrintData getPrintData() {
        return this.printData;
    }

    public void setPrintData(@Nullable PrintData data) {
        this.printData = data;
        this.m_6596_();
    }

    @NotNull
    public ModelData getModelData() {
        ModelData.Builder builder = ModelData.builder();
        BlockState state = this.m_58900_();
        if (this.printData != null) {
            builder.with(PrintBakedModel.SHAPES_PROPERTY, (Object)((Boolean)state.m_61143_((Property)PrintBlock.ON) != false ? this.printData.getShapesOn() : this.printData.getShapesOff()));
        }
        Direction facing = (Direction)state.m_61143_((Property)PrintBlock.FACING);
        builder.with(PrintBakedModel.FACING_PROPERTY, (Object)facing);
        return builder.build();
    }

    public boolean hasCollision() {
        if (this.printData == null) {
            return true;
        }
        BlockState state = this.m_58900_();
        boolean on = (Boolean)state.m_61143_((Property)PrintBlock.ON);
        return on ? this.printData.isCollideWhenOn() : this.printData.isCollideWhenOff();
    }

    public boolean canTurnOn() {
        return this.printData != null && !this.printData.getShapesOn().isEmpty();
    }

    public void toggle() {
        Level level = this.m_58904_();
        if (level == null || level.f_46443_ || this.printData == null) {
            return;
        }
        BlockState state = this.m_58900_();
        if (!(state.m_60734_() instanceof PrintBlock)) {
            return;
        }
        boolean currentOn = (Boolean)state.m_61143_((Property)PrintBlock.ON);
        boolean newOn = !currentOn;
        boolean hasLight = newOn ? this.printData.isLightWhenOn() : this.printData.isLightWhenOff();
        int luminance = hasLight ? this.printData.getLightLevel() : 0;
        BlockState newState = (BlockState)((BlockState)state.m_61124_((Property)PrintBlock.ON, (Comparable)Boolean.valueOf(newOn))).m_61124_((Property)PrintBlock.LUMINANCE, (Comparable)Integer.valueOf(luminance));
        level.m_7731_(this.f_58858_, newState, 3);
        if (!this.printData.isQuiet()) {
            float pitch = newOn ? 0.6f : 0.5f;
            level.m_5594_(null, this.f_58858_, SoundEvents.f_12088_, SoundSource.BLOCKS, 0.3f, pitch);
        }
        level.m_46672_(this.f_58858_, state.m_60734_());
        if (newOn && this.printData.isButton()) {
            level.m_186460_(this.f_58858_, state.m_60734_(), 20);
        }
        this.requestModelDataUpdate();
    }

    public int getRedstoneOutput() {
        if (this.printData == null || this.printData.getRedstoneLevel() == 0) {
            return 0;
        }
        BlockState state = this.m_58900_();
        boolean on = (Boolean)state.m_61143_((Property)PrintBlock.ON);
        boolean canToggle = this.canTurnOn();
        boolean emitsRedstoneWhenOff = this.printData.getRedstoneLevel() > 0 && !canToggle;
        boolean emitsRedstoneWhenOn = this.printData.getRedstoneLevel() > 0 && canToggle;
        boolean emitting = on ? emitsRedstoneWhenOn : emitsRedstoneWhenOff;
        return emitting ? this.printData.getRedstoneLevel() : 0;
    }

    public void updateRedstoneInput() {
        boolean currentOn;
        BlockState state;
        boolean isPowered;
        Level level = this.m_58904_();
        if (level == null || level.f_46443_ || this.printData == null) {
            return;
        }
        if (this.printData.getRedstoneLevel() > 0) {
            return;
        }
        if (this.canTurnOn() && (isPowered = ((Boolean)(state = this.m_58900_()).m_61143_((Property)PrintBlock.POWERED)).booleanValue()) != (currentOn = ((Boolean)state.m_61143_((Property)PrintBlock.ON)).booleanValue())) {
            this.toggle();
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.printData != null) {
            tag.m_128365_("printData", (Tag)this.printData.toNbt());
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("printData")) {
            this.printData = PrintData.fromNbt(tag.m_128469_("printData"));
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        if (this.printData != null) {
            tag.m_128365_("printData", (Tag)this.printData.toNbt());
        }
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, PrintBlockEntity blockEntity) {
    }
}

