/*
 * Decompiled with CFR 0.152.
 */
package kalrog.cc_printers_plus;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="cc_printers_plus", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.IntValue PRINTER_PRINT_TICKS;
    private static final ForgeConfigSpec.IntValue PRINTER_CHAMELIUM_VALUE;
    private static final ForgeConfigSpec.IntValue PRINTER_INK_VALUE;
    private static final ForgeConfigSpec.IntValue PRINTER_MAX_BASE_LIGHT_LEVEL;
    private static final ForgeConfigSpec.IntValue PRINTER_MAX_SHAPES;
    private static final ForgeConfigSpec.IntValue PRINTER_CUSTOM_REDSTONE_COST;
    private static final ForgeConfigSpec.IntValue PRINTER_NOCLIP_COST_MULTIPLIER;
    private static final ForgeConfigSpec.DoubleValue PRINTER_RECYCLE_VALUE_MULTIPLIER;
    private static final ForgeConfigSpec.IntValue POSTER_PRINTER_PRINT_TICKS;
    private static final ForgeConfigSpec.IntValue POSTER_PRINTER_INK_COST;
    private static final ForgeConfigSpec.BooleanValue PROMETHEUS_ENABLED;
    private static final ForgeConfigSpec.IntValue PROMETHEUS_PORT;
    static final ForgeConfigSpec SPEC;
    public static int printerPrintTicks;
    public static int printerChameliumValue;
    public static int printerInkValue;
    public static int printerMaxBaseLightLevel;
    public static int printerMaxShapes;
    public static int printerCustomRedstoneCost;
    public static int printerNoclipCostMultiplier;
    public static double printerRecycleValueMultiplier;
    public static int posterPrinterPrintTicks;
    public static int posterPrinterInkCost;
    public static boolean prometheusEnabled;
    public static int prometheusPort;

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        printerPrintTicks = (Integer)PRINTER_PRINT_TICKS.get();
        printerChameliumValue = (Integer)PRINTER_CHAMELIUM_VALUE.get();
        printerInkValue = (Integer)PRINTER_INK_VALUE.get();
        printerMaxBaseLightLevel = (Integer)PRINTER_MAX_BASE_LIGHT_LEVEL.get();
        printerMaxShapes = (Integer)PRINTER_MAX_SHAPES.get();
        printerCustomRedstoneCost = (Integer)PRINTER_CUSTOM_REDSTONE_COST.get();
        printerNoclipCostMultiplier = (Integer)PRINTER_NOCLIP_COST_MULTIPLIER.get();
        printerRecycleValueMultiplier = (Double)PRINTER_RECYCLE_VALUE_MULTIPLIER.get();
        posterPrinterPrintTicks = (Integer)POSTER_PRINTER_PRINT_TICKS.get();
        posterPrinterInkCost = (Integer)POSTER_PRINTER_INK_COST.get();
        prometheusEnabled = (Boolean)PROMETHEUS_ENABLED.get();
        prometheusPort = (Integer)PROMETHEUS_PORT.get();
    }

    static {
        BUILDER.push("printer");
        PRINTER_PRINT_TICKS = BUILDER.comment("Number of ticks required to print one item").defineInRange("print_ticks", 100, 1, 1000);
        PRINTER_CHAMELIUM_VALUE = BUILDER.comment("Chamelium value per item/block").defineInRange("chamelium_value", 2000, 1, 1000000);
        PRINTER_INK_VALUE = BUILDER.comment("Ink value per cartridge").defineInRange("ink_value", 50000, 1, 1000000);
        PRINTER_MAX_BASE_LIGHT_LEVEL = BUILDER.comment("Maximum base light level for prints").defineInRange("max_base_light_level", 7, 0, 15);
        PRINTER_MAX_SHAPES = BUILDER.comment("Maximum number of shapes allowed in a print").defineInRange("max_shapes", 128, 1, 1024);
        PRINTER_CUSTOM_REDSTONE_COST = BUILDER.comment("Additional chamelium cost for custom redstone levels").defineInRange("custom_redstone_cost", 300, 0, 10000);
        PRINTER_NOCLIP_COST_MULTIPLIER = BUILDER.comment("Cost multiplier for non-solid prints").defineInRange("noclip_cost_multiplier", 2, 1, 10);
        PRINTER_RECYCLE_VALUE_MULTIPLIER = BUILDER.comment("Multiplier for recycling prints back to chamelium").defineInRange("recycle_value_multiplier", 0.75, 0.0, 1.0);
        BUILDER.pop();
        BUILDER.push("poster_printer");
        POSTER_PRINTER_PRINT_TICKS = BUILDER.comment("Number of ticks required to print one poster").defineInRange("print_ticks", 100, 1, 1000);
        POSTER_PRINTER_INK_COST = BUILDER.comment("Ink cost per poster").defineInRange("ink_cost", 5000, 1, 100000);
        BUILDER.pop();
        BUILDER.push("prometheus");
        PROMETHEUS_ENABLED = BUILDER.comment("Enable Prometheus metrics endpoint (requires restart)").define("enabled", false);
        PROMETHEUS_PORT = BUILDER.comment("Port for Prometheus metrics endpoint").defineInRange("port", 9090, 1024, 65535);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

