/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.modules.forge.blocks_plus;

import blocks_plus.blocks.BPCrackedMossyPlanks;
import blocks_plus.blocks.BPCraftingTable;
import blocks_plus.blocks.BPPlankBookshelf;
import blocks_plus.blocks.BPPlankSlab;
import blocks_plus.blocks.BPPlankStairs;
import blocks_plus.blocks.BPPlanks;
import java.util.Objects;
import java.util.function.Consumer;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.RenderLayer;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.common_classes.CompatChestBlock;
import net.mehvahdjukaar.every_compat.common_classes.CompatChestBlockEntity;
import net.mehvahdjukaar.every_compat.common_classes.CompatChestBlockRenderer;
import net.mehvahdjukaar.every_compat.common_classes.CompatChestItem;
import net.mehvahdjukaar.every_compat.common_classes.CompatChestTexture;
import net.mehvahdjukaar.every_compat.common_classes.CompatTrappedChestBlock;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlocksPlusModule
extends SimpleModule {
    public final SimpleEntrySet<WoodType, Block> cracked_planks;
    public final SimpleEntrySet<WoodType, Block> mossy_planks;
    public final SimpleEntrySet<WoodType, Block> crafting_table;
    public final SimpleEntrySet<WoodType, Block> chest;
    public final SimpleEntrySet<WoodType, Block> trapped_chest;
    public final SimpleEntrySet<WoodType, Block> bookshelf;
    public final SimpleEntrySet<WoodType, Block> wooden_crate;
    public final SimpleEntrySet<WoodType, Block> ladder;
    public final SimpleEntrySet<WoodType, Block> mosaic;
    public final SimpleEntrySet<WoodType, Block> mosaic_stairs;
    public final SimpleEntrySet<WoodType, Block> mosaic_slab;
    public final SimpleEntrySet<WoodType, Block> mosaic_pressure_plate;
    public final SimpleEntrySet<WoodType, Block> cracked_mosaic;
    public final SimpleEntrySet<WoodType, Block> mossy_mosaic;

    public BlocksPlusModule(String modId) {
        super(modId, "bp");
        ResourceLocation tab = this.modRes("creative_tab");
        this.cracked_planks = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "planks", "cracked", this.getModBlock("cracked_acacia_planks"), () -> WoodTypeRegistry.getValue((String)"acacia"), w -> new BPCrackedMossyPlanks(Utils.copyPropertySafe((Block)w.planks))).addTexture(this.modRes("block/cracked_acacia_planks"))).addTag(BlockTags.f_144280_, Registries.f_256747_)).setTabKey(tab)).defaultRecipe().build();
        this.addEntry(this.cracked_planks);
        this.mossy_planks = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "planks", "mossy", this.getModBlock("mossy_acacia_planks"), () -> WoodTypeRegistry.getValue((String)"acacia"), w -> new BPCrackedMossyPlanks(Utils.copyPropertySafe((Block)w.planks))).addTextureM(this.modRes("block/mossy_acacia_planks"), EveryCompat.res("block/bp/mossy_acacia_planks_m"))).addTag(BlockTags.f_144280_, Registries.f_256747_)).setTabKey(tab)).defaultRecipe().build();
        this.addEntry(this.mossy_planks);
        this.crafting_table = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "crafting_table", this.getModBlock("acacia_crafting_table"), () -> WoodTypeRegistry.getValue((String)"acacia"), w -> new BPCraftingTable(Utils.copyPropertySafe((Block)Blocks.f_50091_).m_284180_(w.getColor()))).addTextureM(this.modRes("block/acacia_crafting_table_side"), EveryCompat.res("block/vanilla_crafting_table_side_m"))).addTextureM(this.modRes("block/acacia_crafting_table_front"), EveryCompat.res("block/vanilla_crafting_table_front_m"))).addTextureM(this.modRes("block/acacia_crafting_table_top"), EveryCompat.res("block/vanilla_crafting_table_top_m"))).addTag(BlockTags.f_144280_, Registries.f_256747_)).setTabKey(tab)).defaultRecipe().build();
        this.addEntry(this.crafting_table);
        this.chest = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "chest", this.getModBlock("acacia_chest"), () -> WoodTypeRegistry.getValue((String)"acacia"), w -> new CompatChestBlock(this::getChestTile, Utils.copyPropertySafe((Block)Blocks.f_50087_).m_284180_(w.getColor()))).addTile((x$0, x$1) -> new bpChestBlockEntity((BlockPos)x$0, (BlockState)x$1)).addTag(BlockTags.f_144280_, Registries.f_256747_)).addTag(this.modRes("chests"), Registries.f_256913_)).setTabKey(tab)).defaultRecipe().addCustomItem((w, block, properties) -> new CompatChestItem((Block)block, (Item.Properties)properties)).build();
        this.addEntry(this.chest);
        this.trapped_chest = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "trapped_chest", this.getModBlock("acacia_trapped_chest"), () -> WoodTypeRegistry.getValue((String)"acacia"), w -> new CompatTrappedChestBlock(this::getTrappedTile, Utils.copyPropertySafe((Block)Blocks.f_50325_).m_284180_(w.getColor()))).addTile((x$0, x$1) -> new bpTrappedBlockEntity((BlockPos)x$0, (BlockState)x$1)).addTag(BlockTags.f_144280_, Registries.f_256747_)).addTag(this.modRes("chests"), Registries.f_256913_)).setTabKey(tab)).defaultRecipe().addCustomItem((w, block, properties) -> new CompatChestItem((Block)block, (Item.Properties)properties)).build();
        this.addEntry(this.trapped_chest);
        this.bookshelf = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "bookshelf", this.getModBlock("acacia_bookshelf"), () -> WoodTypeRegistry.getValue((String)"acacia"), w -> new BPPlankBookshelf(Utils.copyPropertySafe((Block)Blocks.f_50078_).m_284180_(w.getColor()))).addTextureM(this.modRes("block/acacia_bookshelf"), EveryCompat.res("block/acacia_bookshelf_m"))).addTag(BlockTags.f_144280_, Registries.f_256747_)).addTag(this.modRes("bookshelves"), Registries.f_256747_)).addTag(this.modRes("bookshelves"), Registries.f_256913_)).setTabKey(tab)).defaultRecipe().build();
        this.addEntry(this.bookshelf);
        this.wooden_crate = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "wooden_crate", this.getModBlock("acacia_wooden_crate"), () -> WoodTypeRegistry.getValue((String)"acacia"), w -> new BPPlanks(Utils.copyPropertySafe((Block)w.planks))).addTexture(this.modRes("block/acacia_wooden_crate"))).addTag(BlockTags.f_144280_, Registries.f_256747_)).setTabKey(tab)).defaultRecipe().build();
        this.addEntry(this.wooden_crate);
        this.ladder = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "ladder", this.getModBlock("acacia_ladder"), () -> WoodTypeRegistry.getValue((String)"acacia"), w -> new LadderBlock(Utils.copyPropertySafe((Block)Blocks.f_50155_).m_284180_(w.getColor()))).addTexture(this.modRes("block/acacia_ladder"))).addTag(BlockTags.f_144280_, Registries.f_256747_)).addTag(BlockTags.f_13082_, Registries.f_256747_)).addTag(BlockTags.f_201924_, Registries.f_256747_)).setTabKey(tab)).defaultRecipe().setRenderType(RenderLayer.CUTOUT_MIPPED).build();
        this.addEntry(this.ladder);
        this.mosaic = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "mosaic", this.getModBlock("acacia_mosaic"), () -> WoodTypeRegistry.getValue((String)"acacia"), w -> new BPPlanks(Utils.copyPropertySafe((Block)w.planks))).addTexture(this.modRes("block/acacia_mosaic"))).addTag(BlockTags.f_144280_, Registries.f_256747_)).setTabKey(tab)).defaultRecipe().build();
        this.addEntry(this.mosaic);
        this.mosaic_stairs = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "mosaic_stairs", this.getModBlock("acacia_mosaic_stairs"), () -> WoodTypeRegistry.getValue((String)"acacia"), w -> new BPPlankStairs(((Block)this.mosaic.blocks.get(w)).m_49966_(), Utils.copyPropertySafe((Block)this.getBlockSafe((WoodType)w, "stairs")).m_284180_(w.getColor()))).requiresChildren(new String[]{"stairs"})).requiresFromMap(this.mosaic.blocks)).addTag(BlockTags.f_144280_, Registries.f_256747_)).setTabKey(tab)).defaultRecipe().build();
        this.addEntry(this.mosaic_stairs);
        this.mosaic_slab = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "mosaic_slab", this.getModBlock("acacia_mosaic_slab"), () -> WoodTypeRegistry.getValue((String)"acacia"), w -> new BPPlankSlab(Utils.copyPropertySafe((Block)this.getBlockSafe((WoodType)w, "slab")).m_284180_(w.getColor()))).requiresChildren(new String[]{"slab"})).requiresFromMap(this.mosaic.blocks)).addTag(BlockTags.f_144280_, Registries.f_256747_)).setTabKey(tab)).defaultRecipe().build();
        this.addEntry(this.mosaic_slab);
        this.mosaic_pressure_plate = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "mosaic_pressure_plate", this.getModBlock("acacia_mosaic_pressure_plate"), () -> WoodTypeRegistry.getValue((String)"acacia"), w -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, Utils.copyPropertySafe((Block)this.getBlockSafe((WoodType)w, "pressure_plate")).m_284180_(w.getColor()), BlockSetType.f_271512_)).requiresFromMap(this.mosaic.blocks)).addTag(BlockTags.f_144280_, Registries.f_256747_)).setTabKey(tab)).defaultRecipe().build();
        this.addEntry(this.mosaic_pressure_plate);
        this.cracked_mosaic = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "mosaic", "cracked", this.getModBlock("cracked_acacia_mosaic"), () -> WoodTypeRegistry.getValue((String)"acacia"), w -> new BPCrackedMossyPlanks(Utils.copyPropertySafe((Block)w.planks))).addTexture(this.modRes("block/cracked_acacia_mosaic"))).addTag(BlockTags.f_144280_, Registries.f_256747_)).setTabKey(tab)).defaultRecipe().build();
        this.addEntry(this.cracked_mosaic);
        this.mossy_mosaic = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "mosaic", "mossy", this.getModBlock("mossy_acacia_mosaic"), () -> WoodTypeRegistry.getValue((String)"acacia"), w -> new BPCrackedMossyPlanks(Utils.copyPropertySafe((Block)w.planks))).addTextureM(this.modRes("block/mossy_acacia_mosaic"), EveryCompat.res("block/bp/mossy_acacia_mosaic_m"))).addTag(BlockTags.f_144280_, Registries.f_256747_)).setTabKey(tab)).defaultRecipe().build();
        this.addEntry(this.mossy_mosaic);
    }

    public Block getBlockSafe(WoodType type, String childkey) {
        Block block = type.getBlockOfThis(childkey);
        if (Objects.nonNull(block)) {
            return block;
        }
        switch (childkey) {
            case "pressure_plate": {
                block = Blocks.f_50171_;
                break;
            }
            case "stairs": {
                block = Blocks.f_50372_;
                break;
            }
            case "slab": {
                block = Blocks.f_50402_;
            }
        }
        return block;
    }

    private BlockEntityType<? extends ChestBlockEntity> getChestTile() {
        return this.chest.getTile(CompatChestBlockEntity.class);
    }

    private BlockEntityType<? extends ChestBlockEntity> getTrappedTile() {
        return this.trapped_chest.getTile(CompatChestBlockEntity.class);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerBlockEntityRenderers(ClientHelper.BlockEntityRendererEvent event) {
        super.registerBlockEntityRenderers(event);
        CompatChestBlockRenderer.register(event, this.chest.getTile(CompatChestBlockEntity.class), this.shortenedId());
        CompatChestBlockRenderer.register(event, this.trapped_chest.getTile(CompatChestBlockEntity.class), this.shortenedId());
    }

    @Override
    public void addDynamicClientResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicClientResources(executor);
        executor.accept((manager, sink) -> this.trapped_chest.blocks.forEach((wood, block) -> {
            CompatChestTexture.generateChestTexture(sink, manager, this.shortenedId(), wood, block, this.modRes("entity/chest/acacia/acacia"), EveryCompat.res("entity/bp/chest_normal_m"), EveryCompat.res("model/oak_chest_normal_o"), EveryCompat.res("model/trapped_chest_normal"));
            CompatChestTexture.generateChestTexture(sink, manager, this.shortenedId(), wood, block, this.modRes("entity/chest/acacia/left"), EveryCompat.res("entity/bp/chest_left_m"), EveryCompat.res("model/oak_chest_left_o"), EveryCompat.res("model/trapped_chest_left"));
            CompatChestTexture.generateChestTexture(sink, manager, this.shortenedId(), wood, block, this.modRes("entity/chest/acacia/right"), EveryCompat.res("entity/bp/chest_right_m"), EveryCompat.res("model/oak_chest_right_o"), EveryCompat.res("model/trapped_chest_right"));
        }));
    }

    private class bpTrappedBlockEntity
    extends CompatChestBlockEntity {
        public bpTrappedBlockEntity(BlockPos pos, BlockState state) {
            super(BlocksPlusModule.this.trapped_chest.getTile(), pos, state);
        }
    }

    private class bpChestBlockEntity
    extends CompatChestBlockEntity {
        public bpChestBlockEntity(BlockPos pos, BlockState state) {
            super(BlocksPlusModule.this.chest.getTile(), pos, state);
        }
    }
}

