/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.misc;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.configs.ModEntriesConfigs;
import net.mehvahdjukaar.every_compat.misc.ModelConfiguration;
import net.mehvahdjukaar.every_compat.misc.SpriteHelper;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.resources.BlockTypeResTransformer;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.resources.recipe.IRecipeTemplate;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesType;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesTypeRegistry;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class ResourcesUtils {
    private static final JsonObject DUMMY_BLOCKSTATE = new JsonObject();
    protected static final String RES_CHARS = "[a-z,A-Z,\\-,_./]*";
    protected static final Pattern RES_PATTERN;
    private static final Map<String, String> mapOfItem;

    public static <B extends Block, T extends BlockType> void generateStandardBlockModels(ResourceManager manager, ResourceSink sink, Map<T, B> blocks, T baseType, BlockTypeResTransformer<T> modelTransformer, BlockTypeResTransformer<T> blockStateTransformer, ModelConfiguration modelConfig) {
        if (blocks.isEmpty()) {
            return;
        }
        Map.Entry first = (Map.Entry)blocks.entrySet().stream().findFirst().get();
        Block baseBlock = BlockType.changeBlockType((Block)((Block)first.getValue()), (BlockType)((BlockType)first.getKey()), baseType);
        if (baseBlock == null) {
            EveryCompat.LOGGER.error("Skipped generating some block assets because oakBlock is null for {}", (Object)Utils.getID((Block)((Block)first.getValue())));
            return;
        }
        ResourceLocation baseId = Utils.getID((Block)baseBlock);
        HashSet<String> modelsLoc = new HashSet<String>();
        try {
            StaticResource oakBlockstate = StaticResource.getOrFail((ResourceManager)manager, (ResourceLocation)ResType.BLOCKSTATES.getPath(baseId));
            JsonObject insideBlockstates = RPUtils.deserializeJson((InputStream)new ByteArrayInputStream(oakBlockstate.data));
            modelsLoc.addAll(RPUtils.findAllResourcesInJsonRecursive((JsonElement)insideBlockstates, s -> s.equals("model")));
            List<StaticResource> oakBlockModels = ResourcesUtils.gatherNonVanillaModels(manager, modelsLoc, modelConfig);
            blocks.forEach((blockType, block) -> {
                ResourceLocation blockId = Utils.getID((Block)block);
                try {
                    StaticResource newBlockState = blockStateTransformer.transform(oakBlockstate, blockId, blockType);
                    Preconditions.checkArgument((newBlockState.location != oakBlockstate.location ? 1 : 0) != 0, (Object)("ids cant be the same: " + String.valueOf(newBlockState.location)));
                    sink.addResourceIfNotPresent(manager, newBlockState);
                    for (StaticResource model : oakBlockModels) {
                        try {
                            StaticResource newModel = modelTransformer.transform(model, blockId, blockType);
                            Preconditions.checkArgument((newModel.location != model.location ? 1 : 0) != 0, (Object)("ids cant be the same: " + String.valueOf(newModel.location)));
                            sink.addResourceIfNotPresent(manager, newModel);
                        }
                        catch (Exception e) {
                            EveryCompat.LOGGER.error("Failed to add {}'s models/block file: {}", (Object)Utils.getID((Block)block), (Object)e.getMessage());
                        }
                    }
                }
                catch (Exception e) {
                    EveryCompat.LOGGER.error("Failed to add {}'s blockstate file: {}", block, (Object)e.getMessage());
                }
            });
        }
        catch (Exception e) {
            EveryCompat.LOGGER.error("Could not find blockstate definition for {}", (Object)baseId);
        }
    }

    private static List<StaticResource> gatherNonVanillaModels(ResourceManager manager, Set<String> modelsLoc, ModelConfiguration modelConfig) {
        ArrayList<StaticResource> models = new ArrayList<StaticResource>();
        for (String m : modelsLoc) {
            StaticResource model;
            ResourceLocation modelRes = new ResourceLocation(m);
            if (modelRes.m_135827_().equals("minecraft") && !modelConfig.blockModel().contains(modelRes) && !modelConfig.itemModel().contains(modelRes) || !Objects.nonNull(model = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.MODELS.getPath(m)))) continue;
            models.add(model);
        }
        if (modelConfig.includeInGeneration()) {
            for (ResourceLocation currentModel : modelConfig.blockModel()) {
                StaticResource model = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.MODELS.getPath(currentModel));
                if (!Objects.nonNull(model)) continue;
                models.add(model);
            }
        }
        return models;
    }

    public static <I extends Item, T extends BlockType> void generateStandardItemModels(ResourceManager manager, ResourceSink sink, Map<T, I> items, T baseType, BlockTypeResTransformer<T> itemModelTransformer, ModelConfiguration modelConfig) {
        if (items.isEmpty()) {
            return;
        }
        Map.Entry first = (Map.Entry)items.entrySet().stream().findFirst().get();
        Item oakItem = BlockType.changeItemType((Item)((Item)first.getValue()), (BlockType)((BlockType)first.getKey()), baseType);
        if (oakItem == null) {
            EveryCompat.LOGGER.error("Skipped generating some item assets because oakItem is NULL for {}", (Object)Utils.getID((Item)((Item)first.getValue())));
            return;
        }
        String baseItemName = baseType.getTypeName();
        HashSet<String> modelsLoc = new HashSet<String>();
        try {
            String parent;
            StaticResource oakItemModel = StaticResource.getOrFail((ResourceManager)manager, (ResourceLocation)ResType.ITEM_MODELS.getPath(Utils.getID((Item)oakItem)));
            JsonObject json = RPUtils.deserializeJson((InputStream)new ByteArrayInputStream(oakItemModel.data));
            modelsLoc.addAll(RPUtils.findAllResourcesInJsonRecursive((JsonElement)json, s -> s.equals("model") || s.equals("parent")));
            if (json.has("parent") && (parent = json.get("parent").getAsString()).contains("item/generated")) {
                itemModelTransformer.replaceItemType(baseItemName);
            }
            items.forEach((blockType, item) -> {
                ResourceLocation id = Utils.getID((Item)item);
                try {
                    StaticResource newRes = itemModelTransformer.transform(oakItemModel, id, blockType);
                    Preconditions.checkArgument((newRes.location != oakItemModel.location ? 1 : 0) != 0, (Object)("ids cant be the same: " + String.valueOf(newRes.location)));
                    sink.addResourceIfNotPresent(manager, newRes);
                }
                catch (Exception e) {
                    EveryCompat.LOGGER.error("Failed to add {} item model json file:", item, (Object)e);
                }
            });
        }
        catch (Exception e) {
            EveryCompat.LOGGER.error("Could not find item model for {}", (Object)oakItem);
        }
        List<StaticResource> oakItemModels = ResourcesUtils.gatherNonVanillaModels(manager, modelsLoc, modelConfig);
        items.forEach((w, b) -> {
            ResourceLocation id = Utils.getID((Item)b);
            for (StaticResource model : oakItemModels) {
                try {
                    StaticResource newModel = itemModelTransformer.transform(model, id, w);
                    assert (newModel.location != model.location) : "ids cant be the same";
                    sink.addResourceIfNotPresent(manager, newModel);
                }
                catch (Exception exception) {
                    EveryCompat.LOGGER.error("Failed to add {} model json file:", b, (Object)exception);
                }
            }
        });
    }

    @NotNull
    public static <T extends BlockType> BlockTypeResTransformer<T> addBuiltinModelTransformer(BlockTypeResTransformer<T> transformer, T baseType) {
        String oldTypeName = baseType.getTypeName();
        transformer.setIDModifier((text, id, w) -> BlockTypeResTransformer.replaceFullGenericType((String)text, (BlockType)w, (ResourceLocation)id, (String)oldTypeName, null, (int)2));
        if (baseType instanceof LeavesType) {
            LeavesType leavesType = (LeavesType)baseType;
            SpriteHelper.replaceLeavesTextures(transformer, leavesType);
            WoodType woodT = leavesType.getWoodType();
            if (woodT != null) {
                SpriteHelper.replaceWoodTextures(transformer, woodT);
            }
        } else if (baseType instanceof WoodType) {
            WoodType woodType = (WoodType)baseType;
            SpriteHelper.replaceWoodTextures(transformer, woodType);
        }
        transformer.replaceGenericType(oldTypeName, "block");
        return transformer;
    }

    public static <B extends Block, T extends BlockType> void addBlockResources(ResourceManager manager, ResourceSink pack, Map<T, B> blocks, BlockTypeResTransformer<T> modifier, ResourceLocation ... jsonsLocations) {
        List<StaticResource> original = Arrays.stream(jsonsLocations).map(s -> StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)s)).toList();
        blocks.forEach((wood, value) -> {
            if (ModEntriesConfigs.isEntryEnabled(wood, value)) {
                for (StaticResource res : original) {
                    try {
                        StaticResource newRes = modifier.transform(res, Utils.getID((Block)value), wood);
                        Preconditions.checkArgument((newRes.location != res.location ? 1 : 0) != 0, (Object)("ids cant be the same: " + String.valueOf(newRes.location)));
                        pack.addResource(newRes);
                    }
                    catch (Exception e) {
                        if (res == null) continue;
                        EveryCompat.LOGGER.error("Failed to generate json resource from {}", (Object)res.location);
                    }
                }
            }
        });
    }

    public static void addLeavesRecipes(String modId, ResourceManager manager, ResourceSink pack, Map<LeavesType, Item> blocks, String oakRecipe) {
        ResourcesUtils.addBlocksRecipes(modId, manager, pack, blocks, oakRecipe, LeavesTypeRegistry.OAK_TYPE);
    }

    public static <B extends Item> void addWoodRecipes(String modId, ResourceManager manager, ResourceSink pack, Map<WoodType, B> blocks, String oakRecipe) {
        ResourcesUtils.addBlocksRecipes(modId, manager, pack, blocks, oakRecipe, VanillaWoodTypes.OAK);
    }

    public static <B extends Item, T extends BlockType> void addBlocksRecipes(String modId, ResourceManager manager, ResourceSink pack, Map<T, B> blocks, String oakRecipe, T fromType) {
        ResourcesUtils.addBlocksRecipes(manager, pack, blocks, new ResourceLocation(modId, oakRecipe), fromType, 0);
    }

    public static <B extends Item, T extends BlockType> void addBlocksRecipes(ResourceManager manager, ResourceSink pack, Map<T, B> items, ResourceLocation oakRecipe, T fromType, int index) {
        IRecipeTemplate template = RPUtils.readRecipeAsTemplate((ResourceManager)manager, (ResourceLocation)ResType.RECIPES.getPath(oakRecipe));
        items.forEach((w, i) -> {
            if (ModEntriesConfigs.isEntryEnabled(w, i)) {
                try {
                    String blockId = RecipeBuilder.m_176493_((ItemLike)i).toString();
                    String oakRecipePath = oakRecipe.m_135815_();
                    String modifiedRecipe = oakRecipePath.substring(oakRecipePath.lastIndexOf("/") + 1).replace(fromType.getTypeName(), w.getTypeName());
                    String target = blockId.substring(blockId.lastIndexOf("/") + 1);
                    String newId = blockId.replace(target, modifiedRecipe);
                    FinishedRecipe newR = !blockId.equals(newId) ? template.createSimilar(fromType, w, w.mainChild().m_5456_(), newId) : template.createSimilar(fromType, w, w.mainChild().m_5456_());
                    if (newR == null) {
                        return;
                    }
                    newR = ForgeHelper.addRecipeConditions((FinishedRecipe)newR, (List)template.getConditions());
                    pack.addRecipe(newR);
                }
                catch (Exception e) {
                    EveryCompat.LOGGER.error("Failed to generate recipe @ {} for {}: {}", (Object)oakRecipe, i, (Object)e.getMessage());
                }
            }
        });
    }

    public static <T extends BlockType> Ingredient convertIngredient(Ingredient ingredient, T originalMat, T destinationMat) {
        Ingredient newIng = ingredient;
        for (ItemStack in : ingredient.m_43908_()) {
            Item i;
            Item it = in.m_41720_();
            if (it == Items.f_42127_ || (i = BlockType.changeItemType((Item)it, originalMat, destinationMat)) == null) continue;
            newIng = Ingredient.m_43929_((ItemLike[])new ItemLike[]{i});
            break;
        }
        return newIng;
    }

    public static String convertItemIDinText(String text, BlockType fromType, BlockType toType) {
        Matcher matcher = RES_PATTERN.matcher(text);
        return matcher.replaceAll(m -> {
            Optional item = BuiltInRegistries.f_257033_.m_6612_(ResourceLocation.m_135820_((String)m.group(1)));
            return item.map(value -> mapOfItem.getOrDefault(((Item)item.get()).toString(), "\"" + Utils.getID((Item)BlockType.changeItemType((Item)value, (BlockType)fromType, (BlockType)toType)).toString() + "\"")).orElseGet(() -> m.group(0));
        });
    }

    static {
        DUMMY_BLOCKSTATE.addProperty("parent", "block/cube_all");
        JsonObject t = new JsonObject();
        t.addProperty("all", "everycomp:block/disabled");
        DUMMY_BLOCKSTATE.add("textures", (JsonElement)t);
        RES_PATTERN = Pattern.compile("\"([a-z,A-Z,\\-,_./]*:[a-z,A-Z,\\-,_./]*)\"");
        mapOfItem = Map.ofEntries(Map.entry("shulker_box", "\"minecraft:shulker_box\""), Map.entry("book", "\"minecraft:book\""), Map.entry("white_upholstery", "\"redeco:white_upholstery\""), Map.entry("light_gray_upholstery", "\"redeco:light_gray_upholstery\""), Map.entry("gray_upholstery", "\"redeco:gray_upholstery\""), Map.entry("black_upholstery", "\"redeco:black_upholstery\""), Map.entry("lime_upholstery", "\"redeco:lime_upholstery\""), Map.entry("green_upholstery", "\"redeco:green_upholstery\""), Map.entry("cyan_upholstery", "\"redeco:cyan_upholstery\""), Map.entry("blue_upholstery", "\"redeco:blue_upholstery\""), Map.entry("light_blue_upholstery", "\"redeco:light_blue_upholstery\""), Map.entry("purple_upholstery", "\"redeco:purple_upholstery\""), Map.entry("magenta_upholstery", "\"redeco:magenta_upholstery\""), Map.entry("pink_upholstery", "\"redeco:pink_upholstery\""), Map.entry("orange_upholstery", "\"redeco:orange_upholstery\""), Map.entry("yellow_upholstery", "\"redeco:yellow_upholstery\""), Map.entry("brown_upholstery", "\"redeco:brown_upholstery\""));
    }
}

