/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.armoroftheages.client.models.iron_plate_armor;

import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.LivingEntity;
import org.dawnoftime.armoroftheages.client.models.ArmorModel;

public class HeadIronPlateArmorModel<T extends LivingEntity>
extends ArmorModel<T> {
    private final ModelPart middleFeatherA;
    private final ModelPart middleFeatherB;

    public HeadIronPlateArmorModel(ModelPart root, boolean isSlim) {
        super(root, isSlim);
        this.middleFeatherA = this.f_102808_.m_171324_("middleFeatherA");
        this.middleFeatherB = this.middleFeatherA.m_171324_("middleFeatherB");
    }

    @Override
    public <E extends LivingEntity> ArmorModel<E> create(ModelPart root, boolean isSlim) {
        return new HeadIronPlateArmorModel<T>(root, isSlim);
    }

    public static LayerDefinition createLayerDefinition() {
        MeshDefinition meshdefinition = HeadIronPlateArmorModel.templateLayerDefinition(1.0f);
        PartDefinition root = meshdefinition.m_171576_();
        PartDefinition head = root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(62, 11).m_171488_(-4.5f, -8.2f, -4.5f, 9.0f, 9.0f, 9.0f, new CubeDeformation(0.1f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition earMiddle = head.m_171599_("earMiddle", CubeListBuilder.m_171558_().m_171514_(57, 49).m_171481_(-5.5f, -1.0f, -1.0f, 11.0f, 2.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)-4.0f, (float)0.4f, (float)-0.3187f, (float)0.0f, (float)0.0f));
        earMiddle.m_171599_("leftEarBottom", CubeListBuilder.m_171558_().m_171514_(0, 34).m_171555_(true).m_171481_(4.0f, -1.5f, -7.5f, 1.0f, 3.0f, 9.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        earMiddle.m_171599_("rightEarBottom", CubeListBuilder.m_171558_().m_171514_(0, 34).m_171481_(-5.0f, -1.5f, -7.5f, 1.0f, 3.0f, 9.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        earMiddle.m_171599_("middleBottom", CubeListBuilder.m_171558_().m_171514_(0, 30).m_171481_(-4.0f, -7.5f, -1.5f, 8.0f, 1.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        head.m_171599_("leftHead", CubeListBuilder.m_171558_().m_171514_(52, 31).m_171481_(-2.0f, -9.1f, -4.5f, 4.0f, 1.0f, 9.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2731f));
        head.m_171599_("rightHead", CubeListBuilder.m_171558_().m_171514_(52, 31).m_171555_(true).m_171481_(-2.0f, -9.1f, -4.5f, 4.0f, 1.0f, 9.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2731f));
        head.m_171599_("middleCraneC", CubeListBuilder.m_171558_().m_171514_(45, 28).m_171481_(-1.0f, -10.6f, -2.0f, 2.0f, 2.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.4189f, (float)0.0f, (float)0.0f));
        head.m_171599_("middleHeadA", CubeListBuilder.m_171558_().m_171514_(45, 28).m_171481_(-1.0f, -10.6f, -2.0f, 2.0f, 2.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.4189f, (float)0.0f, (float)0.0f));
        head.m_171599_("middleHeadB", CubeListBuilder.m_171558_().m_171514_(44, 19).m_171481_(-1.0f, -10.5f, -2.5f, 2.0f, 2.0f, 5.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition middleFeatherA = head.m_171599_("middleFeatherA", CubeListBuilder.m_171558_().m_171514_(89, -8).m_171488_(-2.0f, -4.5f, -1.5f, 4.0f, 9.0f, 9.0f, new CubeDeformation(-2.0f)), PartPose.m_171423_((float)0.0f, (float)-8.0f, (float)5.0f, (float)-0.1905f, (float)0.0f, (float)0.0f));
        middleFeatherA.m_171599_("middleFeatherB", CubeListBuilder.m_171558_().m_171514_(89, 2).m_171488_(-2.0f, -4.5f, -2.0f, 4.0f, 9.0f, 9.0f, new CubeDeformation(-2.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)4.5f, (float)-0.1188f, (float)0.0f, (float)0.0f));
        head.m_171599_("topHead", CubeListBuilder.m_171558_().m_171514_(28, 5).m_171488_(-5.0f, -8.2f, -5.0f, 10.0f, 3.0f, 10.0f, new CubeDeformation(-0.3f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    @Override
    protected void setupArmorPartAnim(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float f = Math.abs(this.f_102813_.f_104203_);
        this.middleFeatherA.f_104203_ = -0.15f - f * 0.1f + 0.05f * HeadIronPlateArmorModel.sinPI(ageInTicks / 60.0f + 1.0f);
        this.middleFeatherB.f_104203_ = -0.15f - f * 0.1f + 0.1f * HeadIronPlateArmorModel.sinPI((ageInTicks - 15.0f) / 60.0f + 1.0f);
    }
}

