/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.armoroftheages.client.models.anubis_armor;

import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.LivingEntity;
import org.dawnoftime.armoroftheages.client.models.ArmorModel;

public class HeadAnubisArmorModel<T extends LivingEntity>
extends ArmorModel<T> {
    private final ModelPart ribbonLeft;
    private final ModelPart ribbonRight;
    private final ModelPart earLeft;
    private final ModelPart earRight;

    public HeadAnubisArmorModel(ModelPart root, boolean isSlim) {
        super(root, isSlim);
        this.ribbonLeft = this.f_102808_.m_171324_("ribbonLeft");
        this.ribbonRight = this.f_102808_.m_171324_("ribbonRight");
        this.earLeft = this.f_102808_.m_171324_("earLeft");
        this.earRight = this.f_102808_.m_171324_("earRight");
    }

    @Override
    public <E extends LivingEntity> ArmorModel<E> create(ModelPart root, boolean isSlim) {
        return new HeadAnubisArmorModel<T>(root, isSlim);
    }

    public static LayerDefinition createLayerDefinition() {
        MeshDefinition meshdefinition = HeadAnubisArmorModel.templateLayerDefinition(1.0f);
        PartDefinition root = meshdefinition.m_171576_();
        PartDefinition head = root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(96, 48).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.5f)).m_171514_(34, 0).m_171488_(-4.5f, -10.25f, -4.5f, 9.0f, 12.0f, 9.0f, new CubeDeformation(0.05f)).m_171514_(0, 0).m_171488_(-4.0f, -10.0f, -6.0f, 8.0f, 7.0f, 9.0f, CubeDeformation.f_171458_), PartPose.f_171404_);
        head.m_171599_("ribbonLeft", CubeListBuilder.m_171558_().m_171514_(10, 16).m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 10.0f, 0.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)4.75f, (float)-8.0f, (float)-4.386f, (float)0.0f, (float)-0.9599f, (float)0.0f));
        head.m_171599_("ribbonLeftNode", CubeListBuilder.m_171558_().m_171514_(0, 5).m_171488_(0.1f, -2.1f, -0.032f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.1f)), PartPose.m_171423_((float)2.7151f, (float)-6.9f, (float)-4.168f, (float)0.0f, (float)0.6109f, (float)0.0f));
        head.m_171599_("ribbonRight", CubeListBuilder.m_171558_().m_171480_().m_171514_(10, 16).m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 10.0f, 0.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)-4.75f, (float)-8.0f, (float)-4.386f, (float)0.0f, (float)0.9599f, (float)0.0f));
        head.m_171599_("ribbonRightNode", CubeListBuilder.m_171558_().m_171480_().m_171514_(0, 5).m_171488_(-2.1f, -2.1f, -0.032f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.1f)), PartPose.m_171423_((float)-2.7151f, (float)-6.9f, (float)-4.168f, (float)0.0f, (float)-0.6109f, (float)0.0f));
        head.m_171599_("nose_r1", CubeListBuilder.m_171558_().m_171514_(25, 0).m_171488_(-3.0f, 0.0f, -5.0f, 4.0f, 4.0f, 5.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)1.0f, (float)-7.0f, (float)-6.0f, (float)0.3054f, (float)0.0f, (float)0.0f));
        head.m_171599_("headLayerRight_r1", CubeListBuilder.m_171558_().m_171480_().m_171514_(98, 0).m_171488_(0.05f, 0.05f, 0.04f, 3.0f, 10.0f, 4.0f, new CubeDeformation(0.05f)), PartPose.m_171423_((float)-4.55f, (float)-10.3f, (float)-0.55f, (float)0.0f, (float)0.0f, (float)0.2618f));
        head.m_171599_("headLayerLeft_r1", CubeListBuilder.m_171558_().m_171514_(98, 0).m_171488_(-3.05f, 0.05f, 0.04f, 3.0f, 10.0f, 4.0f, new CubeDeformation(0.05f)), PartPose.m_171423_((float)4.55f, (float)-10.3f, (float)-0.55f, (float)0.0f, (float)0.0f, (float)-0.2618f));
        head.m_171599_("earRight", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-0.7342f, -5.0323f, -1.0764f, 2.0f, 4.0f, 1.0f, CubeDeformation.f_171458_).m_171514_(0, 16).m_171488_(-3.2342f, -10.5323f, -0.5764f, 5.0f, 10.0f, 0.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)-4.0f, (float)-7.0f, (float)-0.5f, (float)0.1249f, (float)0.2577f, (float)-0.0465f));
        head.m_171599_("earLeft", CubeListBuilder.m_171558_().m_171480_().m_171514_(0, 0).m_171488_(-1.2658f, -5.0323f, -1.0764f, 2.0f, 4.0f, 1.0f, CubeDeformation.f_171458_).m_171514_(0, 16).m_171488_(-1.7658f, -10.5323f, -0.5764f, 5.0f, 10.0f, 0.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)4.0f, (float)-7.0f, (float)-0.5f, (float)0.1249f, (float)-0.2577f, (float)0.0465f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public static LayerDefinition createSlimLayerDefinition() {
        MeshDefinition meshdefinition = HeadAnubisArmorModel.templateLayerDefinition(1.0f);
        PartDefinition root = meshdefinition.m_171576_();
        PartDefinition head = root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(96, 48).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.5f)).m_171514_(34, 0).m_171488_(-4.5f, -10.25f, -4.5f, 9.0f, 12.0f, 9.0f, new CubeDeformation(0.05f)).m_171514_(0, 0).m_171488_(-4.0f, -10.0f, -6.0f, 8.0f, 7.0f, 9.0f, CubeDeformation.f_171458_), PartPose.f_171404_);
        head.m_171599_("ribbonLeft", CubeListBuilder.m_171558_().m_171514_(10, 16).m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 10.0f, 0.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)4.75f, (float)-8.0f, (float)-4.386f, (float)0.0f, (float)-0.9599f, (float)0.0f));
        head.m_171599_("ribbonLeftNode", CubeListBuilder.m_171558_().m_171514_(0, 5).m_171488_(0.1f, -2.1f, -0.032f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.1f)), PartPose.m_171423_((float)2.7151f, (float)-6.9f, (float)-4.168f, (float)0.0f, (float)0.6109f, (float)0.0f));
        head.m_171599_("ribbonRight", CubeListBuilder.m_171558_().m_171480_().m_171514_(10, 16).m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 10.0f, 0.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)-4.75f, (float)-8.0f, (float)-4.386f, (float)0.0f, (float)0.9599f, (float)0.0f));
        head.m_171599_("ribbonRightNode", CubeListBuilder.m_171558_().m_171480_().m_171514_(0, 5).m_171488_(-2.1f, -2.1f, -0.032f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.1f)), PartPose.m_171423_((float)-2.7151f, (float)-6.9f, (float)-4.168f, (float)0.0f, (float)-0.6109f, (float)0.0f));
        head.m_171599_("nose_r1", CubeListBuilder.m_171558_().m_171514_(25, 0).m_171488_(-3.0f, 0.0f, -5.0f, 4.0f, 4.0f, 5.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)1.0f, (float)-7.0f, (float)-6.0f, (float)0.3054f, (float)0.0f, (float)0.0f));
        head.m_171599_("headLayerRight_r1", CubeListBuilder.m_171558_().m_171480_().m_171514_(98, 0).m_171488_(0.05f, 0.05f, 0.04f, 3.0f, 10.0f, 4.0f, new CubeDeformation(0.05f)), PartPose.m_171423_((float)-4.55f, (float)-10.3f, (float)-0.55f, (float)0.0f, (float)0.0f, (float)0.2618f));
        head.m_171599_("headLayerLeft_r1", CubeListBuilder.m_171558_().m_171514_(98, 0).m_171488_(-3.05f, 0.05f, 0.04f, 3.0f, 10.0f, 4.0f, new CubeDeformation(0.05f)), PartPose.m_171423_((float)4.55f, (float)-10.3f, (float)-0.55f, (float)0.0f, (float)0.0f, (float)-0.2618f));
        head.m_171599_("earRight", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-0.7342f, -5.0323f, -1.0764f, 2.0f, 4.0f, 1.0f, CubeDeformation.f_171458_).m_171514_(0, 16).m_171488_(-3.2342f, -10.5323f, -0.5764f, 5.0f, 10.0f, 0.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)-4.0f, (float)-7.0f, (float)-0.5f, (float)0.1681f, (float)0.2322f, (float)0.1315f));
        head.m_171599_("earLeft", CubeListBuilder.m_171558_().m_171480_().m_171514_(0, 0).m_171488_(-1.2658f, -5.0323f, -1.0764f, 2.0f, 4.0f, 1.0f, CubeDeformation.f_171458_).m_171514_(0, 16).m_171488_(-1.7658f, -10.5323f, -0.5764f, 5.0f, 10.0f, 0.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)4.0f, (float)-7.0f, (float)-0.5f, (float)0.1681f, (float)-0.2322f, (float)-0.1315f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    @Override
    protected void setupArmorPartAnim(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float rh = 0.1f * HeadAnubisArmorModel.sinPI(ageInTicks / 35.0f);
        if (this.isSlim) {
            this.earRight.m_171327_(0.1249f + rh, 0.2577f, -0.0465f);
            this.earLeft.m_171327_(0.1249f + rh, -0.2577f, 0.0465f);
        } else {
            this.earRight.m_171327_(0.1681f + rh, 0.2322f, 0.1315f);
            this.earLeft.m_171327_(0.1681f + rh, -0.2322f, -0.1315f);
        }
        this.ribbonRight.f_104205_ = rh = 0.05f * HeadAnubisArmorModel.sinPI((ageInTicks - 15.0f) / 50.0f);
        this.ribbonLeft.f_104205_ = -rh;
    }
}

