/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.armoroftheages.client.models.anubis_armor;

import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.LivingEntity;
import org.dawnoftime.armoroftheages.client.models.ArmorModel;

public class ChestAnubisArmorModel<T extends LivingEntity>
extends ArmorModel<T> {
    private final ModelPart collarBack;
    private final ModelPart crossA;
    private final ModelPart crossB;
    private final ModelPart crossC;
    private final ModelPart crossD;

    public ChestAnubisArmorModel(ModelPart root, boolean isSlim) {
        super(root, isSlim);
        this.collarBack = this.f_102810_.m_171324_("collar_back");
        this.crossA = this.f_102810_.m_171324_("cross_a");
        this.crossB = this.f_102810_.m_171324_("cross_b");
        this.crossC = this.f_102810_.m_171324_("cross_c");
        this.crossD = this.f_102810_.m_171324_("cross_d");
    }

    @Override
    public <E extends LivingEntity> ArmorModel<E> create(ModelPart root, boolean isSlim) {
        return new ChestAnubisArmorModel<T>(root, isSlim);
    }

    public static LayerDefinition createLayerDefinition() {
        MeshDefinition meshdefinition = ChestAnubisArmorModel.templateLayerDefinition(1.0f);
        PartDefinition root = meshdefinition.m_171576_();
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(70, 0).m_171488_(-4.5f, -0.5f, -2.5f, 9.0f, 13.0f, 5.0f, new CubeDeformation(-0.22f)).m_171514_(-6, 52).m_171481_(-4.5f, -0.45f, -2.5f, 9.0f, 0.0f, 6.0f), PartPose.f_171404_);
        body.m_171599_("abs", CubeListBuilder.m_171558_().m_171514_(38, 21).m_171488_(-3.5f, -1.0f, 0.3f, 7.0f, 8.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)4.7f, (float)-3.3f, (float)0.0873f, (float)0.0f, (float)0.0f));
        body.m_171599_("chest_back", CubeListBuilder.m_171558_().m_171514_(20, 31).m_171488_(-3.5f, -6.5f, -1.7f, 7.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)6.2f, (float)2.5f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        body.m_171599_("collar_front", CubeListBuilder.m_171558_().m_171514_(-5, 58).m_171488_(-4.5f, 0.0f, -5.0f, 9.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-0.45f, (float)-2.5f, (float)1.309f, (float)0.0f, (float)0.0f));
        body.m_171599_("collar_back", CubeListBuilder.m_171558_().m_171514_(-8, 44).m_171481_(-4.5f, 0.0f, 0.0f, 9.0f, 0.0f, 8.0f), PartPose.m_171423_((float)0.0f, (float)-0.45f, (float)3.5f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        body.m_171599_("chest_core", CubeListBuilder.m_171558_().m_171514_(61, 0).m_171488_(-1.0f, -3.5f, 0.05f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)4.5f, (float)-3.6f, (float)-0.192f, (float)0.0f, (float)0.0f));
        body.m_171599_("chest_pec_right", CubeListBuilder.m_171558_().m_171514_(108, 10).m_171488_(-4.0f, -4.0f, -2.9f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.5f, (float)4.0f, (float)-0.5f, (float)-0.2007f, (float)0.0f, (float)-0.2618f));
        body.m_171599_("chest_pec_left", CubeListBuilder.m_171558_().m_171514_(108, 10).m_171488_(0.0f, -4.0f, -2.9f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.5f, (float)4.0f, (float)-0.5f, (float)-0.2007f, (float)0.0f, (float)0.2618f));
        body.m_171599_("cross_a", CubeListBuilder.m_171558_().m_171514_(18, 45).m_171481_(-2.5f, -44.0f, 2.0f, 5.0f, 6.0f, 0.0f), PartPose.m_171419_((float)0.0f, (float)20.0f, (float)4.0f));
        body.m_171599_("cross_b", CubeListBuilder.m_171558_().m_171514_(18, 45).m_171481_(-2.5f, -44.0f, 2.0f, 5.0f, 6.0f, 0.0f), PartPose.m_171419_((float)0.0f, (float)20.0f, (float)4.0f));
        body.m_171599_("cross_c", CubeListBuilder.m_171558_().m_171514_(18, 45).m_171481_(-2.5f, -44.0f, 2.0f, 5.0f, 6.0f, 0.0f), PartPose.m_171419_((float)0.0f, (float)20.0f, (float)4.0f));
        body.m_171599_("cross_d", CubeListBuilder.m_171558_().m_171514_(18, 45).m_171481_(-2.5f, -44.0f, 2.0f, 5.0f, 6.0f, 0.0f), PartPose.m_171419_((float)0.0f, (float)20.0f, (float)4.0f));
        PartDefinition rightArm = root.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(112, 48).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)).m_171514_(0, 26).m_171488_(-3.5f, -2.5f, -2.5f, 5.0f, 13.0f, 5.0f, new CubeDeformation(-0.2f)), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        rightArm.m_171599_("shoulderRight", CubeListBuilder.m_171558_().m_171514_(112, 0).m_171488_(-1.75f, -2.0f, -2.5f, 3.0f, 5.0f, 5.0f, new CubeDeformation(0.05f)).m_171514_(25, 0).m_171481_(-0.5f, -0.5f, -3.0f, 1.0f, 1.0f, 1.0f).m_171514_(18, 16).m_171488_(-3.0f, -6.0f, -3.0f, 4.0f, 9.0f, 6.0f, new CubeDeformation(-0.2f)), PartPose.m_171423_((float)-2.25f, (float)-0.75f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition leftArm = root.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171480_().m_171514_(112, 48).m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)).m_171514_(0, 26).m_171488_(-1.5f, -2.5f, -2.5f, 5.0f, 13.0f, 5.0f, new CubeDeformation(-0.2f)), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        leftArm.m_171599_("shoulderLeft", CubeListBuilder.m_171558_().m_171480_().m_171514_(112, 0).m_171488_(-1.25f, -2.0f, -2.5f, 3.0f, 5.0f, 5.0f, new CubeDeformation(0.05f)).m_171514_(25, 0).m_171481_(-0.5f, -0.5f, -3.0f, 1.0f, 1.0f, 1.0f).m_171514_(18, 16).m_171488_(-1.0f, -6.0f, -3.0f, 4.0f, 9.0f, 6.0f, new CubeDeformation(-0.2f)), PartPose.m_171423_((float)2.25f, (float)-0.75f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public static LayerDefinition createSlimLayerDefinition() {
        MeshDefinition meshdefinition = ChestAnubisArmorModel.templateLayerDefinition(1.0f);
        PartDefinition root = meshdefinition.m_171576_();
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(70, 0).m_171488_(-4.5f, -0.5f, -2.5f, 9.0f, 13.0f, 5.0f, new CubeDeformation(-0.22f)).m_171514_(-6, 52).m_171488_(-4.5f, -0.45f, -2.5f, 9.0f, 0.0f, 6.0f, CubeDeformation.f_171458_), PartPose.f_171404_);
        body.m_171599_("abs", CubeListBuilder.m_171558_().m_171514_(38, 21).m_171488_(-3.5f, -1.0f, 0.3f, 7.0f, 8.0f, 1.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)0.0f, (float)4.7f, (float)-3.3f, (float)0.0873f, (float)0.0f, (float)0.0f));
        body.m_171599_("chest_back", CubeListBuilder.m_171558_().m_171514_(20, 31).m_171488_(-3.5f, -6.5f, -1.7f, 7.0f, 12.0f, 2.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)0.0f, (float)6.2f, (float)2.5f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        body.m_171599_("collar_front", CubeListBuilder.m_171558_().m_171514_(-5, 58).m_171488_(-4.5f, 0.0f, -5.0f, 9.0f, 0.0f, 5.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)0.0f, (float)-0.45f, (float)-2.5f, (float)1.1345f, (float)0.0f, (float)0.0f));
        body.m_171599_("collar_back", CubeListBuilder.m_171558_().m_171514_(-8, 44).m_171488_(-4.5f, 0.0f, 0.0f, 9.0f, 0.0f, 8.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)0.0f, (float)-0.45f, (float)3.5f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        body.m_171599_("chest_core", CubeListBuilder.m_171558_().m_171514_(61, 0).m_171488_(-1.0f, -1.2974f, -0.1f, 2.0f, 3.0f, 1.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)0.0f, (float)2.5f, (float)-3.6f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        body.m_171599_("chest_pec_right", CubeListBuilder.m_171558_().m_171514_(108, 10).m_171488_(-4.0f, -3.0f, -3.5f, 4.0f, 4.0f, 4.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)0.5f, (float)4.0f, (float)-0.5f, (float)-0.3752f, (float)0.0f, (float)-0.1745f));
        body.m_171599_("chest_pec_left", CubeListBuilder.m_171558_().m_171514_(108, 10).m_171488_(0.0f, -3.0f, -3.5f, 4.0f, 4.0f, 4.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)-0.5f, (float)4.0f, (float)-0.5f, (float)-0.3752f, (float)0.0f, (float)0.1745f));
        body.m_171599_("cross_a", CubeListBuilder.m_171558_().m_171514_(18, 45).m_171488_(-2.5f, -44.0f, 2.0f, 5.0f, 6.0f, 0.0f, CubeDeformation.f_171458_), PartPose.m_171419_((float)0.0f, (float)20.0f, (float)4.0f));
        body.m_171599_("cross_b", CubeListBuilder.m_171558_().m_171514_(18, 45).m_171488_(-2.5f, -44.0f, 2.0f, 5.0f, 6.0f, 0.0f, CubeDeformation.f_171458_), PartPose.m_171419_((float)0.0f, (float)20.0f, (float)4.0f));
        body.m_171599_("cross_c", CubeListBuilder.m_171558_().m_171514_(18, 45).m_171488_(-2.5f, -44.0f, 2.0f, 5.0f, 6.0f, 0.0f, CubeDeformation.f_171458_), PartPose.m_171419_((float)0.0f, (float)20.0f, (float)4.0f));
        body.m_171599_("cross_d", CubeListBuilder.m_171558_().m_171514_(18, 45).m_171488_(-2.5f, -44.0f, 2.0f, 5.0f, 6.0f, 0.0f, CubeDeformation.f_171458_), PartPose.m_171419_((float)0.0f, (float)20.0f, (float)4.0f));
        PartDefinition rightArm = root.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(112, 48).m_171488_(-2.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)).m_171514_(0, 26).m_171488_(-2.5f, -2.5f, -2.5f, 4.0f, 13.0f, 5.0f, new CubeDeformation(-0.2f)), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        rightArm.m_171599_("right_shoulder", CubeListBuilder.m_171558_().m_171514_(112, 0).m_171488_(-1.75f, -2.0f, -2.5f, 3.0f, 5.0f, 5.0f, new CubeDeformation(0.05f)).m_171514_(25, 0).m_171488_(-0.5f, -0.5f, -3.0f, 1.0f, 1.0f, 1.0f, CubeDeformation.f_171458_).m_171514_(18, 16).m_171488_(-3.0f, -6.0f, -3.0f, 4.0f, 9.0f, 6.0f, new CubeDeformation(-0.2f)), PartPose.m_171423_((float)-1.25f, (float)-0.75f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition leftArm = root.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171480_().m_171514_(112, 48).m_171488_(-1.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)).m_171514_(0, 26).m_171488_(-1.5f, -2.5f, -2.5f, 4.0f, 13.0f, 5.0f, new CubeDeformation(-0.2f)), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        leftArm.m_171599_("left_shoulder", CubeListBuilder.m_171558_().m_171480_().m_171514_(112, 0).m_171488_(-1.25f, -2.0f, -2.5f, 3.0f, 5.0f, 5.0f, new CubeDeformation(0.05f)).m_171514_(25, 0).m_171488_(-0.5f, -0.5f, -3.0f, 1.0f, 1.0f, 1.0f, CubeDeformation.f_171458_).m_171514_(18, 16).m_171488_(-1.0f, -6.0f, -3.0f, 4.0f, 9.0f, 6.0f, new CubeDeformation(-0.2f)), PartPose.m_171423_((float)1.25f, (float)-0.75f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    @Override
    protected void setupArmorPartAnim(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.collarBack.f_104203_ = -1.5708f + 0.08f * (1.0f + ChestAnubisArmorModel.sinPI(ageInTicks / 40.0f));
        this.crossA.f_104200_ = this.getOrbitalX(8.5f + 2.0f * ChestAnubisArmorModel.sinPI(ageInTicks / 40.0f), 0.5f, ageInTicks);
        this.crossA.f_104201_ = this.getOrbitalY(8.5f + 2.0f * ChestAnubisArmorModel.sinPI((ageInTicks + 10.0f) / 30.0f), -0.5f, ageInTicks);
        this.crossB.f_104200_ = this.getOrbitalX(8.0f + 2.0f * ChestAnubisArmorModel.sinPI(ageInTicks / 70.0f), 0.45f, ageInTicks + 5.0f);
        this.crossB.f_104201_ = this.getOrbitalY(8.0f + 2.0f * ChestAnubisArmorModel.sinPI((ageInTicks + 10.0f) / 40.0f), 0.45f, ageInTicks + 25.0f);
        this.crossC.f_104200_ = this.getOrbitalX(9.0f + 2.0f * ChestAnubisArmorModel.sinPI((ageInTicks + 25.0f) / 30.0f), 0.55f, ageInTicks + 25.0f);
        this.crossC.f_104201_ = this.getOrbitalY(9.0f + 2.0f * ChestAnubisArmorModel.sinPI((ageInTicks + 5.0f) / 50.0f), 0.55f, ageInTicks + 30.0f);
        this.crossD.f_104200_ = this.getOrbitalX(8.0f + 2.0f * ChestAnubisArmorModel.sinPI((ageInTicks + 30.0f) / 80.0f), 0.42f, ageInTicks + 20.0f);
        this.crossD.f_104201_ = this.getOrbitalY(8.0f + 2.0f * ChestAnubisArmorModel.sinPI(ageInTicks / 50.0f), 0.42f, ageInTicks + 20.0f);
    }

    private float getOrbitalX(float amplitude, float frequency, float ageInTicks) {
        return amplitude * ChestAnubisArmorModel.cosPI(2.0f * frequency * ageInTicks / 40.0f);
    }

    private float getOrbitalY(float amplitude, float frequency, float ageInTicks) {
        return 30.0f + amplitude * ChestAnubisArmorModel.sinPI(2.0f * frequency * ageInTicks / 40.0f);
    }
}

