/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import fi.dy.masa.malilib.config.HudAlignment;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.render.InventoryOverlay;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.InventoryUtils;
import fi.dy.masa.malilib.util.PositionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.SingleThreadedRandomSource;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class RenderUtils {
    public static final ResourceLocation TEXTURE_MAP_BACKGROUND = new ResourceLocation("textures/map/map_background.png");
    public static final ResourceLocation TEXTURE_MAP_BACKGROUND_CHECKERBOARD = new ResourceLocation("textures/map/map_background_checkerboard.png");
    private static final SingleThreadedRandomSource RAND = new SingleThreadedRandomSource(0L);

    public static void setupBlend() {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
    }

    public static void setupBlendSimple() {
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }

    public static void bindTexture(ResourceLocation texture) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
    }

    public static void color(float r, float g, float b, float a) {
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
    }

    public static void disableDiffuseLighting() {
        Lighting.m_84930_();
    }

    public static void enableDiffuseLightingForLevel(PoseStack matrixStack) {
        Lighting.m_252995_((Matrix4f)matrixStack.m_85850_().m_252922_());
    }

    public static void enableDiffuseLightingGui3D() {
        Lighting.m_84931_();
    }

    public static void drawOutlinedBox(int x, int y, int width, int height, int colorBg, int colorBorder) {
        RenderUtils.drawOutlinedBox(x, y, width, height, colorBg, colorBorder, 0.0f);
    }

    public static void drawOutlinedBox(int x, int y, int width, int height, int colorBg, int colorBorder, float zLevel) {
        RenderUtils.drawRect(x, y, width, height, colorBg, zLevel);
        RenderUtils.drawOutline(x - 1, y - 1, width + 2, height + 2, colorBorder, zLevel);
    }

    public static void drawOutline(int x, int y, int width, int height, int colorBorder) {
        RenderUtils.drawOutline(x, y, width, height, colorBorder, 0.0f);
    }

    public static void drawOutline(int x, int y, int width, int height, int colorBorder, float zLevel) {
        RenderUtils.drawRect(x, y, 1, height, colorBorder, zLevel);
        RenderUtils.drawRect(x + width - 1, y, 1, height, colorBorder, zLevel);
        RenderUtils.drawRect(x + 1, y, width - 2, 1, colorBorder, zLevel);
        RenderUtils.drawRect(x + 1, y + height - 1, width - 2, 1, colorBorder, zLevel);
    }

    public static void drawOutline(int x, int y, int width, int height, int borderWidth, int colorBorder) {
        RenderUtils.drawOutline(x, y, width, height, borderWidth, colorBorder, 0.0f);
    }

    public static void drawOutline(int x, int y, int width, int height, int borderWidth, int colorBorder, float zLevel) {
        RenderUtils.drawRect(x, y, borderWidth, height, colorBorder, zLevel);
        RenderUtils.drawRect(x + width - borderWidth, y, borderWidth, height, colorBorder, zLevel);
        RenderUtils.drawRect(x + borderWidth, y, width - 2 * borderWidth, borderWidth, colorBorder, zLevel);
        RenderUtils.drawRect(x + borderWidth, y + height - borderWidth, width - 2 * borderWidth, borderWidth, colorBorder, zLevel);
    }

    public static void drawTexturedRect(int x, int y, int u, int v, int width, int height) {
        RenderUtils.drawTexturedRect(x, y, u, v, width, height, 0.0f);
    }

    public static void drawRect(int x, int y, int width, int height, int color) {
        RenderUtils.drawRect(x, y, width, height, color, 0.0f);
    }

    public static void drawRect(int x, int y, int width, int height, int color, float zLevel) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.applyModelViewMatrix();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        RenderUtils.setupBlend();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        buffer.m_5483_((double)x, (double)y, (double)zLevel).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_((double)x, (double)(y + height), (double)zLevel).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_((double)(x + width), (double)(y + height), (double)zLevel).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_((double)(x + width), (double)y, (double)zLevel).m_85950_(r, g, b, a).m_5752_();
        tessellator.m_85914_();
        RenderSystem.disableBlend();
    }

    public static void drawTexturedRect(int x, int y, int u, int v, int width, int height, float zLevel) {
        float pixelWidth = 0.00390625f;
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.applyModelViewMatrix();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        RenderUtils.setupBlend();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_5483_((double)x, (double)(y + height), (double)zLevel).m_7421_((float)u * pixelWidth, (float)(v + height) * pixelWidth).m_5752_();
        buffer.m_5483_((double)(x + width), (double)(y + height), (double)zLevel).m_7421_((float)(u + width) * pixelWidth, (float)(v + height) * pixelWidth).m_5752_();
        buffer.m_5483_((double)(x + width), (double)y, (double)zLevel).m_7421_((float)(u + width) * pixelWidth, (float)v * pixelWidth).m_5752_();
        buffer.m_5483_((double)x, (double)y, (double)zLevel).m_7421_((float)u * pixelWidth, (float)v * pixelWidth).m_5752_();
        tessellator.m_85914_();
    }

    public static void drawTexturedRectBatched(int x, int y, int u, int v, int width, int height, BufferBuilder buffer) {
        RenderUtils.drawTexturedRectBatched(x, y, u, v, width, height, 0.0f, buffer);
    }

    public static void drawTexturedRectBatched(int x, int y, int u, int v, int width, int height, float zLevel, BufferBuilder buffer) {
        float pixelWidth = 0.00390625f;
        buffer.m_5483_((double)x, (double)(y + height), (double)zLevel).m_7421_((float)u * pixelWidth, (float)(v + height) * pixelWidth).m_5752_();
        buffer.m_5483_((double)(x + width), (double)(y + height), (double)zLevel).m_7421_((float)(u + width) * pixelWidth, (float)(v + height) * pixelWidth).m_5752_();
        buffer.m_5483_((double)(x + width), (double)y, (double)zLevel).m_7421_((float)(u + width) * pixelWidth, (float)v * pixelWidth).m_5752_();
        buffer.m_5483_((double)x, (double)y, (double)zLevel).m_7421_((float)u * pixelWidth, (float)v * pixelWidth).m_5752_();
    }

    public static void drawHoverText(int x, int y, List<String> textLines, GuiGraphics drawContext) {
        Minecraft mc = RenderUtils.mc();
        if (!textLines.isEmpty() && GuiUtils.getCurrentScreen() != null) {
            RenderSystem.enableDepthTest();
            Font font = mc.f_91062_;
            int maxLineLength = 0;
            int maxWidth = GuiUtils.getCurrentScreen().f_96543_;
            ArrayList<String> linesNew = new ArrayList<String>();
            for (String lineOrig : textLines) {
                String[] lines;
                for (String line : lines = lineOrig.split("\\n")) {
                    int length = font.m_92895_(line);
                    if (length > maxLineLength) {
                        maxLineLength = length;
                    }
                    linesNew.add(line);
                }
            }
            textLines = linesNew;
            Objects.requireNonNull(font);
            int lineHeight = 9 + 1;
            int textHeight = textLines.size() * lineHeight - 2;
            int textStartX = x + 4;
            int textStartY = Math.max(8, y - textHeight - 6);
            if (textStartX + maxLineLength + 6 > maxWidth) {
                textStartX = Math.max(2, maxWidth - maxLineLength - 8);
            }
            PoseStack matrixStack = drawContext.m_280168_();
            matrixStack.m_85836_();
            matrixStack.m_252880_(0.0f, 0.0f, 300.0f);
            RenderSystem.applyModelViewMatrix();
            double zLevel = 300.0;
            int borderColor = -267386864;
            RenderUtils.drawGradientRect(textStartX - 3, textStartY - 4, textStartX + maxLineLength + 3, textStartY - 3, zLevel, borderColor, borderColor);
            RenderUtils.drawGradientRect(textStartX - 3, textStartY + textHeight + 3, textStartX + maxLineLength + 3, textStartY + textHeight + 4, zLevel, borderColor, borderColor);
            RenderUtils.drawGradientRect(textStartX - 3, textStartY - 3, textStartX + maxLineLength + 3, textStartY + textHeight + 3, zLevel, borderColor, borderColor);
            RenderUtils.drawGradientRect(textStartX - 4, textStartY - 3, textStartX - 3, textStartY + textHeight + 3, zLevel, borderColor, borderColor);
            RenderUtils.drawGradientRect(textStartX + maxLineLength + 3, textStartY - 3, textStartX + maxLineLength + 4, textStartY + textHeight + 3, zLevel, borderColor, borderColor);
            int fillColor1 = 0x505000FF;
            int fillColor2 = 1344798847;
            RenderUtils.drawGradientRect(textStartX - 3, textStartY - 3 + 1, textStartX - 3 + 1, textStartY + textHeight + 3 - 1, zLevel, fillColor1, fillColor2);
            RenderUtils.drawGradientRect(textStartX + maxLineLength + 2, textStartY - 3 + 1, textStartX + maxLineLength + 3, textStartY + textHeight + 3 - 1, zLevel, fillColor1, fillColor2);
            RenderUtils.drawGradientRect(textStartX - 3, textStartY - 3, textStartX + maxLineLength + 3, textStartY - 3 + 1, zLevel, fillColor1, fillColor1);
            RenderUtils.drawGradientRect(textStartX - 3, textStartY + textHeight + 2, textStartX + maxLineLength + 3, textStartY + textHeight + 3, zLevel, fillColor2, fillColor2);
            for (int i = 0; i < textLines.size(); ++i) {
                String str = textLines.get(i);
                drawContext.m_280056_(font, str, textStartX, textStartY, -1, false);
                textStartY += lineHeight;
            }
            matrixStack.m_85849_();
            RenderSystem.applyModelViewMatrix();
        }
    }

    public static void drawGradientRect(int left, int top, int right, int bottom, double zLevel, int startColor, int endColor) {
        int sa = startColor >> 24 & 0xFF;
        int sr = startColor >> 16 & 0xFF;
        int sg = startColor >> 8 & 0xFF;
        int sb = startColor & 0xFF;
        int ea = endColor >> 24 & 0xFF;
        int er = endColor >> 16 & 0xFF;
        int eg = endColor >> 8 & 0xFF;
        int eb = endColor & 0xFF;
        RenderUtils.setupBlend();
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.applyModelViewMatrix();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        buffer.m_5483_((double)right, (double)top, zLevel).m_6122_(sr, sg, sb, sa).m_5752_();
        buffer.m_5483_((double)left, (double)top, zLevel).m_6122_(sr, sg, sb, sa).m_5752_();
        buffer.m_5483_((double)left, (double)bottom, zLevel).m_6122_(er, eg, eb, ea).m_5752_();
        buffer.m_5483_((double)right, (double)bottom, zLevel).m_6122_(er, eg, eb, ea).m_5752_();
        tessellator.m_85914_();
        RenderSystem.disableBlend();
    }

    public static void drawCenteredString(int x, int y, int color, String text, GuiGraphics drawContext) {
        Font textRenderer = RenderUtils.mc().f_91062_;
        drawContext.m_280137_(textRenderer, text, x, y, color);
    }

    public static void drawHorizontalLine(int x, int y, int width, int color) {
        RenderUtils.drawRect(x, y, width, 1, color);
    }

    public static void drawVerticalLine(int x, int y, int height, int color) {
        RenderUtils.drawRect(x, y, 1, height, color);
    }

    public static void renderSprite(int x, int y, int width, int height, ResourceLocation atlas, ResourceLocation texture, GuiGraphics drawContext) {
        if (texture != null) {
            TextureAtlasSprite sprite = (TextureAtlasSprite)RenderUtils.mc().m_91258_(atlas).apply(texture);
            drawContext.m_280159_(x, y, 0, width, height, sprite);
        }
    }

    public static void renderText(int x, int y, int color, String text, GuiGraphics drawContext) {
        String[] parts = text.split("\\\\n");
        Font textRenderer = RenderUtils.mc().f_91062_;
        for (String line : parts) {
            drawContext.m_280056_(textRenderer, line, x, y, color, true);
            Objects.requireNonNull(textRenderer);
            y += 9 + 1;
        }
    }

    public static void renderText(int x, int y, int color, List<String> lines, GuiGraphics drawContext) {
        if (!lines.isEmpty()) {
            Font textRenderer = RenderUtils.mc().f_91062_;
            for (String line : lines) {
                drawContext.m_280056_(textRenderer, line, x, y, color, false);
                Objects.requireNonNull(textRenderer);
                y += 9 + 2;
            }
        }
    }

    public static int renderText(int xOff, int yOff, double scale, int textColor, int bgColor, HudAlignment alignment, boolean useBackground, boolean useShadow, List<String> lines, GuiGraphics drawContext) {
        boolean scaled;
        Font fontRenderer = RenderUtils.mc().f_91062_;
        int scaledWidth = GuiUtils.getScaledWindowWidth();
        Objects.requireNonNull(fontRenderer);
        int lineHeight = 9 + 2;
        int contentHeight = lines.size() * lineHeight - 2;
        int bgMargin = 2;
        if (scale < 0.0125) {
            return 0;
        }
        PoseStack globalStack = RenderSystem.getModelViewStack();
        boolean bl = scaled = scale != 1.0;
        if (scaled) {
            if (scale != 0.0) {
                xOff = (int)((double)xOff * scale);
                yOff = (int)((double)yOff * scale);
            }
            globalStack.m_85836_();
            globalStack.m_85841_((float)scale, (float)scale, 1.0f);
            RenderSystem.applyModelViewMatrix();
        }
        double posX = xOff + 2;
        double posY = yOff + 2;
        posY = RenderUtils.getHudPosY((int)posY, yOff, contentHeight, scale, alignment);
        posY += (double)RenderUtils.getHudOffsetForPotions(alignment, scale, (Player)RenderUtils.mc().f_91074_);
        for (String line : lines) {
            int width = fontRenderer.m_92895_(line);
            switch (alignment) {
                case TOP_RIGHT: 
                case BOTTOM_RIGHT: {
                    posX = (double)scaledWidth / scale - (double)width - (double)xOff - 2.0;
                    break;
                }
                case CENTER: {
                    posX = (double)scaledWidth / scale / 2.0 - (double)(width / 2) - (double)xOff;
                    break;
                }
            }
            int x = (int)posX;
            int y = (int)posY;
            posY += (double)lineHeight;
            if (useBackground) {
                Objects.requireNonNull(fontRenderer);
                RenderUtils.drawRect(x - 2, y - 2, width + 2, 2 + 9, bgColor);
            }
            drawContext.m_280056_(fontRenderer, line, x, y, textColor, useShadow);
        }
        if (scaled) {
            globalStack.m_85849_();
            RenderSystem.applyModelViewMatrix();
        }
        return contentHeight + 4;
    }

    public static int getHudOffsetForPotions(HudAlignment alignment, double scale, Player player) {
        if (alignment == HudAlignment.TOP_RIGHT) {
            if (scale == 0.0) {
                return 0;
            }
            Collection effects = player.m_21220_();
            if (!effects.isEmpty()) {
                int y1 = 0;
                int y2 = 0;
                for (MobEffectInstance effectInstance : effects) {
                    MobEffect effect = effectInstance.m_19544_();
                    if (!effectInstance.m_19572_() || !effectInstance.m_19575_()) continue;
                    if (effect.m_19486_()) {
                        y1 = 26;
                        continue;
                    }
                    y2 = 52;
                    break;
                }
                return (int)((double)Math.max(y1, y2) / scale);
            }
        }
        return 0;
    }

    public static int getHudPosY(int yOrig, int yOffset, int contentHeight, double scale, HudAlignment alignment) {
        int scaledHeight = GuiUtils.getScaledWindowHeight();
        int posY = yOrig;
        switch (alignment) {
            case BOTTOM_RIGHT: 
            case BOTTOM_LEFT: {
                posY = (int)((double)scaledHeight / scale - (double)contentHeight - (double)yOffset);
                break;
            }
            case CENTER: {
                posY = (int)((double)scaledHeight / scale / 2.0 - (double)contentHeight / 2.0 + (double)yOffset);
                break;
            }
        }
        return posY;
    }

    public static void drawBlockBoundingBoxSidesBatchedQuads(BlockPos pos, Color4f color, double expand, BufferBuilder buffer) {
        double minX = (double)pos.m_123341_() - expand;
        double minY = (double)pos.m_123342_() - expand;
        double minZ = (double)pos.m_123343_() - expand;
        double maxX = (double)pos.m_123341_() + expand + 1.0;
        double maxY = (double)pos.m_123342_() + expand + 1.0;
        double maxZ = (double)pos.m_123343_() + expand + 1.0;
        RenderUtils.drawBoxAllSidesBatchedQuads(minX, minY, minZ, maxX, maxY, maxZ, color, buffer);
    }

    public static void drawBlockBoundingBoxOutlinesBatchedLines(BlockPos pos, Color4f color, double expand, BufferBuilder buffer) {
        RenderUtils.drawBlockBoundingBoxOutlinesBatchedLines(pos, Vec3.f_82478_, color, expand, buffer);
    }

    public static void drawBlockBoundingBoxOutlinesBatchedLines(BlockPos pos, Vec3 cameraPos, Color4f color, double expand, BufferBuilder buffer) {
        double minX = (double)pos.m_123341_() - expand - cameraPos.f_82479_;
        double minY = (double)pos.m_123342_() - expand - cameraPos.f_82480_;
        double minZ = (double)pos.m_123343_() - expand - cameraPos.f_82481_;
        double maxX = (double)pos.m_123341_() + expand - cameraPos.f_82479_ + 1.0;
        double maxY = (double)pos.m_123342_() + expand - cameraPos.f_82480_ + 1.0;
        double maxZ = (double)pos.m_123343_() + expand - cameraPos.f_82481_ + 1.0;
        RenderUtils.drawBoxAllEdgesBatchedLines(minX, minY, minZ, maxX, maxY, maxZ, color, buffer);
    }

    public static void drawBoxAllSidesBatchedQuads(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, Color4f color, BufferBuilder buffer) {
        RenderUtils.drawBoxHorizontalSidesBatchedQuads(minX, minY, minZ, maxX, maxY, maxZ, color, buffer);
        RenderUtils.drawBoxTopBatchedQuads(minX, minZ, maxX, maxY, maxZ, color, buffer);
        RenderUtils.drawBoxBottomBatchedQuads(minX, minY, minZ, maxX, maxZ, color, buffer);
    }

    public static void drawBoxWithEdgesBatched(BlockPos posMin, BlockPos posMax, Color4f colorLines, Color4f colorSides, BufferBuilder bufferQuads, BufferBuilder bufferLines) {
        RenderUtils.drawBoxWithEdgesBatched(posMin, posMax, Vec3.f_82478_, colorLines, colorSides, bufferQuads, bufferLines);
    }

    public static void drawBoxWithEdgesBatched(BlockPos posMin, BlockPos posMax, Vec3 cameraPos, Color4f colorLines, Color4f colorSides, BufferBuilder bufferQuads, BufferBuilder bufferLines) {
        double x1 = (double)posMin.m_123341_() - cameraPos.f_82479_;
        double y1 = (double)posMin.m_123342_() - cameraPos.f_82480_;
        double z1 = (double)posMin.m_123343_() - cameraPos.f_82481_;
        double x2 = (double)(posMax.m_123341_() + 1) - cameraPos.f_82479_;
        double y2 = (double)(posMax.m_123342_() + 1) - cameraPos.f_82480_;
        double z2 = (double)(posMax.m_123343_() + 1) - cameraPos.f_82481_;
        RenderUtils.drawBoxAllSidesBatchedQuads(x1, y1, z1, x2, y2, z2, colorSides, bufferQuads);
        RenderUtils.drawBoxAllEdgesBatchedLines(x1, y1, z1, x2, y2, z2, colorLines, bufferLines);
    }

    public static void drawBoxHorizontalSidesBatchedQuads(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, Color4f color, BufferBuilder buffer) {
        buffer.m_5483_(minX, minY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(minX, minY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(minX, maxY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(minX, maxY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(maxX, minY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(maxX, minY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(maxX, maxY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(maxX, maxY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(maxX, minY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(minX, minY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(minX, maxY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(maxX, maxY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(minX, minY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(maxX, minY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(maxX, maxY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(minX, maxY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
    }

    public static void drawBoxTopBatchedQuads(double minX, double minZ, double maxX, double maxY, double maxZ, Color4f color, BufferBuilder buffer) {
        buffer.m_5483_(minX, maxY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(maxX, maxY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(maxX, maxY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(minX, maxY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
    }

    public static void drawBoxBottomBatchedQuads(double minX, double minY, double minZ, double maxX, double maxZ, Color4f color, BufferBuilder buffer) {
        buffer.m_5483_(maxX, minY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(minX, minY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(minX, minY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(maxX, minY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
    }

    public static void drawBoxAllEdgesBatchedLines(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, Color4f color, BufferBuilder buffer) {
        buffer.m_5483_(minX, minY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(minX, minY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(minX, minY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(minX, maxY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(minX, maxY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(minX, maxY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(minX, maxY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(minX, minY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(maxX, minY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(maxX, minY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(maxX, minY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(maxX, maxY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(maxX, maxY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(maxX, maxY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(maxX, maxY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(maxX, minY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(maxX, minY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(minX, minY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(minX, maxY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(maxX, maxY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(minX, minY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(maxX, minY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(maxX, maxY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(minX, maxY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
    }

    public static void drawBox(IntBoundingBox bb, Vec3 cameraPos, Color4f color, BufferBuilder bufferQuads, BufferBuilder bufferLines) {
        double minX = (double)bb.minX - cameraPos.f_82479_;
        double minY = (double)bb.minY - cameraPos.f_82480_;
        double minZ = (double)bb.minZ - cameraPos.f_82481_;
        double maxX = (double)(bb.maxX + 1) - cameraPos.f_82479_;
        double maxY = (double)(bb.maxY + 1) - cameraPos.f_82480_;
        double maxZ = (double)(bb.maxZ + 1) - cameraPos.f_82481_;
        RenderUtils.drawBoxAllSidesBatchedQuads(minX, minY, minZ, maxX, maxY, maxZ, color, bufferQuads);
        RenderUtils.drawBoxAllEdgesBatchedLines(minX, minY, minZ, maxX, maxY, maxZ, color, bufferLines);
    }

    public static void drawTextPlate(List<String> text, double x, double y, double z, float scale) {
        Entity entity = RenderUtils.mc().m_91288_();
        if (entity != null) {
            RenderUtils.drawTextPlate(text, x, y, z, entity.m_146908_(), entity.m_146909_(), scale, -1, 0x40000000, true);
        }
    }

    public static void drawTextPlate(List<String> text, double x, double y, double z, float yaw, float pitch, float scale, int textColor, int bgColor, boolean disableDepth) {
        Vec3 cameraPos = RenderUtils.mc().f_91063_.m_109153_().m_90583_();
        double cx = cameraPos.f_82479_;
        double cy = cameraPos.f_82480_;
        double cz = cameraPos.f_82481_;
        Font textRenderer = RenderUtils.mc().f_91062_;
        PoseStack globalStack = RenderSystem.getModelViewStack();
        globalStack.m_85836_();
        globalStack.m_85837_(x - cx, y - cy, z - cz);
        Quaternionf rot = new Quaternionf().rotationYXZ(-yaw * ((float)Math.PI / 180), pitch * ((float)Math.PI / 180), 0.0f);
        globalStack.m_252781_(rot);
        globalStack.m_85841_(-scale, -scale, scale);
        RenderSystem.applyModelViewMatrix();
        RenderSystem.disableCull();
        RenderUtils.setupBlend();
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        int maxLineLen = 0;
        for (String line : text) {
            maxLineLen = Math.max(maxLineLen, textRenderer.m_92895_(line));
        }
        int strLenHalf = maxLineLen / 2;
        Objects.requireNonNull(textRenderer);
        int textHeight = 9 * text.size() - 1;
        int bga = bgColor >>> 24 & 0xFF;
        int bgr = bgColor >>> 16 & 0xFF;
        int bgg = bgColor >>> 8 & 0xFF;
        int bgb = bgColor & 0xFF;
        if (disableDepth) {
            RenderSystem.depthMask((boolean)false);
            RenderSystem.disableDepthTest();
        }
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        buffer.m_5483_((double)(-strLenHalf - 1), -1.0, 0.0).m_6122_(bgr, bgg, bgb, bga).m_5752_();
        buffer.m_5483_((double)(-strLenHalf - 1), (double)textHeight, 0.0).m_6122_(bgr, bgg, bgb, bga).m_5752_();
        buffer.m_5483_((double)strLenHalf, (double)textHeight, 0.0).m_6122_(bgr, bgg, bgb, bga).m_5752_();
        buffer.m_5483_((double)strLenHalf, -1.0, 0.0).m_6122_(bgr, bgg, bgb, bga).m_5752_();
        tessellator.m_85914_();
        int textY = 0;
        if (!disableDepth) {
            RenderSystem.enablePolygonOffset();
            RenderSystem.polygonOffset((float)-0.6f, (float)-1.2f);
        }
        Matrix4f modelMatrix = new Matrix4f();
        modelMatrix.identity();
        for (String line : text) {
            MultiBufferSource.BufferSource immediate;
            if (disableDepth) {
                RenderSystem.depthMask((boolean)false);
                RenderSystem.disableDepthTest();
                immediate = MultiBufferSource.m_109898_((BufferBuilder)buffer);
                textRenderer.m_271703_(line, (float)(-strLenHalf), (float)textY, 0x20000000 | textColor & 0xFFFFFF, false, modelMatrix, (MultiBufferSource)immediate, Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
                immediate.m_109911_();
                RenderSystem.enableDepthTest();
                RenderSystem.depthMask((boolean)true);
            }
            immediate = MultiBufferSource.m_109898_((BufferBuilder)buffer);
            textRenderer.m_271703_(line, (float)(-strLenHalf), (float)textY, textColor, false, modelMatrix, (MultiBufferSource)immediate, Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
            immediate.m_109911_();
            Objects.requireNonNull(textRenderer);
            textY += 9;
        }
        if (!disableDepth) {
            RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
            RenderSystem.disablePolygonOffset();
        }
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        globalStack.m_85849_();
    }

    public static void renderBlockTargetingOverlay(Entity entity, BlockPos pos, Direction side, Vec3 hitVec, Color4f color, PoseStack matrixStack, Minecraft mc) {
        Direction playerFacing = entity.m_6350_();
        PositionUtils.HitPart part = PositionUtils.getHitPart(side, playerFacing, pos, hitVec);
        Vec3 cameraPos = mc.f_91063_.m_109153_().m_90583_();
        double x = (double)pos.m_123341_() + 0.5 - cameraPos.f_82479_;
        double y = (double)pos.m_123342_() + 0.5 - cameraPos.f_82480_;
        double z = (double)pos.m_123343_() + 0.5 - cameraPos.f_82481_;
        PoseStack globalStack = RenderSystem.getModelViewStack();
        globalStack.m_85836_();
        RenderUtils.blockTargetingOverlayTranslations(x, y, z, side, playerFacing, globalStack);
        RenderSystem.applyModelViewMatrix();
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        int quadAlpha = 45;
        int hr = (int)(color.r * 255.0f);
        int hg = (int)(color.g * 255.0f);
        int hb = (int)(color.b * 255.0f);
        int ha = (int)(color.a * 255.0f);
        int c = 255;
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        buffer.m_5483_(x - 0.5, y - 0.5, z).m_6122_(c, c, c, quadAlpha).m_5752_();
        buffer.m_5483_(x + 0.5, y - 0.5, z).m_6122_(c, c, c, quadAlpha).m_5752_();
        buffer.m_5483_(x + 0.5, y + 0.5, z).m_6122_(c, c, c, quadAlpha).m_5752_();
        buffer.m_5483_(x - 0.5, y + 0.5, z).m_6122_(c, c, c, quadAlpha).m_5752_();
        switch (part) {
            case CENTER: {
                buffer.m_5483_(x - 0.25, y - 0.25, z).m_6122_(hr, hg, hb, ha).m_5752_();
                buffer.m_5483_(x + 0.25, y - 0.25, z).m_6122_(hr, hg, hb, ha).m_5752_();
                buffer.m_5483_(x + 0.25, y + 0.25, z).m_6122_(hr, hg, hb, ha).m_5752_();
                buffer.m_5483_(x - 0.25, y + 0.25, z).m_6122_(hr, hg, hb, ha).m_5752_();
                break;
            }
            case LEFT: {
                buffer.m_5483_(x - 0.5, y - 0.5, z).m_6122_(hr, hg, hb, ha).m_5752_();
                buffer.m_5483_(x - 0.25, y - 0.25, z).m_6122_(hr, hg, hb, ha).m_5752_();
                buffer.m_5483_(x - 0.25, y + 0.25, z).m_6122_(hr, hg, hb, ha).m_5752_();
                buffer.m_5483_(x - 0.5, y + 0.5, z).m_6122_(hr, hg, hb, ha).m_5752_();
                break;
            }
            case RIGHT: {
                buffer.m_5483_(x + 0.5, y - 0.5, z).m_6122_(hr, hg, hb, ha).m_5752_();
                buffer.m_5483_(x + 0.25, y - 0.25, z).m_6122_(hr, hg, hb, ha).m_5752_();
                buffer.m_5483_(x + 0.25, y + 0.25, z).m_6122_(hr, hg, hb, ha).m_5752_();
                buffer.m_5483_(x + 0.5, y + 0.5, z).m_6122_(hr, hg, hb, ha).m_5752_();
                break;
            }
            case TOP: {
                buffer.m_5483_(x - 0.5, y + 0.5, z).m_6122_(hr, hg, hb, ha).m_5752_();
                buffer.m_5483_(x - 0.25, y + 0.25, z).m_6122_(hr, hg, hb, ha).m_5752_();
                buffer.m_5483_(x + 0.25, y + 0.25, z).m_6122_(hr, hg, hb, ha).m_5752_();
                buffer.m_5483_(x + 0.5, y + 0.5, z).m_6122_(hr, hg, hb, ha).m_5752_();
                break;
            }
            case BOTTOM: {
                buffer.m_5483_(x - 0.5, y - 0.5, z).m_6122_(hr, hg, hb, ha).m_5752_();
                buffer.m_5483_(x - 0.25, y - 0.25, z).m_6122_(hr, hg, hb, ha).m_5752_();
                buffer.m_5483_(x + 0.25, y - 0.25, z).m_6122_(hr, hg, hb, ha).m_5752_();
                buffer.m_5483_(x + 0.5, y - 0.5, z).m_6122_(hr, hg, hb, ha).m_5752_();
                break;
            }
        }
        tessellator.m_85914_();
        RenderSystem.lineWidth((float)1.6f);
        buffer.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
        buffer.m_5483_(x - 0.25, y - 0.25, z).m_6122_(c, c, c, c).m_5752_();
        buffer.m_5483_(x + 0.25, y - 0.25, z).m_6122_(c, c, c, c).m_5752_();
        buffer.m_5483_(x + 0.25, y + 0.25, z).m_6122_(c, c, c, c).m_5752_();
        buffer.m_5483_(x - 0.25, y + 0.25, z).m_6122_(c, c, c, c).m_5752_();
        buffer.m_5483_(x - 0.25, y - 0.25, z).m_6122_(c, c, c, c).m_5752_();
        tessellator.m_85914_();
        buffer.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_);
        buffer.m_5483_(x - 0.5, y - 0.5, z).m_6122_(c, c, c, c).m_5752_();
        buffer.m_5483_(x - 0.25, y - 0.25, z).m_6122_(c, c, c, c).m_5752_();
        buffer.m_5483_(x - 0.5, y + 0.5, z).m_6122_(c, c, c, c).m_5752_();
        buffer.m_5483_(x - 0.25, y + 0.25, z).m_6122_(c, c, c, c).m_5752_();
        buffer.m_5483_(x + 0.5, y - 0.5, z).m_6122_(c, c, c, c).m_5752_();
        buffer.m_5483_(x + 0.25, y - 0.25, z).m_6122_(c, c, c, c).m_5752_();
        buffer.m_5483_(x + 0.5, y + 0.5, z).m_6122_(c, c, c, c).m_5752_();
        buffer.m_5483_(x + 0.25, y + 0.25, z).m_6122_(c, c, c, c).m_5752_();
        tessellator.m_85914_();
        globalStack.m_85849_();
        RenderSystem.applyModelViewMatrix();
    }

    public static void renderBlockTargetingOverlaySimple(Entity entity, BlockPos pos, Direction side, Color4f color, PoseStack matrixStack, Minecraft mc) {
        Direction playerFacing = entity.m_6350_();
        Vec3 cameraPos = mc.f_91063_.m_109153_().m_90583_();
        double x = (double)pos.m_123341_() + 0.5 - cameraPos.f_82479_;
        double y = (double)pos.m_123342_() + 0.5 - cameraPos.f_82480_;
        double z = (double)pos.m_123343_() + 0.5 - cameraPos.f_82481_;
        PoseStack globalStack = RenderSystem.getModelViewStack();
        globalStack.m_85836_();
        RenderUtils.blockTargetingOverlayTranslations(x, y, z, side, playerFacing, globalStack);
        RenderSystem.applyModelViewMatrix();
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        int a = (int)(color.a * 255.0f);
        int r = (int)(color.r * 255.0f);
        int g = (int)(color.g * 255.0f);
        int b = (int)(color.b * 255.0f);
        int c = 255;
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        buffer.m_5483_(x - 0.5, y - 0.5, z).m_6122_(r, g, b, a).m_5752_();
        buffer.m_5483_(x + 0.5, y - 0.5, z).m_6122_(r, g, b, a).m_5752_();
        buffer.m_5483_(x + 0.5, y + 0.5, z).m_6122_(r, g, b, a).m_5752_();
        buffer.m_5483_(x - 0.5, y + 0.5, z).m_6122_(r, g, b, a).m_5752_();
        tessellator.m_85914_();
        RenderSystem.lineWidth((float)1.6f);
        buffer.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
        buffer.m_5483_(x - 0.375, y - 0.375, z).m_6122_(c, c, c, c).m_5752_();
        buffer.m_5483_(x + 0.375, y - 0.375, z).m_6122_(c, c, c, c).m_5752_();
        buffer.m_5483_(x + 0.375, y + 0.375, z).m_6122_(c, c, c, c).m_5752_();
        buffer.m_5483_(x - 0.375, y + 0.375, z).m_6122_(c, c, c, c).m_5752_();
        tessellator.m_85914_();
        globalStack.m_85849_();
        RenderSystem.applyModelViewMatrix();
    }

    private static void blockTargetingOverlayTranslations(double x, double y, double z, Direction side, Direction playerFacing, PoseStack matrixStack) {
        matrixStack.m_85837_(x, y, z);
        switch (side) {
            case DOWN: {
                matrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - playerFacing.m_122435_()));
                matrixStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                break;
            }
            case UP: {
                matrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - playerFacing.m_122435_()));
                matrixStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                break;
            }
            case NORTH: {
                matrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                break;
            }
            case SOUTH: {
                break;
            }
            case WEST: {
                matrixStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
                break;
            }
            case EAST: {
                matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
            }
        }
        matrixStack.m_85837_(-x, -y, -z + 0.51);
    }

    public static void renderMapPreview(ItemStack stack, int x, int y, int dimensions) {
        if (stack.m_41720_() instanceof MapItem && GuiBase.isShiftDown()) {
            RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
            int y1 = y - dimensions - 20;
            int y2 = y1 + dimensions;
            int x1 = x + 8;
            int x2 = x1 + dimensions;
            int z = 300;
            Integer mapId = MapItem.m_151131_((ItemStack)stack);
            MapItemSavedData mapState = MapItem.m_151128_((Integer)mapId, (Level)RenderUtils.mc().f_91073_);
            ResourceLocation bgTexture = mapState == null ? TEXTURE_MAP_BACKGROUND : TEXTURE_MAP_BACKGROUND_CHECKERBOARD;
            RenderUtils.bindTexture(bgTexture);
            RenderUtils.setupBlend();
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.applyModelViewMatrix();
            Tesselator tessellator = Tesselator.m_85913_();
            BufferBuilder buffer = tessellator.m_85915_();
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            buffer.m_5483_((double)x1, (double)y2, (double)z).m_7421_(0.0f, 1.0f).m_5752_();
            buffer.m_5483_((double)x2, (double)y2, (double)z).m_7421_(1.0f, 1.0f).m_5752_();
            buffer.m_5483_((double)x2, (double)y1, (double)z).m_7421_(1.0f, 0.0f).m_5752_();
            buffer.m_5483_((double)x1, (double)y1, (double)z).m_7421_(0.0f, 0.0f).m_5752_();
            tessellator.m_85914_();
            RenderSystem.disableBlend();
            if (mapState != null) {
                x1 += 8;
                y1 += 8;
                z = 310;
                MultiBufferSource.BufferSource consumer = MultiBufferSource.m_109898_((BufferBuilder)buffer);
                double scale = (double)(dimensions - 16) / 128.0;
                PoseStack matrixStack = new PoseStack();
                matrixStack.m_85836_();
                matrixStack.m_252880_((float)x1, (float)y1, (float)z);
                matrixStack.m_85841_((float)scale, (float)scale, 0.0f);
                RenderUtils.mc().f_91063_.m_109151_().m_168771_(matrixStack, (MultiBufferSource)consumer, mapId.intValue(), mapState, false, 0xF000F0);
                consumer.m_109911_();
                matrixStack.m_85849_();
            }
        }
    }

    public static void renderShulkerBoxPreview(ItemStack stack, int baseX, int baseY, boolean useBgColors, GuiGraphics drawContext) {
        if (stack.m_41782_()) {
            NonNullList<ItemStack> items = InventoryUtils.getStoredItems(stack, -1);
            if (items.size() == 0) {
                return;
            }
            InventoryOverlay.InventoryRenderType type = InventoryOverlay.getInventoryType(stack);
            InventoryOverlay.InventoryProperties props = InventoryOverlay.getInventoryPropsTemp(type, items.size());
            int screenWidth = GuiUtils.getScaledWindowWidth();
            int screenHeight = GuiUtils.getScaledWindowHeight();
            int height = props.height + 18;
            int x = Mth.m_14045_((int)(baseX + 8), (int)0, (int)(screenWidth - props.width));
            int y = Mth.m_14045_((int)(baseY - height), (int)0, (int)(screenHeight - height));
            if (stack.m_41720_() instanceof BlockItem && ((BlockItem)stack.m_41720_()).m_40614_() instanceof ShulkerBoxBlock) {
                RenderUtils.setShulkerboxBackgroundTintColor((ShulkerBoxBlock)((BlockItem)stack.m_41720_()).m_40614_(), useBgColors);
            } else {
                RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
            }
            RenderUtils.disableDiffuseLighting();
            PoseStack matrixStack = RenderSystem.getModelViewStack();
            matrixStack.m_85836_();
            matrixStack.m_252880_(0.0f, 0.0f, 500.0f);
            RenderSystem.applyModelViewMatrix();
            InventoryOverlay.renderInventoryBackground(type, x, y, props.slotsPerRow, items.size(), RenderUtils.mc());
            RenderUtils.enableDiffuseLightingGui3D();
            Container inv = InventoryUtils.getAsInventory(items);
            InventoryOverlay.renderInventoryStacks(type, inv, x + props.slotOffsetX, y + props.slotOffsetY, props.slotsPerRow, 0, -1, RenderUtils.mc(), drawContext);
            matrixStack.m_85849_();
            RenderSystem.applyModelViewMatrix();
        }
    }

    public static void setShulkerboxBackgroundTintColor(@Nullable ShulkerBoxBlock block, boolean useBgColors) {
        if (block != null && useBgColors) {
            DyeColor dye = block.m_56261_() != null ? block.m_56261_() : DyeColor.PURPLE;
            float[] colors = dye.m_41068_();
            RenderUtils.color(colors[0], colors[1], colors[2], 1.0f);
        } else {
            RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public static void renderModelInGui(int x, int y, BakedModel model, BlockState state, float zLevel) {
        if (state.m_60734_() == Blocks.f_50016_) {
            return;
        }
        PoseStack matrixStack = RenderSystem.getModelViewStack();
        matrixStack.m_85836_();
        RenderUtils.bindTexture(InventoryMenu.f_39692_);
        RenderUtils.mc().m_91097_().m_118506_(InventoryMenu.f_39692_).m_117960_(false, false);
        RenderSystem.enableBlend();
        RenderUtils.setupBlendSimple();
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        RenderUtils.setupGuiTransform(x, y, model.m_7539_(), zLevel);
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(30.0f));
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(225.0f));
        matrixStack.m_85841_(0.625f, 0.625f, 0.625f);
        RenderUtils.renderModel(model, state);
        matrixStack.m_85849_();
    }

    public static void setupGuiTransform(int xPosition, int yPosition, boolean isGui3d, float zLevel) {
        RenderUtils.setupGuiTransform(RenderSystem.getModelViewStack(), xPosition, yPosition, zLevel);
    }

    public static void setupGuiTransform(PoseStack matrixStack, int xPosition, int yPosition, float zLevel) {
        matrixStack.m_85837_((double)xPosition + 8.0, (double)yPosition + 8.0, (double)zLevel + 100.0);
        matrixStack.m_85841_(16.0f, -16.0f, 16.0f);
    }

    private static void renderModel(BakedModel model, BlockState state) {
        PoseStack matrixStack = RenderSystem.getModelViewStack();
        matrixStack.m_85836_();
        matrixStack.m_85837_(-0.5, -0.5, -0.5);
        int color = -1;
        if (!model.m_7521_()) {
            RenderSystem.setShader(GameRenderer::m_172640_);
            RenderSystem.applyModelViewMatrix();
            Tesselator tessellator = Tesselator.m_85913_();
            BufferBuilder bufferbuilder = tessellator.m_85915_();
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85811_);
            for (Direction face : Direction.values()) {
                RAND.m_188584_(0L);
                RenderUtils.renderQuads(bufferbuilder, model.m_213637_(state, face, (RandomSource)RAND), state, color);
            }
            RAND.m_188584_(0L);
            RenderUtils.renderQuads(bufferbuilder, model.m_213637_(state, null, (RandomSource)RAND), state, color);
            tessellator.m_85914_();
        }
        matrixStack.m_85849_();
    }

    private static void renderQuads(BufferBuilder renderer, List<BakedQuad> quads, BlockState state, int color) {
        int quadCount = quads.size();
        for (int i = 0; i < quadCount; ++i) {
            BakedQuad quad = quads.get(i);
            RenderUtils.renderQuad(renderer, quad, state, -1);
        }
    }

    private static void renderQuad(BufferBuilder buffer, BakedQuad quad, BlockState state, int color) {
    }

    private static Minecraft mc() {
        return Minecraft.m_91087_();
    }
}

