/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.domesticationinnovation.mixin;

import com.github.alexthe668.domesticationinnovation.server.entity.DIActivityRegistry;
import com.github.alexthe668.domesticationinnovation.server.entity.ModifedToBeTameable;
import com.github.alexthe668.domesticationinnovation.server.entity.ai.AmphibianFollowOwnerBehavior;
import com.github.alexthe668.domesticationinnovation.server.entity.ai.AmphibianStayBehavior;
import com.github.alexthe668.domesticationinnovation.server.misc.DITagRegistry;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.animal.frog.FrogAi;
import net.minecraft.world.entity.animal.frog.ShootTongue;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.crafting.Ingredient;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FrogAi.class})
public class FrogAiMixin {
    @Inject(method={"Lnet/minecraft/world/entity/animal/frog/FrogAi;makeBrain(Lnet/minecraft/world/entity/ai/Brain;)Lnet/minecraft/world/entity/ai/Brain;"}, remap=true, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/animal/frog/FrogAi;initJumpActivity(Lnet/minecraft/world/entity/ai/Brain;)V")})
    private static void di_makeBrain(Brain<Frog> brain, CallbackInfoReturnable<Brain<?>> cir) {
        brain.m_21900_((Activity)DIActivityRegistry.FROG_FOLLOW.get(), ImmutableList.of((Object)Pair.of((Object)0, new AmphibianFollowOwnerBehavior(1.25f, 1.0f)), (Object)Pair.of((Object)2, (Object)new ShootTongue(SoundEvents.f_215697_, SoundEvents.f_215692_))));
        brain.m_21900_((Activity)DIActivityRegistry.FROG_STAY.get(), ImmutableList.of((Object)Pair.of((Object)0, new AmphibianStayBehavior())));
    }

    private static boolean canAttack(Frog frog) {
        return !frog.m_27593_();
    }

    @Inject(method={"Lnet/minecraft/world/entity/animal/frog/FrogAi;updateActivity(Lnet/minecraft/world/entity/animal/frog/Frog;)V"}, remap=true, at={@At(value="HEAD")}, cancellable=true)
    private static void di_updateActivity(Frog frog, CallbackInfo ci) {
        Brain brain = frog.m_6274_();
        Activity activity = brain.m_21968_().orElse(null);
        if (frog instanceof ModifedToBeTameable) {
            ModifedToBeTameable modifedToBeTameable = (ModifedToBeTameable)frog;
            if (modifedToBeTameable.isStayingStill()) {
                brain.m_21889_((Activity)DIActivityRegistry.FROG_STAY.get());
                ci.cancel();
            } else if (modifedToBeTameable.isFollowingOwner()) {
                if (frog.m_5448_() != null && frog.m_5448_().m_6084_()) {
                    brain.m_21879_(MemoryModuleType.f_26372_, (Object)frog.m_5448_());
                    brain.m_21879_(MemoryModuleType.f_148194_, (Object)frog.m_5448_());
                    brain.m_21889_(Activity.f_219846_);
                } else {
                    frog.m_6274_().m_21926_((List)ImmutableList.of((Object)((Activity)DIActivityRegistry.FROG_FOLLOW.get()), (Object)Activity.f_219846_, (Object)Activity.f_219848_, (Object)Activity.f_150239_, (Object)Activity.f_219847_, (Object)Activity.f_37979_));
                }
                ci.cancel();
            }
        }
    }

    @Inject(method={"Lnet/minecraft/world/entity/animal/frog/FrogAi;getTemptations()Lnet/minecraft/world/item/crafting/Ingredient;"}, remap=true, at={@At(value="TAIL")}, cancellable=true)
    private static void di_getTemptationItems(CallbackInfoReturnable<Ingredient> cir) {
        cir.setReturnValue((Object)Ingredient.merge((Collection)ImmutableList.of((Object)((Ingredient)cir.getReturnValue()), (Object)Ingredient.m_204132_(DITagRegistry.TAME_FROGS_WITH))));
    }
}

